# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AddCustomizedConfigRequest(AbstractModel):
    r"""AddCustomizedConfig request structure.

    """

    def __init__(self):
        r"""
        :param _ConfigName: Configuration name
        :type ConfigName: str
        :param _ConfigType: Configuration type. valid values: ["CLB", "SERVER", "LOCATION"], respectively indicating CLB configuration, SERVER configuration, and LOCATION configuration.
        :type ConfigType: str
        :param _ConfigContent: Specifies the configuration content.
        :type ConfigContent: str
        :param _Tags: Tag.
        :type Tags: list of TagInfo
        """
        self._ConfigName = None
        self._ConfigType = None
        self._ConfigContent = None
        self._Tags = None

    @property
    def ConfigName(self):
        r"""Configuration name
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigType(self):
        r"""Configuration type. valid values: ["CLB", "SERVER", "LOCATION"], respectively indicating CLB configuration, SERVER configuration, and LOCATION configuration.
        :rtype: str
        """
        return self._ConfigType

    @ConfigType.setter
    def ConfigType(self, ConfigType):
        self._ConfigType = ConfigType

    @property
    def ConfigContent(self):
        r"""Specifies the configuration content.
        :rtype: str
        """
        return self._ConfigContent

    @ConfigContent.setter
    def ConfigContent(self, ConfigContent):
        self._ConfigContent = ConfigContent

    @property
    def Tags(self):
        r"""Tag.
        :rtype: list of TagInfo
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._ConfigName = params.get("ConfigName")
        self._ConfigType = params.get("ConfigType")
        self._ConfigContent = params.get("ConfigContent")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCustomizedConfigResponse(AbstractModel):
    r"""AddCustomizedConfig response structure.

    """

    def __init__(self):
        r"""
        :param _ConfigId: Configuration ID.
        :type ConfigId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ConfigId = None
        self._RequestId = None

    @property
    def ConfigId(self):
        r"""Configuration ID.
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._RequestId = params.get("RequestId")


class AssociateCustomizedConfigRequest(AbstractModel):
    r"""AssociateCustomizedConfig request structure.

    """

    def __init__(self):
        r"""
        :param _UconfigId: Configuration ID.
        :type UconfigId: str
        :param _BindList: Associated server or location
        :type BindList: list of BindItem
        """
        self._UconfigId = None
        self._BindList = None

    @property
    def UconfigId(self):
        r"""Configuration ID.
        :rtype: str
        """
        return self._UconfigId

    @UconfigId.setter
    def UconfigId(self, UconfigId):
        self._UconfigId = UconfigId

    @property
    def BindList(self):
        r"""Associated server or location
        :rtype: list of BindItem
        """
        return self._BindList

    @BindList.setter
    def BindList(self, BindList):
        self._BindList = BindList


    def _deserialize(self, params):
        self._UconfigId = params.get("UconfigId")
        if params.get("BindList") is not None:
            self._BindList = []
            for item in params.get("BindList"):
                obj = BindItem()
                obj._deserialize(item)
                self._BindList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateCustomizedConfigResponse(AbstractModel):
    r"""AssociateCustomizedConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateTargetGroupsRequest(AbstractModel):
    r"""AssociateTargetGroups request structure.

    """

    def __init__(self):
        r"""
        :param _Associations: Specifies the binding relationship array. the target group type should be the same.
Specifies the maximum number of requests supported in a single request is 20.

        :type Associations: list of TargetGroupAssociation
        """
        self._Associations = None

    @property
    def Associations(self):
        r"""Specifies the binding relationship array. the target group type should be the same.
Specifies the maximum number of requests supported in a single request is 20.

        :rtype: list of TargetGroupAssociation
        """
        return self._Associations

    @Associations.setter
    def Associations(self, Associations):
        self._Associations = Associations


    def _deserialize(self, params):
        if params.get("Associations") is not None:
            self._Associations = []
            for item in params.get("Associations"):
                obj = TargetGroupAssociation()
                obj._deserialize(item)
                self._Associations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateTargetGroupsResponse(AbstractModel):
    r"""AssociateTargetGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociationItem(AbstractModel):
    r"""Rule associated with target group

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of associated CLB instance
        :type LoadBalancerId: str
        :param _ListenerId: ID of associated listener
        :type ListenerId: str
        :param _LocationId: ID of associated forwarding rule
Note: this field may return null, indicating that no valid values can be obtained.
        :type LocationId: str
        :param _Protocol: Protocol type of associated listener, such as HTTP or TCP
        :type Protocol: str
        :param _Port: Port of associated listener
        :type Port: int
        :param _Domain: Domain name of associated forwarding rule
Note: this field may return null, indicating that no valid values can be obtained.
        :type Domain: str
        :param _Url: URL of associated forwarding rule
Note: this field may return null, indicating that no valid values can be obtained.
        :type Url: str
        :param _LoadBalancerName: CLB instance name
        :type LoadBalancerName: str
        :param _ListenerName: Listener name
        :type ListenerName: str
        :param _Weight: Weight associated with the target group. this parameter takes effect only for the new version v2 target group.
        :type Weight: int
        :param _RuleId: Advanced routing rule ID.
        :type RuleId: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._LocationId = None
        self._Protocol = None
        self._Port = None
        self._Domain = None
        self._Url = None
        self._LoadBalancerName = None
        self._ListenerName = None
        self._Weight = None
        self._RuleId = None

    @property
    def LoadBalancerId(self):
        r"""ID of associated CLB instance
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""ID of associated listener
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def LocationId(self):
        r"""ID of associated forwarding rule
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Protocol(self):
        r"""Protocol type of associated listener, such as HTTP or TCP
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        r"""Port of associated listener
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Domain(self):
        r"""Domain name of associated forwarding rule
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""URL of associated forwarding rule
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def LoadBalancerName(self):
        r"""CLB instance name
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def ListenerName(self):
        r"""Listener name
        :rtype: str
        """
        return self._ListenerName

    @ListenerName.setter
    def ListenerName(self, ListenerName):
        self._ListenerName = ListenerName

    @property
    def Weight(self):
        r"""Weight associated with the target group. this parameter takes effect only for the new version v2 target group.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def RuleId(self):
        r"""Advanced routing rule ID.
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        self._LocationId = params.get("LocationId")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._ListenerName = params.get("ListenerName")
        self._Weight = params.get("Weight")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoRewriteRequest(AbstractModel):
    r"""AutoRewrite request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _ListenerId: `HTTPS:443` listener ID
        :type ListenerId: str
        :param _Domains: The domain name to be redirected under the listener `HTTPS:443`. If it is left empty, all domain names under the listener `HTTPS:443` will be configured with redirects.
        :type Domains: list of str
        :param _RewriteCodes: Redirection status code. Valid values: 301, 302, and 307.
        :type RewriteCodes: list of int
        :param _TakeUrls: Whether the matched URL is carried in redirection.
        :type TakeUrls: list of bool
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._Domains = None
        self._RewriteCodes = None
        self._TakeUrls = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""`HTTPS:443` listener ID
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Domains(self):
        r"""The domain name to be redirected under the listener `HTTPS:443`. If it is left empty, all domain names under the listener `HTTPS:443` will be configured with redirects.
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def RewriteCodes(self):
        r"""Redirection status code. Valid values: 301, 302, and 307.
        :rtype: list of int
        """
        return self._RewriteCodes

    @RewriteCodes.setter
    def RewriteCodes(self, RewriteCodes):
        self._RewriteCodes = RewriteCodes

    @property
    def TakeUrls(self):
        r"""Whether the matched URL is carried in redirection.
        :rtype: list of bool
        """
        return self._TakeUrls

    @TakeUrls.setter
    def TakeUrls(self, TakeUrls):
        self._TakeUrls = TakeUrls


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        self._Domains = params.get("Domains")
        self._RewriteCodes = params.get("RewriteCodes")
        self._TakeUrls = params.get("TakeUrls")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoRewriteResponse(AbstractModel):
    r"""AutoRewrite response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Backend(AbstractModel):
    r"""Details of a real server bound to a listener

    """

    def __init__(self):
        r"""
        :param _Type: Specifies the backend service type. valid values: CVM, ENI, CCN, EVM, GLOBALROUTE, NAT, SRV.
        :type Type: str
        :param _InstanceId: Unique ID of a real server, which can be obtained from the unInstanceId field in the return of the DescribeInstances API
        :type InstanceId: str
        :param _Port: Specifies the listening port of the backend service. if it is a full listening target group bound to a port range listener, this port returns 0, indicating an invalid port. the port of the bound backend service follows the listener port.
        :type Port: int
        :param _Weight: Forwarding weight of a real server. Value range: [0, 100]. Default value: 10.
        :type Weight: int
        :param _PublicIpAddresses: Public IP of a real server
Note: This field may return null, indicating that no valid values can be obtained.
        :type PublicIpAddresses: list of str
        :param _PrivateIpAddresses: Private network IP of the real server
        :type PrivateIpAddresses: list of str
        :param _InstanceName: Real server instance names
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceName: str
        :param _RegisteredTime: Real server binding time
        :type RegisteredTime: str
        :param _EniId: Unique ENI ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type EniId: str
        :param _Tag: Tag.
        :type Tag: str
        """
        self._Type = None
        self._InstanceId = None
        self._Port = None
        self._Weight = None
        self._PublicIpAddresses = None
        self._PrivateIpAddresses = None
        self._InstanceName = None
        self._RegisteredTime = None
        self._EniId = None
        self._Tag = None

    @property
    def Type(self):
        r"""Specifies the backend service type. valid values: CVM, ENI, CCN, EVM, GLOBALROUTE, NAT, SRV.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InstanceId(self):
        r"""Unique ID of a real server, which can be obtained from the unInstanceId field in the return of the DescribeInstances API
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Port(self):
        r"""Specifies the listening port of the backend service. if it is a full listening target group bound to a port range listener, this port returns 0, indicating an invalid port. the port of the bound backend service follows the listener port.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Weight(self):
        r"""Forwarding weight of a real server. Value range: [0, 100]. Default value: 10.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def PublicIpAddresses(self):
        r"""Public IP of a real server
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses

    @property
    def PrivateIpAddresses(self):
        r"""Private network IP of the real server
        :rtype: list of str
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def InstanceName(self):
        r"""Real server instance names
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def RegisteredTime(self):
        r"""Real server binding time
        :rtype: str
        """
        return self._RegisteredTime

    @RegisteredTime.setter
    def RegisteredTime(self, RegisteredTime):
        self._RegisteredTime = RegisteredTime

    @property
    def EniId(self):
        r"""Unique ENI ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._EniId

    @EniId.setter
    def EniId(self, EniId):
        self._EniId = EniId

    @property
    def Tag(self):
        r"""Tag.
        :rtype: str
        """
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._InstanceId = params.get("InstanceId")
        self._Port = params.get("Port")
        self._Weight = params.get("Weight")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        self._PrivateIpAddresses = params.get("PrivateIpAddresses")
        self._InstanceName = params.get("InstanceName")
        self._RegisteredTime = params.get("RegisteredTime")
        self._EniId = params.get("EniId")
        self._Tag = params.get("Tag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BasicTargetGroupInfo(AbstractModel):
    r"""Basic information of a target group bound to a forwarding rule or a listener

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _TargetGroupName: Target group name
        :type TargetGroupName: str
        :param _Weight: Specifies the weight of the target group.
        :type Weight: int
        """
        self._TargetGroupId = None
        self._TargetGroupName = None
        self._Weight = None

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def TargetGroupName(self):
        r"""Target group name
        :rtype: str
        """
        return self._TargetGroupName

    @TargetGroupName.setter
    def TargetGroupName(self, TargetGroupName):
        self._TargetGroupName = TargetGroupName

    @property
    def Weight(self):
        r"""Specifies the weight of the target group.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        self._TargetGroupName = params.get("TargetGroupName")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeregisterTargetsRequest(AbstractModel):
    r"""BatchDeregisterTargets request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _Targets: Unbinding targets
        :type Targets: list of BatchTarget
        """
        self._LoadBalancerId = None
        self._Targets = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def Targets(self):
        r"""Unbinding targets
        :rtype: list of BatchTarget
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = BatchTarget()
                obj._deserialize(item)
                self._Targets.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeregisterTargetsResponse(AbstractModel):
    r"""BatchDeregisterTargets response structure.

    """

    def __init__(self):
        r"""
        :param _FailListenerIdSet: IDs of the listeners failed to unbind
        :type FailListenerIdSet: list of str
        :param _Message: Failed to unbind error reason information.
        :type Message: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FailListenerIdSet = None
        self._Message = None
        self._RequestId = None

    @property
    def FailListenerIdSet(self):
        r"""IDs of the listeners failed to unbind
        :rtype: list of str
        """
        return self._FailListenerIdSet

    @FailListenerIdSet.setter
    def FailListenerIdSet(self, FailListenerIdSet):
        self._FailListenerIdSet = FailListenerIdSet

    @property
    def Message(self):
        r"""Failed to unbind error reason information.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FailListenerIdSet = params.get("FailListenerIdSet")
        self._Message = params.get("Message")
        self._RequestId = params.get("RequestId")


class BatchModifyTargetTagRequest(AbstractModel):
    r"""BatchModifyTargetTag request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID.
        :type LoadBalancerId: str
        :param _ModifyList: List of tags to be modified in batches.
        :type ModifyList: list of RsTagRule
        """
        self._LoadBalancerId = None
        self._ModifyList = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ModifyList(self):
        r"""List of tags to be modified in batches.
        :rtype: list of RsTagRule
        """
        return self._ModifyList

    @ModifyList.setter
    def ModifyList(self, ModifyList):
        self._ModifyList = ModifyList


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        if params.get("ModifyList") is not None:
            self._ModifyList = []
            for item in params.get("ModifyList"):
                obj = RsTagRule()
                obj._deserialize(item)
                self._ModifyList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchModifyTargetTagResponse(AbstractModel):
    r"""BatchModifyTargetTag response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BatchModifyTargetWeightRequest(AbstractModel):
    r"""BatchModifyTargetWeight request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _ModifyList: List of weights to be modified in batches
        :type ModifyList: list of RsWeightRule
        """
        self._LoadBalancerId = None
        self._ModifyList = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ModifyList(self):
        r"""List of weights to be modified in batches
        :rtype: list of RsWeightRule
        """
        return self._ModifyList

    @ModifyList.setter
    def ModifyList(self, ModifyList):
        self._ModifyList = ModifyList


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        if params.get("ModifyList") is not None:
            self._ModifyList = []
            for item in params.get("ModifyList"):
                obj = RsWeightRule()
                obj._deserialize(item)
                self._ModifyList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchModifyTargetWeightResponse(AbstractModel):
    r"""BatchModifyTargetWeight response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BatchRegisterTargetsRequest(AbstractModel):
    r"""BatchRegisterTargets request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _Targets: Binding target
        :type Targets: list of BatchTarget
        """
        self._LoadBalancerId = None
        self._Targets = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def Targets(self):
        r"""Binding target
        :rtype: list of BatchTarget
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = BatchTarget()
                obj._deserialize(item)
                self._Targets.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRegisterTargetsResponse(AbstractModel):
    r"""BatchRegisterTargets response structure.

    """

    def __init__(self):
        r"""
        :param _FailListenerIdSet: ID of the listener failed to bind. Empty indicates all listeners are bound successfully.
        :type FailListenerIdSet: list of str
        :param _Message: Information of the binding failure cause.
        :type Message: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FailListenerIdSet = None
        self._Message = None
        self._RequestId = None

    @property
    def FailListenerIdSet(self):
        r"""ID of the listener failed to bind. Empty indicates all listeners are bound successfully.
        :rtype: list of str
        """
        return self._FailListenerIdSet

    @FailListenerIdSet.setter
    def FailListenerIdSet(self, FailListenerIdSet):
        self._FailListenerIdSet = FailListenerIdSet

    @property
    def Message(self):
        r"""Information of the binding failure cause.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FailListenerIdSet = params.get("FailListenerIdSet")
        self._Message = params.get("Message")
        self._RequestId = params.get("RequestId")


class BatchTarget(AbstractModel):
    r"""Batch binding type

    """

    def __init__(self):
        r"""
        :param _ListenerId: Listener ID.
        :type ListenerId: str
        :param _Port: The port to Bind
        :type Port: int
        :param _InstanceId: CVM instance ID. The primary IP of the primary ENI will be bound.
        :type InstanceId: str
        :param _EniIp: It is required for binding an IP. It supports an ENI IP or any other private IP. To bind an ENI IP, the ENI should be bound to a CVM instance before being bound to a CLB instance.
Note: either `InstanceId` or `EniIp` must be passed in, which is required for binding a dual-stack IPv6 CVM instance.
        :type EniIp: str
        :param _Weight: Weight of the CVM instance. Value range: [0, 100]. If it is not specified for binding the instance, 10 will be used by default.
        :type Weight: int
        :param _LocationId: Layer-7 rule ID. This parameter is required for Layer-7 CLB.
        :type LocationId: str
        :param _Tag: Tag.
        :type Tag: str
        """
        self._ListenerId = None
        self._Port = None
        self._InstanceId = None
        self._EniIp = None
        self._Weight = None
        self._LocationId = None
        self._Tag = None

    @property
    def ListenerId(self):
        r"""Listener ID.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Port(self):
        r"""The port to Bind
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def InstanceId(self):
        r"""CVM instance ID. The primary IP of the primary ENI will be bound.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def EniIp(self):
        r"""It is required for binding an IP. It supports an ENI IP or any other private IP. To bind an ENI IP, the ENI should be bound to a CVM instance before being bound to a CLB instance.
Note: either `InstanceId` or `EniIp` must be passed in, which is required for binding a dual-stack IPv6 CVM instance.
        :rtype: str
        """
        return self._EniIp

    @EniIp.setter
    def EniIp(self, EniIp):
        self._EniIp = EniIp

    @property
    def Weight(self):
        r"""Weight of the CVM instance. Value range: [0, 100]. If it is not specified for binding the instance, 10 will be used by default.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def LocationId(self):
        r"""Layer-7 rule ID. This parameter is required for Layer-7 CLB.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Tag(self):
        r"""Tag.
        :rtype: str
        """
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag


    def _deserialize(self, params):
        self._ListenerId = params.get("ListenerId")
        self._Port = params.get("Port")
        self._InstanceId = params.get("InstanceId")
        self._EniIp = params.get("EniIp")
        self._Weight = params.get("Weight")
        self._LocationId = params.get("LocationId")
        self._Tag = params.get("Tag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindDetailItem(AbstractModel):
    r"""Binding details including listener name, protocol, url and vport

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: Specifies the ID of CLB to be bound
        :type LoadBalancerId: str
        :param _ListenerId: ID of the listener bound to the configuration
        :type ListenerId: str
        :param _Domain: Domain name bound to the configuration
        :type Domain: str
        :param _LocationId: Rule bound to the configuration
        :type LocationId: str
        :param _ListenerName: Listener name
        :type ListenerName: str
        :param _Protocol: Listener protocol
        :type Protocol: str
        :param _Vport: Listener port
        :type Vport: int
        :param _Url: URL of the location.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Url: str
        :param _UconfigId: Configuration ID.
        :type UconfigId: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._Domain = None
        self._LocationId = None
        self._ListenerName = None
        self._Protocol = None
        self._Vport = None
        self._Url = None
        self._UconfigId = None

    @property
    def LoadBalancerId(self):
        r"""Specifies the ID of CLB to be bound
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""ID of the listener bound to the configuration
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Domain(self):
        r"""Domain name bound to the configuration
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def LocationId(self):
        r"""Rule bound to the configuration
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def ListenerName(self):
        r"""Listener name
        :rtype: str
        """
        return self._ListenerName

    @ListenerName.setter
    def ListenerName(self, ListenerName):
        self._ListenerName = ListenerName

    @property
    def Protocol(self):
        r"""Listener protocol
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Vport(self):
        r"""Listener port
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def Url(self):
        r"""URL of the location.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def UconfigId(self):
        r"""Configuration ID.
        :rtype: str
        """
        return self._UconfigId

    @UconfigId.setter
    def UconfigId(self, UconfigId):
        self._UconfigId = UconfigId


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        self._Domain = params.get("Domain")
        self._LocationId = params.get("LocationId")
        self._ListenerName = params.get("ListenerName")
        self._Protocol = params.get("Protocol")
        self._Vport = params.get("Vport")
        self._Url = params.get("Url")
        self._UconfigId = params.get("UconfigId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindItem(AbstractModel):
    r"""Configuration binding relationship

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the CLB instance bound to the configuration
        :type LoadBalancerId: str
        :param _ListenerId: ID of the listener bound to the configuration
        :type ListenerId: str
        :param _Domain: Domain name bound to the configuration
        :type Domain: str
        :param _LocationId: Rule bound to the configuration
        :type LocationId: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._Domain = None
        self._LocationId = None

    @property
    def LoadBalancerId(self):
        r"""ID of the CLB instance bound to the configuration
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""ID of the listener bound to the configuration
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Domain(self):
        r"""Domain name bound to the configuration
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def LocationId(self):
        r"""Rule bound to the configuration
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        self._Domain = params.get("Domain")
        self._LocationId = params.get("LocationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlockedIP(AbstractModel):
    r"""IP added to blocklist 12306

    """

    def __init__(self):
        r"""
        :param _IP: Blacklisted IP
        :type IP: str
        :param _CreateTime: Blacklisted time
        :type CreateTime: str
        :param _ExpireTime: Expiration time
        :type ExpireTime: str
        """
        self._IP = None
        self._CreateTime = None
        self._ExpireTime = None

    @property
    def IP(self):
        r"""Blacklisted IP
        :rtype: str
        """
        return self._IP

    @IP.setter
    def IP(self, IP):
        self._IP = IP

    @property
    def CreateTime(self):
        r"""Blacklisted time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ExpireTime(self):
        r"""Expiration time
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._IP = params.get("IP")
        self._CreateTime = params.get("CreateTime")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CertIdRelatedWithLoadBalancers(AbstractModel):
    r"""Certificate ID and list of CLB instances associated with it

    """

    def __init__(self):
        r"""
        :param _CertId: Certificate ID
        :type CertId: str
        :param _LoadBalancers: List of CLB instances associated with the certificate
        :type LoadBalancers: list of LoadBalancer
        """
        self._CertId = None
        self._LoadBalancers = None

    @property
    def CertId(self):
        r"""Certificate ID
        :rtype: str
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId

    @property
    def LoadBalancers(self):
        r"""List of CLB instances associated with the certificate
        :rtype: list of LoadBalancer
        """
        return self._LoadBalancers

    @LoadBalancers.setter
    def LoadBalancers(self, LoadBalancers):
        self._LoadBalancers = LoadBalancers


    def _deserialize(self, params):
        self._CertId = params.get("CertId")
        if params.get("LoadBalancers") is not None:
            self._LoadBalancers = []
            for item in params.get("LoadBalancers"):
                obj = LoadBalancer()
                obj._deserialize(item)
                self._LoadBalancers.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CertInfo(AbstractModel):
    r"""Certificate information

    """

    def __init__(self):
        r"""
        :param _CertId: ID of the certificate. If it's not specified, `CertContent` and `CertKey` are required. For a server certificate, you also need to specify `CertName`. 
        :type CertId: str
        :param _CertName: Name of the uploaded certificate. It's required if `CertId` is not specified.
        :type CertName: str
        :param _CertContent: Public key of the uploaded certificate. This is required if `CertId` is not specified.
        :type CertContent: str
        :param _CertKey: Private key of the uploaded server certificate. This is required if `CertId` is not specified.
        :type CertKey: str
        """
        self._CertId = None
        self._CertName = None
        self._CertContent = None
        self._CertKey = None

    @property
    def CertId(self):
        r"""ID of the certificate. If it's not specified, `CertContent` and `CertKey` are required. For a server certificate, you also need to specify `CertName`. 
        :rtype: str
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId

    @property
    def CertName(self):
        r"""Name of the uploaded certificate. It's required if `CertId` is not specified.
        :rtype: str
        """
        return self._CertName

    @CertName.setter
    def CertName(self, CertName):
        self._CertName = CertName

    @property
    def CertContent(self):
        r"""Public key of the uploaded certificate. This is required if `CertId` is not specified.
        :rtype: str
        """
        return self._CertContent

    @CertContent.setter
    def CertContent(self, CertContent):
        self._CertContent = CertContent

    @property
    def CertKey(self):
        r"""Private key of the uploaded server certificate. This is required if `CertId` is not specified.
        :rtype: str
        """
        return self._CertKey

    @CertKey.setter
    def CertKey(self, CertKey):
        self._CertKey = CertKey


    def _deserialize(self, params):
        self._CertId = params.get("CertId")
        self._CertName = params.get("CertName")
        self._CertContent = params.get("CertContent")
        self._CertKey = params.get("CertKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CertificateInput(AbstractModel):
    r"""Certificate information

    """

    def __init__(self):
        r"""
        :param _SSLMode: Authentication type. UNIDIRECTIONAL: one-way authentication; MUTUAL: mutual authentication.
Default value: UNIDIRECTIONAL.
        :type SSLMode: str
        :param _SSLVerifyClient: Whether to enable client authentication for mutual authentication. ON: enable it; OPTIONAL: client certificate not required. Default value: ON.
        :type SSLVerifyClient: str
        :param _CertId: Server certificate ID. If this parameter is not specified, you need to upload a certificate and specify CertContent (server certificate content), CertKey (server certificate key), and CertName (server certificate name).
        :type CertId: str
        :param _CertCaId: ID of a client certificate. When the listener adopts mutual authentication (i.e., SSLMode = mutual), if you leave this parameter empty, you must upload the client certificate, including CertCaContent and CertCaName.
        :type CertCaId: str
        :param _CertName: Name of the uploaded server certificate. If there is no CertId, this parameter is required.
        :type CertName: str
        :param _CertKey: Key of the uploaded server certificate. If there is no CertId, this parameter is required.
        :type CertKey: str
        :param _CertContent: Content of the uploaded server certificate. If there is no CertId, this parameter is required.
        :type CertContent: str
        :param _CertCaName: Upload client CA certificate name. if SSLMode=MUTUAL and there is no CertCaId, this parameter is required.
        :type CertCaName: str
        :param _CertCaContent: Upload client certificate content. if SSLMode is MUTUAL and there is no CertCaId, this parameter is required.
        :type CertCaContent: str
        """
        self._SSLMode = None
        self._SSLVerifyClient = None
        self._CertId = None
        self._CertCaId = None
        self._CertName = None
        self._CertKey = None
        self._CertContent = None
        self._CertCaName = None
        self._CertCaContent = None

    @property
    def SSLMode(self):
        r"""Authentication type. UNIDIRECTIONAL: one-way authentication; MUTUAL: mutual authentication.
Default value: UNIDIRECTIONAL.
        :rtype: str
        """
        return self._SSLMode

    @SSLMode.setter
    def SSLMode(self, SSLMode):
        self._SSLMode = SSLMode

    @property
    def SSLVerifyClient(self):
        r"""Whether to enable client authentication for mutual authentication. ON: enable it; OPTIONAL: client certificate not required. Default value: ON.
        :rtype: str
        """
        return self._SSLVerifyClient

    @SSLVerifyClient.setter
    def SSLVerifyClient(self, SSLVerifyClient):
        self._SSLVerifyClient = SSLVerifyClient

    @property
    def CertId(self):
        r"""Server certificate ID. If this parameter is not specified, you need to upload a certificate and specify CertContent (server certificate content), CertKey (server certificate key), and CertName (server certificate name).
        :rtype: str
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId

    @property
    def CertCaId(self):
        r"""ID of a client certificate. When the listener adopts mutual authentication (i.e., SSLMode = mutual), if you leave this parameter empty, you must upload the client certificate, including CertCaContent and CertCaName.
        :rtype: str
        """
        return self._CertCaId

    @CertCaId.setter
    def CertCaId(self, CertCaId):
        self._CertCaId = CertCaId

    @property
    def CertName(self):
        r"""Name of the uploaded server certificate. If there is no CertId, this parameter is required.
        :rtype: str
        """
        return self._CertName

    @CertName.setter
    def CertName(self, CertName):
        self._CertName = CertName

    @property
    def CertKey(self):
        r"""Key of the uploaded server certificate. If there is no CertId, this parameter is required.
        :rtype: str
        """
        return self._CertKey

    @CertKey.setter
    def CertKey(self, CertKey):
        self._CertKey = CertKey

    @property
    def CertContent(self):
        r"""Content of the uploaded server certificate. If there is no CertId, this parameter is required.
        :rtype: str
        """
        return self._CertContent

    @CertContent.setter
    def CertContent(self, CertContent):
        self._CertContent = CertContent

    @property
    def CertCaName(self):
        r"""Upload client CA certificate name. if SSLMode=MUTUAL and there is no CertCaId, this parameter is required.
        :rtype: str
        """
        return self._CertCaName

    @CertCaName.setter
    def CertCaName(self, CertCaName):
        self._CertCaName = CertCaName

    @property
    def CertCaContent(self):
        r"""Upload client certificate content. if SSLMode is MUTUAL and there is no CertCaId, this parameter is required.
        :rtype: str
        """
        return self._CertCaContent

    @CertCaContent.setter
    def CertCaContent(self, CertCaContent):
        self._CertCaContent = CertCaContent


    def _deserialize(self, params):
        self._SSLMode = params.get("SSLMode")
        self._SSLVerifyClient = params.get("SSLVerifyClient")
        self._CertId = params.get("CertId")
        self._CertCaId = params.get("CertCaId")
        self._CertName = params.get("CertName")
        self._CertKey = params.get("CertKey")
        self._CertContent = params.get("CertContent")
        self._CertCaName = params.get("CertCaName")
        self._CertCaContent = params.get("CertCaContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CertificateOutput(AbstractModel):
    r"""Certificate information

    """

    def __init__(self):
        r"""
        :param _SSLMode: Authentication type. Value range: UNIDIRECTIONAL (unidirectional authentication), MUTUAL (mutual authentication)
        :type SSLMode: str
        :param _SSLVerifyClient: Specifies whether client certificate verification is enabled. this parameter is valid only when mutual authentication is enabled.
        :type SSLVerifyClient: str
        :param _CertId: Server certificate ID.
        :type CertId: str
        :param _CertCaId: Client certificate ID.
        :type CertCaId: str
        :param _ExtCertIds: Specifies the server certificate ID for multi-server certificate scenario expansion.
        :type ExtCertIds: list of str
        """
        self._SSLMode = None
        self._SSLVerifyClient = None
        self._CertId = None
        self._CertCaId = None
        self._ExtCertIds = None

    @property
    def SSLMode(self):
        r"""Authentication type. Value range: UNIDIRECTIONAL (unidirectional authentication), MUTUAL (mutual authentication)
        :rtype: str
        """
        return self._SSLMode

    @SSLMode.setter
    def SSLMode(self, SSLMode):
        self._SSLMode = SSLMode

    @property
    def SSLVerifyClient(self):
        r"""Specifies whether client certificate verification is enabled. this parameter is valid only when mutual authentication is enabled.
        :rtype: str
        """
        return self._SSLVerifyClient

    @SSLVerifyClient.setter
    def SSLVerifyClient(self, SSLVerifyClient):
        self._SSLVerifyClient = SSLVerifyClient

    @property
    def CertId(self):
        r"""Server certificate ID.
        :rtype: str
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId

    @property
    def CertCaId(self):
        r"""Client certificate ID.
        :rtype: str
        """
        return self._CertCaId

    @CertCaId.setter
    def CertCaId(self, CertCaId):
        self._CertCaId = CertCaId

    @property
    def ExtCertIds(self):
        r"""Specifies the server certificate ID for multi-server certificate scenario expansion.
        :rtype: list of str
        """
        return self._ExtCertIds

    @ExtCertIds.setter
    def ExtCertIds(self, ExtCertIds):
        self._ExtCertIds = ExtCertIds


    def _deserialize(self, params):
        self._SSLMode = params.get("SSLMode")
        self._SSLVerifyClient = params.get("SSLVerifyClient")
        self._CertId = params.get("CertId")
        self._CertCaId = params.get("CertCaId")
        self._ExtCertIds = params.get("ExtCertIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassicalHealth(AbstractModel):
    r"""Real server health status of a classic CLB

    """

    def __init__(self):
        r"""
        :param _IP: Private IP of a real server
        :type IP: str
        :param _Port: Real server port
        :type Port: int
        :param _ListenerPort: CLB listener port
        :type ListenerPort: int
        :param _Protocol: Forwarding protocol
        :type Protocol: str
        :param _HealthStatus: Health check result. Value range: 1 (healthy), 0 (unhealthy)
        :type HealthStatus: int
        """
        self._IP = None
        self._Port = None
        self._ListenerPort = None
        self._Protocol = None
        self._HealthStatus = None

    @property
    def IP(self):
        r"""Private IP of a real server
        :rtype: str
        """
        return self._IP

    @IP.setter
    def IP(self, IP):
        self._IP = IP

    @property
    def Port(self):
        r"""Real server port
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def ListenerPort(self):
        r"""CLB listener port
        :rtype: int
        """
        return self._ListenerPort

    @ListenerPort.setter
    def ListenerPort(self, ListenerPort):
        self._ListenerPort = ListenerPort

    @property
    def Protocol(self):
        r"""Forwarding protocol
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def HealthStatus(self):
        r"""Health check result. Value range: 1 (healthy), 0 (unhealthy)
        :rtype: int
        """
        return self._HealthStatus

    @HealthStatus.setter
    def HealthStatus(self, HealthStatus):
        self._HealthStatus = HealthStatus


    def _deserialize(self, params):
        self._IP = params.get("IP")
        self._Port = params.get("Port")
        self._ListenerPort = params.get("ListenerPort")
        self._Protocol = params.get("Protocol")
        self._HealthStatus = params.get("HealthStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassicalListener(AbstractModel):
    r"""Classic CLB listener information

    """

    def __init__(self):
        r"""
        :param _ListenerId: CLB listener ID
        :type ListenerId: str
        :param _ListenerPort: CLB listener port
        :type ListenerPort: int
        :param _InstancePort: Backend forwarding port of a listener
        :type InstancePort: int
        :param _ListenerName: Listener name
        :type ListenerName: str
        :param _Protocol: Listener protocol type
        :type Protocol: str
        :param _SessionExpire: Session persistence time
        :type SessionExpire: int
        :param _HealthSwitch: Whether health check is enabled. 1: enabled; 0: disabled.
        :type HealthSwitch: int
        :param _TimeOut: Response timeout period
        :type TimeOut: int
        :param _IntervalTime: Check interval
        :type IntervalTime: int
        :param _HealthNum: Health threshold
        :type HealthNum: int
        :param _UnhealthNum: Unhealthy threshold
        :type UnhealthNum: int
        :param _HttpHash: Request balancing method for listeners of the classic public network CLB. An empty string or wrr indicates weighted round robin. ip_hash indicates consistent hashing based on the accessed source IP address. least_conn indicates least connections.
        :type HttpHash: str
        :param _HttpCode: Health check return code for HTTP and HTTPS listeners of a public network classic CLB. For more information, see the explanation of the field in the listener creating API.
        :type HttpCode: int
        :param _HttpCheckPath: Health check path for HTTP and HTTPS listeners of a public network classic CLB
        :type HttpCheckPath: str
        :param _SSLMode: Authentication method for an HTTPS listener of a public network classic CLB
        :type SSLMode: str
        :param _CertId: Server certificate ID for an HTTPS listener of a public network classic CLB
        :type CertId: str
        :param _CertCaId: Client certificate ID for an HTTPS listener of a public network classic CLB
        :type CertCaId: str
        :param _Status: Listener status. Value range: 0 (creating), 1 (running)
        :type Status: int
        """
        self._ListenerId = None
        self._ListenerPort = None
        self._InstancePort = None
        self._ListenerName = None
        self._Protocol = None
        self._SessionExpire = None
        self._HealthSwitch = None
        self._TimeOut = None
        self._IntervalTime = None
        self._HealthNum = None
        self._UnhealthNum = None
        self._HttpHash = None
        self._HttpCode = None
        self._HttpCheckPath = None
        self._SSLMode = None
        self._CertId = None
        self._CertCaId = None
        self._Status = None

    @property
    def ListenerId(self):
        r"""CLB listener ID
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def ListenerPort(self):
        r"""CLB listener port
        :rtype: int
        """
        return self._ListenerPort

    @ListenerPort.setter
    def ListenerPort(self, ListenerPort):
        self._ListenerPort = ListenerPort

    @property
    def InstancePort(self):
        r"""Backend forwarding port of a listener
        :rtype: int
        """
        return self._InstancePort

    @InstancePort.setter
    def InstancePort(self, InstancePort):
        self._InstancePort = InstancePort

    @property
    def ListenerName(self):
        r"""Listener name
        :rtype: str
        """
        return self._ListenerName

    @ListenerName.setter
    def ListenerName(self, ListenerName):
        self._ListenerName = ListenerName

    @property
    def Protocol(self):
        r"""Listener protocol type
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def SessionExpire(self):
        r"""Session persistence time
        :rtype: int
        """
        return self._SessionExpire

    @SessionExpire.setter
    def SessionExpire(self, SessionExpire):
        self._SessionExpire = SessionExpire

    @property
    def HealthSwitch(self):
        r"""Whether health check is enabled. 1: enabled; 0: disabled.
        :rtype: int
        """
        return self._HealthSwitch

    @HealthSwitch.setter
    def HealthSwitch(self, HealthSwitch):
        self._HealthSwitch = HealthSwitch

    @property
    def TimeOut(self):
        r"""Response timeout period
        :rtype: int
        """
        return self._TimeOut

    @TimeOut.setter
    def TimeOut(self, TimeOut):
        self._TimeOut = TimeOut

    @property
    def IntervalTime(self):
        r"""Check interval
        :rtype: int
        """
        return self._IntervalTime

    @IntervalTime.setter
    def IntervalTime(self, IntervalTime):
        self._IntervalTime = IntervalTime

    @property
    def HealthNum(self):
        r"""Health threshold
        :rtype: int
        """
        return self._HealthNum

    @HealthNum.setter
    def HealthNum(self, HealthNum):
        self._HealthNum = HealthNum

    @property
    def UnhealthNum(self):
        r"""Unhealthy threshold
        :rtype: int
        """
        return self._UnhealthNum

    @UnhealthNum.setter
    def UnhealthNum(self, UnhealthNum):
        self._UnhealthNum = UnhealthNum

    @property
    def HttpHash(self):
        r"""Request balancing method for listeners of the classic public network CLB. An empty string or wrr indicates weighted round robin. ip_hash indicates consistent hashing based on the accessed source IP address. least_conn indicates least connections.
        :rtype: str
        """
        return self._HttpHash

    @HttpHash.setter
    def HttpHash(self, HttpHash):
        self._HttpHash = HttpHash

    @property
    def HttpCode(self):
        r"""Health check return code for HTTP and HTTPS listeners of a public network classic CLB. For more information, see the explanation of the field in the listener creating API.
        :rtype: int
        """
        return self._HttpCode

    @HttpCode.setter
    def HttpCode(self, HttpCode):
        self._HttpCode = HttpCode

    @property
    def HttpCheckPath(self):
        r"""Health check path for HTTP and HTTPS listeners of a public network classic CLB
        :rtype: str
        """
        return self._HttpCheckPath

    @HttpCheckPath.setter
    def HttpCheckPath(self, HttpCheckPath):
        self._HttpCheckPath = HttpCheckPath

    @property
    def SSLMode(self):
        r"""Authentication method for an HTTPS listener of a public network classic CLB
        :rtype: str
        """
        return self._SSLMode

    @SSLMode.setter
    def SSLMode(self, SSLMode):
        self._SSLMode = SSLMode

    @property
    def CertId(self):
        r"""Server certificate ID for an HTTPS listener of a public network classic CLB
        :rtype: str
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId

    @property
    def CertCaId(self):
        r"""Client certificate ID for an HTTPS listener of a public network classic CLB
        :rtype: str
        """
        return self._CertCaId

    @CertCaId.setter
    def CertCaId(self, CertCaId):
        self._CertCaId = CertCaId

    @property
    def Status(self):
        r"""Listener status. Value range: 0 (creating), 1 (running)
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._ListenerId = params.get("ListenerId")
        self._ListenerPort = params.get("ListenerPort")
        self._InstancePort = params.get("InstancePort")
        self._ListenerName = params.get("ListenerName")
        self._Protocol = params.get("Protocol")
        self._SessionExpire = params.get("SessionExpire")
        self._HealthSwitch = params.get("HealthSwitch")
        self._TimeOut = params.get("TimeOut")
        self._IntervalTime = params.get("IntervalTime")
        self._HealthNum = params.get("HealthNum")
        self._UnhealthNum = params.get("UnhealthNum")
        self._HttpHash = params.get("HttpHash")
        self._HttpCode = params.get("HttpCode")
        self._HttpCheckPath = params.get("HttpCheckPath")
        self._SSLMode = params.get("SSLMode")
        self._CertId = params.get("CertId")
        self._CertCaId = params.get("CertCaId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassicalLoadBalancerInfo(AbstractModel):
    r"""CLB information

    """

    def __init__(self):
        r"""
        :param _InstanceId: Real server ID
        :type InstanceId: str
        :param _LoadBalancerIds: CLB instance ID list
        :type LoadBalancerIds: list of str
        """
        self._InstanceId = None
        self._LoadBalancerIds = None

    @property
    def InstanceId(self):
        r"""Real server ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def LoadBalancerIds(self):
        r"""CLB instance ID list
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassicalTarget(AbstractModel):
    r"""Real server information of a classic CLB

    """

    def __init__(self):
        r"""
        :param _Type: Real server type. Value range: CVM, ENI (coming soon)
        :type Type: str
        :param _InstanceId: Unique ID of a real server, which can be obtained from the unInstanceId field in the return of the DescribeInstances API
        :type InstanceId: str
        :param _Weight: Forwarding weight of a real server. Value range: [0, 100]. Default value: 10.
        :type Weight: int
        :param _PublicIpAddresses: Public network IP of the real server
        :type PublicIpAddresses: list of str
        :param _PrivateIpAddresses: Private network IP of the real server
        :type PrivateIpAddresses: list of str
        :param _InstanceName: Instance name of the real server
        :type InstanceName: str
        :param _RunFlag: Backend service status.
1: failed; 2: running; 3: creating; 4: shut down; 5: returned; 6: returning; 7: restarting; 8: starting; 9: shutting down; 10: resetting password; 11: formatting; 12: making image; 13: setting bandwidth; 14: reinstalling system; 19: upgrading; 21: hot migrating.
        :type RunFlag: int
        """
        self._Type = None
        self._InstanceId = None
        self._Weight = None
        self._PublicIpAddresses = None
        self._PrivateIpAddresses = None
        self._InstanceName = None
        self._RunFlag = None

    @property
    def Type(self):
        r"""Real server type. Value range: CVM, ENI (coming soon)
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InstanceId(self):
        r"""Unique ID of a real server, which can be obtained from the unInstanceId field in the return of the DescribeInstances API
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Weight(self):
        r"""Forwarding weight of a real server. Value range: [0, 100]. Default value: 10.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def PublicIpAddresses(self):
        r"""Public network IP of the real server
        :rtype: list of str
        """
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses

    @property
    def PrivateIpAddresses(self):
        r"""Private network IP of the real server
        :rtype: list of str
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def InstanceName(self):
        r"""Instance name of the real server
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def RunFlag(self):
        r"""Backend service status.
1: failed; 2: running; 3: creating; 4: shut down; 5: returned; 6: returning; 7: restarting; 8: starting; 9: shutting down; 10: resetting password; 11: formatting; 12: making image; 13: setting bandwidth; 14: reinstalling system; 19: upgrading; 21: hot migrating.
        :rtype: int
        """
        return self._RunFlag

    @RunFlag.setter
    def RunFlag(self, RunFlag):
        self._RunFlag = RunFlag


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._InstanceId = params.get("InstanceId")
        self._Weight = params.get("Weight")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        self._PrivateIpAddresses = params.get("PrivateIpAddresses")
        self._InstanceName = params.get("InstanceName")
        self._RunFlag = params.get("RunFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassicalTargetInfo(AbstractModel):
    r"""Backend information of a classic CLB

    """

    def __init__(self):
        r"""
        :param _InstanceId: Real server ID
        :type InstanceId: str
        :param _Weight: Weight. Value range: [0, 100]
        :type Weight: int
        """
        self._InstanceId = None
        self._Weight = None

    @property
    def InstanceId(self):
        r"""Real server ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Weight(self):
        r"""Weight. Value range: [0, 100]
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloneLoadBalancerRequest(AbstractModel):
    r"""CloneLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: Specifies the clb ID. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to obtain the ID.
        :type LoadBalancerId: str
        :param _LoadBalancerName: Specifies the name of the cloned load balancing instance. rule: 1-60 english letters, chinese characters, digits, connecting lines "-", or underscores "_".
Note: if the name is identical to that of an existing load balancing instance in the system, the system will automatically generate a name for the created cloud load balancer instance.
        :type LoadBalancerName: str
        :param _ProjectId: ID of the project to which a CLB instance belongs, which can be obtained through the `DescribeProject` API. If this parameter is not passed in, the default project will be used.
        :type ProjectId: int
        :param _MasterZoneId: Sets the primary AZ ID for cross-AZ disaster recovery, such as `100001` or `ap-guangzhou-1`, which is applicable only to public network CLB.
Note: A primary AZ loads traffic, while a secondary AZ does not load traffic by default and will be used only if the primary AZ becomes unavailable. The platform will automatically select the optimal secondary AZ. You can use the `DescribeResource` API to query the primary AZ list of a region.
        :type MasterZoneId: str
        :param _SlaveZoneId: Specifies the secondary AZ ID for cross-AZ disaster recovery, such as `100001` or `ap-guangzhou-1`. It is applicable only to public network CLB.
Note: A secondary AZ will load traffic if the primary AZ is faulty. You can use the `DescribeMasterZones` API to query the primary and secondary AZ list of a region.
        :type SlaveZoneId: str
        :param _ZoneId: Applicable only to public network clb. AZ ID, both availability zone ID and name are supported. specify availability zone to create a load balancing instance, for example: 100001 or ap-guangzhou-1. if not passed, queries CVM instances in all azs. if needed, call the API for the query DescribeZones (https://www.tencentcloud.comom/document/product/213/15707?from_cn_redirect=1) to specify availability zone.
        :type ZoneId: str
        :param _InternetAccessible: CLB network billing mode, applicable only to public network CLB instances.
        :type InternetAccessible: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        :param _VipIsp: It only applies to public CLB. Currently, the static single-line IP type is supported only for the regions of Guangzhou, Shanghai, Nanjing, Jinan, Hangzhou, Fuzhou, Beijing, Shijiazhuang, Wuhan, Changsha, Chengdu, and Chongqing. If you need to experience it, contact your business manager. After approval, you can select the ISP type as China Mobile (CMCC), China Unicom (CUCC), or China Telecom (CTCC). The network billing mode should be selected as billing by bandwidth package (BANDWIDTH_PACKAGE). If this parameter is not specified, BGP is used by default. You can use the DescribeResources API to query ISPs supported for a region.
        :type VipIsp: str
        :param _Vip: Specifies the Vip to apply for cloud load balancer.
        :type Vip: str
        :param _Tags: Proceed to purchase cloud load balancer and Tag it at the same time.
        :type Tags: list of TagInfo
        :param _ExclusiveCluster: Exclusive cluster information.
        :type ExclusiveCluster: :class:`tencentcloud.clb.v20180317.models.ExclusiveCluster`
        :param _BandwidthPackageId: BANDWIDTH PACKAGE ID, which can be obtained through the [DescribeBandwidthPackages](https://www.tencentcloud.comom/document/api/215/19209?from_cn_redirect=1) api. specifies this parameter indicates the network billing mode (InternetAccessible.InternetChargeType) supports only billing by BANDWIDTH PACKAGE (BANDWIDTH_PACKAGE).
        :type BandwidthPackageId: str
        :param _SnatPro: Specifies whether the cross-regional or cross-Vpc IP binding feature is supported.
        :type SnatPro: bool
        :param _SnatIps: Enables cross-regional or cross-Vpc IP binding and creates a SnatIp.
        :type SnatIps: list of SnatIp
        :param _ClusterIds: Public network exclusive cluster ID or CDCId. can be obtained through the [DescribeExclusiveClusters](https://www.tencentcloud.comom/document/product/214/49278?from_cn_redirect=1) api.
        :type ClusterIds: list of str
        :param _SlaType: Performance capacity specification. <li>clb.c2.medium (standard type)</li> <li>clb.c3.small (advanced type 1)</li> <li>clb.c3.medium (advanced type 2)</li> <li>clb.c4.small (high-strength type 1)</li> <li>clb.c4.medium (high-strength type 2)</li> <li>clb.c4.large (high-strength type 3)</li> <li>clb.c4.xlarge (high-strength type 4)</li>.
        :type SlaType: str
        :param _ClusterTag: Specifies the Tag of the Stgw exclusive cluster.
        :type ClusterTag: str
        :param _Zones: Applicable only to private network clb. when connected to nearby, select availability zone for deployment. you can call DescribeZones (https://www.tencentcloud.comom/document/product/213/15707?from_cn_redirect=1) to query the availability zone list.
        :type Zones: list of str
        :param _EipAddressId: The unique ID of EIP, such as EIP-qhx8udkc, applicable only to private network clb binding EIP, can be queried through the DescribeAddresses API (https://www.tencentcloud.comom/document/product/215/16702?from_cn_redirect=1).
        :type EipAddressId: str
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._ProjectId = None
        self._MasterZoneId = None
        self._SlaveZoneId = None
        self._ZoneId = None
        self._InternetAccessible = None
        self._VipIsp = None
        self._Vip = None
        self._Tags = None
        self._ExclusiveCluster = None
        self._BandwidthPackageId = None
        self._SnatPro = None
        self._SnatIps = None
        self._ClusterIds = None
        self._SlaType = None
        self._ClusterTag = None
        self._Zones = None
        self._EipAddressId = None

    @property
    def LoadBalancerId(self):
        r"""Specifies the clb ID. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to obtain the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""Specifies the name of the cloned load balancing instance. rule: 1-60 english letters, chinese characters, digits, connecting lines "-", or underscores "_".
Note: if the name is identical to that of an existing load balancing instance in the system, the system will automatically generate a name for the created cloud load balancer instance.
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def ProjectId(self):
        r"""ID of the project to which a CLB instance belongs, which can be obtained through the `DescribeProject` API. If this parameter is not passed in, the default project will be used.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def MasterZoneId(self):
        r"""Sets the primary AZ ID for cross-AZ disaster recovery, such as `100001` or `ap-guangzhou-1`, which is applicable only to public network CLB.
Note: A primary AZ loads traffic, while a secondary AZ does not load traffic by default and will be used only if the primary AZ becomes unavailable. The platform will automatically select the optimal secondary AZ. You can use the `DescribeResource` API to query the primary AZ list of a region.
        :rtype: str
        """
        return self._MasterZoneId

    @MasterZoneId.setter
    def MasterZoneId(self, MasterZoneId):
        self._MasterZoneId = MasterZoneId

    @property
    def SlaveZoneId(self):
        r"""Specifies the secondary AZ ID for cross-AZ disaster recovery, such as `100001` or `ap-guangzhou-1`. It is applicable only to public network CLB.
Note: A secondary AZ will load traffic if the primary AZ is faulty. You can use the `DescribeMasterZones` API to query the primary and secondary AZ list of a region.
        :rtype: str
        """
        return self._SlaveZoneId

    @SlaveZoneId.setter
    def SlaveZoneId(self, SlaveZoneId):
        self._SlaveZoneId = SlaveZoneId

    @property
    def ZoneId(self):
        r"""Applicable only to public network clb. AZ ID, both availability zone ID and name are supported. specify availability zone to create a load balancing instance, for example: 100001 or ap-guangzhou-1. if not passed, queries CVM instances in all azs. if needed, call the API for the query DescribeZones (https://www.tencentcloud.comom/document/product/213/15707?from_cn_redirect=1) to specify availability zone.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def InternetAccessible(self):
        r"""CLB network billing mode, applicable only to public network CLB instances.
        :rtype: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        """
        return self._InternetAccessible

    @InternetAccessible.setter
    def InternetAccessible(self, InternetAccessible):
        self._InternetAccessible = InternetAccessible

    @property
    def VipIsp(self):
        r"""It only applies to public CLB. Currently, the static single-line IP type is supported only for the regions of Guangzhou, Shanghai, Nanjing, Jinan, Hangzhou, Fuzhou, Beijing, Shijiazhuang, Wuhan, Changsha, Chengdu, and Chongqing. If you need to experience it, contact your business manager. After approval, you can select the ISP type as China Mobile (CMCC), China Unicom (CUCC), or China Telecom (CTCC). The network billing mode should be selected as billing by bandwidth package (BANDWIDTH_PACKAGE). If this parameter is not specified, BGP is used by default. You can use the DescribeResources API to query ISPs supported for a region.
        :rtype: str
        """
        return self._VipIsp

    @VipIsp.setter
    def VipIsp(self, VipIsp):
        self._VipIsp = VipIsp

    @property
    def Vip(self):
        r"""Specifies the Vip to apply for cloud load balancer.
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Tags(self):
        r"""Proceed to purchase cloud load balancer and Tag it at the same time.
        :rtype: list of TagInfo
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ExclusiveCluster(self):
        r"""Exclusive cluster information.
        :rtype: :class:`tencentcloud.clb.v20180317.models.ExclusiveCluster`
        """
        return self._ExclusiveCluster

    @ExclusiveCluster.setter
    def ExclusiveCluster(self, ExclusiveCluster):
        self._ExclusiveCluster = ExclusiveCluster

    @property
    def BandwidthPackageId(self):
        r"""BANDWIDTH PACKAGE ID, which can be obtained through the [DescribeBandwidthPackages](https://www.tencentcloud.comom/document/api/215/19209?from_cn_redirect=1) api. specifies this parameter indicates the network billing mode (InternetAccessible.InternetChargeType) supports only billing by BANDWIDTH PACKAGE (BANDWIDTH_PACKAGE).
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def SnatPro(self):
        r"""Specifies whether the cross-regional or cross-Vpc IP binding feature is supported.
        :rtype: bool
        """
        return self._SnatPro

    @SnatPro.setter
    def SnatPro(self, SnatPro):
        self._SnatPro = SnatPro

    @property
    def SnatIps(self):
        r"""Enables cross-regional or cross-Vpc IP binding and creates a SnatIp.
        :rtype: list of SnatIp
        """
        return self._SnatIps

    @SnatIps.setter
    def SnatIps(self, SnatIps):
        self._SnatIps = SnatIps

    @property
    def ClusterIds(self):
        r"""Public network exclusive cluster ID or CDCId. can be obtained through the [DescribeExclusiveClusters](https://www.tencentcloud.comom/document/product/214/49278?from_cn_redirect=1) api.
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def SlaType(self):
        r"""Performance capacity specification. <li>clb.c2.medium (standard type)</li> <li>clb.c3.small (advanced type 1)</li> <li>clb.c3.medium (advanced type 2)</li> <li>clb.c4.small (high-strength type 1)</li> <li>clb.c4.medium (high-strength type 2)</li> <li>clb.c4.large (high-strength type 3)</li> <li>clb.c4.xlarge (high-strength type 4)</li>.
        :rtype: str
        """
        return self._SlaType

    @SlaType.setter
    def SlaType(self, SlaType):
        self._SlaType = SlaType

    @property
    def ClusterTag(self):
        r"""Specifies the Tag of the Stgw exclusive cluster.
        :rtype: str
        """
        return self._ClusterTag

    @ClusterTag.setter
    def ClusterTag(self, ClusterTag):
        self._ClusterTag = ClusterTag

    @property
    def Zones(self):
        r"""Applicable only to private network clb. when connected to nearby, select availability zone for deployment. you can call DescribeZones (https://www.tencentcloud.comom/document/product/213/15707?from_cn_redirect=1) to query the availability zone list.
        :rtype: list of str
        """
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones

    @property
    def EipAddressId(self):
        r"""The unique ID of EIP, such as EIP-qhx8udkc, applicable only to private network clb binding EIP, can be queried through the DescribeAddresses API (https://www.tencentcloud.comom/document/product/215/16702?from_cn_redirect=1).
        :rtype: str
        """
        return self._EipAddressId

    @EipAddressId.setter
    def EipAddressId(self, EipAddressId):
        self._EipAddressId = EipAddressId


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._ProjectId = params.get("ProjectId")
        self._MasterZoneId = params.get("MasterZoneId")
        self._SlaveZoneId = params.get("SlaveZoneId")
        self._ZoneId = params.get("ZoneId")
        if params.get("InternetAccessible") is not None:
            self._InternetAccessible = InternetAccessible()
            self._InternetAccessible._deserialize(params.get("InternetAccessible"))
        self._VipIsp = params.get("VipIsp")
        self._Vip = params.get("Vip")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        if params.get("ExclusiveCluster") is not None:
            self._ExclusiveCluster = ExclusiveCluster()
            self._ExclusiveCluster._deserialize(params.get("ExclusiveCluster"))
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._SnatPro = params.get("SnatPro")
        if params.get("SnatIps") is not None:
            self._SnatIps = []
            for item in params.get("SnatIps"):
                obj = SnatIp()
                obj._deserialize(item)
                self._SnatIps.append(obj)
        self._ClusterIds = params.get("ClusterIds")
        self._SlaType = params.get("SlaType")
        self._ClusterTag = params.get("ClusterTag")
        self._Zones = params.get("Zones")
        self._EipAddressId = params.get("EipAddressId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloneLoadBalancerResponse(AbstractModel):
    r"""CloneLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ClusterItem(AbstractModel):
    r"""Dedicated cluster information

    """

    def __init__(self):
        r"""
        :param _ClusterId: Unique cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name.
        :type ClusterName: str
        :param _Zone: Cluster AZ, such as ap-guangzhou-1
Note: this field may return null, indicating that no valid values can be obtained.
        :type Zone: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._Zone = None

    @property
    def ClusterId(self):
        r"""Unique cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""Cluster name.
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Zone(self):
        r"""Cluster AZ, such as ap-guangzhou-1
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._Zone = params.get("Zone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigListItem(AbstractModel):
    r"""Configuration content

    """

    def __init__(self):
        r"""
        :param _UconfigId: Configuration ID.
        :type UconfigId: str
        :param _ConfigType: Configuration type. available values: CLB (instance dimension configuration), SERVER (service dimension configuration), LOCATION (rule dimension configuration).
        :type ConfigType: str
        :param _ConfigName: Configuration name
        :type ConfigName: str
        :param _ConfigContent: Configuration content.
        :type ConfigContent: str
        :param _CreateTimestamp: Specifies the configured creation time.
Format: YYYY-MM-DD HH:MM:ss.
        :type CreateTimestamp: str
        :param _UpdateTimestamp: Specifies the modification time of the configuration.
Format: YYYY-MM-DD HH:MM:ss.
        :type UpdateTimestamp: str
        """
        self._UconfigId = None
        self._ConfigType = None
        self._ConfigName = None
        self._ConfigContent = None
        self._CreateTimestamp = None
        self._UpdateTimestamp = None

    @property
    def UconfigId(self):
        r"""Configuration ID.
        :rtype: str
        """
        return self._UconfigId

    @UconfigId.setter
    def UconfigId(self, UconfigId):
        self._UconfigId = UconfigId

    @property
    def ConfigType(self):
        r"""Configuration type. available values: CLB (instance dimension configuration), SERVER (service dimension configuration), LOCATION (rule dimension configuration).
        :rtype: str
        """
        return self._ConfigType

    @ConfigType.setter
    def ConfigType(self, ConfigType):
        self._ConfigType = ConfigType

    @property
    def ConfigName(self):
        r"""Configuration name
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def ConfigContent(self):
        r"""Configuration content.
        :rtype: str
        """
        return self._ConfigContent

    @ConfigContent.setter
    def ConfigContent(self, ConfigContent):
        self._ConfigContent = ConfigContent

    @property
    def CreateTimestamp(self):
        r"""Specifies the configured creation time.
Format: YYYY-MM-DD HH:MM:ss.
        :rtype: str
        """
        return self._CreateTimestamp

    @CreateTimestamp.setter
    def CreateTimestamp(self, CreateTimestamp):
        self._CreateTimestamp = CreateTimestamp

    @property
    def UpdateTimestamp(self):
        r"""Specifies the modification time of the configuration.
Format: YYYY-MM-DD HH:MM:ss.
        :rtype: str
        """
        return self._UpdateTimestamp

    @UpdateTimestamp.setter
    def UpdateTimestamp(self, UpdateTimestamp):
        self._UpdateTimestamp = UpdateTimestamp


    def _deserialize(self, params):
        self._UconfigId = params.get("UconfigId")
        self._ConfigType = params.get("ConfigType")
        self._ConfigName = params.get("ConfigName")
        self._ConfigContent = params.get("ConfigContent")
        self._CreateTimestamp = params.get("CreateTimestamp")
        self._UpdateTimestamp = params.get("UpdateTimestamp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClsLogSetRequest(AbstractModel):
    r"""CreateClsLogSet request structure.

    """

    def __init__(self):
        r"""
        :param _LogsetName: Logset name, which must be unique among all CLS logsets; default value: clb_logset
        :type LogsetName: str
        :param _Period: Logset retention period (in days)
        :type Period: int
        :param _LogsetType: Logset type. Valid values: ACCESS (access logs; default value) and HEALTH (health check logs).
        :type LogsetType: str
        """
        self._LogsetName = None
        self._Period = None
        self._LogsetType = None

    @property
    def LogsetName(self):
        r"""Logset name, which must be unique among all CLS logsets; default value: clb_logset
        :rtype: str
        """
        return self._LogsetName

    @LogsetName.setter
    def LogsetName(self, LogsetName):
        self._LogsetName = LogsetName

    @property
    def Period(self):
        warnings.warn("parameter `Period` is deprecated", DeprecationWarning) 

        r"""Logset retention period (in days)
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        warnings.warn("parameter `Period` is deprecated", DeprecationWarning) 

        self._Period = Period

    @property
    def LogsetType(self):
        r"""Logset type. Valid values: ACCESS (access logs; default value) and HEALTH (health check logs).
        :rtype: str
        """
        return self._LogsetType

    @LogsetType.setter
    def LogsetType(self, LogsetType):
        self._LogsetType = LogsetType


    def _deserialize(self, params):
        self._LogsetName = params.get("LogsetName")
        self._Period = params.get("Period")
        self._LogsetType = params.get("LogsetType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClsLogSetResponse(AbstractModel):
    r"""CreateClsLogSet response structure.

    """

    def __init__(self):
        r"""
        :param _LogsetId: Logset ID.
        :type LogsetId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LogsetId = None
        self._RequestId = None

    @property
    def LogsetId(self):
        r"""Logset ID.
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LogsetId = params.get("LogsetId")
        self._RequestId = params.get("RequestId")


class CreateListenerRequest(AbstractModel):
    r"""CreateListener request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the CLB instance. You can call the [DescribeLoadBalancers](https://intl.cloud.tencent.com/document/product/214/30685?from_cn_redirect=1) API to obtain the ID.
        :type LoadBalancerId: str
        :param _Ports: Ports for creating listeners. Each port corresponds to a listener.
Port range: 1–65535.
        :type Ports: list of int
        :param _Protocol: Listener protocol. Valid values: TCP, UDP, HTTP, HTTPS, TCP_SSL, and QUIC.
        :type Protocol: str
        :param _ListenerNames: List of names of listeners to be created. The names correspond to ports one by one. This parameter can be left blank if you do not want to name the listeners immediately.
        :type ListenerNames: list of str
        :param _HealthCheck: Health check parameter. This parameter applies only to TCP, UDP, TCP_SSL, and QUIC listeners.
        :type HealthCheck: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        :param _Certificate: Certificate-related information. The parameter limitations are as follows:
<li>This parameter applies only to TCP_SSL listeners and HTTPS listeners with the SNI feature disabled.</li>
<li>Either this parameter or the MultiCertInfo parameter should be specified when you create a TCP_SSL listener or an HTTPS listener with the SNI feature disabled. You cannot specify them at the same time.</li>
        :type Certificate: :class:`tencentcloud.clb.v20180317.models.CertificateInput`
        :param _SessionExpireTime: Session persistence duration, in seconds. Value range: 30–3600. Default value: 0, indicating that session persistence is not enabled by default. This parameter applies only to TCP and UDP listeners.
        :type SessionExpireTime: int
        :param _Scheduler: Listener forwarding mode. valid values: WRR (weighted round-robin), LEAST_CONN (LEAST connections).
Default value: WRR. This parameter applies only to TCP, UDP, TCP_SSL, and QUIC listeners.
        :type Scheduler: str
        :param _SniSwitch: Whether to enable the SNI feature. This parameter applies only to HTTPS listeners. 0: disable; 1: enable.
        :type SniSwitch: int
        :param _TargetType: Real server type. NODE: ordinary node; TARGETGROUP: real server group. This parameter applies only to TCP and UDP listeners. For layer-7 listeners, set the type in forwarding rules.
        :type TargetType: str
        :param _SessionType: Session persistence type. If this parameter is not specified or the value is set to NORMAL, the default session persistence type is used. QUIC_CID: perform session persistence based on QUIC connection ID. If the value is set to QUIC_CID, only the UDP protocol is supported. This parameter applies only to TCP and UDP listeners. For layer-7 listeners, set the type in forwarding rules. (If the value is set to QUIC_CID, the Protocol value should be UDP, the Scheduler value should be WRR, and only IPv4 addresses are supported.)
        :type SessionType: str
        :param _KeepaliveEnable: Whether to enable the persistent connection feature. This parameter applies only to HTTP and HTTPS listeners. 0: disable; 1: enable. This feature is disabled by default.
Enable this feature with caution if the maximum number of connections is limited for real servers. This feature is in beta testing. To use it, submit a [beta testing application](https://intl.cloud.tencent.com/apply/p/tsodp6qm21?from_cn_redirect=1).
        :type KeepaliveEnable: int
        :param _EndPort: End port. This parameter is required for creating a listener with a port range. In this case, the input parameter Ports allows only one value to indicate the start port. To experience the port range feature, [submit a ticket for application](https://console.cloud.tencent.com/workorder/category).
        :type EndPort: int
        :param _DeregisterTargetRst: Reschedules when unbinding real servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :type DeregisterTargetRst: bool
        :param _MultiCertInfo: Certificate information. You can import multiple server certificates with different algorithms at the same time. The parameter limitations are as follows:
<li>This parameter applies only to TCP_SSL listeners and HTTPS listeners with the SNI feature disabled.</li>
<li>Either this parameter or the Certificate parameter should be specified when you create a TCP_SSL listener or an HTTPS listener with the SNI feature disabled. You cannot specify them at the same time.</li>
        :type MultiCertInfo: :class:`tencentcloud.clb.v20180317.models.MultiCertInfo`
        :param _MaxConn: Maximum number of connections to a listener. Currently, this parameter applies only to TCP, UDP, TCP_SSL, and QUIC listeners of LCU-supported instances. If this parameter is not specified or the value is set to -1, the maximum number of connections is not limited. This parameter is not supported for classic network-based instances.
        :type MaxConn: int
        :param _MaxCps: Maximum number of new connections to a listener. Currently, this parameter applies only to TCP, UDP, TCP_SSL, and QUIC listeners of LCU-supported instances. If this parameter is not specified or the value is set to -1, the maximum number of new connections is not limited. This parameter is not supported for classic network-based instances.
        :type MaxCps: int
        :param _IdleConnectTimeout: Specifies the idle connection timeout in seconds. this parameter applies only to TCP/UDP listeners. default value: 900 for TCP listeners and 300 for UDP listeners. value range: 10–900 for shared instances and dedicated instances and 10–1980 for lcu-supported instances. to set a value exceeding the permissible range, [submit a ticket for application](https://console.cloud.tencent.com/workorder/category).
        :type IdleConnectTimeout: int
        :param _ProxyProtocol: Specifies whether PP is supported for TCP_SSL and QUIC.
        :type ProxyProtocol: bool
        :param _SnatEnable: Whether SNAT (source IP replacement) is enabled. valid values: True (enabled), False (disabled). disabled by default. note: when SnatEnable is enabled, the client source IP will be replaced, at this point the `pass through client source IP` option is disabled, and vice versa.
        :type SnatEnable: bool
        :param _FullEndPorts: End port of a listener with a port range. Range of the port: 2–65535.
        :type FullEndPorts: list of int
        :param _H2cSwitch: Enable private network http listener h2c switch. valid values: True (enable), False (disable).
Disabled by default.
        :type H2cSwitch: bool
        :param _SslCloseSwitch: Whether to disable SSL for TCP_SSL listeners. dual-stack binding is still supported after SSL is disabled. valid values: True (disable), False (enable).
Disabled by default.
        :type SslCloseSwitch: bool
        :param _DataCompressMode: Data compression mode. Valid values: transparent (passthrough mode) and compatibility (compatibility mode).
        :type DataCompressMode: str
        :param _RescheduleTargetZeroWeight: Reschedules when setting backend server weight to 0. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :type RescheduleTargetZeroWeight: bool
        :param _RescheduleUnhealthy: Reschedules when health check exceptions occur on real servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :type RescheduleUnhealthy: bool
        :param _RescheduleExpandTarget: Reschedules when adding or removing backend servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :type RescheduleExpandTarget: bool
        :param _RescheduleStartTime: Specifies the trigger start time for rescheduling. value range: 0-3600s. supported only by TCP/UDP listeners.
        :type RescheduleStartTime: int
        :param _RescheduleInterval: Rescheduling trigger duration. valid values: 0-3600s. only TCP/UDP listeners support this.
        :type RescheduleInterval: int
        """
        self._LoadBalancerId = None
        self._Ports = None
        self._Protocol = None
        self._ListenerNames = None
        self._HealthCheck = None
        self._Certificate = None
        self._SessionExpireTime = None
        self._Scheduler = None
        self._SniSwitch = None
        self._TargetType = None
        self._SessionType = None
        self._KeepaliveEnable = None
        self._EndPort = None
        self._DeregisterTargetRst = None
        self._MultiCertInfo = None
        self._MaxConn = None
        self._MaxCps = None
        self._IdleConnectTimeout = None
        self._ProxyProtocol = None
        self._SnatEnable = None
        self._FullEndPorts = None
        self._H2cSwitch = None
        self._SslCloseSwitch = None
        self._DataCompressMode = None
        self._RescheduleTargetZeroWeight = None
        self._RescheduleUnhealthy = None
        self._RescheduleExpandTarget = None
        self._RescheduleStartTime = None
        self._RescheduleInterval = None

    @property
    def LoadBalancerId(self):
        r"""ID of the CLB instance. You can call the [DescribeLoadBalancers](https://intl.cloud.tencent.com/document/product/214/30685?from_cn_redirect=1) API to obtain the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def Ports(self):
        r"""Ports for creating listeners. Each port corresponds to a listener.
Port range: 1–65535.
        :rtype: list of int
        """
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def Protocol(self):
        r"""Listener protocol. Valid values: TCP, UDP, HTTP, HTTPS, TCP_SSL, and QUIC.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def ListenerNames(self):
        r"""List of names of listeners to be created. The names correspond to ports one by one. This parameter can be left blank if you do not want to name the listeners immediately.
        :rtype: list of str
        """
        return self._ListenerNames

    @ListenerNames.setter
    def ListenerNames(self, ListenerNames):
        self._ListenerNames = ListenerNames

    @property
    def HealthCheck(self):
        r"""Health check parameter. This parameter applies only to TCP, UDP, TCP_SSL, and QUIC listeners.
        :rtype: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def Certificate(self):
        r"""Certificate-related information. The parameter limitations are as follows:
<li>This parameter applies only to TCP_SSL listeners and HTTPS listeners with the SNI feature disabled.</li>
<li>Either this parameter or the MultiCertInfo parameter should be specified when you create a TCP_SSL listener or an HTTPS listener with the SNI feature disabled. You cannot specify them at the same time.</li>
        :rtype: :class:`tencentcloud.clb.v20180317.models.CertificateInput`
        """
        return self._Certificate

    @Certificate.setter
    def Certificate(self, Certificate):
        self._Certificate = Certificate

    @property
    def SessionExpireTime(self):
        r"""Session persistence duration, in seconds. Value range: 30–3600. Default value: 0, indicating that session persistence is not enabled by default. This parameter applies only to TCP and UDP listeners.
        :rtype: int
        """
        return self._SessionExpireTime

    @SessionExpireTime.setter
    def SessionExpireTime(self, SessionExpireTime):
        self._SessionExpireTime = SessionExpireTime

    @property
    def Scheduler(self):
        r"""Listener forwarding mode. valid values: WRR (weighted round-robin), LEAST_CONN (LEAST connections).
Default value: WRR. This parameter applies only to TCP, UDP, TCP_SSL, and QUIC listeners.
        :rtype: str
        """
        return self._Scheduler

    @Scheduler.setter
    def Scheduler(self, Scheduler):
        self._Scheduler = Scheduler

    @property
    def SniSwitch(self):
        r"""Whether to enable the SNI feature. This parameter applies only to HTTPS listeners. 0: disable; 1: enable.
        :rtype: int
        """
        return self._SniSwitch

    @SniSwitch.setter
    def SniSwitch(self, SniSwitch):
        self._SniSwitch = SniSwitch

    @property
    def TargetType(self):
        r"""Real server type. NODE: ordinary node; TARGETGROUP: real server group. This parameter applies only to TCP and UDP listeners. For layer-7 listeners, set the type in forwarding rules.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def SessionType(self):
        r"""Session persistence type. If this parameter is not specified or the value is set to NORMAL, the default session persistence type is used. QUIC_CID: perform session persistence based on QUIC connection ID. If the value is set to QUIC_CID, only the UDP protocol is supported. This parameter applies only to TCP and UDP listeners. For layer-7 listeners, set the type in forwarding rules. (If the value is set to QUIC_CID, the Protocol value should be UDP, the Scheduler value should be WRR, and only IPv4 addresses are supported.)
        :rtype: str
        """
        return self._SessionType

    @SessionType.setter
    def SessionType(self, SessionType):
        self._SessionType = SessionType

    @property
    def KeepaliveEnable(self):
        r"""Whether to enable the persistent connection feature. This parameter applies only to HTTP and HTTPS listeners. 0: disable; 1: enable. This feature is disabled by default.
Enable this feature with caution if the maximum number of connections is limited for real servers. This feature is in beta testing. To use it, submit a [beta testing application](https://intl.cloud.tencent.com/apply/p/tsodp6qm21?from_cn_redirect=1).
        :rtype: int
        """
        return self._KeepaliveEnable

    @KeepaliveEnable.setter
    def KeepaliveEnable(self, KeepaliveEnable):
        self._KeepaliveEnable = KeepaliveEnable

    @property
    def EndPort(self):
        r"""End port. This parameter is required for creating a listener with a port range. In this case, the input parameter Ports allows only one value to indicate the start port. To experience the port range feature, [submit a ticket for application](https://console.cloud.tencent.com/workorder/category).
        :rtype: int
        """
        return self._EndPort

    @EndPort.setter
    def EndPort(self, EndPort):
        self._EndPort = EndPort

    @property
    def DeregisterTargetRst(self):
        r"""Reschedules when unbinding real servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :rtype: bool
        """
        return self._DeregisterTargetRst

    @DeregisterTargetRst.setter
    def DeregisterTargetRst(self, DeregisterTargetRst):
        self._DeregisterTargetRst = DeregisterTargetRst

    @property
    def MultiCertInfo(self):
        r"""Certificate information. You can import multiple server certificates with different algorithms at the same time. The parameter limitations are as follows:
<li>This parameter applies only to TCP_SSL listeners and HTTPS listeners with the SNI feature disabled.</li>
<li>Either this parameter or the Certificate parameter should be specified when you create a TCP_SSL listener or an HTTPS listener with the SNI feature disabled. You cannot specify them at the same time.</li>
        :rtype: :class:`tencentcloud.clb.v20180317.models.MultiCertInfo`
        """
        return self._MultiCertInfo

    @MultiCertInfo.setter
    def MultiCertInfo(self, MultiCertInfo):
        self._MultiCertInfo = MultiCertInfo

    @property
    def MaxConn(self):
        r"""Maximum number of connections to a listener. Currently, this parameter applies only to TCP, UDP, TCP_SSL, and QUIC listeners of LCU-supported instances. If this parameter is not specified or the value is set to -1, the maximum number of connections is not limited. This parameter is not supported for classic network-based instances.
        :rtype: int
        """
        return self._MaxConn

    @MaxConn.setter
    def MaxConn(self, MaxConn):
        self._MaxConn = MaxConn

    @property
    def MaxCps(self):
        r"""Maximum number of new connections to a listener. Currently, this parameter applies only to TCP, UDP, TCP_SSL, and QUIC listeners of LCU-supported instances. If this parameter is not specified or the value is set to -1, the maximum number of new connections is not limited. This parameter is not supported for classic network-based instances.
        :rtype: int
        """
        return self._MaxCps

    @MaxCps.setter
    def MaxCps(self, MaxCps):
        self._MaxCps = MaxCps

    @property
    def IdleConnectTimeout(self):
        r"""Specifies the idle connection timeout in seconds. this parameter applies only to TCP/UDP listeners. default value: 900 for TCP listeners and 300 for UDP listeners. value range: 10–900 for shared instances and dedicated instances and 10–1980 for lcu-supported instances. to set a value exceeding the permissible range, [submit a ticket for application](https://console.cloud.tencent.com/workorder/category).
        :rtype: int
        """
        return self._IdleConnectTimeout

    @IdleConnectTimeout.setter
    def IdleConnectTimeout(self, IdleConnectTimeout):
        self._IdleConnectTimeout = IdleConnectTimeout

    @property
    def ProxyProtocol(self):
        r"""Specifies whether PP is supported for TCP_SSL and QUIC.
        :rtype: bool
        """
        return self._ProxyProtocol

    @ProxyProtocol.setter
    def ProxyProtocol(self, ProxyProtocol):
        self._ProxyProtocol = ProxyProtocol

    @property
    def SnatEnable(self):
        r"""Whether SNAT (source IP replacement) is enabled. valid values: True (enabled), False (disabled). disabled by default. note: when SnatEnable is enabled, the client source IP will be replaced, at this point the `pass through client source IP` option is disabled, and vice versa.
        :rtype: bool
        """
        return self._SnatEnable

    @SnatEnable.setter
    def SnatEnable(self, SnatEnable):
        self._SnatEnable = SnatEnable

    @property
    def FullEndPorts(self):
        r"""End port of a listener with a port range. Range of the port: 2–65535.
        :rtype: list of int
        """
        return self._FullEndPorts

    @FullEndPorts.setter
    def FullEndPorts(self, FullEndPorts):
        self._FullEndPorts = FullEndPorts

    @property
    def H2cSwitch(self):
        r"""Enable private network http listener h2c switch. valid values: True (enable), False (disable).
Disabled by default.
        :rtype: bool
        """
        return self._H2cSwitch

    @H2cSwitch.setter
    def H2cSwitch(self, H2cSwitch):
        self._H2cSwitch = H2cSwitch

    @property
    def SslCloseSwitch(self):
        r"""Whether to disable SSL for TCP_SSL listeners. dual-stack binding is still supported after SSL is disabled. valid values: True (disable), False (enable).
Disabled by default.
        :rtype: bool
        """
        return self._SslCloseSwitch

    @SslCloseSwitch.setter
    def SslCloseSwitch(self, SslCloseSwitch):
        self._SslCloseSwitch = SslCloseSwitch

    @property
    def DataCompressMode(self):
        r"""Data compression mode. Valid values: transparent (passthrough mode) and compatibility (compatibility mode).
        :rtype: str
        """
        return self._DataCompressMode

    @DataCompressMode.setter
    def DataCompressMode(self, DataCompressMode):
        self._DataCompressMode = DataCompressMode

    @property
    def RescheduleTargetZeroWeight(self):
        r"""Reschedules when setting backend server weight to 0. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :rtype: bool
        """
        return self._RescheduleTargetZeroWeight

    @RescheduleTargetZeroWeight.setter
    def RescheduleTargetZeroWeight(self, RescheduleTargetZeroWeight):
        self._RescheduleTargetZeroWeight = RescheduleTargetZeroWeight

    @property
    def RescheduleUnhealthy(self):
        r"""Reschedules when health check exceptions occur on real servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :rtype: bool
        """
        return self._RescheduleUnhealthy

    @RescheduleUnhealthy.setter
    def RescheduleUnhealthy(self, RescheduleUnhealthy):
        self._RescheduleUnhealthy = RescheduleUnhealthy

    @property
    def RescheduleExpandTarget(self):
        r"""Reschedules when adding or removing backend servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :rtype: bool
        """
        return self._RescheduleExpandTarget

    @RescheduleExpandTarget.setter
    def RescheduleExpandTarget(self, RescheduleExpandTarget):
        self._RescheduleExpandTarget = RescheduleExpandTarget

    @property
    def RescheduleStartTime(self):
        r"""Specifies the trigger start time for rescheduling. value range: 0-3600s. supported only by TCP/UDP listeners.
        :rtype: int
        """
        return self._RescheduleStartTime

    @RescheduleStartTime.setter
    def RescheduleStartTime(self, RescheduleStartTime):
        self._RescheduleStartTime = RescheduleStartTime

    @property
    def RescheduleInterval(self):
        r"""Rescheduling trigger duration. valid values: 0-3600s. only TCP/UDP listeners support this.
        :rtype: int
        """
        return self._RescheduleInterval

    @RescheduleInterval.setter
    def RescheduleInterval(self, RescheduleInterval):
        self._RescheduleInterval = RescheduleInterval


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._Ports = params.get("Ports")
        self._Protocol = params.get("Protocol")
        self._ListenerNames = params.get("ListenerNames")
        if params.get("HealthCheck") is not None:
            self._HealthCheck = HealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        if params.get("Certificate") is not None:
            self._Certificate = CertificateInput()
            self._Certificate._deserialize(params.get("Certificate"))
        self._SessionExpireTime = params.get("SessionExpireTime")
        self._Scheduler = params.get("Scheduler")
        self._SniSwitch = params.get("SniSwitch")
        self._TargetType = params.get("TargetType")
        self._SessionType = params.get("SessionType")
        self._KeepaliveEnable = params.get("KeepaliveEnable")
        self._EndPort = params.get("EndPort")
        self._DeregisterTargetRst = params.get("DeregisterTargetRst")
        if params.get("MultiCertInfo") is not None:
            self._MultiCertInfo = MultiCertInfo()
            self._MultiCertInfo._deserialize(params.get("MultiCertInfo"))
        self._MaxConn = params.get("MaxConn")
        self._MaxCps = params.get("MaxCps")
        self._IdleConnectTimeout = params.get("IdleConnectTimeout")
        self._ProxyProtocol = params.get("ProxyProtocol")
        self._SnatEnable = params.get("SnatEnable")
        self._FullEndPorts = params.get("FullEndPorts")
        self._H2cSwitch = params.get("H2cSwitch")
        self._SslCloseSwitch = params.get("SslCloseSwitch")
        self._DataCompressMode = params.get("DataCompressMode")
        self._RescheduleTargetZeroWeight = params.get("RescheduleTargetZeroWeight")
        self._RescheduleUnhealthy = params.get("RescheduleUnhealthy")
        self._RescheduleExpandTarget = params.get("RescheduleExpandTarget")
        self._RescheduleStartTime = params.get("RescheduleStartTime")
        self._RescheduleInterval = params.get("RescheduleInterval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateListenerResponse(AbstractModel):
    r"""CreateListener response structure.

    """

    def __init__(self):
        r"""
        :param _ListenerIds: Array of the unique IDs of created listeners.
        :type ListenerIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ListenerIds = None
        self._RequestId = None

    @property
    def ListenerIds(self):
        r"""Array of the unique IDs of created listeners.
        :rtype: list of str
        """
        return self._ListenerIds

    @ListenerIds.setter
    def ListenerIds(self, ListenerIds):
        self._ListenerIds = ListenerIds

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ListenerIds = params.get("ListenerIds")
        self._RequestId = params.get("RequestId")


class CreateLoadBalancerRequest(AbstractModel):
    r"""CreateLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerType: CLB instance network type:
OPEN: public network; INTERNAL: private network.
        :type LoadBalancerType: str
        :param _Forward: CLB instance type. Valid value: 1 (generic CLB instance).
        :type Forward: int
        :param _LoadBalancerName: CLB instance name, which takes effect only when only one instance is to be created in the request. It can consist 1 to 60 letters, digits, hyphens (-), or underscores (_).
Note: if the name of the new CLB instance already exists, a default name will be generated automatically.
        :type LoadBalancerName: str
        :param _VpcId: Network ID of the target device on the CLB backend, such as `vpc-12345678`, which can be obtained through the `DescribeVpcEx` API. If this parameter is not entered, `DefaultVPC` is used by default. This parameter is required when creating a private network instance.
        :type VpcId: str
        :param _SubnetId: A subnet ID should be specified when you purchase a private network CLB instance under a VPC. The VIP of the private network CLB instance is in this subnet. This parameter is required when you create a private network CLB instance but not supported when you create a public network IPv4 CLB instance.
        :type SubnetId: str
        :param _ProjectId: ID of the project to which a CLB instance belongs, which can be obtained through the `DescribeProject` API. If this parameter is not entered, the default project will be used.
        :type ProjectId: int
        :param _AddressIPVersion: It's only applicable to public network CLB instances. IP version. Values: `IPV4`, `IPV6` and `IPv6FullChain` (case-insensitive). Default: `IPV4`. Note: `IPV6` indicates IPv6 NAT64, while `IPv6FullChain` indicates IPv6. 
        :type AddressIPVersion: str
        :param _Number: Specifies the count of cloud load balancers to create, with a default value of 1. the count must not exceed the maximum value allowed for the account, with a default creation maximum value of 20.
        :type Number: int
        :param _MasterZoneId: Applicable only to public network IPv4 cloud load balancer instances. specifies the primary AZ ID for cross-az disaster recovery. both AZ ID and name are supported, such as 100001 or ap-guangzhou-1.
Note: the primary AZ loads traffic. the secondary AZ does not load traffic by default and is used only if the primary AZ becomes unavailable.
        :type MasterZoneId: str
        :param _ZoneId: Applicable only to public network IPv4 clb instances. specifies the AZ ID or availability zone name for creating a clb instance. for example, 100001 or ap-guangzhou-1.
        :type ZoneId: str
        :param _InternetAccessible: Network billing mode by the maximum outbound bandwidth. It applies only to private network LCU-supported instances and all public network instances. The feature of purchasing monthly subscription instances via an API is under grayscale release. If you want to experience this feature, [submit a ticket](https://console.cloud.tencent.com/workorder/category).
        :type InternetAccessible: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        :param _VipIsp: ISP of VIP. Values: `CMCC` (China Mobile), `CUCC` (China Unicom) and `CTCC` (China Telecom). You need to activate static single-line IPs. This feature is in beta and is only available in Guangzhou, Shanghai, Nanjing, Jinan, Hangzhou, Fuzhou, Beijing, Shijiazhuang, Wuhan, Changsha, Chengdu and Chongqing regions. To try it out, please contact your sales rep. If it's specified, the network billing mode must be `BANDWIDTH_PACKAGE`. If it's not specified, BGP is used by default. To query ISPs supported in a region, please use [DescribeResources](https://intl.cloud.tencent.com/document/api/214/70213?from_cn_redirect=1). 
        :type VipIsp: str
        :param _Tags: Tags the CLB instance when purchasing it. Up to 20 tag key value pairs are supported.
        :type Tags: list of TagInfo
        :param _Vip: Specifies the VIP for the application of a CLB instance. This parameter is optional. If you do not specify this parameter, the system automatically assigns a value for the parameter. IPv4 and IPv6 CLB instances support this parameter, but IPv6 NAT64 CLB instances do not.
Note: If the specified VIP is occupied or is not within the IP range of the specified VPC subnet, you cannot use the VIP to create a CLB instance in a private network or an IPv6 BGP CLB instance in a public network.
        :type Vip: str
        :param _BandwidthPackageId: BANDWIDTH PACKAGE ID, which can be obtained through the [DescribeBandwidthPackages](https://www.tencentcloud.comom/document/api/215/19209?from_cn_redirect=1) api. specifies the BANDWIDTH PACKAGE ID. when this parameter is specified, the network billing mode (InternetAccessible.InternetChargeType) supports only billing by BANDWIDTH PACKAGE (BANDWIDTH_PACKAGE). the attributes of the BANDWIDTH PACKAGE determine the settlement method. for IPv6 clb instances purchased by non-promoted users, if the operator type is not BGP, the BANDWIDTH PACKAGE ID cannot be specified.
        :type BandwidthPackageId: str
        :param _ExclusiveCluster: Information about the dedicated CLB instance. You must specify this parameter when you create a dedicated CLB instance in a private network.
        :type ExclusiveCluster: :class:`tencentcloud.clb.v20180317.models.ExclusiveCluster`
        :param _SlaType: Specification of the LCU-supported instance.<ul><li>If you need to create an LCU-supported instance, this parameter is required. Valid values:<ul><li> clb.c2.medium: Standard </li><li> clb.c3.small: Advanced 1 </li><li> clb.c3.medium: Advanced 2 </li><li> clb.c4.small: Super Large 1 </li><li> clb.c4.medium: Super Large 2 </li><li> clb.c4.large: Super Large 3 </li><li> clb.c4.xlarge: Super Large 4 </li></ul></li><li>If you need to create a shared instance, this parameter is not required.</li></ul> For specification details, see [Instance Specifications Comparison](https://intl.cloud.tencent.com/document/product/214/84689?from_cn_redirect=1).
        :type SlaType: str
        :param _ClusterIds: Cluster ID. This cluster identifier is used for configuring a public cloud exclusive cluster or a cloud dedicated cluster. To apply for a public cloud exclusive cluster, [submit a ticket](https://console.cloud.tencent.com/workorder/category). For cloud dedicated clusters, see the descriptions in [Cloud Dedicated Cluster](https://intl.cloud.tencent.com/document/product/1346?from_cn_redirect=1).
        :type ClusterIds: list of str
        :param _ClientToken: A unique string supplied by the client to ensure that the request is idempotent. Its maximum length is 64 ASCII characters. If this parameter is not specified, the idempotency of the request cannot be guaranteed.
        :type ClientToken: str
        :param _SnatPro: Whether Binding IPs of other VPCs feature switch
        :type SnatPro: bool
        :param _SnatIps: Creates `SnatIp` when the binding IPs of other VPCs feature is enabled
        :type SnatIps: list of SnatIp
        :param _ClusterTag: Tag for the STGW exclusive cluster.
        :type ClusterTag: str
        :param _SlaveZoneId: Applicable only to public network IPv4 clb instances. specifies the secondary AZ ID for cross-az disaster recovery. both AZ ID and name are supported, such as 100001 or ap-guangzhou-1.
Note: The secondary AZ sustains traffic when the primary AZ encounters faults. You can call the [DescribeResources](https://www.tencentcloud.comom/document/api/214/70213?from_cn_redirect=1) API to query the list of primary/secondary AZs in a region. If you want to experience this feature, [submit a ticket](https://console.cloud.tencent.com/workorder/category).
        :type SlaveZoneId: str
        :param _EipAddressId: The unique ID of EIP, which can be queried through the DescribeAddresses API (https://www.tencentcloud.comom/document/product/215/16702?from_cn_redirect=1). format: EIP-qhx8udkc. applicable only to private network clb binding EIP.
        :type EipAddressId: str
        :param _LoadBalancerPassToTarget: Specifies whether to allow CLB traffic to the Target. enable (true): verify security groups on CLB. disable (false): verify security groups on both CLB and backend instances. IPv6 CLB security group default permit, this parameter is not required.
        :type LoadBalancerPassToTarget: bool
        :param _DynamicVip: Upgrades to domain name-based CLB
        :type DynamicVip: bool
        :param _Egress: Network egress point
        :type Egress: str
        :param _LBChargePrepaid: Prepayment-related attributes of a CLB instance. The feature of purchasing monthly subscription instances via an API is under grayscale release. If you want to experience this feature, [submit a ticket](https://console.cloud.tencent.com/workorder/category).
        :type LBChargePrepaid: :class:`tencentcloud.clb.v20180317.models.LBChargePrepaid`
        :param _LBChargeType: Billing type of a CLB instance. Valid values: POSTPAID_BY_HOUR and PREPAID. Default value: POSTPAID_BY_HOUR. The feature of purchasing monthly subscription instances via an API is under grayscale release. If you want to experience this feature, [submit a ticket](https://console.cloud.tencent.com/workorder/category).
        :type LBChargeType: str
        :param _AccessLogTopicId: Topic ID of logs of traffic access over layer-7 protocols.
        :type AccessLogTopicId: str
        :param _AdvancedRoute: Whether layer-7 advanced routing is enabled.
        :type AdvancedRoute: bool
        """
        self._LoadBalancerType = None
        self._Forward = None
        self._LoadBalancerName = None
        self._VpcId = None
        self._SubnetId = None
        self._ProjectId = None
        self._AddressIPVersion = None
        self._Number = None
        self._MasterZoneId = None
        self._ZoneId = None
        self._InternetAccessible = None
        self._VipIsp = None
        self._Tags = None
        self._Vip = None
        self._BandwidthPackageId = None
        self._ExclusiveCluster = None
        self._SlaType = None
        self._ClusterIds = None
        self._ClientToken = None
        self._SnatPro = None
        self._SnatIps = None
        self._ClusterTag = None
        self._SlaveZoneId = None
        self._EipAddressId = None
        self._LoadBalancerPassToTarget = None
        self._DynamicVip = None
        self._Egress = None
        self._LBChargePrepaid = None
        self._LBChargeType = None
        self._AccessLogTopicId = None
        self._AdvancedRoute = None

    @property
    def LoadBalancerType(self):
        r"""CLB instance network type:
OPEN: public network; INTERNAL: private network.
        :rtype: str
        """
        return self._LoadBalancerType

    @LoadBalancerType.setter
    def LoadBalancerType(self, LoadBalancerType):
        self._LoadBalancerType = LoadBalancerType

    @property
    def Forward(self):
        r"""CLB instance type. Valid value: 1 (generic CLB instance).
        :rtype: int
        """
        return self._Forward

    @Forward.setter
    def Forward(self, Forward):
        self._Forward = Forward

    @property
    def LoadBalancerName(self):
        r"""CLB instance name, which takes effect only when only one instance is to be created in the request. It can consist 1 to 60 letters, digits, hyphens (-), or underscores (_).
Note: if the name of the new CLB instance already exists, a default name will be generated automatically.
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def VpcId(self):
        r"""Network ID of the target device on the CLB backend, such as `vpc-12345678`, which can be obtained through the `DescribeVpcEx` API. If this parameter is not entered, `DefaultVPC` is used by default. This parameter is required when creating a private network instance.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""A subnet ID should be specified when you purchase a private network CLB instance under a VPC. The VIP of the private network CLB instance is in this subnet. This parameter is required when you create a private network CLB instance but not supported when you create a public network IPv4 CLB instance.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def ProjectId(self):
        r"""ID of the project to which a CLB instance belongs, which can be obtained through the `DescribeProject` API. If this parameter is not entered, the default project will be used.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AddressIPVersion(self):
        r"""It's only applicable to public network CLB instances. IP version. Values: `IPV4`, `IPV6` and `IPv6FullChain` (case-insensitive). Default: `IPV4`. Note: `IPV6` indicates IPv6 NAT64, while `IPv6FullChain` indicates IPv6. 
        :rtype: str
        """
        return self._AddressIPVersion

    @AddressIPVersion.setter
    def AddressIPVersion(self, AddressIPVersion):
        self._AddressIPVersion = AddressIPVersion

    @property
    def Number(self):
        r"""Specifies the count of cloud load balancers to create, with a default value of 1. the count must not exceed the maximum value allowed for the account, with a default creation maximum value of 20.
        :rtype: int
        """
        return self._Number

    @Number.setter
    def Number(self, Number):
        self._Number = Number

    @property
    def MasterZoneId(self):
        r"""Applicable only to public network IPv4 cloud load balancer instances. specifies the primary AZ ID for cross-az disaster recovery. both AZ ID and name are supported, such as 100001 or ap-guangzhou-1.
Note: the primary AZ loads traffic. the secondary AZ does not load traffic by default and is used only if the primary AZ becomes unavailable.
        :rtype: str
        """
        return self._MasterZoneId

    @MasterZoneId.setter
    def MasterZoneId(self, MasterZoneId):
        self._MasterZoneId = MasterZoneId

    @property
    def ZoneId(self):
        r"""Applicable only to public network IPv4 clb instances. specifies the AZ ID or availability zone name for creating a clb instance. for example, 100001 or ap-guangzhou-1.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def InternetAccessible(self):
        r"""Network billing mode by the maximum outbound bandwidth. It applies only to private network LCU-supported instances and all public network instances. The feature of purchasing monthly subscription instances via an API is under grayscale release. If you want to experience this feature, [submit a ticket](https://console.cloud.tencent.com/workorder/category).
        :rtype: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        """
        return self._InternetAccessible

    @InternetAccessible.setter
    def InternetAccessible(self, InternetAccessible):
        self._InternetAccessible = InternetAccessible

    @property
    def VipIsp(self):
        r"""ISP of VIP. Values: `CMCC` (China Mobile), `CUCC` (China Unicom) and `CTCC` (China Telecom). You need to activate static single-line IPs. This feature is in beta and is only available in Guangzhou, Shanghai, Nanjing, Jinan, Hangzhou, Fuzhou, Beijing, Shijiazhuang, Wuhan, Changsha, Chengdu and Chongqing regions. To try it out, please contact your sales rep. If it's specified, the network billing mode must be `BANDWIDTH_PACKAGE`. If it's not specified, BGP is used by default. To query ISPs supported in a region, please use [DescribeResources](https://intl.cloud.tencent.com/document/api/214/70213?from_cn_redirect=1). 
        :rtype: str
        """
        return self._VipIsp

    @VipIsp.setter
    def VipIsp(self, VipIsp):
        self._VipIsp = VipIsp

    @property
    def Tags(self):
        r"""Tags the CLB instance when purchasing it. Up to 20 tag key value pairs are supported.
        :rtype: list of TagInfo
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Vip(self):
        r"""Specifies the VIP for the application of a CLB instance. This parameter is optional. If you do not specify this parameter, the system automatically assigns a value for the parameter. IPv4 and IPv6 CLB instances support this parameter, but IPv6 NAT64 CLB instances do not.
Note: If the specified VIP is occupied or is not within the IP range of the specified VPC subnet, you cannot use the VIP to create a CLB instance in a private network or an IPv6 BGP CLB instance in a public network.
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def BandwidthPackageId(self):
        r"""BANDWIDTH PACKAGE ID, which can be obtained through the [DescribeBandwidthPackages](https://www.tencentcloud.comom/document/api/215/19209?from_cn_redirect=1) api. specifies the BANDWIDTH PACKAGE ID. when this parameter is specified, the network billing mode (InternetAccessible.InternetChargeType) supports only billing by BANDWIDTH PACKAGE (BANDWIDTH_PACKAGE). the attributes of the BANDWIDTH PACKAGE determine the settlement method. for IPv6 clb instances purchased by non-promoted users, if the operator type is not BGP, the BANDWIDTH PACKAGE ID cannot be specified.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def ExclusiveCluster(self):
        r"""Information about the dedicated CLB instance. You must specify this parameter when you create a dedicated CLB instance in a private network.
        :rtype: :class:`tencentcloud.clb.v20180317.models.ExclusiveCluster`
        """
        return self._ExclusiveCluster

    @ExclusiveCluster.setter
    def ExclusiveCluster(self, ExclusiveCluster):
        self._ExclusiveCluster = ExclusiveCluster

    @property
    def SlaType(self):
        r"""Specification of the LCU-supported instance.<ul><li>If you need to create an LCU-supported instance, this parameter is required. Valid values:<ul><li> clb.c2.medium: Standard </li><li> clb.c3.small: Advanced 1 </li><li> clb.c3.medium: Advanced 2 </li><li> clb.c4.small: Super Large 1 </li><li> clb.c4.medium: Super Large 2 </li><li> clb.c4.large: Super Large 3 </li><li> clb.c4.xlarge: Super Large 4 </li></ul></li><li>If you need to create a shared instance, this parameter is not required.</li></ul> For specification details, see [Instance Specifications Comparison](https://intl.cloud.tencent.com/document/product/214/84689?from_cn_redirect=1).
        :rtype: str
        """
        return self._SlaType

    @SlaType.setter
    def SlaType(self, SlaType):
        self._SlaType = SlaType

    @property
    def ClusterIds(self):
        r"""Cluster ID. This cluster identifier is used for configuring a public cloud exclusive cluster or a cloud dedicated cluster. To apply for a public cloud exclusive cluster, [submit a ticket](https://console.cloud.tencent.com/workorder/category). For cloud dedicated clusters, see the descriptions in [Cloud Dedicated Cluster](https://intl.cloud.tencent.com/document/product/1346?from_cn_redirect=1).
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def ClientToken(self):
        r"""A unique string supplied by the client to ensure that the request is idempotent. Its maximum length is 64 ASCII characters. If this parameter is not specified, the idempotency of the request cannot be guaranteed.
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken

    @property
    def SnatPro(self):
        r"""Whether Binding IPs of other VPCs feature switch
        :rtype: bool
        """
        return self._SnatPro

    @SnatPro.setter
    def SnatPro(self, SnatPro):
        self._SnatPro = SnatPro

    @property
    def SnatIps(self):
        r"""Creates `SnatIp` when the binding IPs of other VPCs feature is enabled
        :rtype: list of SnatIp
        """
        return self._SnatIps

    @SnatIps.setter
    def SnatIps(self, SnatIps):
        self._SnatIps = SnatIps

    @property
    def ClusterTag(self):
        r"""Tag for the STGW exclusive cluster.
        :rtype: str
        """
        return self._ClusterTag

    @ClusterTag.setter
    def ClusterTag(self, ClusterTag):
        self._ClusterTag = ClusterTag

    @property
    def SlaveZoneId(self):
        r"""Applicable only to public network IPv4 clb instances. specifies the secondary AZ ID for cross-az disaster recovery. both AZ ID and name are supported, such as 100001 or ap-guangzhou-1.
Note: The secondary AZ sustains traffic when the primary AZ encounters faults. You can call the [DescribeResources](https://www.tencentcloud.comom/document/api/214/70213?from_cn_redirect=1) API to query the list of primary/secondary AZs in a region. If you want to experience this feature, [submit a ticket](https://console.cloud.tencent.com/workorder/category).
        :rtype: str
        """
        return self._SlaveZoneId

    @SlaveZoneId.setter
    def SlaveZoneId(self, SlaveZoneId):
        self._SlaveZoneId = SlaveZoneId

    @property
    def EipAddressId(self):
        r"""The unique ID of EIP, which can be queried through the DescribeAddresses API (https://www.tencentcloud.comom/document/product/215/16702?from_cn_redirect=1). format: EIP-qhx8udkc. applicable only to private network clb binding EIP.
        :rtype: str
        """
        return self._EipAddressId

    @EipAddressId.setter
    def EipAddressId(self, EipAddressId):
        self._EipAddressId = EipAddressId

    @property
    def LoadBalancerPassToTarget(self):
        r"""Specifies whether to allow CLB traffic to the Target. enable (true): verify security groups on CLB. disable (false): verify security groups on both CLB and backend instances. IPv6 CLB security group default permit, this parameter is not required.
        :rtype: bool
        """
        return self._LoadBalancerPassToTarget

    @LoadBalancerPassToTarget.setter
    def LoadBalancerPassToTarget(self, LoadBalancerPassToTarget):
        self._LoadBalancerPassToTarget = LoadBalancerPassToTarget

    @property
    def DynamicVip(self):
        r"""Upgrades to domain name-based CLB
        :rtype: bool
        """
        return self._DynamicVip

    @DynamicVip.setter
    def DynamicVip(self, DynamicVip):
        self._DynamicVip = DynamicVip

    @property
    def Egress(self):
        r"""Network egress point
        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress

    @property
    def LBChargePrepaid(self):
        r"""Prepayment-related attributes of a CLB instance. The feature of purchasing monthly subscription instances via an API is under grayscale release. If you want to experience this feature, [submit a ticket](https://console.cloud.tencent.com/workorder/category).
        :rtype: :class:`tencentcloud.clb.v20180317.models.LBChargePrepaid`
        """
        return self._LBChargePrepaid

    @LBChargePrepaid.setter
    def LBChargePrepaid(self, LBChargePrepaid):
        self._LBChargePrepaid = LBChargePrepaid

    @property
    def LBChargeType(self):
        r"""Billing type of a CLB instance. Valid values: POSTPAID_BY_HOUR and PREPAID. Default value: POSTPAID_BY_HOUR. The feature of purchasing monthly subscription instances via an API is under grayscale release. If you want to experience this feature, [submit a ticket](https://console.cloud.tencent.com/workorder/category).
        :rtype: str
        """
        return self._LBChargeType

    @LBChargeType.setter
    def LBChargeType(self, LBChargeType):
        self._LBChargeType = LBChargeType

    @property
    def AccessLogTopicId(self):
        r"""Topic ID of logs of traffic access over layer-7 protocols.
        :rtype: str
        """
        return self._AccessLogTopicId

    @AccessLogTopicId.setter
    def AccessLogTopicId(self, AccessLogTopicId):
        self._AccessLogTopicId = AccessLogTopicId

    @property
    def AdvancedRoute(self):
        r"""Whether layer-7 advanced routing is enabled.
        :rtype: bool
        """
        return self._AdvancedRoute

    @AdvancedRoute.setter
    def AdvancedRoute(self, AdvancedRoute):
        self._AdvancedRoute = AdvancedRoute


    def _deserialize(self, params):
        self._LoadBalancerType = params.get("LoadBalancerType")
        self._Forward = params.get("Forward")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._ProjectId = params.get("ProjectId")
        self._AddressIPVersion = params.get("AddressIPVersion")
        self._Number = params.get("Number")
        self._MasterZoneId = params.get("MasterZoneId")
        self._ZoneId = params.get("ZoneId")
        if params.get("InternetAccessible") is not None:
            self._InternetAccessible = InternetAccessible()
            self._InternetAccessible._deserialize(params.get("InternetAccessible"))
        self._VipIsp = params.get("VipIsp")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Vip = params.get("Vip")
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        if params.get("ExclusiveCluster") is not None:
            self._ExclusiveCluster = ExclusiveCluster()
            self._ExclusiveCluster._deserialize(params.get("ExclusiveCluster"))
        self._SlaType = params.get("SlaType")
        self._ClusterIds = params.get("ClusterIds")
        self._ClientToken = params.get("ClientToken")
        self._SnatPro = params.get("SnatPro")
        if params.get("SnatIps") is not None:
            self._SnatIps = []
            for item in params.get("SnatIps"):
                obj = SnatIp()
                obj._deserialize(item)
                self._SnatIps.append(obj)
        self._ClusterTag = params.get("ClusterTag")
        self._SlaveZoneId = params.get("SlaveZoneId")
        self._EipAddressId = params.get("EipAddressId")
        self._LoadBalancerPassToTarget = params.get("LoadBalancerPassToTarget")
        self._DynamicVip = params.get("DynamicVip")
        self._Egress = params.get("Egress")
        if params.get("LBChargePrepaid") is not None:
            self._LBChargePrepaid = LBChargePrepaid()
            self._LBChargePrepaid._deserialize(params.get("LBChargePrepaid"))
        self._LBChargeType = params.get("LBChargeType")
        self._AccessLogTopicId = params.get("AccessLogTopicId")
        self._AdvancedRoute = params.get("AdvancedRoute")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLoadBalancerResponse(AbstractModel):
    r"""CreateLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerIds: Array of unique CLB instance IDs.
This field may return `null` in some cases, such as there is delay during instance creation. You can query the IDs of the created instances by invoking `DescribeTaskStatus` with the `RequestId` or `DealName` returned by this API.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type LoadBalancerIds: list of str
        :param _DealName: Order ID.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type DealName: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LoadBalancerIds = None
        self._DealName = None
        self._RequestId = None

    @property
    def LoadBalancerIds(self):
        r"""Array of unique CLB instance IDs.
This field may return `null` in some cases, such as there is delay during instance creation. You can query the IDs of the created instances by invoking `DescribeTaskStatus` with the `RequestId` or `DealName` returned by this API.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds

    @property
    def DealName(self):
        r"""Order ID.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        self._DealName = params.get("DealName")
        self._RequestId = params.get("RequestId")


class CreateLoadBalancerSnatIpsRequest(AbstractModel):
    r"""CreateLoadBalancerSnatIps request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: Specifies the unique ID of the cloud load balancer. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID, such as lb-12345678.
        :type LoadBalancerId: str
        :param _SnatIps: Added SnatIp information. specify IP for request or designated subnet for automatic application. can be accessed through [DescribeSubnets](https://www.tencentcloud.comom/document/api/215/15784?from_cn_redirect=1) to query and retrieve. the default upper limit for one CLB instance is 10.
        :type SnatIps: list of SnatIp
        :param _Number: Number of SNAT IPs to be added. This parameter is used in conjunction with `SnatIps`. Note that if `Ip` is specified in `SnapIps`, this parameter is not available. It defaults to `1` and the upper limit is `10`.
        :type Number: int
        """
        self._LoadBalancerId = None
        self._SnatIps = None
        self._Number = None

    @property
    def LoadBalancerId(self):
        r"""Specifies the unique ID of the cloud load balancer. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID, such as lb-12345678.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def SnatIps(self):
        r"""Added SnatIp information. specify IP for request or designated subnet for automatic application. can be accessed through [DescribeSubnets](https://www.tencentcloud.comom/document/api/215/15784?from_cn_redirect=1) to query and retrieve. the default upper limit for one CLB instance is 10.
        :rtype: list of SnatIp
        """
        return self._SnatIps

    @SnatIps.setter
    def SnatIps(self, SnatIps):
        self._SnatIps = SnatIps

    @property
    def Number(self):
        r"""Number of SNAT IPs to be added. This parameter is used in conjunction with `SnatIps`. Note that if `Ip` is specified in `SnapIps`, this parameter is not available. It defaults to `1` and the upper limit is `10`.
        :rtype: int
        """
        return self._Number

    @Number.setter
    def Number(self, Number):
        self._Number = Number


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        if params.get("SnatIps") is not None:
            self._SnatIps = []
            for item in params.get("SnatIps"):
                obj = SnatIp()
                obj._deserialize(item)
                self._SnatIps.append(obj)
        self._Number = params.get("Number")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLoadBalancerSnatIpsResponse(AbstractModel):
    r"""CreateLoadBalancerSnatIps response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateRuleRequest(AbstractModel):
    r"""CreateRule request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to obtain the ID.
        :type LoadBalancerId: str
        :param _ListenerId: Specifies the listener ID, which can be obtained through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :type ListenerId: str
        :param _Rules: Information of the new forwarding rule
        :type Rules: list of RuleInput
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._Rules = None

    @property
    def LoadBalancerId(self):
        r"""ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to obtain the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""Specifies the listener ID, which can be obtained through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Rules(self):
        r"""Information of the new forwarding rule
        :rtype: list of RuleInput
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleInput()
                obj._deserialize(item)
                self._Rules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRuleResponse(AbstractModel):
    r"""CreateRule response structure.

    """

    def __init__(self):
        r"""
        :param _LocationIds: Array of unique IDs of created forwarding rules
        :type LocationIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LocationIds = None
        self._RequestId = None

    @property
    def LocationIds(self):
        r"""Array of unique IDs of created forwarding rules
        :rtype: list of str
        """
        return self._LocationIds

    @LocationIds.setter
    def LocationIds(self, LocationIds):
        self._LocationIds = LocationIds

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LocationIds = params.get("LocationIds")
        self._RequestId = params.get("RequestId")


class CreateTargetGroupRequest(AbstractModel):
    r"""CreateTargetGroup request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupName: Target group name (up to 50 characters)
        :type TargetGroupName: str
        :param _VpcId: Specifies the vpc id attribute of the target group. uses the default vpc if left empty.
        :type VpcId: str
        :param _Port: Specifies the default Port of the target group. the default Port can be used when servers are added subsequently. this parameter is not supported for full-listen target groups. for non-full-listen target groups, either Port or Port in TargetGroupInstances.N is required.

        :type Port: int
        :param _TargetGroupInstances: Specifies the real servers bound to the target group. supports up to 50 at a time.
        :type TargetGroupInstances: list of TargetGroupInstance
        :param _Type: Target group type, currently supported v1 (legacy version target group) and v2 (new version target group), defaults to v1 (legacy version target group).
        :type Type: str
        :param _Protocol: Backend forwarding protocol of the target group. this field is required for the new version (v2) target group. currently supports TCP, UDP, HTTP, HTTPS, GRPC.
        :type Protocol: str
        :param _HealthCheck: Health check.
        :type HealthCheck: :class:`tencentcloud.clb.v20180317.models.TargetGroupHealthCheck`
        :param _ScheduleAlgorithm: Scheduling algorithm. this parameter is valid only for target groups of the new version V2 when the backend forwarding protocol is HTTP, HTTPS, or GRPC. available values:.
<ur><li>WRR: weighted round-robin.</li><li>LEAST_CONN: LEAST connection.</li><li>IP_HASH: based on IP HASH.</li><li>default is WRR.</li></ur>.
        :type ScheduleAlgorithm: str
        :param _Tags: Tag.
        :type Tags: list of TagInfo
        :param _Weight: Specifies the default weight of the backend service. among them:.
<ul><li>Value ranges from 0 to 100.</li><li>after setting this value, when adding a backend service to the target group, if the backend service does not set Weight separately, use the default Weight here.</li><li>Weight parameter settings not supported for v1 target group type.</li></ul>.
        :type Weight: int
        :param _FullListenSwitch: Full listen target group flag. valid values: true (yes), false (no). only target groups of the new version V2 event type support this parameter.
        :type FullListenSwitch: bool
        :param _KeepaliveEnable: Specifies whether to enable the persistent connection feature. this parameter applies only to HTTP and HTTPS target groups. 0: disable; 1: enable. this feature is off by default.
        :type KeepaliveEnable: bool
        :param _SessionExpireTime: Session hold time, unit: second. value range: 30-3600. default: 0, disabled. this parameter is supported only for target groups with HTTP/HTTPS/GRPC backend forwarding protocol in the new version V2.
        :type SessionExpireTime: int
        :param _IpVersion: IP version type.
        :type IpVersion: str
        """
        self._TargetGroupName = None
        self._VpcId = None
        self._Port = None
        self._TargetGroupInstances = None
        self._Type = None
        self._Protocol = None
        self._HealthCheck = None
        self._ScheduleAlgorithm = None
        self._Tags = None
        self._Weight = None
        self._FullListenSwitch = None
        self._KeepaliveEnable = None
        self._SessionExpireTime = None
        self._IpVersion = None

    @property
    def TargetGroupName(self):
        r"""Target group name (up to 50 characters)
        :rtype: str
        """
        return self._TargetGroupName

    @TargetGroupName.setter
    def TargetGroupName(self, TargetGroupName):
        self._TargetGroupName = TargetGroupName

    @property
    def VpcId(self):
        r"""Specifies the vpc id attribute of the target group. uses the default vpc if left empty.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Port(self):
        r"""Specifies the default Port of the target group. the default Port can be used when servers are added subsequently. this parameter is not supported for full-listen target groups. for non-full-listen target groups, either Port or Port in TargetGroupInstances.N is required.

        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def TargetGroupInstances(self):
        r"""Specifies the real servers bound to the target group. supports up to 50 at a time.
        :rtype: list of TargetGroupInstance
        """
        return self._TargetGroupInstances

    @TargetGroupInstances.setter
    def TargetGroupInstances(self, TargetGroupInstances):
        self._TargetGroupInstances = TargetGroupInstances

    @property
    def Type(self):
        r"""Target group type, currently supported v1 (legacy version target group) and v2 (new version target group), defaults to v1 (legacy version target group).
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Protocol(self):
        r"""Backend forwarding protocol of the target group. this field is required for the new version (v2) target group. currently supports TCP, UDP, HTTP, HTTPS, GRPC.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def HealthCheck(self):
        r"""Health check.
        :rtype: :class:`tencentcloud.clb.v20180317.models.TargetGroupHealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def ScheduleAlgorithm(self):
        r"""Scheduling algorithm. this parameter is valid only for target groups of the new version V2 when the backend forwarding protocol is HTTP, HTTPS, or GRPC. available values:.
<ur><li>WRR: weighted round-robin.</li><li>LEAST_CONN: LEAST connection.</li><li>IP_HASH: based on IP HASH.</li><li>default is WRR.</li></ur>.
        :rtype: str
        """
        return self._ScheduleAlgorithm

    @ScheduleAlgorithm.setter
    def ScheduleAlgorithm(self, ScheduleAlgorithm):
        self._ScheduleAlgorithm = ScheduleAlgorithm

    @property
    def Tags(self):
        r"""Tag.
        :rtype: list of TagInfo
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Weight(self):
        r"""Specifies the default weight of the backend service. among them:.
<ul><li>Value ranges from 0 to 100.</li><li>after setting this value, when adding a backend service to the target group, if the backend service does not set Weight separately, use the default Weight here.</li><li>Weight parameter settings not supported for v1 target group type.</li></ul>.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def FullListenSwitch(self):
        r"""Full listen target group flag. valid values: true (yes), false (no). only target groups of the new version V2 event type support this parameter.
        :rtype: bool
        """
        return self._FullListenSwitch

    @FullListenSwitch.setter
    def FullListenSwitch(self, FullListenSwitch):
        self._FullListenSwitch = FullListenSwitch

    @property
    def KeepaliveEnable(self):
        r"""Specifies whether to enable the persistent connection feature. this parameter applies only to HTTP and HTTPS target groups. 0: disable; 1: enable. this feature is off by default.
        :rtype: bool
        """
        return self._KeepaliveEnable

    @KeepaliveEnable.setter
    def KeepaliveEnable(self, KeepaliveEnable):
        self._KeepaliveEnable = KeepaliveEnable

    @property
    def SessionExpireTime(self):
        r"""Session hold time, unit: second. value range: 30-3600. default: 0, disabled. this parameter is supported only for target groups with HTTP/HTTPS/GRPC backend forwarding protocol in the new version V2.
        :rtype: int
        """
        return self._SessionExpireTime

    @SessionExpireTime.setter
    def SessionExpireTime(self, SessionExpireTime):
        self._SessionExpireTime = SessionExpireTime

    @property
    def IpVersion(self):
        r"""IP version type.
        :rtype: str
        """
        return self._IpVersion

    @IpVersion.setter
    def IpVersion(self, IpVersion):
        self._IpVersion = IpVersion


    def _deserialize(self, params):
        self._TargetGroupName = params.get("TargetGroupName")
        self._VpcId = params.get("VpcId")
        self._Port = params.get("Port")
        if params.get("TargetGroupInstances") is not None:
            self._TargetGroupInstances = []
            for item in params.get("TargetGroupInstances"):
                obj = TargetGroupInstance()
                obj._deserialize(item)
                self._TargetGroupInstances.append(obj)
        self._Type = params.get("Type")
        self._Protocol = params.get("Protocol")
        if params.get("HealthCheck") is not None:
            self._HealthCheck = TargetGroupHealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        self._ScheduleAlgorithm = params.get("ScheduleAlgorithm")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Weight = params.get("Weight")
        self._FullListenSwitch = params.get("FullListenSwitch")
        self._KeepaliveEnable = params.get("KeepaliveEnable")
        self._SessionExpireTime = params.get("SessionExpireTime")
        self._IpVersion = params.get("IpVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTargetGroupResponse(AbstractModel):
    r"""CreateTargetGroup response structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: ID generated after target group creation
        :type TargetGroupId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TargetGroupId = None
        self._RequestId = None

    @property
    def TargetGroupId(self):
        r"""ID generated after target group creation
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        self._RequestId = params.get("RequestId")


class CreateTopicRequest(AbstractModel):
    r"""CreateTopic request structure.

    """

    def __init__(self):
        r"""
        :param _TopicName: Log topic name
        :type TopicName: str
        :param _PartitionCount: The number of topic partitions, which changes as partitions are split or merged. Each log topic can have up to 50 partitions. If this parameter is not passed in, 1 partition will be created by default and up to 10 partitions are allowed to be created.
        :type PartitionCount: int
        :param _TopicType: Log type. Valid values: ACCESS (access logs; default value) and HEALTH (health check logs).
        :type TopicType: str
        :param _Period: Storage time in days, defaults to 30.
-Log access to standard storage supports 1 to 3600 days. a value of 3640 indicates permanent retention.
-Log access to infrequent storage supports 7 to 3600 days. a value of 3640 indicates permanent retention.
        :type Period: int
        :param _StorageType: Log topic storage type. Valid values: `hot` (STANDARD storage); `cold` (IA storage). Default value: `hot`.
        :type StorageType: str
        """
        self._TopicName = None
        self._PartitionCount = None
        self._TopicType = None
        self._Period = None
        self._StorageType = None

    @property
    def TopicName(self):
        r"""Log topic name
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def PartitionCount(self):
        r"""The number of topic partitions, which changes as partitions are split or merged. Each log topic can have up to 50 partitions. If this parameter is not passed in, 1 partition will be created by default and up to 10 partitions are allowed to be created.
        :rtype: int
        """
        return self._PartitionCount

    @PartitionCount.setter
    def PartitionCount(self, PartitionCount):
        self._PartitionCount = PartitionCount

    @property
    def TopicType(self):
        r"""Log type. Valid values: ACCESS (access logs; default value) and HEALTH (health check logs).
        :rtype: str
        """
        return self._TopicType

    @TopicType.setter
    def TopicType(self, TopicType):
        self._TopicType = TopicType

    @property
    def Period(self):
        r"""Storage time in days, defaults to 30.
-Log access to standard storage supports 1 to 3600 days. a value of 3640 indicates permanent retention.
-Log access to infrequent storage supports 7 to 3600 days. a value of 3640 indicates permanent retention.
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def StorageType(self):
        r"""Log topic storage type. Valid values: `hot` (STANDARD storage); `cold` (IA storage). Default value: `hot`.
        :rtype: str
        """
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        self._PartitionCount = params.get("PartitionCount")
        self._TopicType = params.get("TopicType")
        self._Period = params.get("Period")
        self._StorageType = params.get("StorageType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTopicResponse(AbstractModel):
    r"""CreateTopic response structure.

    """

    def __init__(self):
        r"""
        :param _TopicId: Log topic ID
        :type TopicId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TopicId = None
        self._RequestId = None

    @property
    def TopicId(self):
        r"""Log topic ID
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._RequestId = params.get("RequestId")


class CrossTargets(AbstractModel):
    r"""Information of CVMs and ENIs that use cross-region binding 2.0

    """

    def __init__(self):
        r"""
        :param _LocalVpcId: VPC ID of the CLB instance
        :type LocalVpcId: str
        :param _VpcId: VPC ID of the CVM or ENI instance
        :type VpcId: str
        :param _IP: IP address of the CVM or ENI instance
        :type IP: str
        :param _VpcName: VPC name of the CVM or ENI instance
        :type VpcName: str
        :param _EniId: ENI ID of the CVM instance
        :type EniId: str
        :param _InstanceId: Submachine instance ID.
        :type InstanceId: str
        :param _InstanceName: Submachine instance name.
        :type InstanceName: str
        :param _Region: Region of the CVM or ENI instance
        :type Region: str
        """
        self._LocalVpcId = None
        self._VpcId = None
        self._IP = None
        self._VpcName = None
        self._EniId = None
        self._InstanceId = None
        self._InstanceName = None
        self._Region = None

    @property
    def LocalVpcId(self):
        r"""VPC ID of the CLB instance
        :rtype: str
        """
        return self._LocalVpcId

    @LocalVpcId.setter
    def LocalVpcId(self, LocalVpcId):
        self._LocalVpcId = LocalVpcId

    @property
    def VpcId(self):
        r"""VPC ID of the CVM or ENI instance
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def IP(self):
        r"""IP address of the CVM or ENI instance
        :rtype: str
        """
        return self._IP

    @IP.setter
    def IP(self, IP):
        self._IP = IP

    @property
    def VpcName(self):
        r"""VPC name of the CVM or ENI instance
        :rtype: str
        """
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def EniId(self):
        r"""ENI ID of the CVM instance
        :rtype: str
        """
        return self._EniId

    @EniId.setter
    def EniId(self, EniId):
        self._EniId = EniId

    @property
    def InstanceId(self):
        r"""Submachine instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Submachine instance name.
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Region(self):
        r"""Region of the CVM or ENI instance
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._LocalVpcId = params.get("LocalVpcId")
        self._VpcId = params.get("VpcId")
        self._IP = params.get("IP")
        self._VpcName = params.get("VpcName")
        self._EniId = params.get("EniId")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomizedConfigRequest(AbstractModel):
    r"""DeleteCustomizedConfig request structure.

    """

    def __init__(self):
        r"""
        :param _UconfigIdList: Specifies the configuration ID list for deletion.
        :type UconfigIdList: list of str
        """
        self._UconfigIdList = None

    @property
    def UconfigIdList(self):
        r"""Specifies the configuration ID list for deletion.
        :rtype: list of str
        """
        return self._UconfigIdList

    @UconfigIdList.setter
    def UconfigIdList(self, UconfigIdList):
        self._UconfigIdList = UconfigIdList


    def _deserialize(self, params):
        self._UconfigIdList = params.get("UconfigIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomizedConfigResponse(AbstractModel):
    r"""DeleteCustomizedConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteListenerRequest(AbstractModel):
    r"""DeleteListener request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the CLB instance. You can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        :param _ListenerId: The listener ID to be deleted, can be accessed through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :type ListenerId: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None

    @property
    def LoadBalancerId(self):
        r"""ID of the CLB instance. You can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""The listener ID to be deleted, can be accessed through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteListenerResponse(AbstractModel):
    r"""DeleteListener response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLoadBalancerListenersRequest(AbstractModel):
    r"""DeleteLoadBalancerListeners request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the CLB instance. You can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        :param _ListenerIds: Specifies the listener ID array to be deleted, with a maximum of 20 elements. if left blank, all listeners of the clb will be deleted. can be obtained through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :type ListenerIds: list of str
        """
        self._LoadBalancerId = None
        self._ListenerIds = None

    @property
    def LoadBalancerId(self):
        r"""ID of the CLB instance. You can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerIds(self):
        r"""Specifies the listener ID array to be deleted, with a maximum of 20 elements. if left blank, all listeners of the clb will be deleted. can be obtained through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :rtype: list of str
        """
        return self._ListenerIds

    @ListenerIds.setter
    def ListenerIds(self, ListenerIds):
        self._ListenerIds = ListenerIds


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerIds = params.get("ListenerIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLoadBalancerListenersResponse(AbstractModel):
    r"""DeleteLoadBalancerListeners response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLoadBalancerRequest(AbstractModel):
    r"""DeleteLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerIds: CLB instance ID array to be deleted, which can be obtained by calling the [DescribeLoadBalancers](https://www.tencentcloud.com/document/product/214/30685?from_cn_redirect=1) API. The array can include up to 20 elements.
        :type LoadBalancerIds: list of str
        :param _ForceDelete: Whether to forcibly delete the CLB instance. True indicates forced deletion; False indicates non-forced deletion, and blocking verification is required.
The default value is False.
The deletion operation is blocked by default in the following cases. If you confirm forced deletion, the value of the forced verification parameter ForceDelete should be set to True.
1. The instance with 20 or more RS bound to the backend is deleted.
2. The instance with RS bound to the backend and the maximum peak inbound/outbound bandwidth exceeding 10 Mbps within 5 minutes is deleted.
3. Thirty or more instances are deleted within 5 minutes in a single region.
        :type ForceDelete: bool
        """
        self._LoadBalancerIds = None
        self._ForceDelete = None

    @property
    def LoadBalancerIds(self):
        r"""CLB instance ID array to be deleted, which can be obtained by calling the [DescribeLoadBalancers](https://www.tencentcloud.com/document/product/214/30685?from_cn_redirect=1) API. The array can include up to 20 elements.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds

    @property
    def ForceDelete(self):
        r"""Whether to forcibly delete the CLB instance. True indicates forced deletion; False indicates non-forced deletion, and blocking verification is required.
The default value is False.
The deletion operation is blocked by default in the following cases. If you confirm forced deletion, the value of the forced verification parameter ForceDelete should be set to True.
1. The instance with 20 or more RS bound to the backend is deleted.
2. The instance with RS bound to the backend and the maximum peak inbound/outbound bandwidth exceeding 10 Mbps within 5 minutes is deleted.
3. Thirty or more instances are deleted within 5 minutes in a single region.
        :rtype: bool
        """
        return self._ForceDelete

    @ForceDelete.setter
    def ForceDelete(self, ForceDelete):
        self._ForceDelete = ForceDelete


    def _deserialize(self, params):
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        self._ForceDelete = params.get("ForceDelete")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLoadBalancerResponse(AbstractModel):
    r"""DeleteLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLoadBalancerSnatIpsRequest(AbstractModel):
    r"""DeleteLoadBalancerSnatIps request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: Specifies the unique ID of the cloud load balancer. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID, such as lb-12345678.
        :type LoadBalancerId: str
        :param _Ips: Specifies the address array of SnatIp to delete. maximum deletion supported is 20.
        :type Ips: list of str
        """
        self._LoadBalancerId = None
        self._Ips = None

    @property
    def LoadBalancerId(self):
        r"""Specifies the unique ID of the cloud load balancer. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID, such as lb-12345678.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def Ips(self):
        r"""Specifies the address array of SnatIp to delete. maximum deletion supported is 20.
        :rtype: list of str
        """
        return self._Ips

    @Ips.setter
    def Ips(self, Ips):
        self._Ips = Ips


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._Ips = params.get("Ips")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLoadBalancerSnatIpsResponse(AbstractModel):
    r"""DeleteLoadBalancerSnatIps response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRewriteRequest(AbstractModel):
    r"""DeleteRewrite request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _SourceListenerId: Source listener ID
        :type SourceListenerId: str
        :param _TargetListenerId: Target listener ID
        :type TargetListenerId: str
        :param _RewriteInfos: Redirection relationship between forwarding rules
        :type RewriteInfos: list of RewriteLocationMap
        """
        self._LoadBalancerId = None
        self._SourceListenerId = None
        self._TargetListenerId = None
        self._RewriteInfos = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def SourceListenerId(self):
        r"""Source listener ID
        :rtype: str
        """
        return self._SourceListenerId

    @SourceListenerId.setter
    def SourceListenerId(self, SourceListenerId):
        self._SourceListenerId = SourceListenerId

    @property
    def TargetListenerId(self):
        r"""Target listener ID
        :rtype: str
        """
        return self._TargetListenerId

    @TargetListenerId.setter
    def TargetListenerId(self, TargetListenerId):
        self._TargetListenerId = TargetListenerId

    @property
    def RewriteInfos(self):
        r"""Redirection relationship between forwarding rules
        :rtype: list of RewriteLocationMap
        """
        return self._RewriteInfos

    @RewriteInfos.setter
    def RewriteInfos(self, RewriteInfos):
        self._RewriteInfos = RewriteInfos


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._SourceListenerId = params.get("SourceListenerId")
        self._TargetListenerId = params.get("TargetListenerId")
        if params.get("RewriteInfos") is not None:
            self._RewriteInfos = []
            for item in params.get("RewriteInfos"):
                obj = RewriteLocationMap()
                obj._deserialize(item)
                self._RewriteInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRewriteResponse(AbstractModel):
    r"""DeleteRewrite response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRuleRequest(AbstractModel):
    r"""DeleteRule request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the CLB instance. You can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        :param _ListenerId: ID of the CLB instance listener. You can call the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) API to query the ID.
        :type ListenerId: str
        :param _LocationIds: Array of ids of forwarding rules to be deleted, can be accessed through the [DescribeLoadBalancersDetail](https://www.tencentcloud.comom/document/api/214/46916?from_cn_redirect=1) api.
        :type LocationIds: list of str
        :param _Domain: Domain name of the forwarding rule to be deleted. if it is multiple domains, you can specify any one of the domain name list. it can be accessed through the [DescribeLoadBalancersDetail](https://www.tencentcloud.comom/document/api/214/46916?from_cn_redirect=1) api.
        :type Domain: str
        :param _Url: Forwarding path of the forwarding rule to be deleted can be accessed through the DescribeLoadBalancersDetail api (https://www.tencentcloud.comom/document/api/214/46916?from_cn_redirect=1).
        :type Url: str
        :param _NewDefaultServerDomain: A default domain name must be configured under the listener. when you need to delete the default domain name, you can specify another domain name as the new default domain name. if the new default domain name is multiple domains, you can specify any one of the domain name list. it can be accessed through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :type NewDefaultServerDomain: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._LocationIds = None
        self._Domain = None
        self._Url = None
        self._NewDefaultServerDomain = None

    @property
    def LoadBalancerId(self):
        r"""ID of the CLB instance. You can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""ID of the CLB instance listener. You can call the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def LocationIds(self):
        r"""Array of ids of forwarding rules to be deleted, can be accessed through the [DescribeLoadBalancersDetail](https://www.tencentcloud.comom/document/api/214/46916?from_cn_redirect=1) api.
        :rtype: list of str
        """
        return self._LocationIds

    @LocationIds.setter
    def LocationIds(self, LocationIds):
        self._LocationIds = LocationIds

    @property
    def Domain(self):
        r"""Domain name of the forwarding rule to be deleted. if it is multiple domains, you can specify any one of the domain name list. it can be accessed through the [DescribeLoadBalancersDetail](https://www.tencentcloud.comom/document/api/214/46916?from_cn_redirect=1) api.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""Forwarding path of the forwarding rule to be deleted can be accessed through the DescribeLoadBalancersDetail api (https://www.tencentcloud.comom/document/api/214/46916?from_cn_redirect=1).
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def NewDefaultServerDomain(self):
        r"""A default domain name must be configured under the listener. when you need to delete the default domain name, you can specify another domain name as the new default domain name. if the new default domain name is multiple domains, you can specify any one of the domain name list. it can be accessed through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :rtype: str
        """
        return self._NewDefaultServerDomain

    @NewDefaultServerDomain.setter
    def NewDefaultServerDomain(self, NewDefaultServerDomain):
        self._NewDefaultServerDomain = NewDefaultServerDomain


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        self._LocationIds = params.get("LocationIds")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        self._NewDefaultServerDomain = params.get("NewDefaultServerDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRuleResponse(AbstractModel):
    r"""DeleteRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTargetGroupsRequest(AbstractModel):
    r"""DeleteTargetGroups request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupIds: Specifies the ID array of the target group. supports up to 20 deletions.
        :type TargetGroupIds: list of str
        """
        self._TargetGroupIds = None

    @property
    def TargetGroupIds(self):
        r"""Specifies the ID array of the target group. supports up to 20 deletions.
        :rtype: list of str
        """
        return self._TargetGroupIds

    @TargetGroupIds.setter
    def TargetGroupIds(self, TargetGroupIds):
        self._TargetGroupIds = TargetGroupIds


    def _deserialize(self, params):
        self._TargetGroupIds = params.get("TargetGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTargetGroupsResponse(AbstractModel):
    r"""DeleteTargetGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeregisterFunctionTargetsRequest(AbstractModel):
    r"""DeregisterFunctionTargets request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID.
        :type LoadBalancerId: str
        :param _ListenerId: CLB listener ID.
        :type ListenerId: str
        :param _FunctionTargets: List of functions to be unbound
        :type FunctionTargets: list of FunctionTarget
        :param _LocationId: The ID of target forwarding rule. To unbind a function from an L7 forwarding rule, either `LocationId` or `Domain+Url` is required. 
        :type LocationId: str
        :param _Domain: Domain name of the target forwarding rule. It is ignored if `LocationId` is specified. 
        :type Domain: str
        :param _Url: URL of the target forwarding rule. It is ignored if `LocationId` is specified. 
        :type Url: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._FunctionTargets = None
        self._LocationId = None
        self._Domain = None
        self._Url = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""CLB listener ID.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def FunctionTargets(self):
        r"""List of functions to be unbound
        :rtype: list of FunctionTarget
        """
        return self._FunctionTargets

    @FunctionTargets.setter
    def FunctionTargets(self, FunctionTargets):
        self._FunctionTargets = FunctionTargets

    @property
    def LocationId(self):
        r"""The ID of target forwarding rule. To unbind a function from an L7 forwarding rule, either `LocationId` or `Domain+Url` is required. 
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Domain name of the target forwarding rule. It is ignored if `LocationId` is specified. 
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""URL of the target forwarding rule. It is ignored if `LocationId` is specified. 
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        if params.get("FunctionTargets") is not None:
            self._FunctionTargets = []
            for item in params.get("FunctionTargets"):
                obj = FunctionTarget()
                obj._deserialize(item)
                self._FunctionTargets.append(obj)
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeregisterFunctionTargetsResponse(AbstractModel):
    r"""DeregisterFunctionTargets response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeregisterTargetGroupInstancesRequest(AbstractModel):
    r"""DeregisterTargetGroupInstances request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _TargetGroupInstances: Specifies information on server to be unbound. supports bulk removal with the largest quantity of 20 per operation.
Port is a required item in this api.
        :type TargetGroupInstances: list of TargetGroupInstance
        """
        self._TargetGroupId = None
        self._TargetGroupInstances = None

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def TargetGroupInstances(self):
        r"""Specifies information on server to be unbound. supports bulk removal with the largest quantity of 20 per operation.
Port is a required item in this api.
        :rtype: list of TargetGroupInstance
        """
        return self._TargetGroupInstances

    @TargetGroupInstances.setter
    def TargetGroupInstances(self, TargetGroupInstances):
        self._TargetGroupInstances = TargetGroupInstances


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        if params.get("TargetGroupInstances") is not None:
            self._TargetGroupInstances = []
            for item in params.get("TargetGroupInstances"):
                obj = TargetGroupInstance()
                obj._deserialize(item)
                self._TargetGroupInstances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeregisterTargetGroupInstancesResponse(AbstractModel):
    r"""DeregisterTargetGroupInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeregisterTargetsFromClassicalLBRequest(AbstractModel):
    r"""DeregisterTargetsFromClassicalLB request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _InstanceIds: List of real server IDs
        :type InstanceIds: list of str
        """
        self._LoadBalancerId = None
        self._InstanceIds = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def InstanceIds(self):
        r"""List of real server IDs
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeregisterTargetsFromClassicalLBResponse(AbstractModel):
    r"""DeregisterTargetsFromClassicalLB response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeregisterTargetsRequest(AbstractModel):
    r"""DeregisterTargets request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID in the format of "lb-12345678"
        :type LoadBalancerId: str
        :param _ListenerId: Listener ID in the format of "lbl-12345678"
        :type ListenerId: str
        :param _Targets: List of real servers to be unbound. Array length limit: 20.
        :type Targets: list of Target
        :param _LocationId: Forwarding rule ID in the format of "loc-12345678". When unbinding a server from a layer-7 forwarding rule, you must provide either this parameter or Domain+Url.
        :type LocationId: str
        :param _Domain: Target rule domain name. This parameter does not take effect if LocationId is specified.
        :type Domain: str
        :param _Url: Target rule URL. This parameter does not take effect if LocationId is specified.
        :type Url: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._Targets = None
        self._LocationId = None
        self._Domain = None
        self._Url = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID in the format of "lb-12345678"
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""Listener ID in the format of "lbl-12345678"
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Targets(self):
        r"""List of real servers to be unbound. Array length limit: 20.
        :rtype: list of Target
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def LocationId(self):
        r"""Forwarding rule ID in the format of "loc-12345678". When unbinding a server from a layer-7 forwarding rule, you must provide either this parameter or Domain+Url.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Target rule domain name. This parameter does not take effect if LocationId is specified.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""Target rule URL. This parameter does not take effect if LocationId is specified.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = Target()
                obj._deserialize(item)
                self._Targets.append(obj)
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeregisterTargetsResponse(AbstractModel):
    r"""DeregisterTargets response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeBlockIPListRequest(AbstractModel):
    r"""DescribeBlockIPList request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID.
        :type LoadBalancerId: str
        :param _Offset: Data offset. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum number of IPs to be returned. Default value: 100,000.
        :type Limit: int
        """
        self._LoadBalancerId = None
        self._Offset = None
        self._Limit = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def Offset(self):
        r"""Data offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number of IPs to be returned. Default value: 100,000.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBlockIPListResponse(AbstractModel):
    r"""DescribeBlockIPList response structure.

    """

    def __init__(self):
        r"""
        :param _BlockedIPCount: Number of returned IPs
        :type BlockedIPCount: int
        :param _ClientIPField: Field for getting real client IP
        :type ClientIPField: str
        :param _BlockedIPList: List of IPs added to blocklist 12360
        :type BlockedIPList: list of BlockedIP
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BlockedIPCount = None
        self._ClientIPField = None
        self._BlockedIPList = None
        self._RequestId = None

    @property
    def BlockedIPCount(self):
        r"""Number of returned IPs
        :rtype: int
        """
        return self._BlockedIPCount

    @BlockedIPCount.setter
    def BlockedIPCount(self, BlockedIPCount):
        self._BlockedIPCount = BlockedIPCount

    @property
    def ClientIPField(self):
        r"""Field for getting real client IP
        :rtype: str
        """
        return self._ClientIPField

    @ClientIPField.setter
    def ClientIPField(self, ClientIPField):
        self._ClientIPField = ClientIPField

    @property
    def BlockedIPList(self):
        r"""List of IPs added to blocklist 12360
        :rtype: list of BlockedIP
        """
        return self._BlockedIPList

    @BlockedIPList.setter
    def BlockedIPList(self, BlockedIPList):
        self._BlockedIPList = BlockedIPList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BlockedIPCount = params.get("BlockedIPCount")
        self._ClientIPField = params.get("ClientIPField")
        if params.get("BlockedIPList") is not None:
            self._BlockedIPList = []
            for item in params.get("BlockedIPList"):
                obj = BlockedIP()
                obj._deserialize(item)
                self._BlockedIPList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBlockIPTaskRequest(AbstractModel):
    r"""DescribeBlockIPTask request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Async task ID returned by the `ModifyBlockIPList` API
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""Async task ID returned by the `ModifyBlockIPList` API
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBlockIPTaskResponse(AbstractModel):
    r"""DescribeBlockIPTask response structure.

    """

    def __init__(self):
        r"""
        :param _Status: 1: running; 2: failed; 6: succeeded
        :type Status: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._RequestId = None

    @property
    def Status(self):
        r"""1: running; 2: failed; 6: succeeded
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DescribeClassicalLBByInstanceIdRequest(AbstractModel):
    r"""DescribeClassicalLBByInstanceId request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceIds: List of real server IDs
        :type InstanceIds: list of str
        """
        self._InstanceIds = None

    @property
    def InstanceIds(self):
        r"""List of real server IDs
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClassicalLBByInstanceIdResponse(AbstractModel):
    r"""DescribeClassicalLBByInstanceId response structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerInfoList: CLB information list
        :type LoadBalancerInfoList: list of ClassicalLoadBalancerInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LoadBalancerInfoList = None
        self._RequestId = None

    @property
    def LoadBalancerInfoList(self):
        r"""CLB information list
        :rtype: list of ClassicalLoadBalancerInfo
        """
        return self._LoadBalancerInfoList

    @LoadBalancerInfoList.setter
    def LoadBalancerInfoList(self, LoadBalancerInfoList):
        self._LoadBalancerInfoList = LoadBalancerInfoList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LoadBalancerInfoList") is not None:
            self._LoadBalancerInfoList = []
            for item in params.get("LoadBalancerInfoList"):
                obj = ClassicalLoadBalancerInfo()
                obj._deserialize(item)
                self._LoadBalancerInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClassicalLBHealthStatusRequest(AbstractModel):
    r"""DescribeClassicalLBHealthStatus request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _ListenerId: CLB listener ID
        :type ListenerId: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""CLB listener ID
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClassicalLBHealthStatusResponse(AbstractModel):
    r"""DescribeClassicalLBHealthStatus response structure.

    """

    def __init__(self):
        r"""
        :param _HealthList: Backend health status list.
        :type HealthList: list of ClassicalHealth
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._HealthList = None
        self._RequestId = None

    @property
    def HealthList(self):
        r"""Backend health status list.
        :rtype: list of ClassicalHealth
        """
        return self._HealthList

    @HealthList.setter
    def HealthList(self, HealthList):
        self._HealthList = HealthList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HealthList") is not None:
            self._HealthList = []
            for item in params.get("HealthList"):
                obj = ClassicalHealth()
                obj._deserialize(item)
                self._HealthList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClassicalLBListenersRequest(AbstractModel):
    r"""DescribeClassicalLBListeners request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _ListenerIds: List of CLB listener IDs
        :type ListenerIds: list of str
        :param _Protocol: CLB listening protocol. Valid values: TCP, UDP, HTTP, and HTTPS.
        :type Protocol: str
        :param _ListenerPort: CLB listening port. Value range: 1 - 65535.
        :type ListenerPort: int
        :param _Status: Listener status. Valid values: 0 (creating) and 1 (running).
        :type Status: int
        """
        self._LoadBalancerId = None
        self._ListenerIds = None
        self._Protocol = None
        self._ListenerPort = None
        self._Status = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerIds(self):
        r"""List of CLB listener IDs
        :rtype: list of str
        """
        return self._ListenerIds

    @ListenerIds.setter
    def ListenerIds(self, ListenerIds):
        self._ListenerIds = ListenerIds

    @property
    def Protocol(self):
        r"""CLB listening protocol. Valid values: TCP, UDP, HTTP, and HTTPS.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def ListenerPort(self):
        r"""CLB listening port. Value range: 1 - 65535.
        :rtype: int
        """
        return self._ListenerPort

    @ListenerPort.setter
    def ListenerPort(self, ListenerPort):
        self._ListenerPort = ListenerPort

    @property
    def Status(self):
        r"""Listener status. Valid values: 0 (creating) and 1 (running).
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerIds = params.get("ListenerIds")
        self._Protocol = params.get("Protocol")
        self._ListenerPort = params.get("ListenerPort")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClassicalLBListenersResponse(AbstractModel):
    r"""DescribeClassicalLBListeners response structure.

    """

    def __init__(self):
        r"""
        :param _Listeners: Specifies the listener list.
        :type Listeners: list of ClassicalListener
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Listeners = None
        self._RequestId = None

    @property
    def Listeners(self):
        r"""Specifies the listener list.
        :rtype: list of ClassicalListener
        """
        return self._Listeners

    @Listeners.setter
    def Listeners(self, Listeners):
        self._Listeners = Listeners

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Listeners") is not None:
            self._Listeners = []
            for item in params.get("Listeners"):
                obj = ClassicalListener()
                obj._deserialize(item)
                self._Listeners.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClassicalLBTargetsRequest(AbstractModel):
    r"""DescribeClassicalLBTargets request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        """
        self._LoadBalancerId = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClassicalLBTargetsResponse(AbstractModel):
    r"""DescribeClassicalLBTargets response structure.

    """

    def __init__(self):
        r"""
        :param _Targets: Real server list.
        :type Targets: list of ClassicalTarget
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Targets = None
        self._RequestId = None

    @property
    def Targets(self):
        r"""Real server list.
        :rtype: list of ClassicalTarget
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = ClassicalTarget()
                obj._deserialize(item)
                self._Targets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClsLogSetRequest(AbstractModel):
    r"""DescribeClsLogSet request structure.

    """


class DescribeClsLogSetResponse(AbstractModel):
    r"""DescribeClsLogSet response structure.

    """

    def __init__(self):
        r"""
        :param _LogsetId: Logset ID
        :type LogsetId: str
        :param _HealthLogsetId: Health check logset ID
        :type HealthLogsetId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LogsetId = None
        self._HealthLogsetId = None
        self._RequestId = None

    @property
    def LogsetId(self):
        r"""Logset ID
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def HealthLogsetId(self):
        r"""Health check logset ID
        :rtype: str
        """
        return self._HealthLogsetId

    @HealthLogsetId.setter
    def HealthLogsetId(self, HealthLogsetId):
        self._HealthLogsetId = HealthLogsetId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LogsetId = params.get("LogsetId")
        self._HealthLogsetId = params.get("HealthLogsetId")
        self._RequestId = params.get("RequestId")


class DescribeCrossTargetsRequest(AbstractModel):
    r"""DescribeCrossTargets request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of real server lists returned. Default value: 20; maximum value: 100.
        :type Limit: int
        :param _Offset: Starting offset of the real server list returned. Default value: 0.
        :type Offset: int
        :param _Filters: Filter conditions to query CVMs and ENIs
<li> `vpc-id` - String - Required: No - (Filter condition) Filter by VPC ID, such as "vpc-12345678".</li>
<li> `ip` - String - Required: No - (Filter condition) Filter by real server IP, such as "192.168.0.1".</li>
<li> `listener-id` - String - Required: No - (Filter condition) Filter by listener ID, such as "lbl-12345678".</li>
<li> `location-id` - String - Required: No - (Filter condition) Filter by forwarding rule ID of the layer-7 listener, such as "loc-12345678".</li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        r"""Number of real server lists returned. Default value: 20; maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Starting offset of the real server list returned. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""Filter conditions to query CVMs and ENIs
<li> `vpc-id` - String - Required: No - (Filter condition) Filter by VPC ID, such as "vpc-12345678".</li>
<li> `ip` - String - Required: No - (Filter condition) Filter by real server IP, such as "192.168.0.1".</li>
<li> `listener-id` - String - Required: No - (Filter condition) Filter by listener ID, such as "lbl-12345678".</li>
<li> `location-id` - String - Required: No - (Filter condition) Filter by forwarding rule ID of the layer-7 listener, such as "loc-12345678".</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCrossTargetsResponse(AbstractModel):
    r"""DescribeCrossTargets response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of real server lists
        :type TotalCount: int
        :param _CrossTargetSet: Real server list
        :type CrossTargetSet: list of CrossTargets
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._CrossTargetSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of real server lists
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def CrossTargetSet(self):
        r"""Real server list
        :rtype: list of CrossTargets
        """
        return self._CrossTargetSet

    @CrossTargetSet.setter
    def CrossTargetSet(self, CrossTargetSet):
        self._CrossTargetSet = CrossTargetSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("CrossTargetSet") is not None:
            self._CrossTargetSet = []
            for item in params.get("CrossTargetSet"):
                obj = CrossTargets()
                obj._deserialize(item)
                self._CrossTargetSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCustomizedConfigAssociateListRequest(AbstractModel):
    r"""DescribeCustomizedConfigAssociateList request structure.

    """

    def __init__(self):
        r"""
        :param _UconfigId: Specifies the configuration ID, which can be obtained through the [DescribeCustomizedConfigList](https://www.tencentcloud.comom/document/product/214/60009?from_cn_redirect=1) api.
        :type UconfigId: str
        :param _Offset: Start position of the binding list. Default: 0.
        :type Offset: int
        :param _Limit: Number of binding lists to pull. Default: 20.
        :type Limit: int
        :param _Domain: Search Domain. can be queried through the `Domain` field in the [DescribeLoadBalancersDetail](https://www.tencentcloud.comom/document/product/214/46916?from_cn_redirect=1) API return value.
        :type Domain: str
        """
        self._UconfigId = None
        self._Offset = None
        self._Limit = None
        self._Domain = None

    @property
    def UconfigId(self):
        r"""Specifies the configuration ID, which can be obtained through the [DescribeCustomizedConfigList](https://www.tencentcloud.comom/document/product/214/60009?from_cn_redirect=1) api.
        :rtype: str
        """
        return self._UconfigId

    @UconfigId.setter
    def UconfigId(self, UconfigId):
        self._UconfigId = UconfigId

    @property
    def Offset(self):
        r"""Start position of the binding list. Default: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of binding lists to pull. Default: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Domain(self):
        r"""Search Domain. can be queried through the `Domain` field in the [DescribeLoadBalancersDetail](https://www.tencentcloud.comom/document/product/214/46916?from_cn_redirect=1) API return value.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._UconfigId = params.get("UconfigId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomizedConfigAssociateListResponse(AbstractModel):
    r"""DescribeCustomizedConfigAssociateList response structure.

    """

    def __init__(self):
        r"""
        :param _BindList: List of bound resources
        :type BindList: list of BindDetailItem
        :param _TotalCount: Total number of bound resources
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BindList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def BindList(self):
        r"""List of bound resources
        :rtype: list of BindDetailItem
        """
        return self._BindList

    @BindList.setter
    def BindList(self, BindList):
        self._BindList = BindList

    @property
    def TotalCount(self):
        r"""Total number of bound resources
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BindList") is not None:
            self._BindList = []
            for item in params.get("BindList"):
                obj = BindDetailItem()
                obj._deserialize(item)
                self._BindList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCustomizedConfigListRequest(AbstractModel):
    r"""DescribeCustomizedConfigList request structure.

    """

    def __init__(self):
        r"""
        :param _ConfigType: Configuration type. Valid values: `CLB` (CLB-specific configs), `SERVER` (domain name-specific configs), and `LOCATION` (forwarding rule-specific configs).
        :type ConfigType: str
        :param _Offset: Pagination offset. defaults to 0.
        :type Offset: int
        :param _Limit: Number of results. default value: 20.
        :type Limit: int
        :param _ConfigName: Specifies the name of configs to query. Fuzzy match is supported.
        :type ConfigName: str
        :param _UconfigIds: Configuration ID, can be accessed through the [DescribeCustomizedConfigList](https://www.tencentcloud.comom/document/api/214/60009?from_cn_redirect=1) api.
        :type UconfigIds: list of str
        :param _Filters: Filter criteria as follows:.
- loadbalancer-id
Filter by [cloud load balancer ID]. instance billing mode such as lb-9vxezxza.
Type: String.
Required: No
Method for obtaining: [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1).
- vip
Filter by [clb VIP]. network billing mode such as "1.1.1.1", "2204::22:3".
Type: String.
Required: No
Method for obtaining: [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1).
        :type Filters: list of Filter
        """
        self._ConfigType = None
        self._Offset = None
        self._Limit = None
        self._ConfigName = None
        self._UconfigIds = None
        self._Filters = None

    @property
    def ConfigType(self):
        r"""Configuration type. Valid values: `CLB` (CLB-specific configs), `SERVER` (domain name-specific configs), and `LOCATION` (forwarding rule-specific configs).
        :rtype: str
        """
        return self._ConfigType

    @ConfigType.setter
    def ConfigType(self, ConfigType):
        self._ConfigType = ConfigType

    @property
    def Offset(self):
        r"""Pagination offset. defaults to 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of results. default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ConfigName(self):
        r"""Specifies the name of configs to query. Fuzzy match is supported.
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def UconfigIds(self):
        r"""Configuration ID, can be accessed through the [DescribeCustomizedConfigList](https://www.tencentcloud.comom/document/api/214/60009?from_cn_redirect=1) api.
        :rtype: list of str
        """
        return self._UconfigIds

    @UconfigIds.setter
    def UconfigIds(self, UconfigIds):
        self._UconfigIds = UconfigIds

    @property
    def Filters(self):
        r"""Filter criteria as follows:.
- loadbalancer-id
Filter by [cloud load balancer ID]. instance billing mode such as lb-9vxezxza.
Type: String.
Required: No
Method for obtaining: [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1).
- vip
Filter by [clb VIP]. network billing mode such as "1.1.1.1", "2204::22:3".
Type: String.
Required: No
Method for obtaining: [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1).
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ConfigType = params.get("ConfigType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ConfigName = params.get("ConfigName")
        self._UconfigIds = params.get("UconfigIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomizedConfigListResponse(AbstractModel):
    r"""DescribeCustomizedConfigList response structure.

    """

    def __init__(self):
        r"""
        :param _ConfigList: Configuration list.
        :type ConfigList: list of ConfigListItem
        :param _TotalCount: Number of configurations.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ConfigList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ConfigList(self):
        r"""Configuration list.
        :rtype: list of ConfigListItem
        """
        return self._ConfigList

    @ConfigList.setter
    def ConfigList(self, ConfigList):
        self._ConfigList = ConfigList

    @property
    def TotalCount(self):
        r"""Number of configurations.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ConfigList") is not None:
            self._ConfigList = []
            for item in params.get("ConfigList"):
                obj = ConfigListItem()
                obj._deserialize(item)
                self._ConfigList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeIdleLoadBalancersRequest(AbstractModel):
    r"""DescribeIdleLoadBalancers request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Data offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned CLB instances. Default value: 20. Maximum value: 100.
        :type Limit: int
        :param _LoadBalancerRegion: The Region of the cloud load balancer can be obtained through the `RegionSet.Region` field in the API return value of [DescribeRegions](https://www.tencentcloud.comom/document/product/1596/77930?from_cn_redirect=1).
        :type LoadBalancerRegion: str
        """
        self._Offset = None
        self._Limit = None
        self._LoadBalancerRegion = None

    @property
    def Offset(self):
        r"""Data offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned CLB instances. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def LoadBalancerRegion(self):
        r"""The Region of the cloud load balancer can be obtained through the `RegionSet.Region` field in the API return value of [DescribeRegions](https://www.tencentcloud.comom/document/product/1596/77930?from_cn_redirect=1).
        :rtype: str
        """
        return self._LoadBalancerRegion

    @LoadBalancerRegion.setter
    def LoadBalancerRegion(self, LoadBalancerRegion):
        self._LoadBalancerRegion = LoadBalancerRegion


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._LoadBalancerRegion = params.get("LoadBalancerRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIdleLoadBalancersResponse(AbstractModel):
    r"""DescribeIdleLoadBalancers response structure.

    """

    def __init__(self):
        r"""
        :param _IdleLoadBalancers: Idle instance list.
        :type IdleLoadBalancers: list of IdleLoadBalancer
        :param _TotalCount: Total number of idle CLB instances
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IdleLoadBalancers = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def IdleLoadBalancers(self):
        r"""Idle instance list.
        :rtype: list of IdleLoadBalancer
        """
        return self._IdleLoadBalancers

    @IdleLoadBalancers.setter
    def IdleLoadBalancers(self, IdleLoadBalancers):
        self._IdleLoadBalancers = IdleLoadBalancers

    @property
    def TotalCount(self):
        r"""Total number of idle CLB instances
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IdleLoadBalancers") is not None:
            self._IdleLoadBalancers = []
            for item in params.get("IdleLoadBalancers"):
                obj = IdleLoadBalancer()
                obj._deserialize(item)
                self._IdleLoadBalancers.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeLBListenersRequest(AbstractModel):
    r"""DescribeLBListeners request structure.

    """

    def __init__(self):
        r"""
        :param _Backends: List of private network IPs to be queried.
        :type Backends: list of LbRsItem
        """
        self._Backends = None

    @property
    def Backends(self):
        r"""List of private network IPs to be queried.
        :rtype: list of LbRsItem
        """
        return self._Backends

    @Backends.setter
    def Backends(self, Backends):
        self._Backends = Backends


    def _deserialize(self, params):
        if params.get("Backends") is not None:
            self._Backends = []
            for item in params.get("Backends"):
                obj = LbRsItem()
                obj._deserialize(item)
                self._Backends.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLBListenersResponse(AbstractModel):
    r"""DescribeLBListeners response structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancers: Listener rule associated with the real server.
        :type LoadBalancers: list of LBItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LoadBalancers = None
        self._RequestId = None

    @property
    def LoadBalancers(self):
        r"""Listener rule associated with the real server.
        :rtype: list of LBItem
        """
        return self._LoadBalancers

    @LoadBalancers.setter
    def LoadBalancers(self, LoadBalancers):
        self._LoadBalancers = LoadBalancers

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LoadBalancers") is not None:
            self._LoadBalancers = []
            for item in params.get("LoadBalancers"):
                obj = LBItem()
                obj._deserialize(item)
                self._LoadBalancers.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLBOperateProtectRequest(AbstractModel):
    r"""DescribeLBOperateProtect request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerIds: CLB instance ID.
        :type LoadBalancerIds: list of str
        """
        self._LoadBalancerIds = None

    @property
    def LoadBalancerIds(self):
        r"""CLB instance ID.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds


    def _deserialize(self, params):
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLBOperateProtectResponse(AbstractModel):
    r"""DescribeLBOperateProtect response structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerSet: Describes the returned cloud load balancer operation protection information array.
        :type LoadBalancerSet: list of LBOperateProtectInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LoadBalancerSet = None
        self._RequestId = None

    @property
    def LoadBalancerSet(self):
        r"""Describes the returned cloud load balancer operation protection information array.
        :rtype: list of LBOperateProtectInfo
        """
        return self._LoadBalancerSet

    @LoadBalancerSet.setter
    def LoadBalancerSet(self, LoadBalancerSet):
        self._LoadBalancerSet = LoadBalancerSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LoadBalancerSet") is not None:
            self._LoadBalancerSet = []
            for item in params.get("LoadBalancerSet"):
                obj = LBOperateProtectInfo()
                obj._deserialize(item)
                self._LoadBalancerSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeListenersRequest(AbstractModel):
    r"""DescribeListeners request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/api/214/30685?from_cn_redirect=1) api to obtain the ID.
        :type LoadBalancerId: str
        :param _ListenerIds: Specifies the array of clb listener ids to query, with a maximum of 100. you can call the [DescribeListeners](https://www.tencentcloud.comom/document/api/214/30686?from_cn_redirect=1) api to obtain the ids.
        :type ListenerIds: list of str
        :param _Protocol: Type of the listener protocols to be queried. Values: TCP`, `UDP`, `HTTP`, `HTTPS`, `TCP_SSL` and `QUIC`.
        :type Protocol: str
        :param _Port: Port of listener to query. value range: 1-65535.
        :type Port: int
        """
        self._LoadBalancerId = None
        self._ListenerIds = None
        self._Protocol = None
        self._Port = None

    @property
    def LoadBalancerId(self):
        r"""ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/api/214/30685?from_cn_redirect=1) api to obtain the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerIds(self):
        r"""Specifies the array of clb listener ids to query, with a maximum of 100. you can call the [DescribeListeners](https://www.tencentcloud.comom/document/api/214/30686?from_cn_redirect=1) api to obtain the ids.
        :rtype: list of str
        """
        return self._ListenerIds

    @ListenerIds.setter
    def ListenerIds(self, ListenerIds):
        self._ListenerIds = ListenerIds

    @property
    def Protocol(self):
        r"""Type of the listener protocols to be queried. Values: TCP`, `UDP`, `HTTP`, `HTTPS`, `TCP_SSL` and `QUIC`.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        r"""Port of listener to query. value range: 1-65535.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerIds = params.get("ListenerIds")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeListenersResponse(AbstractModel):
    r"""DescribeListeners response structure.

    """

    def __init__(self):
        r"""
        :param _Listeners: Listener list
        :type Listeners: list of Listener
        :param _TotalCount: Total number of listeners (filtered by port, protocol, and listener ID).
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Listeners = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Listeners(self):
        r"""Listener list
        :rtype: list of Listener
        """
        return self._Listeners

    @Listeners.setter
    def Listeners(self, Listeners):
        self._Listeners = Listeners

    @property
    def TotalCount(self):
        r"""Total number of listeners (filtered by port, protocol, and listener ID).
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Listeners") is not None:
            self._Listeners = []
            for item in params.get("Listeners"):
                obj = Listener()
                obj._deserialize(item)
                self._Listeners.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeLoadBalancerListByCertIdRequest(AbstractModel):
    r"""DescribeLoadBalancerListByCertId request structure.

    """

    def __init__(self):
        r"""
        :param _CertIds: Specifies the server certificate ID or client certificate ID. can be accessed through the [DescribeCertificate](https://www.tencentcloud.comom/document/api/400/41674?from_cn_redirect=1) api.
Specifies the maximum length of the array is 20.
        :type CertIds: list of str
        """
        self._CertIds = None

    @property
    def CertIds(self):
        r"""Specifies the server certificate ID or client certificate ID. can be accessed through the [DescribeCertificate](https://www.tencentcloud.comom/document/api/400/41674?from_cn_redirect=1) api.
Specifies the maximum length of the array is 20.
        :rtype: list of str
        """
        return self._CertIds

    @CertIds.setter
    def CertIds(self, CertIds):
        self._CertIds = CertIds


    def _deserialize(self, params):
        self._CertIds = params.get("CertIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLoadBalancerListByCertIdResponse(AbstractModel):
    r"""DescribeLoadBalancerListByCertId response structure.

    """

    def __init__(self):
        r"""
        :param _CertSet: Certificate ID and list of CLB instances associated with it
        :type CertSet: list of CertIdRelatedWithLoadBalancers
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CertSet = None
        self._RequestId = None

    @property
    def CertSet(self):
        r"""Certificate ID and list of CLB instances associated with it
        :rtype: list of CertIdRelatedWithLoadBalancers
        """
        return self._CertSet

    @CertSet.setter
    def CertSet(self, CertSet):
        self._CertSet = CertSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CertSet") is not None:
            self._CertSet = []
            for item in params.get("CertSet"):
                obj = CertIdRelatedWithLoadBalancers()
                obj._deserialize(item)
                self._CertSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLoadBalancerOverviewRequest(AbstractModel):
    r"""DescribeLoadBalancerOverview request structure.

    """


class DescribeLoadBalancerOverviewResponse(AbstractModel):
    r"""DescribeLoadBalancerOverview response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of CLB instances
        :type TotalCount: int
        :param _RunningCount: Number of CLB instances that are running
        :type RunningCount: int
        :param _IsolationCount: Number of CLB instances that are isolated
        :type IsolationCount: int
        :param _WillExpireCount: Number of CLB instances that are about to expire
        :type WillExpireCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RunningCount = None
        self._IsolationCount = None
        self._WillExpireCount = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of CLB instances
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RunningCount(self):
        r"""Number of CLB instances that are running
        :rtype: int
        """
        return self._RunningCount

    @RunningCount.setter
    def RunningCount(self, RunningCount):
        self._RunningCount = RunningCount

    @property
    def IsolationCount(self):
        r"""Number of CLB instances that are isolated
        :rtype: int
        """
        return self._IsolationCount

    @IsolationCount.setter
    def IsolationCount(self, IsolationCount):
        self._IsolationCount = IsolationCount

    @property
    def WillExpireCount(self):
        r"""Number of CLB instances that are about to expire
        :rtype: int
        """
        return self._WillExpireCount

    @WillExpireCount.setter
    def WillExpireCount(self, WillExpireCount):
        self._WillExpireCount = WillExpireCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._RunningCount = params.get("RunningCount")
        self._IsolationCount = params.get("IsolationCount")
        self._WillExpireCount = params.get("WillExpireCount")
        self._RequestId = params.get("RequestId")


class DescribeLoadBalancerTrafficRequest(AbstractModel):
    r"""DescribeLoadBalancerTraffic request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerRegion: CLB instance region. If this parameter is not passed in, CLB instances in all regions will be returned.
        :type LoadBalancerRegion: str
        """
        self._LoadBalancerRegion = None

    @property
    def LoadBalancerRegion(self):
        r"""CLB instance region. If this parameter is not passed in, CLB instances in all regions will be returned.
        :rtype: str
        """
        return self._LoadBalancerRegion

    @LoadBalancerRegion.setter
    def LoadBalancerRegion(self, LoadBalancerRegion):
        self._LoadBalancerRegion = LoadBalancerRegion


    def _deserialize(self, params):
        self._LoadBalancerRegion = params.get("LoadBalancerRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLoadBalancerTrafficResponse(AbstractModel):
    r"""DescribeLoadBalancerTraffic response structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerTraffic: Load balance information sorted in descending order by outbound bandwidth.
        :type LoadBalancerTraffic: list of LoadBalancerTraffic
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LoadBalancerTraffic = None
        self._RequestId = None

    @property
    def LoadBalancerTraffic(self):
        r"""Load balance information sorted in descending order by outbound bandwidth.
        :rtype: list of LoadBalancerTraffic
        """
        return self._LoadBalancerTraffic

    @LoadBalancerTraffic.setter
    def LoadBalancerTraffic(self, LoadBalancerTraffic):
        self._LoadBalancerTraffic = LoadBalancerTraffic

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LoadBalancerTraffic") is not None:
            self._LoadBalancerTraffic = []
            for item in params.get("LoadBalancerTraffic"):
                obj = LoadBalancerTraffic()
                obj._deserialize(item)
                self._LoadBalancerTraffic.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLoadBalancersDetailRequest(AbstractModel):
    r"""DescribeLoadBalancersDetail request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of CLB instance lists returned. Default value: 20; maximum value: 100.
        :type Limit: int
        :param _Offset: Starting offset of the CLB instance list returned. Default value: 0.
        :type Offset: int
        :param _Fields: List of fields. Only fields specified will be returned. If it’s left blank, `null` is returned. The fields `LoadBalancerId` and `LoadBalancerName` are added by default. For details about fields, see <a href="https://intl.cloud.tencent.com/document/api/214/30694?from_cn_redirect=1#LoadBalancerDetail">LoadBalancerDetail</a>.
        :type Fields: list of str
        :param _TargetType: When the Fields include TargetId, TargetAddress, TargetPort, TargetWeight, ListenerId, Protocol, Port, LocationId, Domain, and Url, you must select exporting the Target of the Target GROUP or a non-Target GROUP. valid values: NODE, GROUP.
        :type TargetType: str
        :param _Filters: Querying conditions for cloud load balancer detailed information list. detailed filter criteria.
- loadbalancer-id
Filter by [clb ID], for example: lb-rbw5skde.
Type: String.
Required: No
Method for obtaining: [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1).
- project-id
Filters by [project ID]. for example: "0", "123".
Type: String.
Required: No
Method for obtaining: [DescribeProject](https://www.tencentcloud.comom/document/api/651/78725?from_cn_redirect=1).
- network
Filters by [clb network type]. for example: Public.
Type: String.
Required: No
Valid values: Private (Private network), Public (Public network).
- vip
Filter by [cloud load balancer VIP], such as "1.1.1.1", "2204::22:3".
Type: String.
Required: No
- vpcid
Filter by the vpc to which the cloud load balancer belongs, such as "vpc-12345678".
Type: String.
Required: No
Method for obtaining: [DescribeZones](https://www.tencentcloud.comom/document/product/213/15707?from_cn_redirect=1).
- target-ip
Filters by the private network IP of the backend destination. for example: "1.1.1.1", "2203::214:4".
Type: String.
Required: No
- zone
Filter by [availability zone of the cloud load balancer]. for example: "ap-guangzhou-1".
Type: String.
Required: No
Method for obtaining: [DescribeZones](https://www.tencentcloud.comom/document/product/213/15707?from_cn_redirect=1).
- tag-key
Filters by [tag key of the cloud load balancer tag], for example: "name".
Type: String.
Required: No
Method for obtaining: [DescribeTags](https://www.tencentcloud.comom/document/api/651/35316?from_cn_redirect=1).
- tag:*
Filter by [cloud load balancer tag], where ':' is followed by the tag key. for example, to filter by tag key 'name' with tag Values 'zhangsan' and 'lisi', use {"name": "tag:name","Values": ["zhangsan", "lisi"]}.
Type: String.
Required: No
Method for obtaining: [DescribeTagKeys](https://www.tencentcloud.comom/document/api/651/35318?from_cn_redirect=1).
- fuzzy-search
Searches by [clb VIP, clb name] using fuzzy search, for example: "1.1".
Type: String.
Required: No
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Fields = None
        self._TargetType = None
        self._Filters = None

    @property
    def Limit(self):
        r"""Number of CLB instance lists returned. Default value: 20; maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Starting offset of the CLB instance list returned. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Fields(self):
        r"""List of fields. Only fields specified will be returned. If it’s left blank, `null` is returned. The fields `LoadBalancerId` and `LoadBalancerName` are added by default. For details about fields, see <a href="https://intl.cloud.tencent.com/document/api/214/30694?from_cn_redirect=1#LoadBalancerDetail">LoadBalancerDetail</a>.
        :rtype: list of str
        """
        return self._Fields

    @Fields.setter
    def Fields(self, Fields):
        self._Fields = Fields

    @property
    def TargetType(self):
        r"""When the Fields include TargetId, TargetAddress, TargetPort, TargetWeight, ListenerId, Protocol, Port, LocationId, Domain, and Url, you must select exporting the Target of the Target GROUP or a non-Target GROUP. valid values: NODE, GROUP.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def Filters(self):
        r"""Querying conditions for cloud load balancer detailed information list. detailed filter criteria.
- loadbalancer-id
Filter by [clb ID], for example: lb-rbw5skde.
Type: String.
Required: No
Method for obtaining: [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1).
- project-id
Filters by [project ID]. for example: "0", "123".
Type: String.
Required: No
Method for obtaining: [DescribeProject](https://www.tencentcloud.comom/document/api/651/78725?from_cn_redirect=1).
- network
Filters by [clb network type]. for example: Public.
Type: String.
Required: No
Valid values: Private (Private network), Public (Public network).
- vip
Filter by [cloud load balancer VIP], such as "1.1.1.1", "2204::22:3".
Type: String.
Required: No
- vpcid
Filter by the vpc to which the cloud load balancer belongs, such as "vpc-12345678".
Type: String.
Required: No
Method for obtaining: [DescribeZones](https://www.tencentcloud.comom/document/product/213/15707?from_cn_redirect=1).
- target-ip
Filters by the private network IP of the backend destination. for example: "1.1.1.1", "2203::214:4".
Type: String.
Required: No
- zone
Filter by [availability zone of the cloud load balancer]. for example: "ap-guangzhou-1".
Type: String.
Required: No
Method for obtaining: [DescribeZones](https://www.tencentcloud.comom/document/product/213/15707?from_cn_redirect=1).
- tag-key
Filters by [tag key of the cloud load balancer tag], for example: "name".
Type: String.
Required: No
Method for obtaining: [DescribeTags](https://www.tencentcloud.comom/document/api/651/35316?from_cn_redirect=1).
- tag:*
Filter by [cloud load balancer tag], where ':' is followed by the tag key. for example, to filter by tag key 'name' with tag Values 'zhangsan' and 'lisi', use {"name": "tag:name","Values": ["zhangsan", "lisi"]}.
Type: String.
Required: No
Method for obtaining: [DescribeTagKeys](https://www.tencentcloud.comom/document/api/651/35318?from_cn_redirect=1).
- fuzzy-search
Searches by [clb VIP, clb name] using fuzzy search, for example: "1.1".
Type: String.
Required: No
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Fields = params.get("Fields")
        self._TargetType = params.get("TargetType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLoadBalancersDetailResponse(AbstractModel):
    r"""DescribeLoadBalancersDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of lists describing CLB instance details.
        :type TotalCount: int
        :param _LoadBalancerDetailSet: Load balancing detail list.
        :type LoadBalancerDetailSet: list of LoadBalancerDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._LoadBalancerDetailSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of lists describing CLB instance details.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def LoadBalancerDetailSet(self):
        r"""Load balancing detail list.
        :rtype: list of LoadBalancerDetail
        """
        return self._LoadBalancerDetailSet

    @LoadBalancerDetailSet.setter
    def LoadBalancerDetailSet(self, LoadBalancerDetailSet):
        self._LoadBalancerDetailSet = LoadBalancerDetailSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("LoadBalancerDetailSet") is not None:
            self._LoadBalancerDetailSet = []
            for item in params.get("LoadBalancerDetailSet"):
                obj = LoadBalancerDetail()
                obj._deserialize(item)
                self._LoadBalancerDetailSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLoadBalancersRequest(AbstractModel):
    r"""DescribeLoadBalancers request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerIds: CLB instance IDs. There can be up to 20 IDs.
        :type LoadBalancerIds: list of str
        :param _LoadBalancerType: CLB instance network type:
OPEN: public network; INTERNAL: private network.
        :type LoadBalancerType: str
        :param _Forward: CLB instance type. 1: generic CLB instance; 0: classic CLB instance
        :type Forward: int
        :param _LoadBalancerName: Specifies the name of the clb instance. fuzzy query is supported.
        :type LoadBalancerName: str
        :param _Domain: Tencent cloud assigns a domain name to the cloud load balancer instance. fuzzy query is supported.
        :type Domain: str
        :param _LoadBalancerVips: VIP address of a CLB instance (there can be multiple addresses)
        :type LoadBalancerVips: list of str
        :param _BackendPublicIps: Public IPs of the backend services bound with the load balancer. Only the public IPs of CVMs are supported now.
        :type BackendPublicIps: list of str
        :param _BackendPrivateIps: Private IPs of the backend services bound with the load balancer. Only the private IPs of CVMs are supported now.
        :type BackendPrivateIps: list of str
        :param _Offset: Data offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned CLB instances. Default value: 20. Maximum value: 100.
        :type Limit: int
        :param _OrderBy: Sorting parameter. supports the following fields:.
- LoadBalancerName
- CreateTime
- Domain
- LoadBalancerType

Defaults to CreateTime.

        :type OrderBy: str
        :param _OrderType: 1 for descending, 0 for ascending, defaults to 1, sorted by creation time in descending order.
        :type OrderType: int
        :param _SearchKey: Specifies the fuzzy search field for fuzzy matching the name, domain name, VIP address, or ID of a cloud load balancer instance.
        :type SearchKey: str
        :param _ProjectId: Project ID of the cloud load balancer instance. you can call the [DescribeProject](https://www.tencentcloud.comom/document/api/651/78725?from_cn_redirect=1) api to obtain the ID. defaults to all projects if not passed.
        :type ProjectId: int
        :param _WithRs: Whether a CLB instance is bound to a real server. 0: no; 1: yes; -1: query all.
        :type WithRs: int
        :param _VpcId: Specifies the unique vpc ID of the load balancing instance, such as vpc-bhqkbhdx. you can call the [DescribeVpcs](https://www.tencentcloud.comom/document/api/215/15778?from_cn_redirect=1) api to obtain it.
Searches for cloud load balancer of basic network type. allows input '0'.
        :type VpcId: str
        :param _SecurityGroup: Security group ID, such as sg-m1cc****, can be obtained through the API [DescribeSecurityGroups](https://www.tencentcloud.comom/document/product/215/15808?from_cn_redirect=1).
        :type SecurityGroup: str
        :param _MasterZone: Primary availability zone ID, such as 100001 (corresponding to Guangzhou Zone 1). You can obtain the list of availability zones through [DescribeZones](https://intl.cloud.tencent.com/document/product/213/15707?from_cn_redirect=1).
        :type MasterZone: str
        :param _Filters: Each request can have up to 10 `Filters` and 100 `Filter.Values`. Detailed filter conditions:
<li> internet-charge-type - Type: String - Required: No - Filter by CLB network billing mode, including `TRAFFIC_POSTPAID_BY_HOUR`</li>
        :type Filters: list of Filter
        :param _AdditionalFields: Specifies the expanded fields to return. not specified, expanded fields do not return by default. supported expanded fields are as follows:.
<Li>TargetCount: specifies the number of real servers bound to it.</li>.
        :type AdditionalFields: list of str
        """
        self._LoadBalancerIds = None
        self._LoadBalancerType = None
        self._Forward = None
        self._LoadBalancerName = None
        self._Domain = None
        self._LoadBalancerVips = None
        self._BackendPublicIps = None
        self._BackendPrivateIps = None
        self._Offset = None
        self._Limit = None
        self._OrderBy = None
        self._OrderType = None
        self._SearchKey = None
        self._ProjectId = None
        self._WithRs = None
        self._VpcId = None
        self._SecurityGroup = None
        self._MasterZone = None
        self._Filters = None
        self._AdditionalFields = None

    @property
    def LoadBalancerIds(self):
        r"""CLB instance IDs. There can be up to 20 IDs.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds

    @property
    def LoadBalancerType(self):
        r"""CLB instance network type:
OPEN: public network; INTERNAL: private network.
        :rtype: str
        """
        return self._LoadBalancerType

    @LoadBalancerType.setter
    def LoadBalancerType(self, LoadBalancerType):
        self._LoadBalancerType = LoadBalancerType

    @property
    def Forward(self):
        r"""CLB instance type. 1: generic CLB instance; 0: classic CLB instance
        :rtype: int
        """
        return self._Forward

    @Forward.setter
    def Forward(self, Forward):
        self._Forward = Forward

    @property
    def LoadBalancerName(self):
        r"""Specifies the name of the clb instance. fuzzy query is supported.
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def Domain(self):
        r"""Tencent cloud assigns a domain name to the cloud load balancer instance. fuzzy query is supported.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def LoadBalancerVips(self):
        r"""VIP address of a CLB instance (there can be multiple addresses)
        :rtype: list of str
        """
        return self._LoadBalancerVips

    @LoadBalancerVips.setter
    def LoadBalancerVips(self, LoadBalancerVips):
        self._LoadBalancerVips = LoadBalancerVips

    @property
    def BackendPublicIps(self):
        r"""Public IPs of the backend services bound with the load balancer. Only the public IPs of CVMs are supported now.
        :rtype: list of str
        """
        return self._BackendPublicIps

    @BackendPublicIps.setter
    def BackendPublicIps(self, BackendPublicIps):
        self._BackendPublicIps = BackendPublicIps

    @property
    def BackendPrivateIps(self):
        r"""Private IPs of the backend services bound with the load balancer. Only the private IPs of CVMs are supported now.
        :rtype: list of str
        """
        return self._BackendPrivateIps

    @BackendPrivateIps.setter
    def BackendPrivateIps(self, BackendPrivateIps):
        self._BackendPrivateIps = BackendPrivateIps

    @property
    def Offset(self):
        r"""Data offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned CLB instances. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderBy(self):
        r"""Sorting parameter. supports the following fields:.
- LoadBalancerName
- CreateTime
- Domain
- LoadBalancerType

Defaults to CreateTime.

        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        r"""1 for descending, 0 for ascending, defaults to 1, sorted by creation time in descending order.
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def SearchKey(self):
        r"""Specifies the fuzzy search field for fuzzy matching the name, domain name, VIP address, or ID of a cloud load balancer instance.
        :rtype: str
        """
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey

    @property
    def ProjectId(self):
        r"""Project ID of the cloud load balancer instance. you can call the [DescribeProject](https://www.tencentcloud.comom/document/api/651/78725?from_cn_redirect=1) api to obtain the ID. defaults to all projects if not passed.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WithRs(self):
        r"""Whether a CLB instance is bound to a real server. 0: no; 1: yes; -1: query all.
        :rtype: int
        """
        return self._WithRs

    @WithRs.setter
    def WithRs(self, WithRs):
        self._WithRs = WithRs

    @property
    def VpcId(self):
        r"""Specifies the unique vpc ID of the load balancing instance, such as vpc-bhqkbhdx. you can call the [DescribeVpcs](https://www.tencentcloud.comom/document/api/215/15778?from_cn_redirect=1) api to obtain it.
Searches for cloud load balancer of basic network type. allows input '0'.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SecurityGroup(self):
        r"""Security group ID, such as sg-m1cc****, can be obtained through the API [DescribeSecurityGroups](https://www.tencentcloud.comom/document/product/215/15808?from_cn_redirect=1).
        :rtype: str
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def MasterZone(self):
        r"""Primary availability zone ID, such as 100001 (corresponding to Guangzhou Zone 1). You can obtain the list of availability zones through [DescribeZones](https://intl.cloud.tencent.com/document/product/213/15707?from_cn_redirect=1).
        :rtype: str
        """
        return self._MasterZone

    @MasterZone.setter
    def MasterZone(self, MasterZone):
        self._MasterZone = MasterZone

    @property
    def Filters(self):
        r"""Each request can have up to 10 `Filters` and 100 `Filter.Values`. Detailed filter conditions:
<li> internet-charge-type - Type: String - Required: No - Filter by CLB network billing mode, including `TRAFFIC_POSTPAID_BY_HOUR`</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def AdditionalFields(self):
        r"""Specifies the expanded fields to return. not specified, expanded fields do not return by default. supported expanded fields are as follows:.
<Li>TargetCount: specifies the number of real servers bound to it.</li>.
        :rtype: list of str
        """
        return self._AdditionalFields

    @AdditionalFields.setter
    def AdditionalFields(self, AdditionalFields):
        self._AdditionalFields = AdditionalFields


    def _deserialize(self, params):
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        self._LoadBalancerType = params.get("LoadBalancerType")
        self._Forward = params.get("Forward")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._Domain = params.get("Domain")
        self._LoadBalancerVips = params.get("LoadBalancerVips")
        self._BackendPublicIps = params.get("BackendPublicIps")
        self._BackendPrivateIps = params.get("BackendPrivateIps")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        self._SearchKey = params.get("SearchKey")
        self._ProjectId = params.get("ProjectId")
        self._WithRs = params.get("WithRs")
        self._VpcId = params.get("VpcId")
        self._SecurityGroup = params.get("SecurityGroup")
        self._MasterZone = params.get("MasterZone")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._AdditionalFields = params.get("AdditionalFields")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLoadBalancersResponse(AbstractModel):
    r"""DescribeLoadBalancers response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of CLB instances that meet the filter criteria. This value is independent of the Limit in the input parameter.
        :type TotalCount: int
        :param _LoadBalancerSet: Array of returned CLB instances.
        :type LoadBalancerSet: list of LoadBalancer
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._LoadBalancerSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of CLB instances that meet the filter criteria. This value is independent of the Limit in the input parameter.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def LoadBalancerSet(self):
        r"""Array of returned CLB instances.
        :rtype: list of LoadBalancer
        """
        return self._LoadBalancerSet

    @LoadBalancerSet.setter
    def LoadBalancerSet(self, LoadBalancerSet):
        self._LoadBalancerSet = LoadBalancerSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("LoadBalancerSet") is not None:
            self._LoadBalancerSet = []
            for item in params.get("LoadBalancerSet"):
                obj = LoadBalancer()
                obj._deserialize(item)
                self._LoadBalancerSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeQuotaRequest(AbstractModel):
    r"""DescribeQuota request structure.

    """


class DescribeQuotaResponse(AbstractModel):
    r"""DescribeQuota response structure.

    """

    def __init__(self):
        r"""
        :param _QuotaSet: Quota list
        :type QuotaSet: list of Quota
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._QuotaSet = None
        self._RequestId = None

    @property
    def QuotaSet(self):
        r"""Quota list
        :rtype: list of Quota
        """
        return self._QuotaSet

    @QuotaSet.setter
    def QuotaSet(self, QuotaSet):
        self._QuotaSet = QuotaSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QuotaSet") is not None:
            self._QuotaSet = []
            for item in params.get("QuotaSet"):
                obj = Quota()
                obj._deserialize(item)
                self._QuotaSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeResourcesRequest(AbstractModel):
    r"""DescribeResources request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of returned AZ resources. Default value: 20. Maximum value: 100.
        :type Limit: int
        :param _Offset: Starting offset of the returned AZ resource list. Default value: 0.
        :type Offset: int
        :param _Filters: Specifies the conditions for querying the availability zone resource list. detailed filter criteria are as follows:.
- master-zone
Filters by regional availability zone, for example: ap-guangzhou-2.
Type: String.
Required: No
- ip-version
Filter by [IP type], such as IPv4.
Type: String.
Required: No
Valid values: IPv4, IPv6, IPv6_Nat.
- isp
Filters by [ISP type], for example: BGP.
Type: String.
Required: No
Optional. valid values: BGP, CMCC (china mobile), CUCC (china unicom), CTCC (china telecom), BGP_PRO, INTERNAL (private network).
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        r"""Number of returned AZ resources. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Starting offset of the returned AZ resource list. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""Specifies the conditions for querying the availability zone resource list. detailed filter criteria are as follows:.
- master-zone
Filters by regional availability zone, for example: ap-guangzhou-2.
Type: String.
Required: No
- ip-version
Filter by [IP type], such as IPv4.
Type: String.
Required: No
Valid values: IPv4, IPv6, IPv6_Nat.
- isp
Filters by [ISP type], for example: BGP.
Type: String.
Required: No
Optional. valid values: BGP, CMCC (china mobile), CUCC (china unicom), CTCC (china telecom), BGP_PRO, INTERNAL (private network).
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourcesResponse(AbstractModel):
    r"""DescribeResources response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneResourceSet: List of resources supported by the AZ
        :type ZoneResourceSet: list of ZoneResource
        :param _TotalCount: Number of entries in the AZ resource list.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneResourceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ZoneResourceSet(self):
        r"""List of resources supported by the AZ
        :rtype: list of ZoneResource
        """
        return self._ZoneResourceSet

    @ZoneResourceSet.setter
    def ZoneResourceSet(self, ZoneResourceSet):
        self._ZoneResourceSet = ZoneResourceSet

    @property
    def TotalCount(self):
        r"""Number of entries in the AZ resource list.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ZoneResourceSet") is not None:
            self._ZoneResourceSet = []
            for item in params.get("ZoneResourceSet"):
                obj = ZoneResource()
                obj._deserialize(item)
                self._ZoneResourceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRewriteRequest(AbstractModel):
    r"""DescribeRewrite request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _SourceListenerIds: Array of CLB listener IDs
        :type SourceListenerIds: list of str
        :param _SourceLocationIds: Array of CLB forwarding rule IDs
        :type SourceLocationIds: list of str
        """
        self._LoadBalancerId = None
        self._SourceListenerIds = None
        self._SourceLocationIds = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def SourceListenerIds(self):
        r"""Array of CLB listener IDs
        :rtype: list of str
        """
        return self._SourceListenerIds

    @SourceListenerIds.setter
    def SourceListenerIds(self, SourceListenerIds):
        self._SourceListenerIds = SourceListenerIds

    @property
    def SourceLocationIds(self):
        r"""Array of CLB forwarding rule IDs
        :rtype: list of str
        """
        return self._SourceLocationIds

    @SourceLocationIds.setter
    def SourceLocationIds(self, SourceLocationIds):
        self._SourceLocationIds = SourceLocationIds


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._SourceListenerIds = params.get("SourceListenerIds")
        self._SourceLocationIds = params.get("SourceLocationIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRewriteResponse(AbstractModel):
    r"""DescribeRewrite response structure.

    """

    def __init__(self):
        r"""
        :param _RewriteSet: Array of redirection forwarding rules. If there are no redirection rules, an empty array will be returned.
        :type RewriteSet: list of RuleOutput
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RewriteSet = None
        self._RequestId = None

    @property
    def RewriteSet(self):
        r"""Array of redirection forwarding rules. If there are no redirection rules, an empty array will be returned.
        :rtype: list of RuleOutput
        """
        return self._RewriteSet

    @RewriteSet.setter
    def RewriteSet(self, RewriteSet):
        self._RewriteSet = RewriteSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RewriteSet") is not None:
            self._RewriteSet = []
            for item in params.get("RewriteSet"):
                obj = RuleOutput()
                obj._deserialize(item)
                self._RewriteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTargetGroupInstancesRequest(AbstractModel):
    r"""DescribeTargetGroupInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter criteria, currently supported by multiple conditions combined as TargetGroupId, BindIP, and InstanceId.
        :type Filters: list of Filter
        :param _Limit: Number of displayed results. Default value: 20
        :type Limit: int
        :param _Offset: Display offset. Default value: 0
        :type Offset: int
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def Filters(self):
        r"""Filter criteria, currently supported by multiple conditions combined as TargetGroupId, BindIP, and InstanceId.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        r"""Number of displayed results. Default value: 20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Display offset. Default value: 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTargetGroupInstancesResponse(AbstractModel):
    r"""DescribeTargetGroupInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of results returned for the current query
        :type TotalCount: int
        :param _TargetGroupInstanceSet: Information of the bound server
        :type TargetGroupInstanceSet: list of TargetGroupBackend
        :param _RealCount: The actual total number of bound instances, which is not affected by the setting of `Limit`, `Offset` and the CAM permissions.
        :type RealCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TargetGroupInstanceSet = None
        self._RealCount = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of results returned for the current query
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TargetGroupInstanceSet(self):
        r"""Information of the bound server
        :rtype: list of TargetGroupBackend
        """
        return self._TargetGroupInstanceSet

    @TargetGroupInstanceSet.setter
    def TargetGroupInstanceSet(self, TargetGroupInstanceSet):
        self._TargetGroupInstanceSet = TargetGroupInstanceSet

    @property
    def RealCount(self):
        r"""The actual total number of bound instances, which is not affected by the setting of `Limit`, `Offset` and the CAM permissions.
        :rtype: int
        """
        return self._RealCount

    @RealCount.setter
    def RealCount(self, RealCount):
        self._RealCount = RealCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TargetGroupInstanceSet") is not None:
            self._TargetGroupInstanceSet = []
            for item in params.get("TargetGroupInstanceSet"):
                obj = TargetGroupBackend()
                obj._deserialize(item)
                self._TargetGroupInstanceSet.append(obj)
        self._RealCount = params.get("RealCount")
        self._RequestId = params.get("RequestId")


class DescribeTargetGroupListRequest(AbstractModel):
    r"""DescribeTargetGroupList request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupIds: Target group ID array
        :type TargetGroupIds: list of str
        :param _Filters: Filter array, which is exclusive of `TargetGroupIds`. Valid values: `TargetGroupVpcId` and `TargetGroupName`. Target group ID will be used first.
        :type Filters: list of Filter
        :param _Offset: Starting display offset
        :type Offset: int
        :param _Limit: Limit of the number of displayed results. Default value: 20.
        :type Limit: int
        """
        self._TargetGroupIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def TargetGroupIds(self):
        r"""Target group ID array
        :rtype: list of str
        """
        return self._TargetGroupIds

    @TargetGroupIds.setter
    def TargetGroupIds(self, TargetGroupIds):
        self._TargetGroupIds = TargetGroupIds

    @property
    def Filters(self):
        r"""Filter array, which is exclusive of `TargetGroupIds`. Valid values: `TargetGroupVpcId` and `TargetGroupName`. Target group ID will be used first.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Starting display offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit of the number of displayed results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._TargetGroupIds = params.get("TargetGroupIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTargetGroupListResponse(AbstractModel):
    r"""DescribeTargetGroupList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of displayed results
        :type TotalCount: int
        :param _TargetGroupSet: Information set of displayed target groups
        :type TargetGroupSet: list of TargetGroupInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TargetGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of displayed results
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TargetGroupSet(self):
        r"""Information set of displayed target groups
        :rtype: list of TargetGroupInfo
        """
        return self._TargetGroupSet

    @TargetGroupSet.setter
    def TargetGroupSet(self, TargetGroupSet):
        self._TargetGroupSet = TargetGroupSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TargetGroupSet") is not None:
            self._TargetGroupSet = []
            for item in params.get("TargetGroupSet"):
                obj = TargetGroupInfo()
                obj._deserialize(item)
                self._TargetGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTargetGroupsRequest(AbstractModel):
    r"""DescribeTargetGroups request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupIds: Target group ID, which is exclusive of `Filters`.
        :type TargetGroupIds: list of str
        :param _Limit: Limit of the number of displayed results. Default value: 20.
        :type Limit: int
        :param _Offset: Starting display offset
        :type Offset: int
        :param _Filters: Filter condition array, mutually exclusive with TargetGroupIds, supports TargetGroupVpcId (vpc ID), TargetGroupName (target group name), and Tag.
        :type Filters: list of Filter
        """
        self._TargetGroupIds = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def TargetGroupIds(self):
        r"""Target group ID, which is exclusive of `Filters`.
        :rtype: list of str
        """
        return self._TargetGroupIds

    @TargetGroupIds.setter
    def TargetGroupIds(self, TargetGroupIds):
        self._TargetGroupIds = TargetGroupIds

    @property
    def Limit(self):
        r"""Limit of the number of displayed results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Starting display offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""Filter condition array, mutually exclusive with TargetGroupIds, supports TargetGroupVpcId (vpc ID), TargetGroupName (target group name), and Tag.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._TargetGroupIds = params.get("TargetGroupIds")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTargetGroupsResponse(AbstractModel):
    r"""DescribeTargetGroups response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of displayed results
        :type TotalCount: int
        :param _TargetGroupSet: Information set of displayed target groups
        :type TargetGroupSet: list of TargetGroupInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TargetGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of displayed results
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TargetGroupSet(self):
        r"""Information set of displayed target groups
        :rtype: list of TargetGroupInfo
        """
        return self._TargetGroupSet

    @TargetGroupSet.setter
    def TargetGroupSet(self, TargetGroupSet):
        self._TargetGroupSet = TargetGroupSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TargetGroupSet") is not None:
            self._TargetGroupSet = []
            for item in params.get("TargetGroupSet"):
                obj = TargetGroupInfo()
                obj._deserialize(item)
                self._TargetGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTargetHealthRequest(AbstractModel):
    r"""DescribeTargetHealth request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerIds: List of IDs of CLB instances to be queried
        :type LoadBalancerIds: list of str
        :param _ListenerIds: Specifies the listener ID list to query.
        :type ListenerIds: list of str
        :param _LocationIds: Specifies the list of rule ids to be queried.
        :type LocationIds: list of str
        """
        self._LoadBalancerIds = None
        self._ListenerIds = None
        self._LocationIds = None

    @property
    def LoadBalancerIds(self):
        r"""List of IDs of CLB instances to be queried
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds

    @property
    def ListenerIds(self):
        r"""Specifies the listener ID list to query.
        :rtype: list of str
        """
        return self._ListenerIds

    @ListenerIds.setter
    def ListenerIds(self, ListenerIds):
        self._ListenerIds = ListenerIds

    @property
    def LocationIds(self):
        r"""Specifies the list of rule ids to be queried.
        :rtype: list of str
        """
        return self._LocationIds

    @LocationIds.setter
    def LocationIds(self, LocationIds):
        self._LocationIds = LocationIds


    def _deserialize(self, params):
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        self._ListenerIds = params.get("ListenerIds")
        self._LocationIds = params.get("LocationIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTargetHealthResponse(AbstractModel):
    r"""DescribeTargetHealth response structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancers: LoadBalancer list.
        :type LoadBalancers: list of LoadBalancerHealth
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LoadBalancers = None
        self._RequestId = None

    @property
    def LoadBalancers(self):
        r"""LoadBalancer list.
        :rtype: list of LoadBalancerHealth
        """
        return self._LoadBalancers

    @LoadBalancers.setter
    def LoadBalancers(self, LoadBalancers):
        self._LoadBalancers = LoadBalancers

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LoadBalancers") is not None:
            self._LoadBalancers = []
            for item in params.get("LoadBalancers"):
                obj = LoadBalancerHealth()
                obj._deserialize(item)
                self._LoadBalancers.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTargetsRequest(AbstractModel):
    r"""DescribeTargets request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID.
        :type LoadBalancerId: str
        :param _ListenerIds: List of listener IDs (20 IDs at most).
        :type ListenerIds: list of str
        :param _Protocol: Listener protocol type
        :type Protocol: str
        :param _Port: Listener port
        :type Port: int
        :param _Filters: Conditions for querying the list of real servers bound to the CLB. The filter criteria are as follows:<li> location-id - String - Required: No - (Filter criterion) Filter by rule ID, such as loc-12345678.</li><li> private-ip-address - String - Required: No - (Filter criterion) Filter by private IP address of the real server, such as 172.16.1.1.</li><li> tag - String - Required: No - (Filter criterion) Filter by tag, such as tag-test.</li>
        :type Filters: list of Filter
        """
        self._LoadBalancerId = None
        self._ListenerIds = None
        self._Protocol = None
        self._Port = None
        self._Filters = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerIds(self):
        r"""List of listener IDs (20 IDs at most).
        :rtype: list of str
        """
        return self._ListenerIds

    @ListenerIds.setter
    def ListenerIds(self, ListenerIds):
        self._ListenerIds = ListenerIds

    @property
    def Protocol(self):
        r"""Listener protocol type
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        r"""Listener port
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Filters(self):
        r"""Conditions for querying the list of real servers bound to the CLB. The filter criteria are as follows:<li> location-id - String - Required: No - (Filter criterion) Filter by rule ID, such as loc-12345678.</li><li> private-ip-address - String - Required: No - (Filter criterion) Filter by private IP address of the real server, such as 172.16.1.1.</li><li> tag - String - Required: No - (Filter criterion) Filter by tag, such as tag-test.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerIds = params.get("ListenerIds")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTargetsResponse(AbstractModel):
    r"""DescribeTargets response structure.

    """

    def __init__(self):
        r"""
        :param _Listeners: Information of real servers bound to the listener.
        :type Listeners: list of ListenerBackend
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Listeners = None
        self._RequestId = None

    @property
    def Listeners(self):
        r"""Information of real servers bound to the listener.
        :rtype: list of ListenerBackend
        """
        return self._Listeners

    @Listeners.setter
    def Listeners(self, Listeners):
        self._Listeners = Listeners

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Listeners") is not None:
            self._Listeners = []
            for item in params.get("Listeners"):
                obj = ListenerBackend()
                obj._deserialize(item)
                self._Listeners.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskStatusRequest(AbstractModel):
    r"""DescribeTaskStatus request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Request ID, i.e., the RequestId parameter returned by the API.
        :type TaskId: str
        :param _DealName: Order ID.
Note: Either `TaskId` or `DealName` is required.
        :type DealName: str
        """
        self._TaskId = None
        self._DealName = None

    @property
    def TaskId(self):
        r"""Request ID, i.e., the RequestId parameter returned by the API.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DealName(self):
        r"""Order ID.
Note: Either `TaskId` or `DealName` is required.
        :rtype: str
        """
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._DealName = params.get("DealName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskStatusResponse(AbstractModel):
    r"""DescribeTaskStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Status: Current status of a task. Value range: 0 (succeeded), 1 (failed), 2 (in progress).
        :type Status: int
        :param _LoadBalancerIds: Array of unique CLB instance IDs.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type LoadBalancerIds: list of str
        :param _Message: Auxiliary description information, such as failure cause.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._LoadBalancerIds = None
        self._Message = None
        self._RequestId = None

    @property
    def Status(self):
        r"""Current status of a task. Value range: 0 (succeeded), 1 (failed), 2 (in progress).
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def LoadBalancerIds(self):
        r"""Array of unique CLB instance IDs.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds

    @property
    def Message(self):
        r"""Auxiliary description information, such as failure cause.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        self._Message = params.get("Message")
        self._RequestId = params.get("RequestId")


class DisassociateCustomizedConfigRequest(AbstractModel):
    r"""DisassociateCustomizedConfig request structure.

    """

    def __init__(self):
        r"""
        :param _UconfigId: Configuration ID.
        :type UconfigId: str
        :param _BindList: Specifies the list of unbinding.
        :type BindList: list of BindItem
        """
        self._UconfigId = None
        self._BindList = None

    @property
    def UconfigId(self):
        r"""Configuration ID.
        :rtype: str
        """
        return self._UconfigId

    @UconfigId.setter
    def UconfigId(self, UconfigId):
        self._UconfigId = UconfigId

    @property
    def BindList(self):
        r"""Specifies the list of unbinding.
        :rtype: list of BindItem
        """
        return self._BindList

    @BindList.setter
    def BindList(self, BindList):
        self._BindList = BindList


    def _deserialize(self, params):
        self._UconfigId = params.get("UconfigId")
        if params.get("BindList") is not None:
            self._BindList = []
            for item in params.get("BindList"):
                obj = BindItem()
                obj._deserialize(item)
                self._BindList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateCustomizedConfigResponse(AbstractModel):
    r"""DisassociateCustomizedConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateTargetGroupsRequest(AbstractModel):
    r"""DisassociateTargetGroups request structure.

    """

    def __init__(self):
        r"""
        :param _Associations: Specifies the relationship array of rules to be unbound, supports batch operations for multiple listeners with a maximum of 20 per bulk removal.
        :type Associations: list of TargetGroupAssociation
        """
        self._Associations = None

    @property
    def Associations(self):
        r"""Specifies the relationship array of rules to be unbound, supports batch operations for multiple listeners with a maximum of 20 per bulk removal.
        :rtype: list of TargetGroupAssociation
        """
        return self._Associations

    @Associations.setter
    def Associations(self, Associations):
        self._Associations = Associations


    def _deserialize(self, params):
        if params.get("Associations") is not None:
            self._Associations = []
            for item in params.get("Associations"):
                obj = TargetGroupAssociation()
                obj._deserialize(item)
                self._Associations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateTargetGroupsResponse(AbstractModel):
    r"""DisassociateTargetGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ExclusiveCluster(AbstractModel):
    r"""Dedicated cluster

    """

    def __init__(self):
        r"""
        :param _L4Clusters: Layer-4 dedicated cluster list
Note: this field may return null, indicating that no valid values can be obtained.
        :type L4Clusters: list of ClusterItem
        :param _L7Clusters: Layer-7 dedicated cluster list
Note: this field may return null, indicating that no valid values can be obtained.
        :type L7Clusters: list of ClusterItem
        :param _ClassicalCluster: vpcgw cluster
Note: this field may return null, indicating that no valid values can be obtained.
        :type ClassicalCluster: :class:`tencentcloud.clb.v20180317.models.ClusterItem`
        """
        self._L4Clusters = None
        self._L7Clusters = None
        self._ClassicalCluster = None

    @property
    def L4Clusters(self):
        r"""Layer-4 dedicated cluster list
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of ClusterItem
        """
        return self._L4Clusters

    @L4Clusters.setter
    def L4Clusters(self, L4Clusters):
        self._L4Clusters = L4Clusters

    @property
    def L7Clusters(self):
        r"""Layer-7 dedicated cluster list
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of ClusterItem
        """
        return self._L7Clusters

    @L7Clusters.setter
    def L7Clusters(self, L7Clusters):
        self._L7Clusters = L7Clusters

    @property
    def ClassicalCluster(self):
        r"""vpcgw cluster
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.ClusterItem`
        """
        return self._ClassicalCluster

    @ClassicalCluster.setter
    def ClassicalCluster(self, ClassicalCluster):
        self._ClassicalCluster = ClassicalCluster


    def _deserialize(self, params):
        if params.get("L4Clusters") is not None:
            self._L4Clusters = []
            for item in params.get("L4Clusters"):
                obj = ClusterItem()
                obj._deserialize(item)
                self._L4Clusters.append(obj)
        if params.get("L7Clusters") is not None:
            self._L7Clusters = []
            for item in params.get("L7Clusters"):
                obj = ClusterItem()
                obj._deserialize(item)
                self._L7Clusters.append(obj)
        if params.get("ClassicalCluster") is not None:
            self._ClassicalCluster = ClusterItem()
            self._ClassicalCluster._deserialize(params.get("ClassicalCluster"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExtraInfo(AbstractModel):
    r"""Reserved field which can be ignored generally.

    """

    def __init__(self):
        r"""
        :param _ZhiTong: Whether to enable VIP Direct Connect
        :type ZhiTong: bool
        :param _TgwGroupName: TgwGroup name
        :type TgwGroupName: str
        """
        self._ZhiTong = None
        self._TgwGroupName = None

    @property
    def ZhiTong(self):
        r"""Whether to enable VIP Direct Connect
        :rtype: bool
        """
        return self._ZhiTong

    @ZhiTong.setter
    def ZhiTong(self, ZhiTong):
        self._ZhiTong = ZhiTong

    @property
    def TgwGroupName(self):
        r"""TgwGroup name
        :rtype: str
        """
        return self._TgwGroupName

    @TgwGroupName.setter
    def TgwGroupName(self, TgwGroupName):
        self._TgwGroupName = TgwGroupName


    def _deserialize(self, params):
        self._ZhiTong = params.get("ZhiTong")
        self._TgwGroupName = params.get("TgwGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    r"""Filter

    """

    def __init__(self):
        r"""
        :param _Name: Filter name
        :type Name: str
        :param _Values: Filter value array
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        r"""Filter name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""Filter value array
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FunctionInfo(AbstractModel):
    r"""SCF related information

    """

    def __init__(self):
        r"""
        :param _FunctionNamespace: Function namespace
        :type FunctionNamespace: str
        :param _FunctionName: Function name
        :type FunctionName: str
        :param _FunctionQualifier: Function version name or alias
        :type FunctionQualifier: str
        :param _FunctionQualifierType: Function qualifier type. Values: `VERSION`, `ALIAS`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type FunctionQualifierType: str
        """
        self._FunctionNamespace = None
        self._FunctionName = None
        self._FunctionQualifier = None
        self._FunctionQualifierType = None

    @property
    def FunctionNamespace(self):
        r"""Function namespace
        :rtype: str
        """
        return self._FunctionNamespace

    @FunctionNamespace.setter
    def FunctionNamespace(self, FunctionNamespace):
        self._FunctionNamespace = FunctionNamespace

    @property
    def FunctionName(self):
        r"""Function name
        :rtype: str
        """
        return self._FunctionName

    @FunctionName.setter
    def FunctionName(self, FunctionName):
        self._FunctionName = FunctionName

    @property
    def FunctionQualifier(self):
        r"""Function version name or alias
        :rtype: str
        """
        return self._FunctionQualifier

    @FunctionQualifier.setter
    def FunctionQualifier(self, FunctionQualifier):
        self._FunctionQualifier = FunctionQualifier

    @property
    def FunctionQualifierType(self):
        r"""Function qualifier type. Values: `VERSION`, `ALIAS`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._FunctionQualifierType

    @FunctionQualifierType.setter
    def FunctionQualifierType(self, FunctionQualifierType):
        self._FunctionQualifierType = FunctionQualifierType


    def _deserialize(self, params):
        self._FunctionNamespace = params.get("FunctionNamespace")
        self._FunctionName = params.get("FunctionName")
        self._FunctionQualifier = params.get("FunctionQualifier")
        self._FunctionQualifierType = params.get("FunctionQualifierType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FunctionTarget(AbstractModel):
    r"""Whether to use SCF (Serverless Cloud Function) as the backend service

    """

    def __init__(self):
        r"""
        :param _Function: SCF information
        :type Function: :class:`tencentcloud.clb.v20180317.models.FunctionInfo`
        :param _Weight: Weight
        :type Weight: int
        """
        self._Function = None
        self._Weight = None

    @property
    def Function(self):
        r"""SCF information
        :rtype: :class:`tencentcloud.clb.v20180317.models.FunctionInfo`
        """
        return self._Function

    @Function.setter
    def Function(self, Function):
        self._Function = Function

    @property
    def Weight(self):
        r"""Weight
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        if params.get("Function") is not None:
            self._Function = FunctionInfo()
            self._Function._deserialize(params.get("Function"))
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HealthCheck(AbstractModel):
    r"""Health check information.
    Note: Custom check parameters are currently supported only in certain beta test regions.

    """

    def __init__(self):
        r"""
        :param _HealthSwitch: Whether to enable health check. 1: Enable; 0: Disable.

It is enabled by default.
        :type HealthSwitch: int
        :param _TimeOut: Health check response timeout, in seconds. Value range: 2–60. Default value: 2. The response timeout should be less than the check interval.
        :type TimeOut: int
        :param _IntervalTime: Health check interval, in seconds. Default value: 5. Value range: 2–300 for IPv4 CLB instances and 5–300 for IPv6 CLB instances.
Note: The value range is 5–300 for some IPv4 CLB instances of early versions.
        :type IntervalTime: int
        :param _HealthNum: Healthy threshold. Default: 3, indicating that if a forwarding is found healthy three consecutive times, it is considered to be normal. Value range: 2-10. Unit: times.
        :type HealthNum: int
        :param _UnHealthNum: Unhealthy threshold. Default: 3, indicating that if a forwarding is found unhealthy three consecutive times, it is considered to be exceptional. Value range: 2-10. Unit: times.
        :type UnHealthNum: int
        :param _HttpCode: Health check status code. (This parameter applies only to HTTP/HTTPS forwarding rules and the HTTP health check method of TCP listeners.) Value range: 1–31. Default value: 31.
1: return 1xx after the check (healthy); 2: return 2xx after the check (healthy); 4: return 3xx after the check (healthy); 8: return 4xx after the check (healthy); 16: return 5xx after the check (healthy). If you expect that multiple codes represent a healthy real server, set the value to the sum of the corresponding values.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpCode: int
        :param _HttpCheckPath: Health check path (applicable only to HTTP/HTTPS forwarding rules and HTTP health checks of TCP listeners).

Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpCheckPath: str
        :param _HttpCheckDomain: Health check domain name, which will be contained in a Host header field of the HTTP protocol. (This parameter applies only to HTTP/HTTPS listeners and the HTTP health check method of TCP listeners. For TCP listeners, this parameter is required if the HTTP health check method is used.)
Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpCheckDomain: str
        :param _HttpCheckMethod: Health check method (applicable only to HTTP/HTTPS forwarding rules and HTTP health checks of TCP listeners). Default: HEAD. Valid values: HEAD and GET.

Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpCheckMethod: str
        :param _CheckPort: Custom check parameters. health check port, defaults to the port of the backend service unless you want to specify a specific port, otherwise leave it blank. pass the parameter value -1 to restore default settings. (applicable only to TCP/UDP listener).
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckPort: int
        :param _ContextType: A custom check parameter, which is required if the value of CheckType (health check protocol) is CUSTOM. This parameter represents the input format of the health check. Valid values: HEX and TEXT. If the value is HEX, the characters of SendContext and RecvContext can only be selected from 0123456789ABCDEF and the length must be an even number. (Applicable only to TCP/UDP listeners.)

Note: This field may return null, indicating that no valid values can be obtained.
        :type ContextType: str
        :param _SendContext: A custom check parameter, which is required if the value of CheckType (health check protocol) is CUSTOM. This parameter represents the content of the request sent by the health check. Only ASCII visible characters are allowed, and the maximum length is 500. (Applicable only to TCP/UDP listeners.)

Note: This field may return null, indicating that no valid values can be obtained.
        :type SendContext: str
        :param _RecvContext: A custom check parameter, which is required if the value of CheckType (health check protocol) is CUSTOM. This parameter represents the result returned by the health check. Only ASCII visible characters are allowed, and the maximum length is 500. (Applicable only to TCP/UDP listeners.)

Note: This field may return null, indicating that no valid values can be obtained.
        :type RecvContext: str
        :param _CheckType: Protocol used for health checks. Valid values: TCP (for TCP listeners, TCP_SSL listeners, and QUIC listeners), HTTP (for TCP listeners, TCP_SSL listeners, QUIC listeners, HTTP rules, and HTTPS rules), HTTPS (for HTTPS rules), GRPC (for HTTP rules and HTTPS rules), PING (for UDP listeners), and CUSTOM (for UDP listeners and TCP listeners). The default value is HTTP for HTTP listeners, TCP for TCP, TCP_SSL, and QUIC listeners, and PING for UDP listeners. For HTTPS listeners, the protocol is the same as the backend forwarding protocol.
        :type CheckType: str
        :param _HttpVersion: HTTP version. This field indicates the HTTP version of real servers and is required if the value of CheckType is HTTP. Valid values: HTTP/1.0 and HTTP/1.1. (This field applies only to TCP listeners.)
Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpVersion: str
        :param _SourceIpType: Source IP address type for health checks. 0: use the LB VIP as the source IP address; 1: use an IP address in the 100.64 range as the source IP address.
        :type SourceIpType: int
        :param _ExtendedCode: Health check status code when the protocol is GRPC. (This parameter applies only to rules with the backend forwarding protocol of GRPC.) Default value: 12. You can enter a single numerical value, multiple numerical values, or a range. For example, 20, 20,25, or 0-99.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExtendedCode: str
        """
        self._HealthSwitch = None
        self._TimeOut = None
        self._IntervalTime = None
        self._HealthNum = None
        self._UnHealthNum = None
        self._HttpCode = None
        self._HttpCheckPath = None
        self._HttpCheckDomain = None
        self._HttpCheckMethod = None
        self._CheckPort = None
        self._ContextType = None
        self._SendContext = None
        self._RecvContext = None
        self._CheckType = None
        self._HttpVersion = None
        self._SourceIpType = None
        self._ExtendedCode = None

    @property
    def HealthSwitch(self):
        r"""Whether to enable health check. 1: Enable; 0: Disable.

It is enabled by default.
        :rtype: int
        """
        return self._HealthSwitch

    @HealthSwitch.setter
    def HealthSwitch(self, HealthSwitch):
        self._HealthSwitch = HealthSwitch

    @property
    def TimeOut(self):
        r"""Health check response timeout, in seconds. Value range: 2–60. Default value: 2. The response timeout should be less than the check interval.
        :rtype: int
        """
        return self._TimeOut

    @TimeOut.setter
    def TimeOut(self, TimeOut):
        self._TimeOut = TimeOut

    @property
    def IntervalTime(self):
        r"""Health check interval, in seconds. Default value: 5. Value range: 2–300 for IPv4 CLB instances and 5–300 for IPv6 CLB instances.
Note: The value range is 5–300 for some IPv4 CLB instances of early versions.
        :rtype: int
        """
        return self._IntervalTime

    @IntervalTime.setter
    def IntervalTime(self, IntervalTime):
        self._IntervalTime = IntervalTime

    @property
    def HealthNum(self):
        r"""Healthy threshold. Default: 3, indicating that if a forwarding is found healthy three consecutive times, it is considered to be normal. Value range: 2-10. Unit: times.
        :rtype: int
        """
        return self._HealthNum

    @HealthNum.setter
    def HealthNum(self, HealthNum):
        self._HealthNum = HealthNum

    @property
    def UnHealthNum(self):
        r"""Unhealthy threshold. Default: 3, indicating that if a forwarding is found unhealthy three consecutive times, it is considered to be exceptional. Value range: 2-10. Unit: times.
        :rtype: int
        """
        return self._UnHealthNum

    @UnHealthNum.setter
    def UnHealthNum(self, UnHealthNum):
        self._UnHealthNum = UnHealthNum

    @property
    def HttpCode(self):
        r"""Health check status code. (This parameter applies only to HTTP/HTTPS forwarding rules and the HTTP health check method of TCP listeners.) Value range: 1–31. Default value: 31.
1: return 1xx after the check (healthy); 2: return 2xx after the check (healthy); 4: return 3xx after the check (healthy); 8: return 4xx after the check (healthy); 16: return 5xx after the check (healthy). If you expect that multiple codes represent a healthy real server, set the value to the sum of the corresponding values.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._HttpCode

    @HttpCode.setter
    def HttpCode(self, HttpCode):
        self._HttpCode = HttpCode

    @property
    def HttpCheckPath(self):
        r"""Health check path (applicable only to HTTP/HTTPS forwarding rules and HTTP health checks of TCP listeners).

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HttpCheckPath

    @HttpCheckPath.setter
    def HttpCheckPath(self, HttpCheckPath):
        self._HttpCheckPath = HttpCheckPath

    @property
    def HttpCheckDomain(self):
        r"""Health check domain name, which will be contained in a Host header field of the HTTP protocol. (This parameter applies only to HTTP/HTTPS listeners and the HTTP health check method of TCP listeners. For TCP listeners, this parameter is required if the HTTP health check method is used.)
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HttpCheckDomain

    @HttpCheckDomain.setter
    def HttpCheckDomain(self, HttpCheckDomain):
        self._HttpCheckDomain = HttpCheckDomain

    @property
    def HttpCheckMethod(self):
        r"""Health check method (applicable only to HTTP/HTTPS forwarding rules and HTTP health checks of TCP listeners). Default: HEAD. Valid values: HEAD and GET.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HttpCheckMethod

    @HttpCheckMethod.setter
    def HttpCheckMethod(self, HttpCheckMethod):
        self._HttpCheckMethod = HttpCheckMethod

    @property
    def CheckPort(self):
        r"""Custom check parameters. health check port, defaults to the port of the backend service unless you want to specify a specific port, otherwise leave it blank. pass the parameter value -1 to restore default settings. (applicable only to TCP/UDP listener).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CheckPort

    @CheckPort.setter
    def CheckPort(self, CheckPort):
        self._CheckPort = CheckPort

    @property
    def ContextType(self):
        r"""A custom check parameter, which is required if the value of CheckType (health check protocol) is CUSTOM. This parameter represents the input format of the health check. Valid values: HEX and TEXT. If the value is HEX, the characters of SendContext and RecvContext can only be selected from 0123456789ABCDEF and the length must be an even number. (Applicable only to TCP/UDP listeners.)

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ContextType

    @ContextType.setter
    def ContextType(self, ContextType):
        self._ContextType = ContextType

    @property
    def SendContext(self):
        r"""A custom check parameter, which is required if the value of CheckType (health check protocol) is CUSTOM. This parameter represents the content of the request sent by the health check. Only ASCII visible characters are allowed, and the maximum length is 500. (Applicable only to TCP/UDP listeners.)

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SendContext

    @SendContext.setter
    def SendContext(self, SendContext):
        self._SendContext = SendContext

    @property
    def RecvContext(self):
        r"""A custom check parameter, which is required if the value of CheckType (health check protocol) is CUSTOM. This parameter represents the result returned by the health check. Only ASCII visible characters are allowed, and the maximum length is 500. (Applicable only to TCP/UDP listeners.)

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RecvContext

    @RecvContext.setter
    def RecvContext(self, RecvContext):
        self._RecvContext = RecvContext

    @property
    def CheckType(self):
        r"""Protocol used for health checks. Valid values: TCP (for TCP listeners, TCP_SSL listeners, and QUIC listeners), HTTP (for TCP listeners, TCP_SSL listeners, QUIC listeners, HTTP rules, and HTTPS rules), HTTPS (for HTTPS rules), GRPC (for HTTP rules and HTTPS rules), PING (for UDP listeners), and CUSTOM (for UDP listeners and TCP listeners). The default value is HTTP for HTTP listeners, TCP for TCP, TCP_SSL, and QUIC listeners, and PING for UDP listeners. For HTTPS listeners, the protocol is the same as the backend forwarding protocol.
        :rtype: str
        """
        return self._CheckType

    @CheckType.setter
    def CheckType(self, CheckType):
        self._CheckType = CheckType

    @property
    def HttpVersion(self):
        r"""HTTP version. This field indicates the HTTP version of real servers and is required if the value of CheckType is HTTP. Valid values: HTTP/1.0 and HTTP/1.1. (This field applies only to TCP listeners.)
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HttpVersion

    @HttpVersion.setter
    def HttpVersion(self, HttpVersion):
        self._HttpVersion = HttpVersion

    @property
    def SourceIpType(self):
        r"""Source IP address type for health checks. 0: use the LB VIP as the source IP address; 1: use an IP address in the 100.64 range as the source IP address.
        :rtype: int
        """
        return self._SourceIpType

    @SourceIpType.setter
    def SourceIpType(self, SourceIpType):
        self._SourceIpType = SourceIpType

    @property
    def ExtendedCode(self):
        r"""Health check status code when the protocol is GRPC. (This parameter applies only to rules with the backend forwarding protocol of GRPC.) Default value: 12. You can enter a single numerical value, multiple numerical values, or a range. For example, 20, 20,25, or 0-99.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExtendedCode

    @ExtendedCode.setter
    def ExtendedCode(self, ExtendedCode):
        self._ExtendedCode = ExtendedCode


    def _deserialize(self, params):
        self._HealthSwitch = params.get("HealthSwitch")
        self._TimeOut = params.get("TimeOut")
        self._IntervalTime = params.get("IntervalTime")
        self._HealthNum = params.get("HealthNum")
        self._UnHealthNum = params.get("UnHealthNum")
        self._HttpCode = params.get("HttpCode")
        self._HttpCheckPath = params.get("HttpCheckPath")
        self._HttpCheckDomain = params.get("HttpCheckDomain")
        self._HttpCheckMethod = params.get("HttpCheckMethod")
        self._CheckPort = params.get("CheckPort")
        self._ContextType = params.get("ContextType")
        self._SendContext = params.get("SendContext")
        self._RecvContext = params.get("RecvContext")
        self._CheckType = params.get("CheckType")
        self._HttpVersion = params.get("HttpVersion")
        self._SourceIpType = params.get("SourceIpType")
        self._ExtendedCode = params.get("ExtendedCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IdleLoadBalancer(AbstractModel):
    r"""ID of the idle CLB instance

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _LoadBalancerName: CLB instance name
        :type LoadBalancerName: str
        :param _Region: CLB instance region
        :type Region: str
        :param _Vip: CLB instance VIP
        :type Vip: str
        :param _IdleReason: The reason why the load balancer is considered idle. `NO_RULES`: No rules configured. `NO_RS`: The rules are not associated with servers.
        :type IdleReason: str
        :param _Status: CLB instance status, including:
`0`: Creating; `1`: Running.
        :type Status: int
        :param _Forward: CLB type. Value range: `1` (CLB); `0` (classic CLB).
        :type Forward: int
        :param _Domain: Specifies the clb domain name.
        :type Domain: str
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._Region = None
        self._Vip = None
        self._IdleReason = None
        self._Status = None
        self._Forward = None
        self._Domain = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""CLB instance name
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def Region(self):
        r"""CLB instance region
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Vip(self):
        r"""CLB instance VIP
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def IdleReason(self):
        r"""The reason why the load balancer is considered idle. `NO_RULES`: No rules configured. `NO_RS`: The rules are not associated with servers.
        :rtype: str
        """
        return self._IdleReason

    @IdleReason.setter
    def IdleReason(self, IdleReason):
        self._IdleReason = IdleReason

    @property
    def Status(self):
        r"""CLB instance status, including:
`0`: Creating; `1`: Running.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Forward(self):
        r"""CLB type. Value range: `1` (CLB); `0` (classic CLB).
        :rtype: int
        """
        return self._Forward

    @Forward.setter
    def Forward(self, Forward):
        self._Forward = Forward

    @property
    def Domain(self):
        r"""Specifies the clb domain name.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._Region = params.get("Region")
        self._Vip = params.get("Vip")
        self._IdleReason = params.get("IdleReason")
        self._Status = params.get("Status")
        self._Forward = params.get("Forward")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceCreateLoadBalancerRequest(AbstractModel):
    r"""InquiryPriceCreateLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerType: Network type of the CLB to query. `OPEN`: Public network; `INTERNAL`: Private network is intranet type
        :type LoadBalancerType: str
        :param _LoadBalancerChargeType: The billing mode to query. `POSTPAID`:Pay as you go
        :type LoadBalancerChargeType: str
        :param _LoadBalancerChargePrepaid: Reserved field
        :type LoadBalancerChargePrepaid: :class:`tencentcloud.clb.v20180317.models.LBChargePrepaid`
        :param _InternetAccessible: The network billing mode to query 
        :type InternetAccessible: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        :param _GoodsNum: Number of CLB instances to query. Default value: 1.
        :type GoodsNum: int
        :param _ZoneId: Availability zone in the format of "ap-guangzhou-1"
        :type ZoneId: str
        :param _SlaType: Specification of the LCU-supported instance, which is input to query the monthly subscription price. Valid values: <li>clb.c2.medium: Standard</li><li>clb.c3.small: Advanced 1</li><li>clb.c3.medium: Advanced 2</li><li>clb.c4.small: Super Large 1</li><li>clb.c4.medium: Super Large 2</li><li>clb.c4.large: Super Large 3</li><li>clb.c4.xlarge: Super Large 4</li>SLA is input to query the pay-as-you-go price.
        :type SlaType: str
        :param _AddressIPVersion: IP version. Valid values: `IPV4` (default), `IPV6` (IPV6 NAT64 version) or `IPv6FullChain` (IPv6 version). 
        :type AddressIPVersion: str
        :param _VipIsp: It only applies to public CLB. Currently, the static single-line IP type is supported only for the regions of Guangzhou, Shanghai, Nanjing, Jinan, Hangzhou, Fuzhou, Beijing, Shijiazhuang, Wuhan, Changsha, Chengdu, and Chongqing. If you need to experience it, contact your business manager. After approval, you can select the ISP type as China Mobile (CMCC), China Unicom (CUCC), or China Telecom (CTCC). The network billing mode should be selected as billing by bandwidth package (BANDWIDTH_PACKAGE). If this parameter is not specified, BGP is used by default. You can use the DescribeResources API to query ISPs supported for a region.
        :type VipIsp: str
        """
        self._LoadBalancerType = None
        self._LoadBalancerChargeType = None
        self._LoadBalancerChargePrepaid = None
        self._InternetAccessible = None
        self._GoodsNum = None
        self._ZoneId = None
        self._SlaType = None
        self._AddressIPVersion = None
        self._VipIsp = None

    @property
    def LoadBalancerType(self):
        r"""Network type of the CLB to query. `OPEN`: Public network; `INTERNAL`: Private network is intranet type
        :rtype: str
        """
        return self._LoadBalancerType

    @LoadBalancerType.setter
    def LoadBalancerType(self, LoadBalancerType):
        self._LoadBalancerType = LoadBalancerType

    @property
    def LoadBalancerChargeType(self):
        r"""The billing mode to query. `POSTPAID`:Pay as you go
        :rtype: str
        """
        return self._LoadBalancerChargeType

    @LoadBalancerChargeType.setter
    def LoadBalancerChargeType(self, LoadBalancerChargeType):
        self._LoadBalancerChargeType = LoadBalancerChargeType

    @property
    def LoadBalancerChargePrepaid(self):
        r"""Reserved field
        :rtype: :class:`tencentcloud.clb.v20180317.models.LBChargePrepaid`
        """
        return self._LoadBalancerChargePrepaid

    @LoadBalancerChargePrepaid.setter
    def LoadBalancerChargePrepaid(self, LoadBalancerChargePrepaid):
        self._LoadBalancerChargePrepaid = LoadBalancerChargePrepaid

    @property
    def InternetAccessible(self):
        r"""The network billing mode to query 
        :rtype: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        """
        return self._InternetAccessible

    @InternetAccessible.setter
    def InternetAccessible(self, InternetAccessible):
        self._InternetAccessible = InternetAccessible

    @property
    def GoodsNum(self):
        r"""Number of CLB instances to query. Default value: 1.
        :rtype: int
        """
        return self._GoodsNum

    @GoodsNum.setter
    def GoodsNum(self, GoodsNum):
        self._GoodsNum = GoodsNum

    @property
    def ZoneId(self):
        r"""Availability zone in the format of "ap-guangzhou-1"
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def SlaType(self):
        r"""Specification of the LCU-supported instance, which is input to query the monthly subscription price. Valid values: <li>clb.c2.medium: Standard</li><li>clb.c3.small: Advanced 1</li><li>clb.c3.medium: Advanced 2</li><li>clb.c4.small: Super Large 1</li><li>clb.c4.medium: Super Large 2</li><li>clb.c4.large: Super Large 3</li><li>clb.c4.xlarge: Super Large 4</li>SLA is input to query the pay-as-you-go price.
        :rtype: str
        """
        return self._SlaType

    @SlaType.setter
    def SlaType(self, SlaType):
        self._SlaType = SlaType

    @property
    def AddressIPVersion(self):
        r"""IP version. Valid values: `IPV4` (default), `IPV6` (IPV6 NAT64 version) or `IPv6FullChain` (IPv6 version). 
        :rtype: str
        """
        return self._AddressIPVersion

    @AddressIPVersion.setter
    def AddressIPVersion(self, AddressIPVersion):
        self._AddressIPVersion = AddressIPVersion

    @property
    def VipIsp(self):
        r"""It only applies to public CLB. Currently, the static single-line IP type is supported only for the regions of Guangzhou, Shanghai, Nanjing, Jinan, Hangzhou, Fuzhou, Beijing, Shijiazhuang, Wuhan, Changsha, Chengdu, and Chongqing. If you need to experience it, contact your business manager. After approval, you can select the ISP type as China Mobile (CMCC), China Unicom (CUCC), or China Telecom (CTCC). The network billing mode should be selected as billing by bandwidth package (BANDWIDTH_PACKAGE). If this parameter is not specified, BGP is used by default. You can use the DescribeResources API to query ISPs supported for a region.
        :rtype: str
        """
        return self._VipIsp

    @VipIsp.setter
    def VipIsp(self, VipIsp):
        self._VipIsp = VipIsp


    def _deserialize(self, params):
        self._LoadBalancerType = params.get("LoadBalancerType")
        self._LoadBalancerChargeType = params.get("LoadBalancerChargeType")
        if params.get("LoadBalancerChargePrepaid") is not None:
            self._LoadBalancerChargePrepaid = LBChargePrepaid()
            self._LoadBalancerChargePrepaid._deserialize(params.get("LoadBalancerChargePrepaid"))
        if params.get("InternetAccessible") is not None:
            self._InternetAccessible = InternetAccessible()
            self._InternetAccessible._deserialize(params.get("InternetAccessible"))
        self._GoodsNum = params.get("GoodsNum")
        self._ZoneId = params.get("ZoneId")
        self._SlaType = params.get("SlaType")
        self._AddressIPVersion = params.get("AddressIPVersion")
        self._VipIsp = params.get("VipIsp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceCreateLoadBalancerResponse(AbstractModel):
    r"""InquiryPriceCreateLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _Price: Price of the instance with the specified configurations.
        :type Price: :class:`tencentcloud.clb.v20180317.models.Price`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Price = None
        self._RequestId = None

    @property
    def Price(self):
        r"""Price of the instance with the specified configurations.
        :rtype: :class:`tencentcloud.clb.v20180317.models.Price`
        """
        return self._Price

    @Price.setter
    def Price(self, Price):
        self._Price = Price

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Price") is not None:
            self._Price = Price()
            self._Price._deserialize(params.get("Price"))
        self._RequestId = params.get("RequestId")


class InquiryPriceModifyLoadBalancerRequest(AbstractModel):
    r"""InquiryPriceModifyLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        :param _InternetAccessible: New bandwidth bandwidth specification
        :type InternetAccessible: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        """
        self._LoadBalancerId = None
        self._InternetAccessible = None

    @property
    def LoadBalancerId(self):
        r"""ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def InternetAccessible(self):
        r"""New bandwidth bandwidth specification
        :rtype: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        """
        return self._InternetAccessible

    @InternetAccessible.setter
    def InternetAccessible(self, InternetAccessible):
        self._InternetAccessible = InternetAccessible


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        if params.get("InternetAccessible") is not None:
            self._InternetAccessible = InternetAccessible()
            self._InternetAccessible._deserialize(params.get("InternetAccessible"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceModifyLoadBalancerResponse(AbstractModel):
    r"""InquiryPriceModifyLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _Price: Pricing information
        :type Price: :class:`tencentcloud.clb.v20180317.models.Price`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Price = None
        self._RequestId = None

    @property
    def Price(self):
        r"""Pricing information
        :rtype: :class:`tencentcloud.clb.v20180317.models.Price`
        """
        return self._Price

    @Price.setter
    def Price(self, Price):
        self._Price = Price

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Price") is not None:
            self._Price = Price()
            self._Price._deserialize(params.get("Price"))
        self._RequestId = params.get("RequestId")


class InquiryPriceRefundLoadBalancerRequest(AbstractModel):
    r"""InquiryPriceRefundLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        """
        self._LoadBalancerId = None

    @property
    def LoadBalancerId(self):
        r"""ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceRefundLoadBalancerResponse(AbstractModel):
    r"""InquiryPriceRefundLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _Price: Price of the instance with the specified configurations.
        :type Price: :class:`tencentcloud.clb.v20180317.models.Price`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Price = None
        self._RequestId = None

    @property
    def Price(self):
        r"""Price of the instance with the specified configurations.
        :rtype: :class:`tencentcloud.clb.v20180317.models.Price`
        """
        return self._Price

    @Price.setter
    def Price(self, Price):
        self._Price = Price

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Price") is not None:
            self._Price = Price()
            self._Price._deserialize(params.get("Price"))
        self._RequestId = params.get("RequestId")


class InquiryPriceRenewLoadBalancerRequest(AbstractModel):
    r"""InquiryPriceRenewLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        :param _LoadBalancerChargePrepaid: Renewal period
        :type LoadBalancerChargePrepaid: :class:`tencentcloud.clb.v20180317.models.LBChargePrepaid`
        """
        self._LoadBalancerId = None
        self._LoadBalancerChargePrepaid = None

    @property
    def LoadBalancerId(self):
        r"""ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerChargePrepaid(self):
        r"""Renewal period
        :rtype: :class:`tencentcloud.clb.v20180317.models.LBChargePrepaid`
        """
        return self._LoadBalancerChargePrepaid

    @LoadBalancerChargePrepaid.setter
    def LoadBalancerChargePrepaid(self, LoadBalancerChargePrepaid):
        self._LoadBalancerChargePrepaid = LoadBalancerChargePrepaid


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        if params.get("LoadBalancerChargePrepaid") is not None:
            self._LoadBalancerChargePrepaid = LBChargePrepaid()
            self._LoadBalancerChargePrepaid._deserialize(params.get("LoadBalancerChargePrepaid"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceRenewLoadBalancerResponse(AbstractModel):
    r"""InquiryPriceRenewLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _Price: Price to renew
        :type Price: :class:`tencentcloud.clb.v20180317.models.Price`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Price = None
        self._RequestId = None

    @property
    def Price(self):
        r"""Price to renew
        :rtype: :class:`tencentcloud.clb.v20180317.models.Price`
        """
        return self._Price

    @Price.setter
    def Price(self, Price):
        self._Price = Price

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Price") is not None:
            self._Price = Price()
            self._Price._deserialize(params.get("Price"))
        self._RequestId = params.get("RequestId")


class InternetAccessible(AbstractModel):
    r"""Network billing mode based on maximum outbound bandwidth

    """

    def __init__(self):
        r"""
        :param _InternetChargeType: TRAFFIC_POSTPAID_BY_HOUR: Postpaid by traffic on an hourly basis. BANDWIDTH_POSTPAID_BY_HOUR: Postpaid by bandwidth on an hourly basis. International site users do not support this billing mode. BANDWIDTH_PACKAGE: Charged by bandwidth package. BANDWIDTH_PREPAID: Bandwidth prepaid.
        :type InternetChargeType: str
        :param _InternetMaxBandwidthOut: Maximum outbound bandwidth, in Mbps. This parameter is valid only for public network shared, LCU-supported, and exclusive CLB instances and private network LCU-supported CLB instances.
- The range of the maximum outbound bandwidth for public network shared and exclusive CLB instances is 1 Mbps to 2,048 Mbps.
- The range of the maximum outbound bandwidth for public network and private network LCU-supported CLB instances is 1 Mbps to 61,440 Mbps.
(If this parameter is not specified when CreateLoadBalancer is called to create a CLB instance, the default value of 10 Mbps is used. This value can be modified.)
        :type InternetMaxBandwidthOut: int
        :param _BandwidthpkgSubType: Bandwidth package type, for example BGP (multi-line).
Type as follows:.
SINGLEISP: single isp.
BGP: multi-line.
HIGH_QUALITY_BGP: specifies a dedicated bgp bandwidth package.
SINGLEISP_CMCC: specifies a cmcc bandwidth package.
SINGLEISP_CTCC: specifies the ctcc bandwidth package.
SINGLEISP_CUCC: specifies the china unicom bandwidth package.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BandwidthpkgSubType: str
        """
        self._InternetChargeType = None
        self._InternetMaxBandwidthOut = None
        self._BandwidthpkgSubType = None

    @property
    def InternetChargeType(self):
        r"""TRAFFIC_POSTPAID_BY_HOUR: Postpaid by traffic on an hourly basis. BANDWIDTH_POSTPAID_BY_HOUR: Postpaid by bandwidth on an hourly basis. International site users do not support this billing mode. BANDWIDTH_PACKAGE: Charged by bandwidth package. BANDWIDTH_PREPAID: Bandwidth prepaid.
        :rtype: str
        """
        return self._InternetChargeType

    @InternetChargeType.setter
    def InternetChargeType(self, InternetChargeType):
        self._InternetChargeType = InternetChargeType

    @property
    def InternetMaxBandwidthOut(self):
        r"""Maximum outbound bandwidth, in Mbps. This parameter is valid only for public network shared, LCU-supported, and exclusive CLB instances and private network LCU-supported CLB instances.
- The range of the maximum outbound bandwidth for public network shared and exclusive CLB instances is 1 Mbps to 2,048 Mbps.
- The range of the maximum outbound bandwidth for public network and private network LCU-supported CLB instances is 1 Mbps to 61,440 Mbps.
(If this parameter is not specified when CreateLoadBalancer is called to create a CLB instance, the default value of 10 Mbps is used. This value can be modified.)
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def BandwidthpkgSubType(self):
        r"""Bandwidth package type, for example BGP (multi-line).
Type as follows:.
SINGLEISP: single isp.
BGP: multi-line.
HIGH_QUALITY_BGP: specifies a dedicated bgp bandwidth package.
SINGLEISP_CMCC: specifies a cmcc bandwidth package.
SINGLEISP_CTCC: specifies the ctcc bandwidth package.
SINGLEISP_CUCC: specifies the china unicom bandwidth package.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._BandwidthpkgSubType

    @BandwidthpkgSubType.setter
    def BandwidthpkgSubType(self, BandwidthpkgSubType):
        self._BandwidthpkgSubType = BandwidthpkgSubType


    def _deserialize(self, params):
        self._InternetChargeType = params.get("InternetChargeType")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._BandwidthpkgSubType = params.get("BandwidthpkgSubType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ItemPrice(AbstractModel):
    r"""Pricing information of an item

    """

    def __init__(self):
        r"""
        :param _UnitPrice: PAYG unit price, in USD.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type UnitPrice: float
        :param _ChargeUnit: Subsequent billing unit. Value Range: 
`HOUR`: Calculate the cost by hour. It's available when "InternetChargeType=POSTPAID_BY_HOUR".
`GB`: Calculate the cost by traffic in GB. It's available when "InternetChargeType=TRAFFIC_POSTPAID_BY_HOUR".
Note: This field may return·null, indicating that no valid values can be obtained.
        :type ChargeUnit: str
        :param _OriginalPrice: Reserved field
Note: This field may return·null, indicating that no valid values can be obtained.
        :type OriginalPrice: float
        :param _DiscountPrice: Reserved field
Note: This field may return·null, indicating that no valid values can be obtained.
        :type DiscountPrice: float
        :param _UnitPriceDiscount: Discount unit price of a pay-as-you-go instance, in USD.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type UnitPriceDiscount: float
        :param _Discount: Discount. For example, 20.0 indicates 80% off.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Discount: float
        """
        self._UnitPrice = None
        self._ChargeUnit = None
        self._OriginalPrice = None
        self._DiscountPrice = None
        self._UnitPriceDiscount = None
        self._Discount = None

    @property
    def UnitPrice(self):
        r"""PAYG unit price, in USD.
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._UnitPrice

    @UnitPrice.setter
    def UnitPrice(self, UnitPrice):
        self._UnitPrice = UnitPrice

    @property
    def ChargeUnit(self):
        r"""Subsequent billing unit. Value Range: 
`HOUR`: Calculate the cost by hour. It's available when "InternetChargeType=POSTPAID_BY_HOUR".
`GB`: Calculate the cost by traffic in GB. It's available when "InternetChargeType=TRAFFIC_POSTPAID_BY_HOUR".
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ChargeUnit

    @ChargeUnit.setter
    def ChargeUnit(self, ChargeUnit):
        self._ChargeUnit = ChargeUnit

    @property
    def OriginalPrice(self):
        r"""Reserved field
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._OriginalPrice

    @OriginalPrice.setter
    def OriginalPrice(self, OriginalPrice):
        self._OriginalPrice = OriginalPrice

    @property
    def DiscountPrice(self):
        r"""Reserved field
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._DiscountPrice

    @DiscountPrice.setter
    def DiscountPrice(self, DiscountPrice):
        self._DiscountPrice = DiscountPrice

    @property
    def UnitPriceDiscount(self):
        r"""Discount unit price of a pay-as-you-go instance, in USD.
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._UnitPriceDiscount

    @UnitPriceDiscount.setter
    def UnitPriceDiscount(self, UnitPriceDiscount):
        self._UnitPriceDiscount = UnitPriceDiscount

    @property
    def Discount(self):
        r"""Discount. For example, 20.0 indicates 80% off.
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._Discount

    @Discount.setter
    def Discount(self, Discount):
        self._Discount = Discount


    def _deserialize(self, params):
        self._UnitPrice = params.get("UnitPrice")
        self._ChargeUnit = params.get("ChargeUnit")
        self._OriginalPrice = params.get("OriginalPrice")
        self._DiscountPrice = params.get("DiscountPrice")
        self._UnitPriceDiscount = params.get("UnitPriceDiscount")
        self._Discount = params.get("Discount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LBChargePrepaid(AbstractModel):
    r"""Monthly subscription configuration of a CLB instance

    """

    def __init__(self):
        r"""
        :param _RenewFlag: Reserved field.
        :type RenewFlag: str
        :param _Period: Reserved field.
        :type Period: int
        """
        self._RenewFlag = None
        self._Period = None

    @property
    def RenewFlag(self):
        r"""Reserved field.
        :rtype: str
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def Period(self):
        r"""Reserved field.
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period


    def _deserialize(self, params):
        self._RenewFlag = params.get("RenewFlag")
        self._Period = params.get("Period")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LBItem(AbstractModel):
    r"""Querying the binding relation of the CLB instance

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: String ID of the CLB instance.
        :type LoadBalancerId: str
        :param _Vip: VIP of the CLB instance.
        :type Vip: str
        :param _Listeners: Listener rule.
        :type Listeners: list of ListenerItem
        :param _Region: Region of the CLB instance
        :type Region: str
        """
        self._LoadBalancerId = None
        self._Vip = None
        self._Listeners = None
        self._Region = None

    @property
    def LoadBalancerId(self):
        r"""String ID of the CLB instance.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def Vip(self):
        r"""VIP of the CLB instance.
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Listeners(self):
        r"""Listener rule.
        :rtype: list of ListenerItem
        """
        return self._Listeners

    @Listeners.setter
    def Listeners(self, Listeners):
        self._Listeners = Listeners

    @property
    def Region(self):
        r"""Region of the CLB instance
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._Vip = params.get("Vip")
        if params.get("Listeners") is not None:
            self._Listeners = []
            for item in params.get("Listeners"):
                obj = ListenerItem()
                obj._deserialize(item)
                self._Listeners.append(obj)
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LBOperateProtectInfo(AbstractModel):
    r"""Operation protection information of cloud load balancer.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID.
        :type LoadBalancerId: str
        :param _ProtectState: Protected status. true means operation protection is enabled. false means operation protection is disabled.
        :type ProtectState: bool
        :param _OperatorUin: Specifies the uin for operation protection setting.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OperatorUin: str
        :param _Description: Specifies the description when setting operation protection.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _ModifyTime: Specifies the last modification time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifyTime: str
        """
        self._LoadBalancerId = None
        self._ProtectState = None
        self._OperatorUin = None
        self._Description = None
        self._ModifyTime = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ProtectState(self):
        r"""Protected status. true means operation protection is enabled. false means operation protection is disabled.
        :rtype: bool
        """
        return self._ProtectState

    @ProtectState.setter
    def ProtectState(self, ProtectState):
        self._ProtectState = ProtectState

    @property
    def OperatorUin(self):
        r"""Specifies the uin for operation protection setting.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._OperatorUin

    @OperatorUin.setter
    def OperatorUin(self, OperatorUin):
        self._OperatorUin = OperatorUin

    @property
    def Description(self):
        r"""Specifies the description when setting operation protection.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ModifyTime(self):
        r"""Specifies the last modification time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ProtectState = params.get("ProtectState")
        self._OperatorUin = params.get("OperatorUin")
        self._Description = params.get("Description")
        self._ModifyTime = params.get("ModifyTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LbRsItem(AbstractModel):
    r"""Querying the input data types

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC ID in string format. Only string format is supported.
Can be queried through the [DescribeVpcs](https://www.tencentcloud.comom/document/api/215/15778?from_cn_redirect=1) api.
        :type VpcId: str
        :param _PrivateIp: Specifies the private IP address for backend querying, which can be CVM or eni.
Can be queried through the [DescribeAddresses](https://www.tencentcloud.comom/document/product/215/16702?from_cn_redirect=1) api.
        :type PrivateIp: str
        """
        self._VpcId = None
        self._PrivateIp = None

    @property
    def VpcId(self):
        r"""VPC ID in string format. Only string format is supported.
Can be queried through the [DescribeVpcs](https://www.tencentcloud.comom/document/api/215/15778?from_cn_redirect=1) api.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def PrivateIp(self):
        r"""Specifies the private IP address for backend querying, which can be CVM or eni.
Can be queried through the [DescribeAddresses](https://www.tencentcloud.comom/document/product/215/16702?from_cn_redirect=1) api.
        :rtype: str
        """
        return self._PrivateIp

    @PrivateIp.setter
    def PrivateIp(self, PrivateIp):
        self._PrivateIp = PrivateIp


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._PrivateIp = params.get("PrivateIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LbRsTargets(AbstractModel):
    r"""Querying the output data types

    """

    def __init__(self):
        r"""
        :param _Type: Private network IP type, which can be `cvm` or `eni`.
        :type Type: str
        :param _PrivateIp: Private network IP of the real server.
        :type PrivateIp: str
        :param _Port: Port bound to the real server.
        :type Port: int
        :param _VpcId: vpcId of RS
        :type VpcId: int
        :param _Weight: RS weight
        :type Weight: int
        """
        self._Type = None
        self._PrivateIp = None
        self._Port = None
        self._VpcId = None
        self._Weight = None

    @property
    def Type(self):
        r"""Private network IP type, which can be `cvm` or `eni`.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PrivateIp(self):
        r"""Private network IP of the real server.
        :rtype: str
        """
        return self._PrivateIp

    @PrivateIp.setter
    def PrivateIp(self, PrivateIp):
        self._PrivateIp = PrivateIp

    @property
    def Port(self):
        r"""Port bound to the real server.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def VpcId(self):
        r"""vpcId of RS
        :rtype: int
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Weight(self):
        r"""RS weight
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._PrivateIp = params.get("PrivateIp")
        self._Port = params.get("Port")
        self._VpcId = params.get("VpcId")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Listener(AbstractModel):
    r"""Listener information

    """

    def __init__(self):
        r"""
        :param _ListenerId: CLB listener ID
        :type ListenerId: str
        :param _Protocol: Listener protocol. valid values: TCP, UDP, HTTP, HTTPS, TCP_SSL, QUIC.
        :type Protocol: str
        :param _Port: Listener port. value range: 1-65535.
        :type Port: int
        :param _Certificate: Information of certificates bound to the listener
Note: This field may return null, indicating that no valid values can be obtained.
        :type Certificate: :class:`tencentcloud.clb.v20180317.models.CertificateOutput`
        :param _HealthCheck: Health check information of the listener
Note: This field may return null, indicating that no valid values can be obtained.
        :type HealthCheck: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        :param _Scheduler: Request scheduling method. WRR, LEAST_CONN, and IP_HASH respectively indicate weighted round robin, least connections, and IP hash.Note: This field may return null, indicating that no valid values can be obtained.
        :type Scheduler: str
        :param _SessionExpireTime: Session persistence time, in seconds. value range: 30-3600. default value: 0, indicating that session persistence is not enabled by default. this parameter applies only to TCP and UDP listeners.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SessionExpireTime: int
        :param _SniSwitch: Specifies whether to enable the SNI feature. 1: enable; 0: disable. this parameter is applicable only to HTTPS listeners.
        :type SniSwitch: int
        :param _Rules: All forwarding rules under a listener (this parameter is meaningful only for HTTP/HTTPS listeners)
Note: This field may return null, indicating that no valid values can be obtained.
        :type Rules: list of RuleOutput
        :param _ListenerName: Listener name
        :type ListenerName: str
        :param _CreateTime: Listener creation time
        :type CreateTime: str
        :param _EndPort: End port of the port range. value range: 2-65535.
        :type EndPort: int
        :param _TargetType: Backend server type. available values: NODE, POLARIS, TARGETGROUP, TARGETGROUP-V2.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TargetType: str
        :param _TargetGroup: Basic information of a bound target group. This field will be returned when a target group is bound to a listener.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TargetGroup: :class:`tencentcloud.clb.v20180317.models.BasicTargetGroupInfo`
        :param _SessionType: Session persistence type. NORMAL: Default session persistence type; QUIC_CID: Session persistence by Quic Connection ID.
        :type SessionType: str
        :param _KeepaliveEnable: Whether a persistent connection is enabled (1: enabled; 0: disabled). This parameter can only be configured in HTTP/HTTPS listeners.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type KeepaliveEnable: int
        :param _Toa: Supports Nat64 CLB TCP listeners only
        :type Toa: bool
        :param _DeregisterTargetRst: Reschedules when unbinding real servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :type DeregisterTargetRst: bool
        :param _AttrFlags: Describes the attributes of the listener.
        :type AttrFlags: list of str
        :param _TargetGroupList: List of bound target groups
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TargetGroupList: list of BasicTargetGroupInfo
        :param _MaxConn: Maximum number of connections to a listener. -1 indicates unlimited speed at the listener dimension.
        :type MaxConn: int
        :param _MaxCps: Maximum number of new connections to a listener. -1 means no speed limit at the listener dimension.
        :type MaxCps: int
        :param _IdleConnectTimeout: Connection idle timeout period (in seconds). It’s only available to TCP listeners. Value range: 300-900 for shared and dedicated instances; 300-2000 for LCU-supported CLB instances. It defaults to 900.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type IdleConnectTimeout: int
        :param _RescheduleInterval: Rescheduling trigger duration, valid values: 0-3600s. only TCP/UDP listeners support this. after triggering rescheduling, persistent connections will disconnect and be reassigned within the set scheduling time.
        :type RescheduleInterval: int
        :param _DataCompressMode: Data compression mode.
        :type DataCompressMode: str
        :param _RescheduleStartTime: Reschedules the startup time. when configured, rescheduling will be triggered upon arrival of the start time.
        :type RescheduleStartTime: int
        """
        self._ListenerId = None
        self._Protocol = None
        self._Port = None
        self._Certificate = None
        self._HealthCheck = None
        self._Scheduler = None
        self._SessionExpireTime = None
        self._SniSwitch = None
        self._Rules = None
        self._ListenerName = None
        self._CreateTime = None
        self._EndPort = None
        self._TargetType = None
        self._TargetGroup = None
        self._SessionType = None
        self._KeepaliveEnable = None
        self._Toa = None
        self._DeregisterTargetRst = None
        self._AttrFlags = None
        self._TargetGroupList = None
        self._MaxConn = None
        self._MaxCps = None
        self._IdleConnectTimeout = None
        self._RescheduleInterval = None
        self._DataCompressMode = None
        self._RescheduleStartTime = None

    @property
    def ListenerId(self):
        r"""CLB listener ID
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Protocol(self):
        r"""Listener protocol. valid values: TCP, UDP, HTTP, HTTPS, TCP_SSL, QUIC.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        r"""Listener port. value range: 1-65535.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Certificate(self):
        r"""Information of certificates bound to the listener
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.CertificateOutput`
        """
        return self._Certificate

    @Certificate.setter
    def Certificate(self, Certificate):
        self._Certificate = Certificate

    @property
    def HealthCheck(self):
        r"""Health check information of the listener
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def Scheduler(self):
        r"""Request scheduling method. WRR, LEAST_CONN, and IP_HASH respectively indicate weighted round robin, least connections, and IP hash.Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Scheduler

    @Scheduler.setter
    def Scheduler(self, Scheduler):
        self._Scheduler = Scheduler

    @property
    def SessionExpireTime(self):
        r"""Session persistence time, in seconds. value range: 30-3600. default value: 0, indicating that session persistence is not enabled by default. this parameter applies only to TCP and UDP listeners.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SessionExpireTime

    @SessionExpireTime.setter
    def SessionExpireTime(self, SessionExpireTime):
        self._SessionExpireTime = SessionExpireTime

    @property
    def SniSwitch(self):
        r"""Specifies whether to enable the SNI feature. 1: enable; 0: disable. this parameter is applicable only to HTTPS listeners.
        :rtype: int
        """
        return self._SniSwitch

    @SniSwitch.setter
    def SniSwitch(self, SniSwitch):
        self._SniSwitch = SniSwitch

    @property
    def Rules(self):
        r"""All forwarding rules under a listener (this parameter is meaningful only for HTTP/HTTPS listeners)
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of RuleOutput
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def ListenerName(self):
        r"""Listener name
        :rtype: str
        """
        return self._ListenerName

    @ListenerName.setter
    def ListenerName(self, ListenerName):
        self._ListenerName = ListenerName

    @property
    def CreateTime(self):
        r"""Listener creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def EndPort(self):
        r"""End port of the port range. value range: 2-65535.
        :rtype: int
        """
        return self._EndPort

    @EndPort.setter
    def EndPort(self, EndPort):
        self._EndPort = EndPort

    @property
    def TargetType(self):
        r"""Backend server type. available values: NODE, POLARIS, TARGETGROUP, TARGETGROUP-V2.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetGroup(self):
        r"""Basic information of a bound target group. This field will be returned when a target group is bound to a listener.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.BasicTargetGroupInfo`
        """
        return self._TargetGroup

    @TargetGroup.setter
    def TargetGroup(self, TargetGroup):
        self._TargetGroup = TargetGroup

    @property
    def SessionType(self):
        r"""Session persistence type. NORMAL: Default session persistence type; QUIC_CID: Session persistence by Quic Connection ID.
        :rtype: str
        """
        return self._SessionType

    @SessionType.setter
    def SessionType(self, SessionType):
        self._SessionType = SessionType

    @property
    def KeepaliveEnable(self):
        r"""Whether a persistent connection is enabled (1: enabled; 0: disabled). This parameter can only be configured in HTTP/HTTPS listeners.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._KeepaliveEnable

    @KeepaliveEnable.setter
    def KeepaliveEnable(self, KeepaliveEnable):
        self._KeepaliveEnable = KeepaliveEnable

    @property
    def Toa(self):
        r"""Supports Nat64 CLB TCP listeners only
        :rtype: bool
        """
        return self._Toa

    @Toa.setter
    def Toa(self, Toa):
        self._Toa = Toa

    @property
    def DeregisterTargetRst(self):
        r"""Reschedules when unbinding real servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :rtype: bool
        """
        return self._DeregisterTargetRst

    @DeregisterTargetRst.setter
    def DeregisterTargetRst(self, DeregisterTargetRst):
        self._DeregisterTargetRst = DeregisterTargetRst

    @property
    def AttrFlags(self):
        r"""Describes the attributes of the listener.
        :rtype: list of str
        """
        return self._AttrFlags

    @AttrFlags.setter
    def AttrFlags(self, AttrFlags):
        self._AttrFlags = AttrFlags

    @property
    def TargetGroupList(self):
        r"""List of bound target groups
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of BasicTargetGroupInfo
        """
        return self._TargetGroupList

    @TargetGroupList.setter
    def TargetGroupList(self, TargetGroupList):
        self._TargetGroupList = TargetGroupList

    @property
    def MaxConn(self):
        r"""Maximum number of connections to a listener. -1 indicates unlimited speed at the listener dimension.
        :rtype: int
        """
        return self._MaxConn

    @MaxConn.setter
    def MaxConn(self, MaxConn):
        self._MaxConn = MaxConn

    @property
    def MaxCps(self):
        r"""Maximum number of new connections to a listener. -1 means no speed limit at the listener dimension.
        :rtype: int
        """
        return self._MaxCps

    @MaxCps.setter
    def MaxCps(self, MaxCps):
        self._MaxCps = MaxCps

    @property
    def IdleConnectTimeout(self):
        r"""Connection idle timeout period (in seconds). It’s only available to TCP listeners. Value range: 300-900 for shared and dedicated instances; 300-2000 for LCU-supported CLB instances. It defaults to 900.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IdleConnectTimeout

    @IdleConnectTimeout.setter
    def IdleConnectTimeout(self, IdleConnectTimeout):
        self._IdleConnectTimeout = IdleConnectTimeout

    @property
    def RescheduleInterval(self):
        r"""Rescheduling trigger duration, valid values: 0-3600s. only TCP/UDP listeners support this. after triggering rescheduling, persistent connections will disconnect and be reassigned within the set scheduling time.
        :rtype: int
        """
        return self._RescheduleInterval

    @RescheduleInterval.setter
    def RescheduleInterval(self, RescheduleInterval):
        self._RescheduleInterval = RescheduleInterval

    @property
    def DataCompressMode(self):
        r"""Data compression mode.
        :rtype: str
        """
        return self._DataCompressMode

    @DataCompressMode.setter
    def DataCompressMode(self, DataCompressMode):
        self._DataCompressMode = DataCompressMode

    @property
    def RescheduleStartTime(self):
        r"""Reschedules the startup time. when configured, rescheduling will be triggered upon arrival of the start time.
        :rtype: int
        """
        return self._RescheduleStartTime

    @RescheduleStartTime.setter
    def RescheduleStartTime(self, RescheduleStartTime):
        self._RescheduleStartTime = RescheduleStartTime


    def _deserialize(self, params):
        self._ListenerId = params.get("ListenerId")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        if params.get("Certificate") is not None:
            self._Certificate = CertificateOutput()
            self._Certificate._deserialize(params.get("Certificate"))
        if params.get("HealthCheck") is not None:
            self._HealthCheck = HealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        self._Scheduler = params.get("Scheduler")
        self._SessionExpireTime = params.get("SessionExpireTime")
        self._SniSwitch = params.get("SniSwitch")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleOutput()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._ListenerName = params.get("ListenerName")
        self._CreateTime = params.get("CreateTime")
        self._EndPort = params.get("EndPort")
        self._TargetType = params.get("TargetType")
        if params.get("TargetGroup") is not None:
            self._TargetGroup = BasicTargetGroupInfo()
            self._TargetGroup._deserialize(params.get("TargetGroup"))
        self._SessionType = params.get("SessionType")
        self._KeepaliveEnable = params.get("KeepaliveEnable")
        self._Toa = params.get("Toa")
        self._DeregisterTargetRst = params.get("DeregisterTargetRst")
        self._AttrFlags = params.get("AttrFlags")
        if params.get("TargetGroupList") is not None:
            self._TargetGroupList = []
            for item in params.get("TargetGroupList"):
                obj = BasicTargetGroupInfo()
                obj._deserialize(item)
                self._TargetGroupList.append(obj)
        self._MaxConn = params.get("MaxConn")
        self._MaxCps = params.get("MaxCps")
        self._IdleConnectTimeout = params.get("IdleConnectTimeout")
        self._RescheduleInterval = params.get("RescheduleInterval")
        self._DataCompressMode = params.get("DataCompressMode")
        self._RescheduleStartTime = params.get("RescheduleStartTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListenerBackend(AbstractModel):
    r"""Details of real servers bound to a listener

    """

    def __init__(self):
        r"""
        :param _ListenerId: Listener ID
        :type ListenerId: str
        :param _Protocol: Listener protocol
        :type Protocol: str
        :param _Port: Listener port
        :type Port: int
        :param _Rules: Information of rules under a listener (applicable only to HTTP/HTTPS listeners)
        :type Rules: list of RuleTargets
        :param _Targets: List of real servers bound to the listener (applicable only to TCP/UDP/TCP_SSL listener)
        :type Targets: list of Backend
        :param _EndPort: End port in a port range if port range is supported, or 0 if port range is not supported
        :type EndPort: int
        """
        self._ListenerId = None
        self._Protocol = None
        self._Port = None
        self._Rules = None
        self._Targets = None
        self._EndPort = None

    @property
    def ListenerId(self):
        r"""Listener ID
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Protocol(self):
        r"""Listener protocol
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        r"""Listener port
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Rules(self):
        r"""Information of rules under a listener (applicable only to HTTP/HTTPS listeners)
        :rtype: list of RuleTargets
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def Targets(self):
        r"""List of real servers bound to the listener (applicable only to TCP/UDP/TCP_SSL listener)
        :rtype: list of Backend
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def EndPort(self):
        r"""End port in a port range if port range is supported, or 0 if port range is not supported
        :rtype: int
        """
        return self._EndPort

    @EndPort.setter
    def EndPort(self, EndPort):
        self._EndPort = EndPort


    def _deserialize(self, params):
        self._ListenerId = params.get("ListenerId")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleTargets()
                obj._deserialize(item)
                self._Rules.append(obj)
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = Backend()
                obj._deserialize(item)
                self._Targets.append(obj)
        self._EndPort = params.get("EndPort")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListenerHealth(AbstractModel):
    r"""Health check information of the listener

    """

    def __init__(self):
        r"""
        :param _ListenerId: Listener ID
        :type ListenerId: str
        :param _ListenerName: Listener name.
        :type ListenerName: str
        :param _Protocol: Listener protocol
        :type Protocol: str
        :param _Port: Listener port
        :type Port: int
        :param _Rules: List of forwarding rules of the listener
        :type Rules: list of RuleHealth
        """
        self._ListenerId = None
        self._ListenerName = None
        self._Protocol = None
        self._Port = None
        self._Rules = None

    @property
    def ListenerId(self):
        r"""Listener ID
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def ListenerName(self):
        r"""Listener name.
        :rtype: str
        """
        return self._ListenerName

    @ListenerName.setter
    def ListenerName(self, ListenerName):
        self._ListenerName = ListenerName

    @property
    def Protocol(self):
        r"""Listener protocol
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        r"""Listener port
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Rules(self):
        r"""List of forwarding rules of the listener
        :rtype: list of RuleHealth
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules


    def _deserialize(self, params):
        self._ListenerId = params.get("ListenerId")
        self._ListenerName = params.get("ListenerName")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleHealth()
                obj._deserialize(item)
                self._Rules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListenerItem(AbstractModel):
    r"""Querying the listener type

    """

    def __init__(self):
        r"""
        :param _ListenerId: Listener ID.
        :type ListenerId: str
        :param _Protocol: Listener protocol.
        :type Protocol: str
        :param _Port: Listener port.
        :type Port: int
        :param _Rules: Bound rule.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Rules: list of RulesItems
        :param _Targets: Object bound to the layer-4 listener.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Targets: list of LbRsTargets
        :param _EndPort: End port of a port range for a listener
        :type EndPort: int
        """
        self._ListenerId = None
        self._Protocol = None
        self._Port = None
        self._Rules = None
        self._Targets = None
        self._EndPort = None

    @property
    def ListenerId(self):
        r"""Listener ID.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Protocol(self):
        r"""Listener protocol.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        r"""Listener port.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Rules(self):
        r"""Bound rule.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of RulesItems
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def Targets(self):
        r"""Object bound to the layer-4 listener.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of LbRsTargets
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def EndPort(self):
        r"""End port of a port range for a listener
        :rtype: int
        """
        return self._EndPort

    @EndPort.setter
    def EndPort(self, EndPort):
        self._EndPort = EndPort


    def _deserialize(self, params):
        self._ListenerId = params.get("ListenerId")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RulesItems()
                obj._deserialize(item)
                self._Rules.append(obj)
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = LbRsTargets()
                obj._deserialize(item)
                self._Targets.append(obj)
        self._EndPort = params.get("EndPort")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadBalancer(AbstractModel):
    r"""CLB instance information

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID.
        :type LoadBalancerId: str
        :param _LoadBalancerName: CLB instance name.
        :type LoadBalancerName: str
        :param _LoadBalancerType: Network type of the load balancing instance.
OPEN: public network attribute. INTERNAL: private network attribute. for a cloud load balancer with private network attribute, you can bind an EIP for public network access. for details, see the EIP document on binding elastic IP (https://www.tencentcloud.comom/document/product/215/16700?from_cn_redirect=1).
        :type LoadBalancerType: str
        :param _Forward: CLB type identifier. Value range: 1 (CLB); 0 (classic CLB).
        :type Forward: int
        :param _Domain: The domain name of the cloud load balancer instance. this field is only provided for public network classic and domain name-based load balancing instances. it is being gradually phased out. we recommend using LoadBalancerDomain instead.
        :type Domain: str
        :param _LoadBalancerVips: List of VIPs of a CLB instance.
        :type LoadBalancerVips: list of str
        :param _Status: Specifies the state of the load balancing instance, including.
0: creating. 1: normal operation.
        :type Status: int
        :param _CreateTime: CLB instance creation time
Format: YYYY-MM-DD HH:MM:ss.
        :type CreateTime: str
        :param _StatusTime: Last status transition time of the CLB instance.
Format: YYYY-MM-DD HH:MM:ss.
        :type StatusTime: str
        :param _ProjectId: ID of the project to which a CLB instance belongs. 0: default project.
        :type ProjectId: int
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _OpenBgp: Anti-DDoS Pro identifier for CLB. 1: CLB with Anti-DDoS Pro; 0: CLB without Anti-DDoS Pro.
        :type OpenBgp: int
        :param _Snat: Whether SNAT is enabled. for traditional private network clbs before december 2016, SNAT was enabled.
        :type Snat: bool
        :param _Isolation: Whether isolated. 0 means not isolated. 1 means isolated.
        :type Isolation: int
        :param _Log: Log information. Only the public network CLB that have HTTP or HTTPS listeners can generate logs.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Log: str
        :param _SubnetId: Subnet of the CLB instance (applicable only to VPC-type CLB instances on private networks)
        :type SubnetId: str
        :param _Tags: CLB instance tag information
        :type Tags: list of TagInfo
        :param _SecureGroups: Security group of the CLB instance
        :type SecureGroups: list of str
        :param _TargetRegionInfo: Basic information of real servers bound to the CLB instance
        :type TargetRegionInfo: :class:`tencentcloud.clb.v20180317.models.TargetRegionInfo`
        :param _AnycastZone: Anycast CLB release domain. For non-anycast CLB, this field returns an empty string.
        :type AnycastZone: str
        :param _AddressIPVersion: IP Version, ipv4 | ipv6
        :type AddressIPVersion: str
        :param _NumericalVpcId: Specifies the VPC ID in numerical form, obtainable through the DescribeVpcs API (https://www.tencentcloud.comom/document/product/215/15778?from_cn_redirect=1).
        :type NumericalVpcId: int
        :param _VipIsp: Specifies the ISP of the load balancer IP address.

-BGP (multi-line).
- CMCC: CMCC single line network.
-CTCC: ctcc single-line.
- CUCC: china unicom single-line.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VipIsp: str
        :param _MasterZone: Primary AZ
Note: This field may return null, indicating that no valid values can be obtained.
        :type MasterZone: :class:`tencentcloud.clb.v20180317.models.ZoneInfo`
        :param _BackupZoneSet: Secondary AZ
Note: This field may return null, indicating that no valid values can be obtained.
        :type BackupZoneSet: list of ZoneInfo
        :param _IsolatedTime: Specifies the isolation time of the cloud load balancer instance.
Format: YYYY-MM-DD HH:MM:ss.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolatedTime: str
        :param _ExpireTime: CLB instance expiration time, which takes effect only for prepaid instances
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpireTime: str
        :param _ChargeType: Billing mode of CLB instance. Valid values: PREPAID (monthly subscription), POSTPAID_BY_HOUR (pay as you go).
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ChargeType: str
        :param _NetworkAttributes: CLB instance network attributes
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetworkAttributes: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        :param _PrepaidAttributes: Prepaid billing attributes of a CLB instance
Note: This field may return null, indicating that no valid values can be obtained.
        :type PrepaidAttributes: :class:`tencentcloud.clb.v20180317.models.LBChargePrepaid`
        :param _LogSetId: Log set ID of Cloud Log Service (CLS) for CLB
        :type LogSetId: str
        :param _LogTopicId: Log topic ID of Cloud Log Service (CLS) for CLB
        :type LogTopicId: str
        :param _AddressIPv6: IPv6 address of a CLB instance
Note: This field may return null, indicating that no valid values can be obtained.
        :type AddressIPv6: str
        :param _ExtraInfo: Reserved field which can be ignored generally.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExtraInfo: :class:`tencentcloud.clb.v20180317.models.ExtraInfo`
        :param _IsDDos: Whether an Anti-DDoS Pro instance can be bound
        :type IsDDos: bool
        :param _ConfigId: Custom configuration IDs of CLB instances
        :type ConfigId: str
        :param _LoadBalancerPassToTarget: Whether the real server allows traffic from CLB
        :type LoadBalancerPassToTarget: bool
        :param _ExclusiveCluster: Exclusive cluster on the private network
        :type ExclusiveCluster: :class:`tencentcloud.clb.v20180317.models.ExclusiveCluster`
        :param _IPv6Mode: Specifies the field is meaningful when the IP address version is ipv6. valid values: ipv6Nat64 | ipv6FullChain.
IPv6Nat64: specifies a load balancer based on Nat64 IPv6 transition technology.
IPv6FullChain: specifies a cloud load balancer implemented based on ipv6 single-stack technology.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IPv6Mode: str
        :param _SnatPro: Specifies whether SnatPro is enabled.
        :type SnatPro: bool
        :param _SnatIps: Enables the SnatIp list after turning on SnatPro load balancing.
        :type SnatIps: list of SnatIp
        :param _SlaType: Performance capacity specification. <ul><li> clb.c1.small: minimalist specification </li> <li> clb.c2.medium: standard specification </li> <li> clb.c3.small: advanced type 1 specification </li> <li> clb.c3.medium: advanced type 2 specification </li> <li> clb.c4.small: super type 1 specification </li> <li> clb.c4.medium: super type 2 specification </li> <li> clb.c4.large: super type 3 specification </li> <li> clb.c4.xlarge: super type 4 specification </li> <li>"" : non-performance capacity instance</li></ul>.
        :type SlaType: str
        :param _IsBlock: Whether VIP is blocked
        :type IsBlock: bool
        :param _IsBlockTime: Specifies the blocking or unblocking time.
Format: YYYY-MM-DD HH:MM:ss.
        :type IsBlockTime: str
        :param _LocalBgp: Whether the IP type is Local BGP
        :type LocalBgp: bool
        :param _ClusterTag: Dedicated layer-7 tag.
Note: this field may return null, indicating that no valid values can be obtained.
        :type ClusterTag: str
        :param _MixIpTarget: If the layer-7 listener of an IPv6FullChain CLB instance is enabled, the CLB instance can be bound with IPv4 and IPv6 CVM instances simultaneously.
        :type MixIpTarget: bool
        :param _Zones: Availability zone of a VPC-based private network CLB instance
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Zones: list of str
        :param _NfvInfo: Whether it is an NFV CLB instance. No returned information: no; l7nfv: yes.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type NfvInfo: str
        :param _HealthLogSetId: Health check log set ID of Cloud Log Service (CLS) for CLB
        :type HealthLogSetId: str
        :param _HealthLogTopicId: Health check log topic ID of Cloud Log Service (CLS) for CLB
        :type HealthLogTopicId: str
        :param _ClusterIds: Cluster ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterIds: list of str
        :param _AttributeFlags: Attributes of cloud load balancer, input an array of strings to determine whether it is enabled.
DeleteProtect: specifies deletion protection. once enabled, it prevents the cloud load balancer from being accidentally deleted. 
UserInVisible: invisible to users, controls load balancing visibility to users. 
BlockStatus: specifies the blockage status, used to limit certain operations or traffic for cloud load balancer. 
NoLBNat: disables the NAT feature of cloud load balancer for direct forwarding of traffic in specific scenarios. 
BanStatus: specifies the blocking status for suspending the clb service or restricting access. 
ShiftupFlag: specifies the upgrade flag used to identify if the cloud load balancer requires a configuration upgrade or performance improvement. 
Specifies the stopped status. once enabled, the cloud load balancer suspends service. 
NoVpcGw: specifies not to use VPC gateway to bypass the gateway for direct traffic handling. 
SgInTgw: specifies the security group in TGW (Transit Gateway) involving network security policy configuration. 
SharedLimitFlag: specifies the shared limit flag used to control the resource constraints of cloud load balancer. 
WafFlag: specifies the Web application firewall (WAF) flag. enabled to enable WAF protection. 
IsDomainCLB: indicates whether the cloud load balancer is domain name-based for traffic distribution. 
IPv6Snat: IPv6 source address translation (Snat), used for source address processing in IPv6 networks. 
HideDomain. specifies whether to hide the domain name for privacy protection or to avoid exposing it in specific scenarios. 
JumboFrame: specifies giant frame support. once enabled, it supports larger data frames to improve network efficiency. 
NoLBNatL4IPdc: specifies layer 4 IP direct connection without NAT, used for direct forwarding of IP traffic in layer 4 load balancing. 
VpcGwL3Service: specifies the VPC gateway layer-3 Service, which involves the gateway feature of the layer-3 network. 
Ipv62Flag: specifies the Ipv6 expansion Flag for specific feature support. 
Ipv62ExclusiveFlag: specifies the Ipv6 exclusive flag used for exclusive Ipv6 traffic processing. 
BgpPro: specifies BGP Pro support. 
ToaClean: TOA (TCP Option Address) cleanup. clears Address information in TCP options. 

        :type AttributeFlags: list of str
        :param _LoadBalancerDomain: Specifies the domain name of the load balancing instance.
        :type LoadBalancerDomain: str
        :param _Egress: Specifies the network outbound.
        :type Egress: str
        :param _Exclusive: Indicates whether the instance type is dedicated. 1: dedicated instance. 0: non-dedicated instance.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Exclusive: int
        :param _TargetCount: Specifies the number of bound backend services.
        :type TargetCount: int
        :param _AssociateEndpoint: Specifies the Endpoint id associated with the clb instance.
        :type AssociateEndpoint: str
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._LoadBalancerType = None
        self._Forward = None
        self._Domain = None
        self._LoadBalancerVips = None
        self._Status = None
        self._CreateTime = None
        self._StatusTime = None
        self._ProjectId = None
        self._VpcId = None
        self._OpenBgp = None
        self._Snat = None
        self._Isolation = None
        self._Log = None
        self._SubnetId = None
        self._Tags = None
        self._SecureGroups = None
        self._TargetRegionInfo = None
        self._AnycastZone = None
        self._AddressIPVersion = None
        self._NumericalVpcId = None
        self._VipIsp = None
        self._MasterZone = None
        self._BackupZoneSet = None
        self._IsolatedTime = None
        self._ExpireTime = None
        self._ChargeType = None
        self._NetworkAttributes = None
        self._PrepaidAttributes = None
        self._LogSetId = None
        self._LogTopicId = None
        self._AddressIPv6 = None
        self._ExtraInfo = None
        self._IsDDos = None
        self._ConfigId = None
        self._LoadBalancerPassToTarget = None
        self._ExclusiveCluster = None
        self._IPv6Mode = None
        self._SnatPro = None
        self._SnatIps = None
        self._SlaType = None
        self._IsBlock = None
        self._IsBlockTime = None
        self._LocalBgp = None
        self._ClusterTag = None
        self._MixIpTarget = None
        self._Zones = None
        self._NfvInfo = None
        self._HealthLogSetId = None
        self._HealthLogTopicId = None
        self._ClusterIds = None
        self._AttributeFlags = None
        self._LoadBalancerDomain = None
        self._Egress = None
        self._Exclusive = None
        self._TargetCount = None
        self._AssociateEndpoint = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""CLB instance name.
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def LoadBalancerType(self):
        r"""Network type of the load balancing instance.
OPEN: public network attribute. INTERNAL: private network attribute. for a cloud load balancer with private network attribute, you can bind an EIP for public network access. for details, see the EIP document on binding elastic IP (https://www.tencentcloud.comom/document/product/215/16700?from_cn_redirect=1).
        :rtype: str
        """
        return self._LoadBalancerType

    @LoadBalancerType.setter
    def LoadBalancerType(self, LoadBalancerType):
        self._LoadBalancerType = LoadBalancerType

    @property
    def Forward(self):
        r"""CLB type identifier. Value range: 1 (CLB); 0 (classic CLB).
        :rtype: int
        """
        return self._Forward

    @Forward.setter
    def Forward(self, Forward):
        self._Forward = Forward

    @property
    def Domain(self):
        r"""The domain name of the cloud load balancer instance. this field is only provided for public network classic and domain name-based load balancing instances. it is being gradually phased out. we recommend using LoadBalancerDomain instead.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def LoadBalancerVips(self):
        r"""List of VIPs of a CLB instance.
        :rtype: list of str
        """
        return self._LoadBalancerVips

    @LoadBalancerVips.setter
    def LoadBalancerVips(self, LoadBalancerVips):
        self._LoadBalancerVips = LoadBalancerVips

    @property
    def Status(self):
        r"""Specifies the state of the load balancing instance, including.
0: creating. 1: normal operation.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        r"""CLB instance creation time
Format: YYYY-MM-DD HH:MM:ss.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def StatusTime(self):
        r"""Last status transition time of the CLB instance.
Format: YYYY-MM-DD HH:MM:ss.
        :rtype: str
        """
        return self._StatusTime

    @StatusTime.setter
    def StatusTime(self, StatusTime):
        self._StatusTime = StatusTime

    @property
    def ProjectId(self):
        r"""ID of the project to which a CLB instance belongs. 0: default project.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def VpcId(self):
        r"""VPC ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def OpenBgp(self):
        r"""Anti-DDoS Pro identifier for CLB. 1: CLB with Anti-DDoS Pro; 0: CLB without Anti-DDoS Pro.
        :rtype: int
        """
        return self._OpenBgp

    @OpenBgp.setter
    def OpenBgp(self, OpenBgp):
        self._OpenBgp = OpenBgp

    @property
    def Snat(self):
        r"""Whether SNAT is enabled. for traditional private network clbs before december 2016, SNAT was enabled.
        :rtype: bool
        """
        return self._Snat

    @Snat.setter
    def Snat(self, Snat):
        self._Snat = Snat

    @property
    def Isolation(self):
        r"""Whether isolated. 0 means not isolated. 1 means isolated.
        :rtype: int
        """
        return self._Isolation

    @Isolation.setter
    def Isolation(self, Isolation):
        self._Isolation = Isolation

    @property
    def Log(self):
        warnings.warn("parameter `Log` is deprecated", DeprecationWarning) 

        r"""Log information. Only the public network CLB that have HTTP or HTTPS listeners can generate logs.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Log

    @Log.setter
    def Log(self, Log):
        warnings.warn("parameter `Log` is deprecated", DeprecationWarning) 

        self._Log = Log

    @property
    def SubnetId(self):
        r"""Subnet of the CLB instance (applicable only to VPC-type CLB instances on private networks)
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Tags(self):
        r"""CLB instance tag information
        :rtype: list of TagInfo
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def SecureGroups(self):
        r"""Security group of the CLB instance
        :rtype: list of str
        """
        return self._SecureGroups

    @SecureGroups.setter
    def SecureGroups(self, SecureGroups):
        self._SecureGroups = SecureGroups

    @property
    def TargetRegionInfo(self):
        r"""Basic information of real servers bound to the CLB instance
        :rtype: :class:`tencentcloud.clb.v20180317.models.TargetRegionInfo`
        """
        return self._TargetRegionInfo

    @TargetRegionInfo.setter
    def TargetRegionInfo(self, TargetRegionInfo):
        self._TargetRegionInfo = TargetRegionInfo

    @property
    def AnycastZone(self):
        r"""Anycast CLB release domain. For non-anycast CLB, this field returns an empty string.
        :rtype: str
        """
        return self._AnycastZone

    @AnycastZone.setter
    def AnycastZone(self, AnycastZone):
        self._AnycastZone = AnycastZone

    @property
    def AddressIPVersion(self):
        r"""IP Version, ipv4 | ipv6
        :rtype: str
        """
        return self._AddressIPVersion

    @AddressIPVersion.setter
    def AddressIPVersion(self, AddressIPVersion):
        self._AddressIPVersion = AddressIPVersion

    @property
    def NumericalVpcId(self):
        r"""Specifies the VPC ID in numerical form, obtainable through the DescribeVpcs API (https://www.tencentcloud.comom/document/product/215/15778?from_cn_redirect=1).
        :rtype: int
        """
        return self._NumericalVpcId

    @NumericalVpcId.setter
    def NumericalVpcId(self, NumericalVpcId):
        self._NumericalVpcId = NumericalVpcId

    @property
    def VipIsp(self):
        r"""Specifies the ISP of the load balancer IP address.

-BGP (multi-line).
- CMCC: CMCC single line network.
-CTCC: ctcc single-line.
- CUCC: china unicom single-line.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VipIsp

    @VipIsp.setter
    def VipIsp(self, VipIsp):
        self._VipIsp = VipIsp

    @property
    def MasterZone(self):
        r"""Primary AZ
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.ZoneInfo`
        """
        return self._MasterZone

    @MasterZone.setter
    def MasterZone(self, MasterZone):
        self._MasterZone = MasterZone

    @property
    def BackupZoneSet(self):
        r"""Secondary AZ
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ZoneInfo
        """
        return self._BackupZoneSet

    @BackupZoneSet.setter
    def BackupZoneSet(self, BackupZoneSet):
        self._BackupZoneSet = BackupZoneSet

    @property
    def IsolatedTime(self):
        r"""Specifies the isolation time of the cloud load balancer instance.
Format: YYYY-MM-DD HH:MM:ss.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IsolatedTime

    @IsolatedTime.setter
    def IsolatedTime(self, IsolatedTime):
        self._IsolatedTime = IsolatedTime

    @property
    def ExpireTime(self):
        r"""CLB instance expiration time, which takes effect only for prepaid instances
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def ChargeType(self):
        r"""Billing mode of CLB instance. Valid values: PREPAID (monthly subscription), POSTPAID_BY_HOUR (pay as you go).
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def NetworkAttributes(self):
        r"""CLB instance network attributes
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        """
        return self._NetworkAttributes

    @NetworkAttributes.setter
    def NetworkAttributes(self, NetworkAttributes):
        self._NetworkAttributes = NetworkAttributes

    @property
    def PrepaidAttributes(self):
        r"""Prepaid billing attributes of a CLB instance
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.LBChargePrepaid`
        """
        return self._PrepaidAttributes

    @PrepaidAttributes.setter
    def PrepaidAttributes(self, PrepaidAttributes):
        self._PrepaidAttributes = PrepaidAttributes

    @property
    def LogSetId(self):
        r"""Log set ID of Cloud Log Service (CLS) for CLB
        :rtype: str
        """
        return self._LogSetId

    @LogSetId.setter
    def LogSetId(self, LogSetId):
        self._LogSetId = LogSetId

    @property
    def LogTopicId(self):
        r"""Log topic ID of Cloud Log Service (CLS) for CLB
        :rtype: str
        """
        return self._LogTopicId

    @LogTopicId.setter
    def LogTopicId(self, LogTopicId):
        self._LogTopicId = LogTopicId

    @property
    def AddressIPv6(self):
        r"""IPv6 address of a CLB instance
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AddressIPv6

    @AddressIPv6.setter
    def AddressIPv6(self, AddressIPv6):
        self._AddressIPv6 = AddressIPv6

    @property
    def ExtraInfo(self):
        r"""Reserved field which can be ignored generally.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.ExtraInfo`
        """
        return self._ExtraInfo

    @ExtraInfo.setter
    def ExtraInfo(self, ExtraInfo):
        self._ExtraInfo = ExtraInfo

    @property
    def IsDDos(self):
        r"""Whether an Anti-DDoS Pro instance can be bound
        :rtype: bool
        """
        return self._IsDDos

    @IsDDos.setter
    def IsDDos(self, IsDDos):
        self._IsDDos = IsDDos

    @property
    def ConfigId(self):
        r"""Custom configuration IDs of CLB instances
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def LoadBalancerPassToTarget(self):
        r"""Whether the real server allows traffic from CLB
        :rtype: bool
        """
        return self._LoadBalancerPassToTarget

    @LoadBalancerPassToTarget.setter
    def LoadBalancerPassToTarget(self, LoadBalancerPassToTarget):
        self._LoadBalancerPassToTarget = LoadBalancerPassToTarget

    @property
    def ExclusiveCluster(self):
        r"""Exclusive cluster on the private network
        :rtype: :class:`tencentcloud.clb.v20180317.models.ExclusiveCluster`
        """
        return self._ExclusiveCluster

    @ExclusiveCluster.setter
    def ExclusiveCluster(self, ExclusiveCluster):
        self._ExclusiveCluster = ExclusiveCluster

    @property
    def IPv6Mode(self):
        r"""Specifies the field is meaningful when the IP address version is ipv6. valid values: ipv6Nat64 | ipv6FullChain.
IPv6Nat64: specifies a load balancer based on Nat64 IPv6 transition technology.
IPv6FullChain: specifies a cloud load balancer implemented based on ipv6 single-stack technology.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IPv6Mode

    @IPv6Mode.setter
    def IPv6Mode(self, IPv6Mode):
        self._IPv6Mode = IPv6Mode

    @property
    def SnatPro(self):
        r"""Specifies whether SnatPro is enabled.
        :rtype: bool
        """
        return self._SnatPro

    @SnatPro.setter
    def SnatPro(self, SnatPro):
        self._SnatPro = SnatPro

    @property
    def SnatIps(self):
        r"""Enables the SnatIp list after turning on SnatPro load balancing.
        :rtype: list of SnatIp
        """
        return self._SnatIps

    @SnatIps.setter
    def SnatIps(self, SnatIps):
        self._SnatIps = SnatIps

    @property
    def SlaType(self):
        r"""Performance capacity specification. <ul><li> clb.c1.small: minimalist specification </li> <li> clb.c2.medium: standard specification </li> <li> clb.c3.small: advanced type 1 specification </li> <li> clb.c3.medium: advanced type 2 specification </li> <li> clb.c4.small: super type 1 specification </li> <li> clb.c4.medium: super type 2 specification </li> <li> clb.c4.large: super type 3 specification </li> <li> clb.c4.xlarge: super type 4 specification </li> <li>"" : non-performance capacity instance</li></ul>.
        :rtype: str
        """
        return self._SlaType

    @SlaType.setter
    def SlaType(self, SlaType):
        self._SlaType = SlaType

    @property
    def IsBlock(self):
        r"""Whether VIP is blocked
        :rtype: bool
        """
        return self._IsBlock

    @IsBlock.setter
    def IsBlock(self, IsBlock):
        self._IsBlock = IsBlock

    @property
    def IsBlockTime(self):
        r"""Specifies the blocking or unblocking time.
Format: YYYY-MM-DD HH:MM:ss.
        :rtype: str
        """
        return self._IsBlockTime

    @IsBlockTime.setter
    def IsBlockTime(self, IsBlockTime):
        self._IsBlockTime = IsBlockTime

    @property
    def LocalBgp(self):
        r"""Whether the IP type is Local BGP
        :rtype: bool
        """
        return self._LocalBgp

    @LocalBgp.setter
    def LocalBgp(self, LocalBgp):
        self._LocalBgp = LocalBgp

    @property
    def ClusterTag(self):
        r"""Dedicated layer-7 tag.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ClusterTag

    @ClusterTag.setter
    def ClusterTag(self, ClusterTag):
        self._ClusterTag = ClusterTag

    @property
    def MixIpTarget(self):
        r"""If the layer-7 listener of an IPv6FullChain CLB instance is enabled, the CLB instance can be bound with IPv4 and IPv6 CVM instances simultaneously.
        :rtype: bool
        """
        return self._MixIpTarget

    @MixIpTarget.setter
    def MixIpTarget(self, MixIpTarget):
        self._MixIpTarget = MixIpTarget

    @property
    def Zones(self):
        r"""Availability zone of a VPC-based private network CLB instance
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones

    @property
    def NfvInfo(self):
        r"""Whether it is an NFV CLB instance. No returned information: no; l7nfv: yes.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NfvInfo

    @NfvInfo.setter
    def NfvInfo(self, NfvInfo):
        self._NfvInfo = NfvInfo

    @property
    def HealthLogSetId(self):
        r"""Health check log set ID of Cloud Log Service (CLS) for CLB
        :rtype: str
        """
        return self._HealthLogSetId

    @HealthLogSetId.setter
    def HealthLogSetId(self, HealthLogSetId):
        self._HealthLogSetId = HealthLogSetId

    @property
    def HealthLogTopicId(self):
        r"""Health check log topic ID of Cloud Log Service (CLS) for CLB
        :rtype: str
        """
        return self._HealthLogTopicId

    @HealthLogTopicId.setter
    def HealthLogTopicId(self, HealthLogTopicId):
        self._HealthLogTopicId = HealthLogTopicId

    @property
    def ClusterIds(self):
        r"""Cluster ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def AttributeFlags(self):
        r"""Attributes of cloud load balancer, input an array of strings to determine whether it is enabled.
DeleteProtect: specifies deletion protection. once enabled, it prevents the cloud load balancer from being accidentally deleted. 
UserInVisible: invisible to users, controls load balancing visibility to users. 
BlockStatus: specifies the blockage status, used to limit certain operations or traffic for cloud load balancer. 
NoLBNat: disables the NAT feature of cloud load balancer for direct forwarding of traffic in specific scenarios. 
BanStatus: specifies the blocking status for suspending the clb service or restricting access. 
ShiftupFlag: specifies the upgrade flag used to identify if the cloud load balancer requires a configuration upgrade or performance improvement. 
Specifies the stopped status. once enabled, the cloud load balancer suspends service. 
NoVpcGw: specifies not to use VPC gateway to bypass the gateway for direct traffic handling. 
SgInTgw: specifies the security group in TGW (Transit Gateway) involving network security policy configuration. 
SharedLimitFlag: specifies the shared limit flag used to control the resource constraints of cloud load balancer. 
WafFlag: specifies the Web application firewall (WAF) flag. enabled to enable WAF protection. 
IsDomainCLB: indicates whether the cloud load balancer is domain name-based for traffic distribution. 
IPv6Snat: IPv6 source address translation (Snat), used for source address processing in IPv6 networks. 
HideDomain. specifies whether to hide the domain name for privacy protection or to avoid exposing it in specific scenarios. 
JumboFrame: specifies giant frame support. once enabled, it supports larger data frames to improve network efficiency. 
NoLBNatL4IPdc: specifies layer 4 IP direct connection without NAT, used for direct forwarding of IP traffic in layer 4 load balancing. 
VpcGwL3Service: specifies the VPC gateway layer-3 Service, which involves the gateway feature of the layer-3 network. 
Ipv62Flag: specifies the Ipv6 expansion Flag for specific feature support. 
Ipv62ExclusiveFlag: specifies the Ipv6 exclusive flag used for exclusive Ipv6 traffic processing. 
BgpPro: specifies BGP Pro support. 
ToaClean: TOA (TCP Option Address) cleanup. clears Address information in TCP options. 

        :rtype: list of str
        """
        return self._AttributeFlags

    @AttributeFlags.setter
    def AttributeFlags(self, AttributeFlags):
        self._AttributeFlags = AttributeFlags

    @property
    def LoadBalancerDomain(self):
        r"""Specifies the domain name of the load balancing instance.
        :rtype: str
        """
        return self._LoadBalancerDomain

    @LoadBalancerDomain.setter
    def LoadBalancerDomain(self, LoadBalancerDomain):
        self._LoadBalancerDomain = LoadBalancerDomain

    @property
    def Egress(self):
        r"""Specifies the network outbound.
        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress

    @property
    def Exclusive(self):
        r"""Indicates whether the instance type is dedicated. 1: dedicated instance. 0: non-dedicated instance.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Exclusive

    @Exclusive.setter
    def Exclusive(self, Exclusive):
        self._Exclusive = Exclusive

    @property
    def TargetCount(self):
        r"""Specifies the number of bound backend services.
        :rtype: int
        """
        return self._TargetCount

    @TargetCount.setter
    def TargetCount(self, TargetCount):
        self._TargetCount = TargetCount

    @property
    def AssociateEndpoint(self):
        r"""Specifies the Endpoint id associated with the clb instance.
        :rtype: str
        """
        return self._AssociateEndpoint

    @AssociateEndpoint.setter
    def AssociateEndpoint(self, AssociateEndpoint):
        self._AssociateEndpoint = AssociateEndpoint


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._LoadBalancerType = params.get("LoadBalancerType")
        self._Forward = params.get("Forward")
        self._Domain = params.get("Domain")
        self._LoadBalancerVips = params.get("LoadBalancerVips")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._StatusTime = params.get("StatusTime")
        self._ProjectId = params.get("ProjectId")
        self._VpcId = params.get("VpcId")
        self._OpenBgp = params.get("OpenBgp")
        self._Snat = params.get("Snat")
        self._Isolation = params.get("Isolation")
        self._Log = params.get("Log")
        self._SubnetId = params.get("SubnetId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._SecureGroups = params.get("SecureGroups")
        if params.get("TargetRegionInfo") is not None:
            self._TargetRegionInfo = TargetRegionInfo()
            self._TargetRegionInfo._deserialize(params.get("TargetRegionInfo"))
        self._AnycastZone = params.get("AnycastZone")
        self._AddressIPVersion = params.get("AddressIPVersion")
        self._NumericalVpcId = params.get("NumericalVpcId")
        self._VipIsp = params.get("VipIsp")
        if params.get("MasterZone") is not None:
            self._MasterZone = ZoneInfo()
            self._MasterZone._deserialize(params.get("MasterZone"))
        if params.get("BackupZoneSet") is not None:
            self._BackupZoneSet = []
            for item in params.get("BackupZoneSet"):
                obj = ZoneInfo()
                obj._deserialize(item)
                self._BackupZoneSet.append(obj)
        self._IsolatedTime = params.get("IsolatedTime")
        self._ExpireTime = params.get("ExpireTime")
        self._ChargeType = params.get("ChargeType")
        if params.get("NetworkAttributes") is not None:
            self._NetworkAttributes = InternetAccessible()
            self._NetworkAttributes._deserialize(params.get("NetworkAttributes"))
        if params.get("PrepaidAttributes") is not None:
            self._PrepaidAttributes = LBChargePrepaid()
            self._PrepaidAttributes._deserialize(params.get("PrepaidAttributes"))
        self._LogSetId = params.get("LogSetId")
        self._LogTopicId = params.get("LogTopicId")
        self._AddressIPv6 = params.get("AddressIPv6")
        if params.get("ExtraInfo") is not None:
            self._ExtraInfo = ExtraInfo()
            self._ExtraInfo._deserialize(params.get("ExtraInfo"))
        self._IsDDos = params.get("IsDDos")
        self._ConfigId = params.get("ConfigId")
        self._LoadBalancerPassToTarget = params.get("LoadBalancerPassToTarget")
        if params.get("ExclusiveCluster") is not None:
            self._ExclusiveCluster = ExclusiveCluster()
            self._ExclusiveCluster._deserialize(params.get("ExclusiveCluster"))
        self._IPv6Mode = params.get("IPv6Mode")
        self._SnatPro = params.get("SnatPro")
        if params.get("SnatIps") is not None:
            self._SnatIps = []
            for item in params.get("SnatIps"):
                obj = SnatIp()
                obj._deserialize(item)
                self._SnatIps.append(obj)
        self._SlaType = params.get("SlaType")
        self._IsBlock = params.get("IsBlock")
        self._IsBlockTime = params.get("IsBlockTime")
        self._LocalBgp = params.get("LocalBgp")
        self._ClusterTag = params.get("ClusterTag")
        self._MixIpTarget = params.get("MixIpTarget")
        self._Zones = params.get("Zones")
        self._NfvInfo = params.get("NfvInfo")
        self._HealthLogSetId = params.get("HealthLogSetId")
        self._HealthLogTopicId = params.get("HealthLogTopicId")
        self._ClusterIds = params.get("ClusterIds")
        self._AttributeFlags = params.get("AttributeFlags")
        self._LoadBalancerDomain = params.get("LoadBalancerDomain")
        self._Egress = params.get("Egress")
        self._Exclusive = params.get("Exclusive")
        self._TargetCount = params.get("TargetCount")
        self._AssociateEndpoint = params.get("AssociateEndpoint")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadBalancerDetail(AbstractModel):
    r"""CLB instance details

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID.
        :type LoadBalancerId: str
        :param _LoadBalancerName: CLB instance name.
        :type LoadBalancerName: str
        :param _LoadBalancerType: Network type of the load balancing instance.
Public: Public network attribute. Private: Private network attribute. for Private network cloud load balancer, bind EIP for Public network access. refer to EIP document.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LoadBalancerType: str
        :param _Status: CLB instance status, including:
0: creating; 1: running.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _Address: CLB instance VIP.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Address: str
        :param _AddressIPv6: IPv6 VIP address of the CLB instance.
Note: this field may return null, indicating that no valid values can be obtained.
        :type AddressIPv6: str
        :param _AddressIPVersion: IP version of the CLB instance. Valid values: IPv4, IPv6.
Note: this field may return null, indicating that no valid values can be obtained.
        :type AddressIPVersion: str
        :param _IPv6Mode: IPv6 address type of the CLB instance. Valid values: IPv6Nat64, IPv6FullChain.
Note: this field may return null, indicating that no valid values can be obtained.
        :type IPv6Mode: str
        :param _Zone: Availability zone where the CLB instance resides.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Zone: str
        :param _AddressIsp: ISP for the IP address of the CLB instance. Valid values: BGP (multi-line), CMCC (China Mobile), CUCC (China Unicom), CTCC (China Telecom), INTERNAL (private network).Note: This field may return null, indicating that no valid values can be obtained.
        :type AddressIsp: str
        :param _VpcId: ID of the VPC instance to which the CLB instance belongs.
Note: this field may return null, indicating that no valid values can be obtained.
        :type VpcId: str
        :param _ProjectId: ID of the project to which the CLB instance belongs. 0: default project.
Note: this field may return null, indicating that no valid values can be obtained.
        :type ProjectId: int
        :param _CreateTime: CLB instance creation time.
Note: this field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _ChargeType: Billing type of a CLB instance. Valid values: PREPAID (prepaid), POSTPAID_BY_HOUR (pay-as-you-go).Note: This field may return null, indicating that no valid values can be obtained.
        :type ChargeType: str
        :param _NetworkAttributes: CLB instance network attribute.
Note: this field may return null, indicating that no valid values can be obtained.
        :type NetworkAttributes: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        :param _PrepaidAttributes: Pay-as-you-go attribute of the CLB instance.
Note: this field may return null, indicating that no valid values can be obtained.
        :type PrepaidAttributes: :class:`tencentcloud.clb.v20180317.models.LBChargePrepaid`
        :param _ExtraInfo: Reserved field, which can be ignored generally.
Note: this field may return null, indicating that no valid values can be obtained.
        :type ExtraInfo: :class:`tencentcloud.clb.v20180317.models.ExtraInfo`
        :param _ConfigId: Custom configuration IDs of CLB instances. Multiple IDs must be separated by commas (,).
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConfigId: str
        :param _Tags: CLB instance tag information.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Tags: list of TagInfo
        :param _ListenerId: CLB listener ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :type ListenerId: str
        :param _Protocol: Listener protocol.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Protocol: str
        :param _Port: Listener port.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Port: int
        :param _LocationId: Forwarding rule ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :type LocationId: str
        :param _Domain: Domain name of the forwarding rule.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Domain: str
        :param _Url: Forwarding rule path.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Url: str
        :param _TargetId: ID of target real servers.
Note: this field may return null, indicating that no valid values can be obtained.
        :type TargetId: str
        :param _TargetAddress: Address of target real servers.
Note: this field may return null, indicating that no valid values can be obtained.
        :type TargetAddress: str
        :param _TargetPort: Listening port of target real servers.
Note: this field may return null, indicating that no valid values can be obtained.
        :type TargetPort: int
        :param _TargetWeight: Forwarding weight of target real servers.
Note: this field may return null, indicating that no valid values can be obtained.
        :type TargetWeight: int
        :param _Isolation: 0: not isolated; 1: isolated.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Isolation: int
        :param _SecurityGroup: List of the security groups bound to the CLB instance.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type SecurityGroup: list of str
        :param _LoadBalancerPassToTarget: Whether to enable moving up CLB security groups. Valid values: 1 (enabled), 0 (not enabled).Note: This field may return null, indicating that no valid values can be obtained.
        :type LoadBalancerPassToTarget: int
        :param _TargetHealth: Health status of the target real server.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type TargetHealth: str
        :param _Domains: List o domain names associated with the forwarding rule
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Domains: str
        :param _SlaveZone: The secondary zone of multi-AZ CLB instance
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type SlaveZone: list of str
        :param _Zones: The AZ of private CLB instance. This is only available for beta users.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Zones: list of str
        :param _SniSwitch: Whether to enable SNI. `1`: Enable; `0`: Do not enable. This parameter is only meaningful for HTTPS listeners.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type SniSwitch: int
        :param _LoadBalancerDomain: Specifies the domain name of the load balancing instance.
        :type LoadBalancerDomain: str
        :param _Egress: Specifies the network outbound.
        :type Egress: str
        :param _AttributeFlags: Specifies the attributes of cloud load balancer.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AttributeFlags: list of str
        :param _SlaType: Specification type information for load balancing instances <ul><li>clb.c1.small: minimalist specification</li> <li>clb.c2.medium: standard specification</li> <li>clb.c3.small: advanced type 1 specification</li> <li>clb.c3.medium: advanced type 2 specification</li> <li>clb.c4.small: ultra type 1 specification</li> <li>clb.c4.medium: ultra type 2 specification</li> <li>clb.c4.large: ultra type 3 specification</li> <li>clb.c4.xlarge: ultra type 4 specification</li> <li>"" : non-lcu-supported instance</li></ul>.

Note: This field may return null, indicating that no valid values can be obtained.
        :type SlaType: str
        :param _Exclusive: 0 means non-dedicated instance. 1 means dedicated instance.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Exclusive: int
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._LoadBalancerType = None
        self._Status = None
        self._Address = None
        self._AddressIPv6 = None
        self._AddressIPVersion = None
        self._IPv6Mode = None
        self._Zone = None
        self._AddressIsp = None
        self._VpcId = None
        self._ProjectId = None
        self._CreateTime = None
        self._ChargeType = None
        self._NetworkAttributes = None
        self._PrepaidAttributes = None
        self._ExtraInfo = None
        self._ConfigId = None
        self._Tags = None
        self._ListenerId = None
        self._Protocol = None
        self._Port = None
        self._LocationId = None
        self._Domain = None
        self._Url = None
        self._TargetId = None
        self._TargetAddress = None
        self._TargetPort = None
        self._TargetWeight = None
        self._Isolation = None
        self._SecurityGroup = None
        self._LoadBalancerPassToTarget = None
        self._TargetHealth = None
        self._Domains = None
        self._SlaveZone = None
        self._Zones = None
        self._SniSwitch = None
        self._LoadBalancerDomain = None
        self._Egress = None
        self._AttributeFlags = None
        self._SlaType = None
        self._Exclusive = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""CLB instance name.
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def LoadBalancerType(self):
        r"""Network type of the load balancing instance.
Public: Public network attribute. Private: Private network attribute. for Private network cloud load balancer, bind EIP for Public network access. refer to EIP document.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LoadBalancerType

    @LoadBalancerType.setter
    def LoadBalancerType(self, LoadBalancerType):
        self._LoadBalancerType = LoadBalancerType

    @property
    def Status(self):
        r"""CLB instance status, including:
0: creating; 1: running.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Address(self):
        r"""CLB instance VIP.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def AddressIPv6(self):
        r"""IPv6 VIP address of the CLB instance.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AddressIPv6

    @AddressIPv6.setter
    def AddressIPv6(self, AddressIPv6):
        self._AddressIPv6 = AddressIPv6

    @property
    def AddressIPVersion(self):
        r"""IP version of the CLB instance. Valid values: IPv4, IPv6.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AddressIPVersion

    @AddressIPVersion.setter
    def AddressIPVersion(self, AddressIPVersion):
        self._AddressIPVersion = AddressIPVersion

    @property
    def IPv6Mode(self):
        r"""IPv6 address type of the CLB instance. Valid values: IPv6Nat64, IPv6FullChain.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IPv6Mode

    @IPv6Mode.setter
    def IPv6Mode(self, IPv6Mode):
        self._IPv6Mode = IPv6Mode

    @property
    def Zone(self):
        r"""Availability zone where the CLB instance resides.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def AddressIsp(self):
        r"""ISP for the IP address of the CLB instance. Valid values: BGP (multi-line), CMCC (China Mobile), CUCC (China Unicom), CTCC (China Telecom), INTERNAL (private network).Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AddressIsp

    @AddressIsp.setter
    def AddressIsp(self, AddressIsp):
        self._AddressIsp = AddressIsp

    @property
    def VpcId(self):
        r"""ID of the VPC instance to which the CLB instance belongs.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ProjectId(self):
        r"""ID of the project to which the CLB instance belongs. 0: default project.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CreateTime(self):
        r"""CLB instance creation time.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ChargeType(self):
        r"""Billing type of a CLB instance. Valid values: PREPAID (prepaid), POSTPAID_BY_HOUR (pay-as-you-go).Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def NetworkAttributes(self):
        r"""CLB instance network attribute.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        """
        return self._NetworkAttributes

    @NetworkAttributes.setter
    def NetworkAttributes(self, NetworkAttributes):
        self._NetworkAttributes = NetworkAttributes

    @property
    def PrepaidAttributes(self):
        r"""Pay-as-you-go attribute of the CLB instance.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.LBChargePrepaid`
        """
        return self._PrepaidAttributes

    @PrepaidAttributes.setter
    def PrepaidAttributes(self, PrepaidAttributes):
        self._PrepaidAttributes = PrepaidAttributes

    @property
    def ExtraInfo(self):
        r"""Reserved field, which can be ignored generally.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.ExtraInfo`
        """
        return self._ExtraInfo

    @ExtraInfo.setter
    def ExtraInfo(self, ExtraInfo):
        self._ExtraInfo = ExtraInfo

    @property
    def ConfigId(self):
        r"""Custom configuration IDs of CLB instances. Multiple IDs must be separated by commas (,).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def Tags(self):
        r"""CLB instance tag information.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of TagInfo
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ListenerId(self):
        r"""CLB listener ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Protocol(self):
        r"""Listener protocol.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        r"""Listener port.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def LocationId(self):
        r"""Forwarding rule ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Domain name of the forwarding rule.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""Forwarding rule path.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def TargetId(self):
        r"""ID of target real servers.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TargetId

    @TargetId.setter
    def TargetId(self, TargetId):
        self._TargetId = TargetId

    @property
    def TargetAddress(self):
        r"""Address of target real servers.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TargetAddress

    @TargetAddress.setter
    def TargetAddress(self, TargetAddress):
        self._TargetAddress = TargetAddress

    @property
    def TargetPort(self):
        r"""Listening port of target real servers.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TargetPort

    @TargetPort.setter
    def TargetPort(self, TargetPort):
        self._TargetPort = TargetPort

    @property
    def TargetWeight(self):
        r"""Forwarding weight of target real servers.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TargetWeight

    @TargetWeight.setter
    def TargetWeight(self, TargetWeight):
        self._TargetWeight = TargetWeight

    @property
    def Isolation(self):
        r"""0: not isolated; 1: isolated.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Isolation

    @Isolation.setter
    def Isolation(self, Isolation):
        self._Isolation = Isolation

    @property
    def SecurityGroup(self):
        r"""List of the security groups bound to the CLB instance.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def LoadBalancerPassToTarget(self):
        r"""Whether to enable moving up CLB security groups. Valid values: 1 (enabled), 0 (not enabled).Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._LoadBalancerPassToTarget

    @LoadBalancerPassToTarget.setter
    def LoadBalancerPassToTarget(self, LoadBalancerPassToTarget):
        self._LoadBalancerPassToTarget = LoadBalancerPassToTarget

    @property
    def TargetHealth(self):
        r"""Health status of the target real server.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TargetHealth

    @TargetHealth.setter
    def TargetHealth(self, TargetHealth):
        self._TargetHealth = TargetHealth

    @property
    def Domains(self):
        r"""List o domain names associated with the forwarding rule
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def SlaveZone(self):
        r"""The secondary zone of multi-AZ CLB instance
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SlaveZone

    @SlaveZone.setter
    def SlaveZone(self, SlaveZone):
        self._SlaveZone = SlaveZone

    @property
    def Zones(self):
        r"""The AZ of private CLB instance. This is only available for beta users.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones

    @property
    def SniSwitch(self):
        r"""Whether to enable SNI. `1`: Enable; `0`: Do not enable. This parameter is only meaningful for HTTPS listeners.
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SniSwitch

    @SniSwitch.setter
    def SniSwitch(self, SniSwitch):
        self._SniSwitch = SniSwitch

    @property
    def LoadBalancerDomain(self):
        r"""Specifies the domain name of the load balancing instance.
        :rtype: str
        """
        return self._LoadBalancerDomain

    @LoadBalancerDomain.setter
    def LoadBalancerDomain(self, LoadBalancerDomain):
        self._LoadBalancerDomain = LoadBalancerDomain

    @property
    def Egress(self):
        r"""Specifies the network outbound.
        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress

    @property
    def AttributeFlags(self):
        r"""Specifies the attributes of cloud load balancer.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._AttributeFlags

    @AttributeFlags.setter
    def AttributeFlags(self, AttributeFlags):
        self._AttributeFlags = AttributeFlags

    @property
    def SlaType(self):
        r"""Specification type information for load balancing instances <ul><li>clb.c1.small: minimalist specification</li> <li>clb.c2.medium: standard specification</li> <li>clb.c3.small: advanced type 1 specification</li> <li>clb.c3.medium: advanced type 2 specification</li> <li>clb.c4.small: ultra type 1 specification</li> <li>clb.c4.medium: ultra type 2 specification</li> <li>clb.c4.large: ultra type 3 specification</li> <li>clb.c4.xlarge: ultra type 4 specification</li> <li>"" : non-lcu-supported instance</li></ul>.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SlaType

    @SlaType.setter
    def SlaType(self, SlaType):
        self._SlaType = SlaType

    @property
    def Exclusive(self):
        r"""0 means non-dedicated instance. 1 means dedicated instance.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Exclusive

    @Exclusive.setter
    def Exclusive(self, Exclusive):
        self._Exclusive = Exclusive


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._LoadBalancerType = params.get("LoadBalancerType")
        self._Status = params.get("Status")
        self._Address = params.get("Address")
        self._AddressIPv6 = params.get("AddressIPv6")
        self._AddressIPVersion = params.get("AddressIPVersion")
        self._IPv6Mode = params.get("IPv6Mode")
        self._Zone = params.get("Zone")
        self._AddressIsp = params.get("AddressIsp")
        self._VpcId = params.get("VpcId")
        self._ProjectId = params.get("ProjectId")
        self._CreateTime = params.get("CreateTime")
        self._ChargeType = params.get("ChargeType")
        if params.get("NetworkAttributes") is not None:
            self._NetworkAttributes = InternetAccessible()
            self._NetworkAttributes._deserialize(params.get("NetworkAttributes"))
        if params.get("PrepaidAttributes") is not None:
            self._PrepaidAttributes = LBChargePrepaid()
            self._PrepaidAttributes._deserialize(params.get("PrepaidAttributes"))
        if params.get("ExtraInfo") is not None:
            self._ExtraInfo = ExtraInfo()
            self._ExtraInfo._deserialize(params.get("ExtraInfo"))
        self._ConfigId = params.get("ConfigId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._ListenerId = params.get("ListenerId")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        self._TargetId = params.get("TargetId")
        self._TargetAddress = params.get("TargetAddress")
        self._TargetPort = params.get("TargetPort")
        self._TargetWeight = params.get("TargetWeight")
        self._Isolation = params.get("Isolation")
        self._SecurityGroup = params.get("SecurityGroup")
        self._LoadBalancerPassToTarget = params.get("LoadBalancerPassToTarget")
        self._TargetHealth = params.get("TargetHealth")
        self._Domains = params.get("Domains")
        self._SlaveZone = params.get("SlaveZone")
        self._Zones = params.get("Zones")
        self._SniSwitch = params.get("SniSwitch")
        self._LoadBalancerDomain = params.get("LoadBalancerDomain")
        self._Egress = params.get("Egress")
        self._AttributeFlags = params.get("AttributeFlags")
        self._SlaType = params.get("SlaType")
        self._Exclusive = params.get("Exclusive")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadBalancerHealth(AbstractModel):
    r"""CLB instance health check status

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _LoadBalancerName: Specifies the name of the load balancing instance.
        :type LoadBalancerName: str
        :param _Listeners: Listener list
        :type Listeners: list of ListenerHealth
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._Listeners = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""Specifies the name of the load balancing instance.
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def Listeners(self):
        r"""Listener list
        :rtype: list of ListenerHealth
        """
        return self._Listeners

    @Listeners.setter
    def Listeners(self, Listeners):
        self._Listeners = Listeners


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        if params.get("Listeners") is not None:
            self._Listeners = []
            for item in params.get("Listeners"):
                obj = ListenerHealth()
                obj._deserialize(item)
                self._Listeners.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadBalancerTraffic(AbstractModel):
    r"""CLB instance traffic data

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _LoadBalancerName: CLB instance name
        :type LoadBalancerName: str
        :param _Region: CLB instance region
        :type Region: str
        :param _Vip: CLB instance VIP
        :type Vip: str
        :param _OutBandwidth: Maximum outbound bandwidth in Mbps
        :type OutBandwidth: float
        :param _Domain: Specifies the CLB domain name.
        :type Domain: str
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._Region = None
        self._Vip = None
        self._OutBandwidth = None
        self._Domain = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""CLB instance name
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def Region(self):
        r"""CLB instance region
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Vip(self):
        r"""CLB instance VIP
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def OutBandwidth(self):
        r"""Maximum outbound bandwidth in Mbps
        :rtype: float
        """
        return self._OutBandwidth

    @OutBandwidth.setter
    def OutBandwidth(self, OutBandwidth):
        self._OutBandwidth = OutBandwidth

    @property
    def Domain(self):
        r"""Specifies the CLB domain name.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._Region = params.get("Region")
        self._Vip = params.get("Vip")
        self._OutBandwidth = params.get("OutBandwidth")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ManualRewriteRequest(AbstractModel):
    r"""ManualRewrite request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _SourceListenerId: Source listener ID
        :type SourceListenerId: str
        :param _TargetListenerId: Target listener ID
        :type TargetListenerId: str
        :param _RewriteInfos: Redirection relationship between forwarding rules
        :type RewriteInfos: list of RewriteLocationMap
        """
        self._LoadBalancerId = None
        self._SourceListenerId = None
        self._TargetListenerId = None
        self._RewriteInfos = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def SourceListenerId(self):
        r"""Source listener ID
        :rtype: str
        """
        return self._SourceListenerId

    @SourceListenerId.setter
    def SourceListenerId(self, SourceListenerId):
        self._SourceListenerId = SourceListenerId

    @property
    def TargetListenerId(self):
        r"""Target listener ID
        :rtype: str
        """
        return self._TargetListenerId

    @TargetListenerId.setter
    def TargetListenerId(self, TargetListenerId):
        self._TargetListenerId = TargetListenerId

    @property
    def RewriteInfos(self):
        r"""Redirection relationship between forwarding rules
        :rtype: list of RewriteLocationMap
        """
        return self._RewriteInfos

    @RewriteInfos.setter
    def RewriteInfos(self, RewriteInfos):
        self._RewriteInfos = RewriteInfos


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._SourceListenerId = params.get("SourceListenerId")
        self._TargetListenerId = params.get("TargetListenerId")
        if params.get("RewriteInfos") is not None:
            self._RewriteInfos = []
            for item in params.get("RewriteInfos"):
                obj = RewriteLocationMap()
                obj._deserialize(item)
                self._RewriteInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ManualRewriteResponse(AbstractModel):
    r"""ManualRewrite response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class MigrateClassicalLoadBalancersRequest(AbstractModel):
    r"""MigrateClassicalLoadBalancers request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerIds: Array of classic CLB instance IDs
        :type LoadBalancerIds: list of str
        :param _ExclusiveCluster: Exclusive cluster information
        :type ExclusiveCluster: :class:`tencentcloud.clb.v20180317.models.ExclusiveCluster`
        """
        self._LoadBalancerIds = None
        self._ExclusiveCluster = None

    @property
    def LoadBalancerIds(self):
        r"""Array of classic CLB instance IDs
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds

    @property
    def ExclusiveCluster(self):
        r"""Exclusive cluster information
        :rtype: :class:`tencentcloud.clb.v20180317.models.ExclusiveCluster`
        """
        return self._ExclusiveCluster

    @ExclusiveCluster.setter
    def ExclusiveCluster(self, ExclusiveCluster):
        self._ExclusiveCluster = ExclusiveCluster


    def _deserialize(self, params):
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        if params.get("ExclusiveCluster") is not None:
            self._ExclusiveCluster = ExclusiveCluster()
            self._ExclusiveCluster._deserialize(params.get("ExclusiveCluster"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MigrateClassicalLoadBalancersResponse(AbstractModel):
    r"""MigrateClassicalLoadBalancers response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyBlockIPListRequest(AbstractModel):
    r"""ModifyBlockIPList request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerIds: CLB instance ID
        :type LoadBalancerIds: list of str
        :param _Type: Operation type. Valid values:
<li> add_customized_field (sets header initially to enable the blocklist feature)</li>
<li> set_customized_field (modifies header)</li>
<li> del_customized_field (deletes header)</li>
<li> add_blocked (adds IPs to blocklist)</li>
<li> del_blocked (deletes IPs from blocklist)</li>
<li> flush_blocked (clears blocklist)</li>
        :type Type: str
        :param _ClientIPField: Header field that stores real client IPs
        :type ClientIPField: str
        :param _BlockIPList: List of blocked IPs. The array can contain up to 200,000 entries in one operation.
        :type BlockIPList: list of str
        :param _ExpireTime: Expiration time in seconds. Default value: 3600
        :type ExpireTime: int
        :param _AddStrategy: IP adding policy. Valid value: fifo (if a blocklist is full, new IPs added to the blocklist will adopt the first-in first-out policy)
        :type AddStrategy: str
        """
        self._LoadBalancerIds = None
        self._Type = None
        self._ClientIPField = None
        self._BlockIPList = None
        self._ExpireTime = None
        self._AddStrategy = None

    @property
    def LoadBalancerIds(self):
        r"""CLB instance ID
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds

    @property
    def Type(self):
        r"""Operation type. Valid values:
<li> add_customized_field (sets header initially to enable the blocklist feature)</li>
<li> set_customized_field (modifies header)</li>
<li> del_customized_field (deletes header)</li>
<li> add_blocked (adds IPs to blocklist)</li>
<li> del_blocked (deletes IPs from blocklist)</li>
<li> flush_blocked (clears blocklist)</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClientIPField(self):
        r"""Header field that stores real client IPs
        :rtype: str
        """
        return self._ClientIPField

    @ClientIPField.setter
    def ClientIPField(self, ClientIPField):
        self._ClientIPField = ClientIPField

    @property
    def BlockIPList(self):
        r"""List of blocked IPs. The array can contain up to 200,000 entries in one operation.
        :rtype: list of str
        """
        return self._BlockIPList

    @BlockIPList.setter
    def BlockIPList(self, BlockIPList):
        self._BlockIPList = BlockIPList

    @property
    def ExpireTime(self):
        r"""Expiration time in seconds. Default value: 3600
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def AddStrategy(self):
        r"""IP adding policy. Valid value: fifo (if a blocklist is full, new IPs added to the blocklist will adopt the first-in first-out policy)
        :rtype: str
        """
        return self._AddStrategy

    @AddStrategy.setter
    def AddStrategy(self, AddStrategy):
        self._AddStrategy = AddStrategy


    def _deserialize(self, params):
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        self._Type = params.get("Type")
        self._ClientIPField = params.get("ClientIPField")
        self._BlockIPList = params.get("BlockIPList")
        self._ExpireTime = params.get("ExpireTime")
        self._AddStrategy = params.get("AddStrategy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBlockIPListResponse(AbstractModel):
    r"""ModifyBlockIPList response structure.

    """

    def __init__(self):
        r"""
        :param _JodId: Async task ID
        :type JodId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JodId = None
        self._RequestId = None

    @property
    def JodId(self):
        r"""Async task ID
        :rtype: str
        """
        return self._JodId

    @JodId.setter
    def JodId(self, JodId):
        self._JodId = JodId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JodId = params.get("JodId")
        self._RequestId = params.get("RequestId")


class ModifyCustomizedConfigRequest(AbstractModel):
    r"""ModifyCustomizedConfig request structure.

    """

    def __init__(self):
        r"""
        :param _ConfigName: Configuration name
        :type ConfigName: str
        :param _UconfigId: Configuration ID.
        :type UconfigId: str
        :param _ConfigContent: Specifies the configuration content.
        :type ConfigContent: str
        """
        self._ConfigName = None
        self._UconfigId = None
        self._ConfigContent = None

    @property
    def ConfigName(self):
        r"""Configuration name
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def UconfigId(self):
        r"""Configuration ID.
        :rtype: str
        """
        return self._UconfigId

    @UconfigId.setter
    def UconfigId(self, UconfigId):
        self._UconfigId = UconfigId

    @property
    def ConfigContent(self):
        r"""Specifies the configuration content.
        :rtype: str
        """
        return self._ConfigContent

    @ConfigContent.setter
    def ConfigContent(self, ConfigContent):
        self._ConfigContent = ConfigContent


    def _deserialize(self, params):
        self._ConfigName = params.get("ConfigName")
        self._UconfigId = params.get("UconfigId")
        self._ConfigContent = params.get("ConfigContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomizedConfigResponse(AbstractModel):
    r"""ModifyCustomizedConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyDomainAttributesRequest(AbstractModel):
    r"""ModifyDomainAttributes request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the CLB instance. You can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        :param _ListenerId: ID of the CLB instance listener. You can call the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) API to query the ID.
        :type ListenerId: str
        :param _Domain: Domain name (must be a domain name under a created forwarding rule). if it is multiple domains, you can specify any one of the domain name list. it can be accessed through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :type Domain: str
        :param _NewDomain: The one domain name to modify. `NewDomain` and `NewDomains` can not be both specified.
        :type NewDomain: str
        :param _Certificate: Certificate information of the domain name. It is only applicable to listeners with SNI enabled. `Certificate` and `MultiCertInfo` cannot be specified at the same time. 
        :type Certificate: :class:`tencentcloud.clb.v20180317.models.CertificateInput`
        :param _Http2: Specifies whether to enable HTTP/2. note that only HTTPS domain names support HTTP/2.
True: enable HTTP2. false: disable HTTP2.
        :type Http2: bool
        :param _DefaultServer: Whether to set as the default domain name. Note: Only one default domain name can be set under a listener.
True: set as default domain name. false: do not set as default domain name.
        :type DefaultServer: bool
        :param _Quic: Specifies whether QUIC is enabled. note that QUIC can only be enabled for HTTPS domains.
True: enable QUIC. False: disable.
        :type Quic: bool
        :param _NewDefaultServerDomain: Specifies a new default domain name for the listener. This field is used when the original default domain name is disabled. If there are multiple domain names, specify one of them.
        :type NewDefaultServerDomain: str
        :param _NewDomains: The new domain names to modify. `NewDomain` and `NewDomains` can not be both specified.
        :type NewDomains: list of str
        :param _MultiCertInfo: Certificate information related to the domain name. Note: This applies only to listeners with SNI enabled. Multiple server certificates with different algorithm types can be input simultaneously, but this parameter cannot be input together with the Certificate.
        :type MultiCertInfo: :class:`tencentcloud.clb.v20180317.models.MultiCertInfo`
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._Domain = None
        self._NewDomain = None
        self._Certificate = None
        self._Http2 = None
        self._DefaultServer = None
        self._Quic = None
        self._NewDefaultServerDomain = None
        self._NewDomains = None
        self._MultiCertInfo = None

    @property
    def LoadBalancerId(self):
        r"""ID of the CLB instance. You can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""ID of the CLB instance listener. You can call the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Domain(self):
        r"""Domain name (must be a domain name under a created forwarding rule). if it is multiple domains, you can specify any one of the domain name list. it can be accessed through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def NewDomain(self):
        r"""The one domain name to modify. `NewDomain` and `NewDomains` can not be both specified.
        :rtype: str
        """
        return self._NewDomain

    @NewDomain.setter
    def NewDomain(self, NewDomain):
        self._NewDomain = NewDomain

    @property
    def Certificate(self):
        r"""Certificate information of the domain name. It is only applicable to listeners with SNI enabled. `Certificate` and `MultiCertInfo` cannot be specified at the same time. 
        :rtype: :class:`tencentcloud.clb.v20180317.models.CertificateInput`
        """
        return self._Certificate

    @Certificate.setter
    def Certificate(self, Certificate):
        self._Certificate = Certificate

    @property
    def Http2(self):
        r"""Specifies whether to enable HTTP/2. note that only HTTPS domain names support HTTP/2.
True: enable HTTP2. false: disable HTTP2.
        :rtype: bool
        """
        return self._Http2

    @Http2.setter
    def Http2(self, Http2):
        self._Http2 = Http2

    @property
    def DefaultServer(self):
        r"""Whether to set as the default domain name. Note: Only one default domain name can be set under a listener.
True: set as default domain name. false: do not set as default domain name.
        :rtype: bool
        """
        return self._DefaultServer

    @DefaultServer.setter
    def DefaultServer(self, DefaultServer):
        self._DefaultServer = DefaultServer

    @property
    def Quic(self):
        r"""Specifies whether QUIC is enabled. note that QUIC can only be enabled for HTTPS domains.
True: enable QUIC. False: disable.
        :rtype: bool
        """
        return self._Quic

    @Quic.setter
    def Quic(self, Quic):
        self._Quic = Quic

    @property
    def NewDefaultServerDomain(self):
        r"""Specifies a new default domain name for the listener. This field is used when the original default domain name is disabled. If there are multiple domain names, specify one of them.
        :rtype: str
        """
        return self._NewDefaultServerDomain

    @NewDefaultServerDomain.setter
    def NewDefaultServerDomain(self, NewDefaultServerDomain):
        self._NewDefaultServerDomain = NewDefaultServerDomain

    @property
    def NewDomains(self):
        r"""The new domain names to modify. `NewDomain` and `NewDomains` can not be both specified.
        :rtype: list of str
        """
        return self._NewDomains

    @NewDomains.setter
    def NewDomains(self, NewDomains):
        self._NewDomains = NewDomains

    @property
    def MultiCertInfo(self):
        r"""Certificate information related to the domain name. Note: This applies only to listeners with SNI enabled. Multiple server certificates with different algorithm types can be input simultaneously, but this parameter cannot be input together with the Certificate.
        :rtype: :class:`tencentcloud.clb.v20180317.models.MultiCertInfo`
        """
        return self._MultiCertInfo

    @MultiCertInfo.setter
    def MultiCertInfo(self, MultiCertInfo):
        self._MultiCertInfo = MultiCertInfo


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        self._Domain = params.get("Domain")
        self._NewDomain = params.get("NewDomain")
        if params.get("Certificate") is not None:
            self._Certificate = CertificateInput()
            self._Certificate._deserialize(params.get("Certificate"))
        self._Http2 = params.get("Http2")
        self._DefaultServer = params.get("DefaultServer")
        self._Quic = params.get("Quic")
        self._NewDefaultServerDomain = params.get("NewDefaultServerDomain")
        self._NewDomains = params.get("NewDomains")
        if params.get("MultiCertInfo") is not None:
            self._MultiCertInfo = MultiCertInfo()
            self._MultiCertInfo._deserialize(params.get("MultiCertInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDomainAttributesResponse(AbstractModel):
    r"""ModifyDomainAttributes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyDomainRequest(AbstractModel):
    r"""ModifyDomain request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        :param _ListenerId: ID of the clb listener. you can call the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) API to query the ID.
        :type ListenerId: str
        :param _Domain: An existing domain under the listener, can be queried through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :type Domain: str
        :param _NewDomain: New domain name. 	Length limit: 1-120. There are three usage formats: non-regular expression, wildcard, and regular expression. A non-regular expression can only contain letters, digits, "-", and ".". In a wildcard, "*" can only be at the beginning or the end. A regular expressions must begin with a "~".
        :type NewDomain: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._Domain = None
        self._NewDomain = None

    @property
    def LoadBalancerId(self):
        r"""ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""ID of the clb listener. you can call the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Domain(self):
        r"""An existing domain under the listener, can be queried through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def NewDomain(self):
        r"""New domain name. 	Length limit: 1-120. There are three usage formats: non-regular expression, wildcard, and regular expression. A non-regular expression can only contain letters, digits, "-", and ".". In a wildcard, "*" can only be at the beginning or the end. A regular expressions must begin with a "~".
        :rtype: str
        """
        return self._NewDomain

    @NewDomain.setter
    def NewDomain(self, NewDomain):
        self._NewDomain = NewDomain


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        self._Domain = params.get("Domain")
        self._NewDomain = params.get("NewDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDomainResponse(AbstractModel):
    r"""ModifyDomain response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyFunctionTargetsRequest(AbstractModel):
    r"""ModifyFunctionTargets request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _ListenerId: CLB listener ID
        :type ListenerId: str
        :param _FunctionTargets: Specifies the backend SCF service list to modify. only Event function type is supported.
        :type FunctionTargets: list of FunctionTarget
        :param _LocationId: Forwarding rule ID. When binding a real server to a layer-7 forwarding rule, you must provide either this parameter or `Domain`+`Url`.
        :type LocationId: str
        :param _Domain: Target rule domain name. This parameter does not take effect if `LocationId` is specified.
        :type Domain: str
        :param _Url: Target rule URL. This parameter does not take effect if `LocationId` is specified.
        :type Url: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._FunctionTargets = None
        self._LocationId = None
        self._Domain = None
        self._Url = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""CLB listener ID
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def FunctionTargets(self):
        r"""Specifies the backend SCF service list to modify. only Event function type is supported.
        :rtype: list of FunctionTarget
        """
        return self._FunctionTargets

    @FunctionTargets.setter
    def FunctionTargets(self, FunctionTargets):
        self._FunctionTargets = FunctionTargets

    @property
    def LocationId(self):
        r"""Forwarding rule ID. When binding a real server to a layer-7 forwarding rule, you must provide either this parameter or `Domain`+`Url`.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Target rule domain name. This parameter does not take effect if `LocationId` is specified.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""Target rule URL. This parameter does not take effect if `LocationId` is specified.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        if params.get("FunctionTargets") is not None:
            self._FunctionTargets = []
            for item in params.get("FunctionTargets"):
                obj = FunctionTarget()
                obj._deserialize(item)
                self._FunctionTargets.append(obj)
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyFunctionTargetsResponse(AbstractModel):
    r"""ModifyFunctionTargets response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyListenerRequest(AbstractModel):
    r"""ModifyListener request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the CLB instance. You can call the [DescribeLoadBalancers](https://intl.cloud.tencent.com/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        :param _ListenerId: ID of the CLB instance listener. You can call the [DescribeListeners](https://intl.cloud.tencent.com/document/product/214/30686?from_cn_redirect=1) API to query the ID.
        :type ListenerId: str
        :param _ListenerName: New listener name. The maximum length is 255 characters.
        :type ListenerName: str
        :param _SessionExpireTime: Session persistence time in seconds. Value range: 30-3,600. The default value is 0, indicating that session persistence is not enabled. This parameter is applicable only to TCP/UDP listeners.
        :type SessionExpireTime: int
        :param _HealthCheck: Health check parameter. It is only applicable only to TCP, UDP, TCP_SSL and QUIC listeners.
        :type HealthCheck: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        :param _Certificate: Certificate information. This parameter is only applicable to HTTPS/TCP_SSL/QUIC listeners. `Certificate` and `MultiCertInfo` cannot be both specified.
        :type Certificate: :class:`tencentcloud.clb.v20180317.models.CertificateInput`
        :param _Scheduler: Listener forwarding method. Valid values: WRR (weighted round-robin), LEAST_CONN (least connections), and IP_HASH (IP address hash).
They indicate weighted round-robin and least connections, respectively. Default value: WRR.
Use cases: This applies to TCP/UDP/TCP_SSL/QUIC listeners. The balancing method for Layer-7 listeners should be modified in the forwarding rules.
        :type Scheduler: str
        :param _SniSwitch: Whether to enable the SNI feature. This parameter applies only to HTTPS listeners. The default value is 0, indicating disabled, and 1 indicates enabled. Note: The SNI feature can be enabled for listeners that have not enabled SNI, but cannot be disabled for listeners that have enabled SNI.
        :type SniSwitch: int
        :param _TargetType: Target backend type. `NODE`: A single node; `TARGETGROUP`: A target group.
        :type TargetType: str
        :param _KeepaliveEnable: Whether to enable the persistent connection feature. This parameter applies only to HTTP/HTTPS listeners.
The default value is 0, indicating disabled, and 1 indicates enabled.

Enable this feature with caution if the maximum number of connections is limited for real servers. This feature is in beta testing. To use it, submit a [beta testing application](https://intl.cloud.tencent.com/apply/p/tsodp6qm21?from_cn_redirect=1).
        :type KeepaliveEnable: int
        :param _DeregisterTargetRst: Reschedules when unbinding real servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :type DeregisterTargetRst: bool
        :param _SessionType: Session persistence type. NORMAL: default session persistence type; QUIC_CID: perform session persistence based on QUIC connection ID. If the value is set to QUIC_CID, only the UDP protocol is supported.
Use cases: This applies to TCP/UDP/TCP_SSL/QUIC listeners.

Default value: NORMAL.
        :type SessionType: str
        :param _MultiCertInfo: Certificate information. You can specify multiple server-side certificates with different algorithm types. This parameter is only applicable to HTTPS listeners with the SNI feature not enabled. `Certificate` and `MultiCertInfo` cannot be specified at the same time. 
        :type MultiCertInfo: :class:`tencentcloud.clb.v20180317.models.MultiCertInfo`
        :param _MaxConn: Maximum number of concurrent connections at the listener level. This parameter is supported only for LCU-supported instances with TCP/UDP/TCP_SSL/QUIC listeners currently. Value range: 1 to the maximum number of concurrent connections for the instance specification. -1 indicates that no limit is set on the concurrent connections at the listener level. Classic network instances do not support this parameter.

Default value: -1, which indicates no limit.
        :type MaxConn: int
        :param _MaxCps: Maximum number of new connections at the listener level. This parameter is supported only for LCU-supported instances with TCP/UDP/TCP_SSL/QUIC listeners currently. Value range: 1 to the maximum number of new connections for the instance specification. -1 indicates that no limit is set on the new connections at the listener level. Classic network instances do not support this parameter.

Default value: -1, which indicates no limit.
        :type MaxCps: int
        :param _IdleConnectTimeout: Specifies the idle connection timeout in seconds. this parameter applies only to TCP/UDP listeners. default value: 900 for TCP listeners and 300 for UDP listeners. value range: 10–900 for shared instances and dedicated instances and 10–1980 for lcu-supported instances. to set a value exceeding 1980, [submit a ticket application](https://console.cloud.tencent.com/workorder/category). the maximum settable value is 3600.
        :type IdleConnectTimeout: int
        :param _ProxyProtocol: Specifies whether PP is supported for TCP_SSL and QUIC.
        :type ProxyProtocol: bool
        :param _SnatEnable: Whether SNAT (source IP replacement) is enabled. valid values: True (enabled), False (disabled). disabled by default. note: when SnatEnable is enabled, the client source IP will be replaced, at this point the `pass through client source IP` option is disabled, and vice versa.
        :type SnatEnable: bool
        :param _DataCompressMode: Data compression mode.
        :type DataCompressMode: str
        :param _RescheduleTargetZeroWeight: Reschedules when setting backend server weight to 0. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :type RescheduleTargetZeroWeight: bool
        :param _RescheduleUnhealthy: Reschedules when health check exceptions occur on real servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :type RescheduleUnhealthy: bool
        :param _RescheduleExpandTarget: Reschedules when adding or removing backend servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :type RescheduleExpandTarget: bool
        :param _RescheduleStartTime: Specifies the trigger start time for rescheduling. value range: 0-3600s. supported only by TCP/UDP listeners.
        :type RescheduleStartTime: int
        :param _RescheduleInterval: Rescheduling trigger duration. valid values: 0-3600s. only TCP/UDP listeners support this.
        :type RescheduleInterval: int
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._ListenerName = None
        self._SessionExpireTime = None
        self._HealthCheck = None
        self._Certificate = None
        self._Scheduler = None
        self._SniSwitch = None
        self._TargetType = None
        self._KeepaliveEnable = None
        self._DeregisterTargetRst = None
        self._SessionType = None
        self._MultiCertInfo = None
        self._MaxConn = None
        self._MaxCps = None
        self._IdleConnectTimeout = None
        self._ProxyProtocol = None
        self._SnatEnable = None
        self._DataCompressMode = None
        self._RescheduleTargetZeroWeight = None
        self._RescheduleUnhealthy = None
        self._RescheduleExpandTarget = None
        self._RescheduleStartTime = None
        self._RescheduleInterval = None

    @property
    def LoadBalancerId(self):
        r"""ID of the CLB instance. You can call the [DescribeLoadBalancers](https://intl.cloud.tencent.com/document/product/214/30685?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""ID of the CLB instance listener. You can call the [DescribeListeners](https://intl.cloud.tencent.com/document/product/214/30686?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def ListenerName(self):
        r"""New listener name. The maximum length is 255 characters.
        :rtype: str
        """
        return self._ListenerName

    @ListenerName.setter
    def ListenerName(self, ListenerName):
        self._ListenerName = ListenerName

    @property
    def SessionExpireTime(self):
        r"""Session persistence time in seconds. Value range: 30-3,600. The default value is 0, indicating that session persistence is not enabled. This parameter is applicable only to TCP/UDP listeners.
        :rtype: int
        """
        return self._SessionExpireTime

    @SessionExpireTime.setter
    def SessionExpireTime(self, SessionExpireTime):
        self._SessionExpireTime = SessionExpireTime

    @property
    def HealthCheck(self):
        r"""Health check parameter. It is only applicable only to TCP, UDP, TCP_SSL and QUIC listeners.
        :rtype: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def Certificate(self):
        r"""Certificate information. This parameter is only applicable to HTTPS/TCP_SSL/QUIC listeners. `Certificate` and `MultiCertInfo` cannot be both specified.
        :rtype: :class:`tencentcloud.clb.v20180317.models.CertificateInput`
        """
        return self._Certificate

    @Certificate.setter
    def Certificate(self, Certificate):
        self._Certificate = Certificate

    @property
    def Scheduler(self):
        r"""Listener forwarding method. Valid values: WRR (weighted round-robin), LEAST_CONN (least connections), and IP_HASH (IP address hash).
They indicate weighted round-robin and least connections, respectively. Default value: WRR.
Use cases: This applies to TCP/UDP/TCP_SSL/QUIC listeners. The balancing method for Layer-7 listeners should be modified in the forwarding rules.
        :rtype: str
        """
        return self._Scheduler

    @Scheduler.setter
    def Scheduler(self, Scheduler):
        self._Scheduler = Scheduler

    @property
    def SniSwitch(self):
        r"""Whether to enable the SNI feature. This parameter applies only to HTTPS listeners. The default value is 0, indicating disabled, and 1 indicates enabled. Note: The SNI feature can be enabled for listeners that have not enabled SNI, but cannot be disabled for listeners that have enabled SNI.
        :rtype: int
        """
        return self._SniSwitch

    @SniSwitch.setter
    def SniSwitch(self, SniSwitch):
        self._SniSwitch = SniSwitch

    @property
    def TargetType(self):
        r"""Target backend type. `NODE`: A single node; `TARGETGROUP`: A target group.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def KeepaliveEnable(self):
        r"""Whether to enable the persistent connection feature. This parameter applies only to HTTP/HTTPS listeners.
The default value is 0, indicating disabled, and 1 indicates enabled.

Enable this feature with caution if the maximum number of connections is limited for real servers. This feature is in beta testing. To use it, submit a [beta testing application](https://intl.cloud.tencent.com/apply/p/tsodp6qm21?from_cn_redirect=1).
        :rtype: int
        """
        return self._KeepaliveEnable

    @KeepaliveEnable.setter
    def KeepaliveEnable(self, KeepaliveEnable):
        self._KeepaliveEnable = KeepaliveEnable

    @property
    def DeregisterTargetRst(self):
        r"""Reschedules when unbinding real servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :rtype: bool
        """
        return self._DeregisterTargetRst

    @DeregisterTargetRst.setter
    def DeregisterTargetRst(self, DeregisterTargetRst):
        self._DeregisterTargetRst = DeregisterTargetRst

    @property
    def SessionType(self):
        r"""Session persistence type. NORMAL: default session persistence type; QUIC_CID: perform session persistence based on QUIC connection ID. If the value is set to QUIC_CID, only the UDP protocol is supported.
Use cases: This applies to TCP/UDP/TCP_SSL/QUIC listeners.

Default value: NORMAL.
        :rtype: str
        """
        return self._SessionType

    @SessionType.setter
    def SessionType(self, SessionType):
        self._SessionType = SessionType

    @property
    def MultiCertInfo(self):
        r"""Certificate information. You can specify multiple server-side certificates with different algorithm types. This parameter is only applicable to HTTPS listeners with the SNI feature not enabled. `Certificate` and `MultiCertInfo` cannot be specified at the same time. 
        :rtype: :class:`tencentcloud.clb.v20180317.models.MultiCertInfo`
        """
        return self._MultiCertInfo

    @MultiCertInfo.setter
    def MultiCertInfo(self, MultiCertInfo):
        self._MultiCertInfo = MultiCertInfo

    @property
    def MaxConn(self):
        r"""Maximum number of concurrent connections at the listener level. This parameter is supported only for LCU-supported instances with TCP/UDP/TCP_SSL/QUIC listeners currently. Value range: 1 to the maximum number of concurrent connections for the instance specification. -1 indicates that no limit is set on the concurrent connections at the listener level. Classic network instances do not support this parameter.

Default value: -1, which indicates no limit.
        :rtype: int
        """
        return self._MaxConn

    @MaxConn.setter
    def MaxConn(self, MaxConn):
        self._MaxConn = MaxConn

    @property
    def MaxCps(self):
        r"""Maximum number of new connections at the listener level. This parameter is supported only for LCU-supported instances with TCP/UDP/TCP_SSL/QUIC listeners currently. Value range: 1 to the maximum number of new connections for the instance specification. -1 indicates that no limit is set on the new connections at the listener level. Classic network instances do not support this parameter.

Default value: -1, which indicates no limit.
        :rtype: int
        """
        return self._MaxCps

    @MaxCps.setter
    def MaxCps(self, MaxCps):
        self._MaxCps = MaxCps

    @property
    def IdleConnectTimeout(self):
        r"""Specifies the idle connection timeout in seconds. this parameter applies only to TCP/UDP listeners. default value: 900 for TCP listeners and 300 for UDP listeners. value range: 10–900 for shared instances and dedicated instances and 10–1980 for lcu-supported instances. to set a value exceeding 1980, [submit a ticket application](https://console.cloud.tencent.com/workorder/category). the maximum settable value is 3600.
        :rtype: int
        """
        return self._IdleConnectTimeout

    @IdleConnectTimeout.setter
    def IdleConnectTimeout(self, IdleConnectTimeout):
        self._IdleConnectTimeout = IdleConnectTimeout

    @property
    def ProxyProtocol(self):
        r"""Specifies whether PP is supported for TCP_SSL and QUIC.
        :rtype: bool
        """
        return self._ProxyProtocol

    @ProxyProtocol.setter
    def ProxyProtocol(self, ProxyProtocol):
        self._ProxyProtocol = ProxyProtocol

    @property
    def SnatEnable(self):
        r"""Whether SNAT (source IP replacement) is enabled. valid values: True (enabled), False (disabled). disabled by default. note: when SnatEnable is enabled, the client source IP will be replaced, at this point the `pass through client source IP` option is disabled, and vice versa.
        :rtype: bool
        """
        return self._SnatEnable

    @SnatEnable.setter
    def SnatEnable(self, SnatEnable):
        self._SnatEnable = SnatEnable

    @property
    def DataCompressMode(self):
        r"""Data compression mode.
        :rtype: str
        """
        return self._DataCompressMode

    @DataCompressMode.setter
    def DataCompressMode(self, DataCompressMode):
        self._DataCompressMode = DataCompressMode

    @property
    def RescheduleTargetZeroWeight(self):
        r"""Reschedules when setting backend server weight to 0. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :rtype: bool
        """
        return self._RescheduleTargetZeroWeight

    @RescheduleTargetZeroWeight.setter
    def RescheduleTargetZeroWeight(self, RescheduleTargetZeroWeight):
        self._RescheduleTargetZeroWeight = RescheduleTargetZeroWeight

    @property
    def RescheduleUnhealthy(self):
        r"""Reschedules when health check exceptions occur on real servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :rtype: bool
        """
        return self._RescheduleUnhealthy

    @RescheduleUnhealthy.setter
    def RescheduleUnhealthy(self, RescheduleUnhealthy):
        self._RescheduleUnhealthy = RescheduleUnhealthy

    @property
    def RescheduleExpandTarget(self):
        r"""Reschedules when adding or removing backend servers. only supported for TCP/UDP listeners. toggle on to enable this feature.
        :rtype: bool
        """
        return self._RescheduleExpandTarget

    @RescheduleExpandTarget.setter
    def RescheduleExpandTarget(self, RescheduleExpandTarget):
        self._RescheduleExpandTarget = RescheduleExpandTarget

    @property
    def RescheduleStartTime(self):
        r"""Specifies the trigger start time for rescheduling. value range: 0-3600s. supported only by TCP/UDP listeners.
        :rtype: int
        """
        return self._RescheduleStartTime

    @RescheduleStartTime.setter
    def RescheduleStartTime(self, RescheduleStartTime):
        self._RescheduleStartTime = RescheduleStartTime

    @property
    def RescheduleInterval(self):
        r"""Rescheduling trigger duration. valid values: 0-3600s. only TCP/UDP listeners support this.
        :rtype: int
        """
        return self._RescheduleInterval

    @RescheduleInterval.setter
    def RescheduleInterval(self, RescheduleInterval):
        self._RescheduleInterval = RescheduleInterval


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        self._ListenerName = params.get("ListenerName")
        self._SessionExpireTime = params.get("SessionExpireTime")
        if params.get("HealthCheck") is not None:
            self._HealthCheck = HealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        if params.get("Certificate") is not None:
            self._Certificate = CertificateInput()
            self._Certificate._deserialize(params.get("Certificate"))
        self._Scheduler = params.get("Scheduler")
        self._SniSwitch = params.get("SniSwitch")
        self._TargetType = params.get("TargetType")
        self._KeepaliveEnable = params.get("KeepaliveEnable")
        self._DeregisterTargetRst = params.get("DeregisterTargetRst")
        self._SessionType = params.get("SessionType")
        if params.get("MultiCertInfo") is not None:
            self._MultiCertInfo = MultiCertInfo()
            self._MultiCertInfo._deserialize(params.get("MultiCertInfo"))
        self._MaxConn = params.get("MaxConn")
        self._MaxCps = params.get("MaxCps")
        self._IdleConnectTimeout = params.get("IdleConnectTimeout")
        self._ProxyProtocol = params.get("ProxyProtocol")
        self._SnatEnable = params.get("SnatEnable")
        self._DataCompressMode = params.get("DataCompressMode")
        self._RescheduleTargetZeroWeight = params.get("RescheduleTargetZeroWeight")
        self._RescheduleUnhealthy = params.get("RescheduleUnhealthy")
        self._RescheduleExpandTarget = params.get("RescheduleExpandTarget")
        self._RescheduleStartTime = params.get("RescheduleStartTime")
        self._RescheduleInterval = params.get("RescheduleInterval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyListenerResponse(AbstractModel):
    r"""ModifyListener response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLoadBalancerAttributesRequest(AbstractModel):
    r"""ModifyLoadBalancerAttributes request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: Specifies the unique ID of the cloud load balancer. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to obtain the ID.
        :type LoadBalancerId: str
        :param _LoadBalancerName: Load balancing instance name. rule: 1-60 english letters, chinese characters, digits, hyphens "-", or underscores "_".
        :type LoadBalancerName: str
        :param _TargetRegionInfo: The backend service information of cross-region binding 1.0
        :type TargetRegionInfo: :class:`tencentcloud.clb.v20180317.models.TargetRegionInfo`
        :param _InternetChargeInfo: Network billing parameter
        :type InternetChargeInfo: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        :param _LoadBalancerPassToTarget: Specifies whether to allow CLB traffic to the Target.
Enable pass-through (true): verify security groups on CLB only.
Denies CLB traffic to the target (false): verify security groups on both CLB and backend instances.
Specifies no modification if left blank.
        :type LoadBalancerPassToTarget: bool
        :param _SnatPro: Specifies whether the cross-region binding 2.0 feature is enabled. leave blank for no modification.
        :type SnatPro: bool
        :param _DeleteProtect: Specifies whether to enable deletion protection. leave it blank to keep the current setting.
        :type DeleteProtect: bool
        :param _ModifyClassicDomain: Modifies the second-level domain name of cloud load balancer from mycloud.com to tencentclb.com. the subdomain will be transformed, and the mycloud.com domain name will become invalid after modification. leave it blank if no modification is required.
        :type ModifyClassicDomain: bool
        :param _AssociateEndpoint: The associated endpoint Id, which can be queried via the [DescribeVpcEndPoint](https://www.tencentcloud.comom/document/product/215/54679?from_cn_redirect=1) api. input an empty string to unbind.
        :type AssociateEndpoint: str
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._TargetRegionInfo = None
        self._InternetChargeInfo = None
        self._LoadBalancerPassToTarget = None
        self._SnatPro = None
        self._DeleteProtect = None
        self._ModifyClassicDomain = None
        self._AssociateEndpoint = None

    @property
    def LoadBalancerId(self):
        r"""Specifies the unique ID of the cloud load balancer. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to obtain the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""Load balancing instance name. rule: 1-60 english letters, chinese characters, digits, hyphens "-", or underscores "_".
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def TargetRegionInfo(self):
        r"""The backend service information of cross-region binding 1.0
        :rtype: :class:`tencentcloud.clb.v20180317.models.TargetRegionInfo`
        """
        return self._TargetRegionInfo

    @TargetRegionInfo.setter
    def TargetRegionInfo(self, TargetRegionInfo):
        self._TargetRegionInfo = TargetRegionInfo

    @property
    def InternetChargeInfo(self):
        r"""Network billing parameter
        :rtype: :class:`tencentcloud.clb.v20180317.models.InternetAccessible`
        """
        return self._InternetChargeInfo

    @InternetChargeInfo.setter
    def InternetChargeInfo(self, InternetChargeInfo):
        self._InternetChargeInfo = InternetChargeInfo

    @property
    def LoadBalancerPassToTarget(self):
        r"""Specifies whether to allow CLB traffic to the Target.
Enable pass-through (true): verify security groups on CLB only.
Denies CLB traffic to the target (false): verify security groups on both CLB and backend instances.
Specifies no modification if left blank.
        :rtype: bool
        """
        return self._LoadBalancerPassToTarget

    @LoadBalancerPassToTarget.setter
    def LoadBalancerPassToTarget(self, LoadBalancerPassToTarget):
        self._LoadBalancerPassToTarget = LoadBalancerPassToTarget

    @property
    def SnatPro(self):
        r"""Specifies whether the cross-region binding 2.0 feature is enabled. leave blank for no modification.
        :rtype: bool
        """
        return self._SnatPro

    @SnatPro.setter
    def SnatPro(self, SnatPro):
        self._SnatPro = SnatPro

    @property
    def DeleteProtect(self):
        r"""Specifies whether to enable deletion protection. leave it blank to keep the current setting.
        :rtype: bool
        """
        return self._DeleteProtect

    @DeleteProtect.setter
    def DeleteProtect(self, DeleteProtect):
        self._DeleteProtect = DeleteProtect

    @property
    def ModifyClassicDomain(self):
        r"""Modifies the second-level domain name of cloud load balancer from mycloud.com to tencentclb.com. the subdomain will be transformed, and the mycloud.com domain name will become invalid after modification. leave it blank if no modification is required.
        :rtype: bool
        """
        return self._ModifyClassicDomain

    @ModifyClassicDomain.setter
    def ModifyClassicDomain(self, ModifyClassicDomain):
        self._ModifyClassicDomain = ModifyClassicDomain

    @property
    def AssociateEndpoint(self):
        r"""The associated endpoint Id, which can be queried via the [DescribeVpcEndPoint](https://www.tencentcloud.comom/document/product/215/54679?from_cn_redirect=1) api. input an empty string to unbind.
        :rtype: str
        """
        return self._AssociateEndpoint

    @AssociateEndpoint.setter
    def AssociateEndpoint(self, AssociateEndpoint):
        self._AssociateEndpoint = AssociateEndpoint


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        if params.get("TargetRegionInfo") is not None:
            self._TargetRegionInfo = TargetRegionInfo()
            self._TargetRegionInfo._deserialize(params.get("TargetRegionInfo"))
        if params.get("InternetChargeInfo") is not None:
            self._InternetChargeInfo = InternetAccessible()
            self._InternetChargeInfo._deserialize(params.get("InternetChargeInfo"))
        self._LoadBalancerPassToTarget = params.get("LoadBalancerPassToTarget")
        self._SnatPro = params.get("SnatPro")
        self._DeleteProtect = params.get("DeleteProtect")
        self._ModifyClassicDomain = params.get("ModifyClassicDomain")
        self._AssociateEndpoint = params.get("AssociateEndpoint")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLoadBalancerAttributesResponse(AbstractModel):
    r"""ModifyLoadBalancerAttributes response structure.

    """

    def __init__(self):
        r"""
        :param _DealName: This parameter can be used to query whether CLB billing mode switch is successful.
Note: this field may return null, indicating that no valid values can be obtained.
        :type DealName: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DealName = None
        self._RequestId = None

    @property
    def DealName(self):
        r"""This parameter can be used to query whether CLB billing mode switch is successful.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DealName = params.get("DealName")
        self._RequestId = params.get("RequestId")


class ModifyLoadBalancerSlaRequest(AbstractModel):
    r"""ModifyLoadBalancerSla request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerSla: CLB instance information.
        :type LoadBalancerSla: list of SlaUpdateParam
        :param _Force: Whether to force upgrade. The default is no.
        :type Force: bool
        """
        self._LoadBalancerSla = None
        self._Force = None

    @property
    def LoadBalancerSla(self):
        r"""CLB instance information.
        :rtype: list of SlaUpdateParam
        """
        return self._LoadBalancerSla

    @LoadBalancerSla.setter
    def LoadBalancerSla(self, LoadBalancerSla):
        self._LoadBalancerSla = LoadBalancerSla

    @property
    def Force(self):
        r"""Whether to force upgrade. The default is no.
        :rtype: bool
        """
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        if params.get("LoadBalancerSla") is not None:
            self._LoadBalancerSla = []
            for item in params.get("LoadBalancerSla"):
                obj = SlaUpdateParam()
                obj._deserialize(item)
                self._LoadBalancerSla.append(obj)
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLoadBalancerSlaResponse(AbstractModel):
    r"""ModifyLoadBalancerSla response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLoadBalancersProjectRequest(AbstractModel):
    r"""ModifyLoadBalancersProject request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerIds: One or more load balancing instance ids to be operated. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ids.
Specifies the maximum length supported by the list is 20.
        :type LoadBalancerIds: list of str
        :param _ProjectId: Project ID. You can obtain it through the [DescribeProject](https://intl.cloud.tencent.com/document/api/651/78725?from_cn_redirect=1) API.
        :type ProjectId: int
        """
        self._LoadBalancerIds = None
        self._ProjectId = None

    @property
    def LoadBalancerIds(self):
        r"""One or more load balancing instance ids to be operated. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ids.
Specifies the maximum length supported by the list is 20.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds

    @property
    def ProjectId(self):
        r"""Project ID. You can obtain it through the [DescribeProject](https://intl.cloud.tencent.com/document/api/651/78725?from_cn_redirect=1) API.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLoadBalancersProjectResponse(AbstractModel):
    r"""ModifyLoadBalancersProject response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRuleRequest(AbstractModel):
    r"""ModifyRule request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the CLB instance. You can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to obtain the ID.
        :type LoadBalancerId: str
        :param _ListenerId: ID of the clb listener. can be obtained through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :type ListenerId: str
        :param _LocationId: Specifies the rule ID of the forwarding rule to be modified, which can be obtained through the DescribeListeners API (https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1).
        :type LocationId: str
        :param _Url: New forwarding path of the forwarding rule. This parameter is not required if the URL does not need to be modified.
        :type Url: str
        :param _HealthCheck: Health check information
        :type HealthCheck: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        :param _Scheduler: Request forwarding method of the rule. Value range: WRR, LEAST_CONN, IP_HASH
They represent weighted round robin, least connections, and IP hash, respectively. Default value: WRR.
        :type Scheduler: str
        :param _SessionExpireTime: Session persistence duration, in seconds. Value range: 0 or 30-86400.
Defaults to 0.
        :type SessionExpireTime: int
        :param _ForwardType: Forwarding protocol between a CLB instance and the real server. Default value: HTTP. Valid values: HTTP, HTTPS, GRPC. This parameter is valid only for HTTPS listeners.
        :type ForwardType: str
        :param _TrpcCallee: TRPC callee server route, which is required when `ForwardType` is "TRPC". This is now only for internal usage.
        :type TrpcCallee: str
        :param _TrpcFunc: TRPC calling service API, which is required when `ForwardType` is "TRPC". This is now only for internal usage.
        :type TrpcFunc: str
        :param _OAuth: OAuth configuration information.
        :type OAuth: :class:`tencentcloud.clb.v20180317.models.OAuth`
        :param _CookieName: Specifies the custom cookie name.
        :type CookieName: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._LocationId = None
        self._Url = None
        self._HealthCheck = None
        self._Scheduler = None
        self._SessionExpireTime = None
        self._ForwardType = None
        self._TrpcCallee = None
        self._TrpcFunc = None
        self._OAuth = None
        self._CookieName = None

    @property
    def LoadBalancerId(self):
        r"""ID of the CLB instance. You can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/214/30685?from_cn_redirect=1) API to obtain the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""ID of the clb listener. can be obtained through the [DescribeListeners](https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1) api.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def LocationId(self):
        r"""Specifies the rule ID of the forwarding rule to be modified, which can be obtained through the DescribeListeners API (https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1).
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Url(self):
        r"""New forwarding path of the forwarding rule. This parameter is not required if the URL does not need to be modified.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def HealthCheck(self):
        r"""Health check information
        :rtype: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def Scheduler(self):
        r"""Request forwarding method of the rule. Value range: WRR, LEAST_CONN, IP_HASH
They represent weighted round robin, least connections, and IP hash, respectively. Default value: WRR.
        :rtype: str
        """
        return self._Scheduler

    @Scheduler.setter
    def Scheduler(self, Scheduler):
        self._Scheduler = Scheduler

    @property
    def SessionExpireTime(self):
        r"""Session persistence duration, in seconds. Value range: 0 or 30-86400.
Defaults to 0.
        :rtype: int
        """
        return self._SessionExpireTime

    @SessionExpireTime.setter
    def SessionExpireTime(self, SessionExpireTime):
        self._SessionExpireTime = SessionExpireTime

    @property
    def ForwardType(self):
        r"""Forwarding protocol between a CLB instance and the real server. Default value: HTTP. Valid values: HTTP, HTTPS, GRPC. This parameter is valid only for HTTPS listeners.
        :rtype: str
        """
        return self._ForwardType

    @ForwardType.setter
    def ForwardType(self, ForwardType):
        self._ForwardType = ForwardType

    @property
    def TrpcCallee(self):
        r"""TRPC callee server route, which is required when `ForwardType` is "TRPC". This is now only for internal usage.
        :rtype: str
        """
        return self._TrpcCallee

    @TrpcCallee.setter
    def TrpcCallee(self, TrpcCallee):
        self._TrpcCallee = TrpcCallee

    @property
    def TrpcFunc(self):
        r"""TRPC calling service API, which is required when `ForwardType` is "TRPC". This is now only for internal usage.
        :rtype: str
        """
        return self._TrpcFunc

    @TrpcFunc.setter
    def TrpcFunc(self, TrpcFunc):
        self._TrpcFunc = TrpcFunc

    @property
    def OAuth(self):
        r"""OAuth configuration information.
        :rtype: :class:`tencentcloud.clb.v20180317.models.OAuth`
        """
        return self._OAuth

    @OAuth.setter
    def OAuth(self, OAuth):
        self._OAuth = OAuth

    @property
    def CookieName(self):
        r"""Specifies the custom cookie name.
        :rtype: str
        """
        return self._CookieName

    @CookieName.setter
    def CookieName(self, CookieName):
        self._CookieName = CookieName


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        self._LocationId = params.get("LocationId")
        self._Url = params.get("Url")
        if params.get("HealthCheck") is not None:
            self._HealthCheck = HealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        self._Scheduler = params.get("Scheduler")
        self._SessionExpireTime = params.get("SessionExpireTime")
        self._ForwardType = params.get("ForwardType")
        self._TrpcCallee = params.get("TrpcCallee")
        self._TrpcFunc = params.get("TrpcFunc")
        if params.get("OAuth") is not None:
            self._OAuth = OAuth()
            self._OAuth._deserialize(params.get("OAuth"))
        self._CookieName = params.get("CookieName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRuleResponse(AbstractModel):
    r"""ModifyRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyTargetGroupAttributeRequest(AbstractModel):
    r"""ModifyTargetGroupAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _TargetGroupName: New name of target group
        :type TargetGroupName: str
        :param _Port: The new default port of the target group. this parameter is not supported for full listen target groups.
        :type Port: int
        :param _ScheduleAlgorithm: Scheduling algorithm. this parameter is valid only for target groups of the new version V2 when the backend forwarding protocol is HTTP, HTTPS, or GRPC. available values:.
<ur><li>WRR: weighted round-robin.</li><li>LEAST_CONN: LEAST connection.</li><li>IP_HASH: based on IP HASH.</li><li>default is WRR.</li></ur>.
        :type ScheduleAlgorithm: str
        :param _HealthCheck: Health check details.
        :type HealthCheck: :class:`tencentcloud.clb.v20180317.models.TargetGroupHealthCheck`
        :param _Weight: Default Weight for backend service. among them: <ul><li>value ranges from 0 to 100.</li><li>after setting this value, when adding a backend service to the target group, if the backend service does not set Weight separately, use the default Weight here.</li><li>Weight parameter settings not supported for v1 target group type.</li></ul>.
        :type Weight: int
        :param _KeepaliveEnable: Specifies whether to enable the persistent connection feature. this parameter applies only to HTTP and HTTPS target groups. true: disable; false: enable. this feature is off by default.
        :type KeepaliveEnable: bool
        :param _SessionExpireTime: Specifies the session persistence time in seconds. value range: 30-3600. default: 0 (disabled). this parameter is unsupported for TCP/UDP target groups.
        :type SessionExpireTime: int
        """
        self._TargetGroupId = None
        self._TargetGroupName = None
        self._Port = None
        self._ScheduleAlgorithm = None
        self._HealthCheck = None
        self._Weight = None
        self._KeepaliveEnable = None
        self._SessionExpireTime = None

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def TargetGroupName(self):
        r"""New name of target group
        :rtype: str
        """
        return self._TargetGroupName

    @TargetGroupName.setter
    def TargetGroupName(self, TargetGroupName):
        self._TargetGroupName = TargetGroupName

    @property
    def Port(self):
        r"""The new default port of the target group. this parameter is not supported for full listen target groups.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def ScheduleAlgorithm(self):
        r"""Scheduling algorithm. this parameter is valid only for target groups of the new version V2 when the backend forwarding protocol is HTTP, HTTPS, or GRPC. available values:.
<ur><li>WRR: weighted round-robin.</li><li>LEAST_CONN: LEAST connection.</li><li>IP_HASH: based on IP HASH.</li><li>default is WRR.</li></ur>.
        :rtype: str
        """
        return self._ScheduleAlgorithm

    @ScheduleAlgorithm.setter
    def ScheduleAlgorithm(self, ScheduleAlgorithm):
        self._ScheduleAlgorithm = ScheduleAlgorithm

    @property
    def HealthCheck(self):
        r"""Health check details.
        :rtype: :class:`tencentcloud.clb.v20180317.models.TargetGroupHealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def Weight(self):
        r"""Default Weight for backend service. among them: <ul><li>value ranges from 0 to 100.</li><li>after setting this value, when adding a backend service to the target group, if the backend service does not set Weight separately, use the default Weight here.</li><li>Weight parameter settings not supported for v1 target group type.</li></ul>.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def KeepaliveEnable(self):
        r"""Specifies whether to enable the persistent connection feature. this parameter applies only to HTTP and HTTPS target groups. true: disable; false: enable. this feature is off by default.
        :rtype: bool
        """
        return self._KeepaliveEnable

    @KeepaliveEnable.setter
    def KeepaliveEnable(self, KeepaliveEnable):
        self._KeepaliveEnable = KeepaliveEnable

    @property
    def SessionExpireTime(self):
        r"""Specifies the session persistence time in seconds. value range: 30-3600. default: 0 (disabled). this parameter is unsupported for TCP/UDP target groups.
        :rtype: int
        """
        return self._SessionExpireTime

    @SessionExpireTime.setter
    def SessionExpireTime(self, SessionExpireTime):
        self._SessionExpireTime = SessionExpireTime


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        self._TargetGroupName = params.get("TargetGroupName")
        self._Port = params.get("Port")
        self._ScheduleAlgorithm = params.get("ScheduleAlgorithm")
        if params.get("HealthCheck") is not None:
            self._HealthCheck = TargetGroupHealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        self._Weight = params.get("Weight")
        self._KeepaliveEnable = params.get("KeepaliveEnable")
        self._SessionExpireTime = params.get("SessionExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTargetGroupAttributeResponse(AbstractModel):
    r"""ModifyTargetGroupAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyTargetGroupInstancesPortRequest(AbstractModel):
    r"""ModifyTargetGroupInstancesPort request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _TargetGroupInstances: Array of servers whose Port is to be modified. NewPort and Port are required items in this api.
        :type TargetGroupInstances: list of TargetGroupInstance
        """
        self._TargetGroupId = None
        self._TargetGroupInstances = None

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def TargetGroupInstances(self):
        r"""Array of servers whose Port is to be modified. NewPort and Port are required items in this api.
        :rtype: list of TargetGroupInstance
        """
        return self._TargetGroupInstances

    @TargetGroupInstances.setter
    def TargetGroupInstances(self, TargetGroupInstances):
        self._TargetGroupInstances = TargetGroupInstances


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        if params.get("TargetGroupInstances") is not None:
            self._TargetGroupInstances = []
            for item in params.get("TargetGroupInstances"):
                obj = TargetGroupInstance()
                obj._deserialize(item)
                self._TargetGroupInstances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTargetGroupInstancesPortResponse(AbstractModel):
    r"""ModifyTargetGroupInstancesPort response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyTargetGroupInstancesWeightRequest(AbstractModel):
    r"""ModifyTargetGroupInstancesWeight request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _TargetGroupInstances: Array of servers whose weight is to be modified. Port is a required item in this api.
        :type TargetGroupInstances: list of TargetGroupInstance
        """
        self._TargetGroupId = None
        self._TargetGroupInstances = None

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def TargetGroupInstances(self):
        r"""Array of servers whose weight is to be modified. Port is a required item in this api.
        :rtype: list of TargetGroupInstance
        """
        return self._TargetGroupInstances

    @TargetGroupInstances.setter
    def TargetGroupInstances(self, TargetGroupInstances):
        self._TargetGroupInstances = TargetGroupInstances


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        if params.get("TargetGroupInstances") is not None:
            self._TargetGroupInstances = []
            for item in params.get("TargetGroupInstances"):
                obj = TargetGroupInstance()
                obj._deserialize(item)
                self._TargetGroupInstances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTargetGroupInstancesWeightResponse(AbstractModel):
    r"""ModifyTargetGroupInstancesWeight response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyTargetPortRequest(AbstractModel):
    r"""ModifyTargetPort request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _ListenerId: CLB listener ID
        :type ListenerId: str
        :param _Targets: List of real servers for which to modify the ports
        :type Targets: list of Target
        :param _NewPort: New port of the real server bound to a listener or forwarding rule
        :type NewPort: int
        :param _LocationId: Forwarding rule ID. When binding a real server to a layer-7 forwarding rule, you must provide either this parameter or Domain+Url.
        :type LocationId: str
        :param _Domain: Target rule domain name. This parameter does not take effect if LocationId is specified.
        :type Domain: str
        :param _Url: Target rule URL. This parameter does not take effect if LocationId is specified.
        :type Url: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._Targets = None
        self._NewPort = None
        self._LocationId = None
        self._Domain = None
        self._Url = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""CLB listener ID
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Targets(self):
        r"""List of real servers for which to modify the ports
        :rtype: list of Target
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def NewPort(self):
        r"""New port of the real server bound to a listener or forwarding rule
        :rtype: int
        """
        return self._NewPort

    @NewPort.setter
    def NewPort(self, NewPort):
        self._NewPort = NewPort

    @property
    def LocationId(self):
        r"""Forwarding rule ID. When binding a real server to a layer-7 forwarding rule, you must provide either this parameter or Domain+Url.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Target rule domain name. This parameter does not take effect if LocationId is specified.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""Target rule URL. This parameter does not take effect if LocationId is specified.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = Target()
                obj._deserialize(item)
                self._Targets.append(obj)
        self._NewPort = params.get("NewPort")
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTargetPortResponse(AbstractModel):
    r"""ModifyTargetPort response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyTargetWeightRequest(AbstractModel):
    r"""ModifyTargetWeight request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _ListenerId: CLB listener ID
        :type ListenerId: str
        :param _Targets: List of real servers for which to modify the weights
        :type Targets: list of Target
        :param _LocationId: Forwarding rule ID. When binding a real server to a layer-7 forwarding rule, you must provide either this parameter or Domain+Url.
        :type LocationId: str
        :param _Domain: Target rule domain name. This parameter does not take effect if LocationId is specified.
        :type Domain: str
        :param _Url: Target rule URL. This parameter does not take effect if LocationId is specified.
        :type Url: str
        :param _Weight: New forwarding weight of a real server. Value range: 0-100. Default value: 10. If the Targets.Weight parameter is set, this parameter will not take effect.
        :type Weight: int
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._Targets = None
        self._LocationId = None
        self._Domain = None
        self._Url = None
        self._Weight = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""CLB listener ID
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Targets(self):
        r"""List of real servers for which to modify the weights
        :rtype: list of Target
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def LocationId(self):
        r"""Forwarding rule ID. When binding a real server to a layer-7 forwarding rule, you must provide either this parameter or Domain+Url.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Target rule domain name. This parameter does not take effect if LocationId is specified.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""Target rule URL. This parameter does not take effect if LocationId is specified.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Weight(self):
        r"""New forwarding weight of a real server. Value range: 0-100. Default value: 10. If the Targets.Weight parameter is set, this parameter will not take effect.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = Target()
                obj._deserialize(item)
                self._Targets.append(obj)
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTargetWeightResponse(AbstractModel):
    r"""ModifyTargetWeight response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class MultiCertInfo(AbstractModel):
    r"""Information of multiple certificates bound with the load balancer listener or rule.

    """

    def __init__(self):
        r"""
        :param _SSLMode: Authentication type. Values: `UNIDIRECTIONAL` (one-way authentication), `MUTUAL` (two-way authentication)
        :type SSLMode: str
        :param _CertList: List of listener or rule certificates. One-way and two-way authentication are supported. Only one certificate can be specified for one algorithm. If `SSLMode` is `MUTUAL` (two-way authentication), at least one CA certificate is required. 
        :type CertList: list of CertInfo
        :param _SSLVerifyClient: Whether to enable client authentication for mutual authentication. ON: enable it; OPTIONAL: client certificate not required. Default value: ON.
        :type SSLVerifyClient: str
        """
        self._SSLMode = None
        self._CertList = None
        self._SSLVerifyClient = None

    @property
    def SSLMode(self):
        r"""Authentication type. Values: `UNIDIRECTIONAL` (one-way authentication), `MUTUAL` (two-way authentication)
        :rtype: str
        """
        return self._SSLMode

    @SSLMode.setter
    def SSLMode(self, SSLMode):
        self._SSLMode = SSLMode

    @property
    def CertList(self):
        r"""List of listener or rule certificates. One-way and two-way authentication are supported. Only one certificate can be specified for one algorithm. If `SSLMode` is `MUTUAL` (two-way authentication), at least one CA certificate is required. 
        :rtype: list of CertInfo
        """
        return self._CertList

    @CertList.setter
    def CertList(self, CertList):
        self._CertList = CertList

    @property
    def SSLVerifyClient(self):
        r"""Whether to enable client authentication for mutual authentication. ON: enable it; OPTIONAL: client certificate not required. Default value: ON.
        :rtype: str
        """
        return self._SSLVerifyClient

    @SSLVerifyClient.setter
    def SSLVerifyClient(self, SSLVerifyClient):
        self._SSLVerifyClient = SSLVerifyClient


    def _deserialize(self, params):
        self._SSLMode = params.get("SSLMode")
        if params.get("CertList") is not None:
            self._CertList = []
            for item in params.get("CertList"):
                obj = CertInfo()
                obj._deserialize(item)
                self._CertList.append(obj)
        self._SSLVerifyClient = params.get("SSLVerifyClient")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OAuth(AbstractModel):
    r"""OAuth configuration information.

    """

    def __init__(self):
        r"""
        :param _OAuthEnable: Specifies whether to turn on or off authentication.
True: enable.
False: disabled.
Disabled by default.
        :type OAuthEnable: bool
        :param _OAuthFailureStatus: Deny requests or allow when all iaps fail.
BYPASS: specifies the bypass.
REJECT.
Defaults to BYPASS.
        :type OAuthFailureStatus: str
        """
        self._OAuthEnable = None
        self._OAuthFailureStatus = None

    @property
    def OAuthEnable(self):
        r"""Specifies whether to turn on or off authentication.
True: enable.
False: disabled.
Disabled by default.
        :rtype: bool
        """
        return self._OAuthEnable

    @OAuthEnable.setter
    def OAuthEnable(self, OAuthEnable):
        self._OAuthEnable = OAuthEnable

    @property
    def OAuthFailureStatus(self):
        r"""Deny requests or allow when all iaps fail.
BYPASS: specifies the bypass.
REJECT.
Defaults to BYPASS.
        :rtype: str
        """
        return self._OAuthFailureStatus

    @OAuthFailureStatus.setter
    def OAuthFailureStatus(self, OAuthFailureStatus):
        self._OAuthFailureStatus = OAuthFailureStatus


    def _deserialize(self, params):
        self._OAuthEnable = params.get("OAuthEnable")
        self._OAuthFailureStatus = params.get("OAuthFailureStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Price(AbstractModel):
    r"""Price of CLB instances.

    """

    def __init__(self):
        r"""
        :param _InstancePrice: Describes the instance pricing.
        :type InstancePrice: :class:`tencentcloud.clb.v20180317.models.ItemPrice`
        :param _BandwidthPrice: Network price.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type BandwidthPrice: :class:`tencentcloud.clb.v20180317.models.ItemPrice`
        :param _LcuPrice: LCU price.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type LcuPrice: :class:`tencentcloud.clb.v20180317.models.ItemPrice`
        """
        self._InstancePrice = None
        self._BandwidthPrice = None
        self._LcuPrice = None

    @property
    def InstancePrice(self):
        r"""Describes the instance pricing.
        :rtype: :class:`tencentcloud.clb.v20180317.models.ItemPrice`
        """
        return self._InstancePrice

    @InstancePrice.setter
    def InstancePrice(self, InstancePrice):
        self._InstancePrice = InstancePrice

    @property
    def BandwidthPrice(self):
        r"""Network price.
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.ItemPrice`
        """
        return self._BandwidthPrice

    @BandwidthPrice.setter
    def BandwidthPrice(self, BandwidthPrice):
        self._BandwidthPrice = BandwidthPrice

    @property
    def LcuPrice(self):
        r"""LCU price.
Note: This field may return·null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.ItemPrice`
        """
        return self._LcuPrice

    @LcuPrice.setter
    def LcuPrice(self, LcuPrice):
        self._LcuPrice = LcuPrice


    def _deserialize(self, params):
        if params.get("InstancePrice") is not None:
            self._InstancePrice = ItemPrice()
            self._InstancePrice._deserialize(params.get("InstancePrice"))
        if params.get("BandwidthPrice") is not None:
            self._BandwidthPrice = ItemPrice()
            self._BandwidthPrice._deserialize(params.get("BandwidthPrice"))
        if params.get("LcuPrice") is not None:
            self._LcuPrice = ItemPrice()
            self._LcuPrice._deserialize(params.get("LcuPrice"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Quota(AbstractModel):
    r"""Quota description. All quotas are in the current region.

    """

    def __init__(self):
        r"""
        :param _QuotaId: Quota name. value range:.
<Li>TOTAL_OPEN_CLB_QUOTA: specifies the public network clb quota in the current region for the user.</li>.
<Li>TOTAL_INTERNAL_CLB_QUOTA: specifies the private network clb quota in the current region for the user.</li>.
<li>TOTAL_LISTENER_QUOTA: specifies the LISTENER QUOTA under a CLB.</li>.
<Li>TOTAL_LISTENER_RULE_QUOTA: specifies the forwarding rule quota under a listener.</li>.
<Li>TOTAL_TARGET_BIND_QUOTA: specifies the quota of devices that can be bound to a forwarding rule.</li>.
<li> TOTAL_SNAT_IP_QUOTA: specifies the SNAT IP QUOTA for a cross-regional 2.0 CLB instance. </li>.
<Li>TOTAL_ISP_CLB_QUOTA: specifies the quota of triple-isp (cmcc/cucc/ctcc) clb instances in the current region for the user.</li>.
<li>TOTAL_FULL_PORT_RANGE_LISTENER_QUOTA: specifies the QUOTA of single-protocol FULL PORT RANGE listeners for a CLB instance.</li>.
        :type QuotaId: str
        :param _QuotaCurrent: Currently used quantity. If it is `null`, it is meaningless.
Note: this field may return null, indicating that no valid values can be obtained.
        :type QuotaCurrent: int
        :param _QuotaLimit: Quota limit.
        :type QuotaLimit: int
        """
        self._QuotaId = None
        self._QuotaCurrent = None
        self._QuotaLimit = None

    @property
    def QuotaId(self):
        r"""Quota name. value range:.
<Li>TOTAL_OPEN_CLB_QUOTA: specifies the public network clb quota in the current region for the user.</li>.
<Li>TOTAL_INTERNAL_CLB_QUOTA: specifies the private network clb quota in the current region for the user.</li>.
<li>TOTAL_LISTENER_QUOTA: specifies the LISTENER QUOTA under a CLB.</li>.
<Li>TOTAL_LISTENER_RULE_QUOTA: specifies the forwarding rule quota under a listener.</li>.
<Li>TOTAL_TARGET_BIND_QUOTA: specifies the quota of devices that can be bound to a forwarding rule.</li>.
<li> TOTAL_SNAT_IP_QUOTA: specifies the SNAT IP QUOTA for a cross-regional 2.0 CLB instance. </li>.
<Li>TOTAL_ISP_CLB_QUOTA: specifies the quota of triple-isp (cmcc/cucc/ctcc) clb instances in the current region for the user.</li>.
<li>TOTAL_FULL_PORT_RANGE_LISTENER_QUOTA: specifies the QUOTA of single-protocol FULL PORT RANGE listeners for a CLB instance.</li>.
        :rtype: str
        """
        return self._QuotaId

    @QuotaId.setter
    def QuotaId(self, QuotaId):
        self._QuotaId = QuotaId

    @property
    def QuotaCurrent(self):
        r"""Currently used quantity. If it is `null`, it is meaningless.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._QuotaCurrent

    @QuotaCurrent.setter
    def QuotaCurrent(self, QuotaCurrent):
        self._QuotaCurrent = QuotaCurrent

    @property
    def QuotaLimit(self):
        r"""Quota limit.
        :rtype: int
        """
        return self._QuotaLimit

    @QuotaLimit.setter
    def QuotaLimit(self, QuotaLimit):
        self._QuotaLimit = QuotaLimit


    def _deserialize(self, params):
        self._QuotaId = params.get("QuotaId")
        self._QuotaCurrent = params.get("QuotaCurrent")
        self._QuotaLimit = params.get("QuotaLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegisterFunctionTargetsRequest(AbstractModel):
    r"""RegisterFunctionTargets request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID.
        :type LoadBalancerId: str
        :param _ListenerId: CLB listener ID.
        :type ListenerId: str
        :param _FunctionTargets: SCF functions to be bound.
        :type FunctionTargets: list of FunctionTarget
        :param _LocationId: ID of the target forwarding rule. To bind an SCF function to a L7 forwarding rule, this parameter or `Domain+Url` is required.
        :type LocationId: str
        :param _Domain: Domain name of the target forwarding rule. It is ignored if `LocationId` is specified.
        :type Domain: str
        :param _Url: URL of the target forwarding rule. It is ignored if `LocationId` is specified.
        :type Url: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._FunctionTargets = None
        self._LocationId = None
        self._Domain = None
        self._Url = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""CLB listener ID.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def FunctionTargets(self):
        r"""SCF functions to be bound.
        :rtype: list of FunctionTarget
        """
        return self._FunctionTargets

    @FunctionTargets.setter
    def FunctionTargets(self, FunctionTargets):
        self._FunctionTargets = FunctionTargets

    @property
    def LocationId(self):
        r"""ID of the target forwarding rule. To bind an SCF function to a L7 forwarding rule, this parameter or `Domain+Url` is required.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Domain name of the target forwarding rule. It is ignored if `LocationId` is specified.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""URL of the target forwarding rule. It is ignored if `LocationId` is specified.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        if params.get("FunctionTargets") is not None:
            self._FunctionTargets = []
            for item in params.get("FunctionTargets"):
                obj = FunctionTarget()
                obj._deserialize(item)
                self._FunctionTargets.append(obj)
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegisterFunctionTargetsResponse(AbstractModel):
    r"""RegisterFunctionTargets response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RegisterTargetGroupInstancesRequest(AbstractModel):
    r"""RegisterTargetGroupInstances request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _TargetGroupInstances: Server instance array. the VPC of the server and target group must be the same.
        :type TargetGroupInstances: list of TargetGroupInstance
        """
        self._TargetGroupId = None
        self._TargetGroupInstances = None

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def TargetGroupInstances(self):
        r"""Server instance array. the VPC of the server and target group must be the same.
        :rtype: list of TargetGroupInstance
        """
        return self._TargetGroupInstances

    @TargetGroupInstances.setter
    def TargetGroupInstances(self, TargetGroupInstances):
        self._TargetGroupInstances = TargetGroupInstances


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        if params.get("TargetGroupInstances") is not None:
            self._TargetGroupInstances = []
            for item in params.get("TargetGroupInstances"):
                obj = TargetGroupInstance()
                obj._deserialize(item)
                self._TargetGroupInstances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegisterTargetGroupInstancesResponse(AbstractModel):
    r"""RegisterTargetGroupInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RegisterTargetsRequest(AbstractModel):
    r"""RegisterTargets request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _ListenerId: CLB listener ID
        :type ListenerId: str
        :param _Targets: List of real servers to be bound. Array length limit: 20.
        :type Targets: list of Target
        :param _LocationId: Specifies the forwarding rule ID, which can be obtained through the DescribeListeners API (https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1). you must provide this parameter or either Domain or Url when binding a backend service to a layer-7 forwarding rule.
        :type LocationId: str
        :param _Domain: Target forwarding rule domain name. This parameter does not take effect if LocationId is specified.
        :type Domain: str
        :param _Url: Target forwarding rule URL. This parameter does not take effect if LocationId is specified.
        :type Url: str
        """
        self._LoadBalancerId = None
        self._ListenerId = None
        self._Targets = None
        self._LocationId = None
        self._Domain = None
        self._Url = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerId(self):
        r"""CLB listener ID
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Targets(self):
        r"""List of real servers to be bound. Array length limit: 20.
        :rtype: list of Target
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def LocationId(self):
        r"""Specifies the forwarding rule ID, which can be obtained through the DescribeListeners API (https://www.tencentcloud.comom/document/product/214/30686?from_cn_redirect=1). you must provide this parameter or either Domain or Url when binding a backend service to a layer-7 forwarding rule.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Target forwarding rule domain name. This parameter does not take effect if LocationId is specified.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""Target forwarding rule URL. This parameter does not take effect if LocationId is specified.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerId = params.get("ListenerId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = Target()
                obj._deserialize(item)
                self._Targets.append(obj)
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegisterTargetsResponse(AbstractModel):
    r"""RegisterTargets response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RegisterTargetsWithClassicalLBRequest(AbstractModel):
    r"""RegisterTargetsWithClassicalLB request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _Targets: Real server information
        :type Targets: list of ClassicalTargetInfo
        """
        self._LoadBalancerId = None
        self._Targets = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def Targets(self):
        r"""Real server information
        :rtype: list of ClassicalTargetInfo
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = ClassicalTargetInfo()
                obj._deserialize(item)
                self._Targets.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegisterTargetsWithClassicalLBResponse(AbstractModel):
    r"""RegisterTargetsWithClassicalLB response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ReplaceCertForLoadBalancersRequest(AbstractModel):
    r"""ReplaceCertForLoadBalancers request structure.

    """

    def __init__(self):
        r"""
        :param _OldCertificateId: ID of the certificate to be replaced, which can be a server certificate or a client certificate.
        :type OldCertificateId: str
        :param _Certificate: Information such as the content of the new certificate
        :type Certificate: :class:`tencentcloud.clb.v20180317.models.CertificateInput`
        """
        self._OldCertificateId = None
        self._Certificate = None

    @property
    def OldCertificateId(self):
        r"""ID of the certificate to be replaced, which can be a server certificate or a client certificate.
        :rtype: str
        """
        return self._OldCertificateId

    @OldCertificateId.setter
    def OldCertificateId(self, OldCertificateId):
        self._OldCertificateId = OldCertificateId

    @property
    def Certificate(self):
        r"""Information such as the content of the new certificate
        :rtype: :class:`tencentcloud.clb.v20180317.models.CertificateInput`
        """
        return self._Certificate

    @Certificate.setter
    def Certificate(self, Certificate):
        self._Certificate = Certificate


    def _deserialize(self, params):
        self._OldCertificateId = params.get("OldCertificateId")
        if params.get("Certificate") is not None:
            self._Certificate = CertificateInput()
            self._Certificate._deserialize(params.get("Certificate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReplaceCertForLoadBalancersResponse(AbstractModel):
    r"""ReplaceCertForLoadBalancers response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Resource(AbstractModel):
    r"""Resource details

    """

    def __init__(self):
        r"""
        :param _Type: Specific ISP resource information, Vaules: `CMCC`, `CUCC`, `CTCC`, `BGP`, and `INTERNAL`.
        :type Type: list of str
        :param _Isp: ISP information, such as `CMCC`, `CUCC`, `CTCC`, `BGP`, and `INTERNAL`.
        :type Isp: str
        :param _AvailabilitySet: Available resources.
        :type AvailabilitySet: list of ResourceAvailability
        :param _TypeSet: Operator type info.
        :type TypeSet: list of TypeInfo
        """
        self._Type = None
        self._Isp = None
        self._AvailabilitySet = None
        self._TypeSet = None

    @property
    def Type(self):
        r"""Specific ISP resource information, Vaules: `CMCC`, `CUCC`, `CTCC`, `BGP`, and `INTERNAL`.
        :rtype: list of str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Isp(self):
        r"""ISP information, such as `CMCC`, `CUCC`, `CTCC`, `BGP`, and `INTERNAL`.
        :rtype: str
        """
        return self._Isp

    @Isp.setter
    def Isp(self, Isp):
        self._Isp = Isp

    @property
    def AvailabilitySet(self):
        r"""Available resources.
        :rtype: list of ResourceAvailability
        """
        return self._AvailabilitySet

    @AvailabilitySet.setter
    def AvailabilitySet(self, AvailabilitySet):
        self._AvailabilitySet = AvailabilitySet

    @property
    def TypeSet(self):
        r"""Operator type info.
        :rtype: list of TypeInfo
        """
        return self._TypeSet

    @TypeSet.setter
    def TypeSet(self, TypeSet):
        self._TypeSet = TypeSet


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Isp = params.get("Isp")
        if params.get("AvailabilitySet") is not None:
            self._AvailabilitySet = []
            for item in params.get("AvailabilitySet"):
                obj = ResourceAvailability()
                obj._deserialize(item)
                self._AvailabilitySet.append(obj)
        if params.get("TypeSet") is not None:
            self._TypeSet = []
            for item in params.get("TypeSet"):
                obj = TypeInfo()
                obj._deserialize(item)
                self._TypeSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResourceAvailability(AbstractModel):
    r"""Resource availability

    """

    def __init__(self):
        r"""
        :param _Type: Specific ISP resource information. Values: `CMCC`, `CUCC`, `CTCC`, `BGP`.
        :type Type: str
        :param _Availability: Whether the resource is available. Values: `Available`, `Unavailable`
        :type Availability: str
        """
        self._Type = None
        self._Availability = None

    @property
    def Type(self):
        r"""Specific ISP resource information. Values: `CMCC`, `CUCC`, `CTCC`, `BGP`.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Availability(self):
        r"""Whether the resource is available. Values: `Available`, `Unavailable`
        :rtype: str
        """
        return self._Availability

    @Availability.setter
    def Availability(self, Availability):
        self._Availability = Availability


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Availability = params.get("Availability")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RewriteLocationMap(AbstractModel):
    r"""Redirection relationship between forwarding rules

    """

    def __init__(self):
        r"""
        :param _SourceLocationId: Source forwarding rule ID
        :type SourceLocationId: str
        :param _TargetLocationId: ID of the forwarding rule of the destination
        :type TargetLocationId: str
        :param _RewriteCode: Redirection status code. Valid values: 301, 302, and 307.
        :type RewriteCode: int
        :param _TakeUrl: Whether the matched URL is carried in redirection. It is required when configuring `RewriteCode`.
        :type TakeUrl: bool
        :param _SourceDomain: Original domain name of redirection, which must be the corresponding domain name of `SourceLocationId`. It is required when configuring `RewriteCode`.
        :type SourceDomain: str
        """
        self._SourceLocationId = None
        self._TargetLocationId = None
        self._RewriteCode = None
        self._TakeUrl = None
        self._SourceDomain = None

    @property
    def SourceLocationId(self):
        r"""Source forwarding rule ID
        :rtype: str
        """
        return self._SourceLocationId

    @SourceLocationId.setter
    def SourceLocationId(self, SourceLocationId):
        self._SourceLocationId = SourceLocationId

    @property
    def TargetLocationId(self):
        r"""ID of the forwarding rule of the destination
        :rtype: str
        """
        return self._TargetLocationId

    @TargetLocationId.setter
    def TargetLocationId(self, TargetLocationId):
        self._TargetLocationId = TargetLocationId

    @property
    def RewriteCode(self):
        r"""Redirection status code. Valid values: 301, 302, and 307.
        :rtype: int
        """
        return self._RewriteCode

    @RewriteCode.setter
    def RewriteCode(self, RewriteCode):
        self._RewriteCode = RewriteCode

    @property
    def TakeUrl(self):
        r"""Whether the matched URL is carried in redirection. It is required when configuring `RewriteCode`.
        :rtype: bool
        """
        return self._TakeUrl

    @TakeUrl.setter
    def TakeUrl(self, TakeUrl):
        self._TakeUrl = TakeUrl

    @property
    def SourceDomain(self):
        r"""Original domain name of redirection, which must be the corresponding domain name of `SourceLocationId`. It is required when configuring `RewriteCode`.
        :rtype: str
        """
        return self._SourceDomain

    @SourceDomain.setter
    def SourceDomain(self, SourceDomain):
        self._SourceDomain = SourceDomain


    def _deserialize(self, params):
        self._SourceLocationId = params.get("SourceLocationId")
        self._TargetLocationId = params.get("TargetLocationId")
        self._RewriteCode = params.get("RewriteCode")
        self._TakeUrl = params.get("TakeUrl")
        self._SourceDomain = params.get("SourceDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RewriteTarget(AbstractModel):
    r"""Redirect target information

    """

    def __init__(self):
        r"""
        :param _TargetListenerId: Listener ID of the redirection target. this field is valid only when redirection is configured.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TargetListenerId: str
        :param _TargetLocationId: Specifies the forwarding rule ID of redirection target. field is valid only when redirection is configured.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TargetLocationId: str
        :param _RewriteCode: Specifies the redirection status code.
        :type RewriteCode: int
        :param _TakeUrl: Whether the matched URL is carried in redirection
        :type TakeUrl: bool
        :param _RewriteType: Redirection type. Manual: Manual redirection; Auto: Automatic redirection
        :type RewriteType: str
        """
        self._TargetListenerId = None
        self._TargetLocationId = None
        self._RewriteCode = None
        self._TakeUrl = None
        self._RewriteType = None

    @property
    def TargetListenerId(self):
        r"""Listener ID of the redirection target. this field is valid only when redirection is configured.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TargetListenerId

    @TargetListenerId.setter
    def TargetListenerId(self, TargetListenerId):
        self._TargetListenerId = TargetListenerId

    @property
    def TargetLocationId(self):
        r"""Specifies the forwarding rule ID of redirection target. field is valid only when redirection is configured.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TargetLocationId

    @TargetLocationId.setter
    def TargetLocationId(self, TargetLocationId):
        self._TargetLocationId = TargetLocationId

    @property
    def RewriteCode(self):
        r"""Specifies the redirection status code.
        :rtype: int
        """
        return self._RewriteCode

    @RewriteCode.setter
    def RewriteCode(self, RewriteCode):
        self._RewriteCode = RewriteCode

    @property
    def TakeUrl(self):
        r"""Whether the matched URL is carried in redirection
        :rtype: bool
        """
        return self._TakeUrl

    @TakeUrl.setter
    def TakeUrl(self, TakeUrl):
        self._TakeUrl = TakeUrl

    @property
    def RewriteType(self):
        r"""Redirection type. Manual: Manual redirection; Auto: Automatic redirection
        :rtype: str
        """
        return self._RewriteType

    @RewriteType.setter
    def RewriteType(self, RewriteType):
        self._RewriteType = RewriteType


    def _deserialize(self, params):
        self._TargetListenerId = params.get("TargetListenerId")
        self._TargetLocationId = params.get("TargetLocationId")
        self._RewriteCode = params.get("RewriteCode")
        self._TakeUrl = params.get("TakeUrl")
        self._RewriteType = params.get("RewriteType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RsTagRule(AbstractModel):
    r"""Data type of the modified node tag.

    """

    def __init__(self):
        r"""
        :param _ListenerId: CLB listener ID.
        :type ListenerId: str
        :param _Targets: List of real servers with tags to be modified.
        :type Targets: list of Target
        :param _LocationId: Forwarding rule ID, which is required only for Layer-7 rules but not for Layer-4 rules.
        :type LocationId: str
        :param _Tag: Modified Tag of the backend service. this parameter has a lower priority than the Tag parameter in the aforementioned [Target](https://www.tencentcloud.comom/document/api/214/30694?from_cn_redirect=1#Target). the final Tag value is based on the Tag parameter in the Target. the Tag parameter in RsTagRule will be used only when the Tag parameter in the Target is empty.
        :type Tag: str
        """
        self._ListenerId = None
        self._Targets = None
        self._LocationId = None
        self._Tag = None

    @property
    def ListenerId(self):
        r"""CLB listener ID.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Targets(self):
        r"""List of real servers with tags to be modified.
        :rtype: list of Target
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def LocationId(self):
        r"""Forwarding rule ID, which is required only for Layer-7 rules but not for Layer-4 rules.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Tag(self):
        r"""Modified Tag of the backend service. this parameter has a lower priority than the Tag parameter in the aforementioned [Target](https://www.tencentcloud.comom/document/api/214/30694?from_cn_redirect=1#Target). the final Tag value is based on the Tag parameter in the Target. the Tag parameter in RsTagRule will be used only when the Tag parameter in the Target is empty.
        :rtype: str
        """
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag


    def _deserialize(self, params):
        self._ListenerId = params.get("ListenerId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = Target()
                obj._deserialize(item)
                self._Targets.append(obj)
        self._LocationId = params.get("LocationId")
        self._Tag = params.get("Tag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RsWeightRule(AbstractModel):
    r"""Modifies the data type of a node weight

    """

    def __init__(self):
        r"""
        :param _ListenerId: CLB listener ID.
        :type ListenerId: str
        :param _Targets: List of real servers whose weights to modify.
        :type Targets: list of Target
        :param _LocationId: Forwarding rule ID, which is required only for layer-7 rules.
        :type LocationId: str
        :param _Domain: Target rule domain name. This parameter does not take effect if LocationId is specified
        :type Domain: str
        :param _Url: Target rule URL. This parameter does not take effect if LocationId is specified
        :type Url: str
        :param _Weight: The new forwarding weight of the real server. Value range: [0, 100]. This parameter takes lower precedence than `Weight` in [`Targets`](https://intl.cloud.tencent.com/document/api/214/30694?from_cn_redirect=1#Target), which means that this parameter only takes effect when the `Weight` in `RsWeightRule` is left empty.
        :type Weight: int
        """
        self._ListenerId = None
        self._Targets = None
        self._LocationId = None
        self._Domain = None
        self._Url = None
        self._Weight = None

    @property
    def ListenerId(self):
        r"""CLB listener ID.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def Targets(self):
        r"""List of real servers whose weights to modify.
        :rtype: list of Target
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def LocationId(self):
        r"""Forwarding rule ID, which is required only for layer-7 rules.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        warnings.warn("parameter `Domain` is deprecated", DeprecationWarning) 

        r"""Target rule domain name. This parameter does not take effect if LocationId is specified
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        warnings.warn("parameter `Domain` is deprecated", DeprecationWarning) 

        self._Domain = Domain

    @property
    def Url(self):
        warnings.warn("parameter `Url` is deprecated", DeprecationWarning) 

        r"""Target rule URL. This parameter does not take effect if LocationId is specified
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        warnings.warn("parameter `Url` is deprecated", DeprecationWarning) 

        self._Url = Url

    @property
    def Weight(self):
        r"""The new forwarding weight of the real server. Value range: [0, 100]. This parameter takes lower precedence than `Weight` in [`Targets`](https://intl.cloud.tencent.com/document/api/214/30694?from_cn_redirect=1#Target), which means that this parameter only takes effect when the `Weight` in `RsWeightRule` is left empty.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._ListenerId = params.get("ListenerId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = Target()
                obj._deserialize(item)
                self._Targets.append(obj)
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleHealth(AbstractModel):
    r"""Health check status of a forwarding rule

    """

    def __init__(self):
        r"""
        :param _LocationId: Forwarding rule ID
        :type LocationId: str
        :param _Domain: Domain name of the forwarding rule
Note: This field may return null, indicating that no valid values can be obtained.
        :type Domain: str
        :param _Url: Forwarding rule Url
Note: This field may return null, indicating that no valid values can be obtained.
        :type Url: str
        :param _RuleId: Advanced routing rule ID.
        :type RuleId: str
        :param _Targets: Indicates the health check status of the backend service bound to this rule.
        :type Targets: list of TargetHealth
        """
        self._LocationId = None
        self._Domain = None
        self._Url = None
        self._RuleId = None
        self._Targets = None

    @property
    def LocationId(self):
        r"""Forwarding rule ID
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Domain name of the forwarding rule
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""Forwarding rule Url
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RuleId(self):
        r"""Advanced routing rule ID.
        :rtype: str
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Targets(self):
        r"""Indicates the health check status of the backend service bound to this rule.
        :rtype: list of TargetHealth
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets


    def _deserialize(self, params):
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        self._RuleId = params.get("RuleId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = TargetHealth()
                obj._deserialize(item)
                self._Targets.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleInput(AbstractModel):
    r"""HTTP/HTTPS forwarding rule (input)

    """

    def __init__(self):
        r"""
        :param _Url: Forwarding rule path. Length: 1-200.
        :type Url: str
        :param _Domain: The domain name associated with the forwarding rule. It can contain 1-80 characters. Only one domain name can be entered. If you need to enter multiple domain names, use `Domains`.
        :type Domain: str
        :param _SessionExpireTime: Session persistence duration, in seconds. 0 indicates that session persistence is disabled, and a value ranging from 30 to 86400 indicates that session persistence is enabled.
        :type SessionExpireTime: int
        :param _HealthCheck: Health check information. For more information, please see [Health Check](https://intl.cloud.tencent.com/document/product/214/6097?from_cn_redirect=1)
        :type HealthCheck: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        :param _Certificate: Certificate information. `Certificate` and `MultiCertInfo` cannot be specified at the same time. 
        :type Certificate: :class:`tencentcloud.clb.v20180317.models.CertificateInput`
        :param _Scheduler: Request forwarding method of the rule. Value range: WRR, LEAST_CONN, IP_HASH
They represent weighted round robin, least connections, and IP hash, respectively. Default value: WRR.
        :type Scheduler: str
        :param _ForwardType: Specifies the forwarding protocol between cloud load balancer and backend service. currently supports HTTP/HTTPS/GRPC/GRPCS/TRPC. TRPC is not yet available. default HTTP.
        :type ForwardType: str
        :param _DefaultServer: Whether to set this domain name as the default domain name. Note: Only one default domain name can be set under one listener.
        :type DefaultServer: bool
        :param _Http2: Whether to enable HTTP/2. Note: HTTP/2 can be enabled only for HTTPS domain names.
        :type Http2: bool
        :param _TargetType: Target real server type. NODE: binding a general node; TARGETGROUP: binding a target group.
        :type TargetType: str
        :param _TrpcCallee: TRPC callee server route, which is required when `ForwardType` is "TRPC". This is now only for internal usage.
        :type TrpcCallee: str
        :param _TrpcFunc: TRPC calling service API, which is required when `ForwardType` is "TRPC". This is now only for internal usage.
        :type TrpcFunc: str
        :param _Quic: Whether to enable QUIC. Note: QUIC can be enabled only for HTTPS domain names
        :type Quic: bool
        :param _Domains: The domain name associated with the forwarding rule. Each contain 1-80 characters. If you only need to enter one domain name, use `Domain` instead.
        :type Domains: list of str
        :param _MultiCertInfo: Certificate information. You can specify multiple server-side certificates with different algorithm types. `Certificate` and `MultiCertInfo` cannot be specified at the same time. 
        :type MultiCertInfo: :class:`tencentcloud.clb.v20180317.models.MultiCertInfo`
        :param _CookieName: Specifies the custom cookie name.
        :type CookieName: str
        """
        self._Url = None
        self._Domain = None
        self._SessionExpireTime = None
        self._HealthCheck = None
        self._Certificate = None
        self._Scheduler = None
        self._ForwardType = None
        self._DefaultServer = None
        self._Http2 = None
        self._TargetType = None
        self._TrpcCallee = None
        self._TrpcFunc = None
        self._Quic = None
        self._Domains = None
        self._MultiCertInfo = None
        self._CookieName = None

    @property
    def Url(self):
        r"""Forwarding rule path. Length: 1-200.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Domain(self):
        r"""The domain name associated with the forwarding rule. It can contain 1-80 characters. Only one domain name can be entered. If you need to enter multiple domain names, use `Domains`.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SessionExpireTime(self):
        r"""Session persistence duration, in seconds. 0 indicates that session persistence is disabled, and a value ranging from 30 to 86400 indicates that session persistence is enabled.
        :rtype: int
        """
        return self._SessionExpireTime

    @SessionExpireTime.setter
    def SessionExpireTime(self, SessionExpireTime):
        self._SessionExpireTime = SessionExpireTime

    @property
    def HealthCheck(self):
        r"""Health check information. For more information, please see [Health Check](https://intl.cloud.tencent.com/document/product/214/6097?from_cn_redirect=1)
        :rtype: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def Certificate(self):
        r"""Certificate information. `Certificate` and `MultiCertInfo` cannot be specified at the same time. 
        :rtype: :class:`tencentcloud.clb.v20180317.models.CertificateInput`
        """
        return self._Certificate

    @Certificate.setter
    def Certificate(self, Certificate):
        self._Certificate = Certificate

    @property
    def Scheduler(self):
        r"""Request forwarding method of the rule. Value range: WRR, LEAST_CONN, IP_HASH
They represent weighted round robin, least connections, and IP hash, respectively. Default value: WRR.
        :rtype: str
        """
        return self._Scheduler

    @Scheduler.setter
    def Scheduler(self, Scheduler):
        self._Scheduler = Scheduler

    @property
    def ForwardType(self):
        r"""Specifies the forwarding protocol between cloud load balancer and backend service. currently supports HTTP/HTTPS/GRPC/GRPCS/TRPC. TRPC is not yet available. default HTTP.
        :rtype: str
        """
        return self._ForwardType

    @ForwardType.setter
    def ForwardType(self, ForwardType):
        self._ForwardType = ForwardType

    @property
    def DefaultServer(self):
        r"""Whether to set this domain name as the default domain name. Note: Only one default domain name can be set under one listener.
        :rtype: bool
        """
        return self._DefaultServer

    @DefaultServer.setter
    def DefaultServer(self, DefaultServer):
        self._DefaultServer = DefaultServer

    @property
    def Http2(self):
        r"""Whether to enable HTTP/2. Note: HTTP/2 can be enabled only for HTTPS domain names.
        :rtype: bool
        """
        return self._Http2

    @Http2.setter
    def Http2(self, Http2):
        self._Http2 = Http2

    @property
    def TargetType(self):
        r"""Target real server type. NODE: binding a general node; TARGETGROUP: binding a target group.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TrpcCallee(self):
        r"""TRPC callee server route, which is required when `ForwardType` is "TRPC". This is now only for internal usage.
        :rtype: str
        """
        return self._TrpcCallee

    @TrpcCallee.setter
    def TrpcCallee(self, TrpcCallee):
        self._TrpcCallee = TrpcCallee

    @property
    def TrpcFunc(self):
        r"""TRPC calling service API, which is required when `ForwardType` is "TRPC". This is now only for internal usage.
        :rtype: str
        """
        return self._TrpcFunc

    @TrpcFunc.setter
    def TrpcFunc(self, TrpcFunc):
        self._TrpcFunc = TrpcFunc

    @property
    def Quic(self):
        r"""Whether to enable QUIC. Note: QUIC can be enabled only for HTTPS domain names
        :rtype: bool
        """
        return self._Quic

    @Quic.setter
    def Quic(self, Quic):
        self._Quic = Quic

    @property
    def Domains(self):
        r"""The domain name associated with the forwarding rule. Each contain 1-80 characters. If you only need to enter one domain name, use `Domain` instead.
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def MultiCertInfo(self):
        r"""Certificate information. You can specify multiple server-side certificates with different algorithm types. `Certificate` and `MultiCertInfo` cannot be specified at the same time. 
        :rtype: :class:`tencentcloud.clb.v20180317.models.MultiCertInfo`
        """
        return self._MultiCertInfo

    @MultiCertInfo.setter
    def MultiCertInfo(self, MultiCertInfo):
        self._MultiCertInfo = MultiCertInfo

    @property
    def CookieName(self):
        r"""Specifies the custom cookie name.
        :rtype: str
        """
        return self._CookieName

    @CookieName.setter
    def CookieName(self, CookieName):
        self._CookieName = CookieName


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._Domain = params.get("Domain")
        self._SessionExpireTime = params.get("SessionExpireTime")
        if params.get("HealthCheck") is not None:
            self._HealthCheck = HealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        if params.get("Certificate") is not None:
            self._Certificate = CertificateInput()
            self._Certificate._deserialize(params.get("Certificate"))
        self._Scheduler = params.get("Scheduler")
        self._ForwardType = params.get("ForwardType")
        self._DefaultServer = params.get("DefaultServer")
        self._Http2 = params.get("Http2")
        self._TargetType = params.get("TargetType")
        self._TrpcCallee = params.get("TrpcCallee")
        self._TrpcFunc = params.get("TrpcFunc")
        self._Quic = params.get("Quic")
        self._Domains = params.get("Domains")
        if params.get("MultiCertInfo") is not None:
            self._MultiCertInfo = MultiCertInfo()
            self._MultiCertInfo._deserialize(params.get("MultiCertInfo"))
        self._CookieName = params.get("CookieName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleOutput(AbstractModel):
    r"""HTTP/HTTPS listener forwarding rule (output)

    """

    def __init__(self):
        r"""
        :param _LocationId: Forwarding rule ID
        :type LocationId: str
        :param _Domain: Domain name of the forwarding rule
        :type Domain: str
        :param _Url: Path of forwarding rules.
        :type Url: str
        :param _SessionExpireTime: Session persistence time
        :type SessionExpireTime: int
        :param _HealthCheck: Health Check Information
        :type HealthCheck: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        :param _Certificate: Certificate information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Certificate: :class:`tencentcloud.clb.v20180317.models.CertificateOutput`
        :param _Scheduler: Request forwarding method in the rules.WRR, LEAST_CONN, and IP_HASH respectively indicate weighted round robin, least connections, and IP hash.
        :type Scheduler: str
        :param _ListenerId: ID of the listener to which the forwarding rule belongs
        :type ListenerId: str
        :param _RewriteTarget: Redirection target information of the forwarding rule
        :type RewriteTarget: :class:`tencentcloud.clb.v20180317.models.RewriteTarget`
        :param _HttpGzip: Whether to enable gzip
        :type HttpGzip: bool
        :param _BeAutoCreated: Whether the forwarding rule is automatically created
        :type BeAutoCreated: bool
        :param _DefaultServer: Whether to use as the default domain name
        :type DefaultServer: bool
        :param _Http2: Whether to enable Http2
        :type Http2: bool
        :param _ForwardType: Forwarding protocol between CLB and real server
        :type ForwardType: str
        :param _CreateTime: Forwarding rule creation time
        :type CreateTime: str
        :param _TargetType: Real server type. NODE indicates binding to a general node, and TARGETGROUP indicates binding to a target group.
        :type TargetType: str
        :param _TargetGroup: Basic information of a bound target group. This field will be returned if a target group is bound to a rule.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TargetGroup: :class:`tencentcloud.clb.v20180317.models.BasicTargetGroupInfo`
        :param _WafDomainId: WAF instance ID.
        :type WafDomainId: str
        :param _TrpcCallee: Called server routing. valid when ForwardType is TRPC. currently not yet available.
        :type TrpcCallee: str
        :param _TrpcFunc: TRPC calling service api. valid when ForwardType is TRPC. currently not yet available.
        :type TrpcFunc: str
        :param _QuicStatus: QUIC status. QUIC_ACTIVE means enabled, QUIC_INACTIVE means not enabled. note that only HTTPS domain names can enable QUIC.
        :type QuicStatus: str
        :param _Domains: Specifies the domain name list of the forwarding rule.
        :type Domains: list of str
        :param _TargetGroupList: List of bound target groups
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TargetGroupList: list of BasicTargetGroupInfo
        :param _OAuth: OAuth configuration status.
        :type OAuth: :class:`tencentcloud.clb.v20180317.models.OAuth`
        :param _CookieName: Specifies the custom cookie name.
        :type CookieName: str
        """
        self._LocationId = None
        self._Domain = None
        self._Url = None
        self._SessionExpireTime = None
        self._HealthCheck = None
        self._Certificate = None
        self._Scheduler = None
        self._ListenerId = None
        self._RewriteTarget = None
        self._HttpGzip = None
        self._BeAutoCreated = None
        self._DefaultServer = None
        self._Http2 = None
        self._ForwardType = None
        self._CreateTime = None
        self._TargetType = None
        self._TargetGroup = None
        self._WafDomainId = None
        self._TrpcCallee = None
        self._TrpcFunc = None
        self._QuicStatus = None
        self._Domains = None
        self._TargetGroupList = None
        self._OAuth = None
        self._CookieName = None

    @property
    def LocationId(self):
        r"""Forwarding rule ID
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Domain name of the forwarding rule
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""Path of forwarding rules.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def SessionExpireTime(self):
        r"""Session persistence time
        :rtype: int
        """
        return self._SessionExpireTime

    @SessionExpireTime.setter
    def SessionExpireTime(self, SessionExpireTime):
        self._SessionExpireTime = SessionExpireTime

    @property
    def HealthCheck(self):
        r"""Health Check Information
        :rtype: :class:`tencentcloud.clb.v20180317.models.HealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def Certificate(self):
        r"""Certificate information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.CertificateOutput`
        """
        return self._Certificate

    @Certificate.setter
    def Certificate(self, Certificate):
        self._Certificate = Certificate

    @property
    def Scheduler(self):
        r"""Request forwarding method in the rules.WRR, LEAST_CONN, and IP_HASH respectively indicate weighted round robin, least connections, and IP hash.
        :rtype: str
        """
        return self._Scheduler

    @Scheduler.setter
    def Scheduler(self, Scheduler):
        self._Scheduler = Scheduler

    @property
    def ListenerId(self):
        r"""ID of the listener to which the forwarding rule belongs
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def RewriteTarget(self):
        r"""Redirection target information of the forwarding rule
        :rtype: :class:`tencentcloud.clb.v20180317.models.RewriteTarget`
        """
        return self._RewriteTarget

    @RewriteTarget.setter
    def RewriteTarget(self, RewriteTarget):
        self._RewriteTarget = RewriteTarget

    @property
    def HttpGzip(self):
        r"""Whether to enable gzip
        :rtype: bool
        """
        return self._HttpGzip

    @HttpGzip.setter
    def HttpGzip(self, HttpGzip):
        self._HttpGzip = HttpGzip

    @property
    def BeAutoCreated(self):
        r"""Whether the forwarding rule is automatically created
        :rtype: bool
        """
        return self._BeAutoCreated

    @BeAutoCreated.setter
    def BeAutoCreated(self, BeAutoCreated):
        self._BeAutoCreated = BeAutoCreated

    @property
    def DefaultServer(self):
        r"""Whether to use as the default domain name
        :rtype: bool
        """
        return self._DefaultServer

    @DefaultServer.setter
    def DefaultServer(self, DefaultServer):
        self._DefaultServer = DefaultServer

    @property
    def Http2(self):
        r"""Whether to enable Http2
        :rtype: bool
        """
        return self._Http2

    @Http2.setter
    def Http2(self, Http2):
        self._Http2 = Http2

    @property
    def ForwardType(self):
        r"""Forwarding protocol between CLB and real server
        :rtype: str
        """
        return self._ForwardType

    @ForwardType.setter
    def ForwardType(self, ForwardType):
        self._ForwardType = ForwardType

    @property
    def CreateTime(self):
        r"""Forwarding rule creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def TargetType(self):
        r"""Real server type. NODE indicates binding to a general node, and TARGETGROUP indicates binding to a target group.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetGroup(self):
        r"""Basic information of a bound target group. This field will be returned if a target group is bound to a rule.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.BasicTargetGroupInfo`
        """
        return self._TargetGroup

    @TargetGroup.setter
    def TargetGroup(self, TargetGroup):
        self._TargetGroup = TargetGroup

    @property
    def WafDomainId(self):
        r"""WAF instance ID.
        :rtype: str
        """
        return self._WafDomainId

    @WafDomainId.setter
    def WafDomainId(self, WafDomainId):
        self._WafDomainId = WafDomainId

    @property
    def TrpcCallee(self):
        r"""Called server routing. valid when ForwardType is TRPC. currently not yet available.
        :rtype: str
        """
        return self._TrpcCallee

    @TrpcCallee.setter
    def TrpcCallee(self, TrpcCallee):
        self._TrpcCallee = TrpcCallee

    @property
    def TrpcFunc(self):
        r"""TRPC calling service api. valid when ForwardType is TRPC. currently not yet available.
        :rtype: str
        """
        return self._TrpcFunc

    @TrpcFunc.setter
    def TrpcFunc(self, TrpcFunc):
        self._TrpcFunc = TrpcFunc

    @property
    def QuicStatus(self):
        r"""QUIC status. QUIC_ACTIVE means enabled, QUIC_INACTIVE means not enabled. note that only HTTPS domain names can enable QUIC.
        :rtype: str
        """
        return self._QuicStatus

    @QuicStatus.setter
    def QuicStatus(self, QuicStatus):
        self._QuicStatus = QuicStatus

    @property
    def Domains(self):
        r"""Specifies the domain name list of the forwarding rule.
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def TargetGroupList(self):
        r"""List of bound target groups
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of BasicTargetGroupInfo
        """
        return self._TargetGroupList

    @TargetGroupList.setter
    def TargetGroupList(self, TargetGroupList):
        self._TargetGroupList = TargetGroupList

    @property
    def OAuth(self):
        r"""OAuth configuration status.
        :rtype: :class:`tencentcloud.clb.v20180317.models.OAuth`
        """
        return self._OAuth

    @OAuth.setter
    def OAuth(self, OAuth):
        self._OAuth = OAuth

    @property
    def CookieName(self):
        r"""Specifies the custom cookie name.
        :rtype: str
        """
        return self._CookieName

    @CookieName.setter
    def CookieName(self, CookieName):
        self._CookieName = CookieName


    def _deserialize(self, params):
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        self._SessionExpireTime = params.get("SessionExpireTime")
        if params.get("HealthCheck") is not None:
            self._HealthCheck = HealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        if params.get("Certificate") is not None:
            self._Certificate = CertificateOutput()
            self._Certificate._deserialize(params.get("Certificate"))
        self._Scheduler = params.get("Scheduler")
        self._ListenerId = params.get("ListenerId")
        if params.get("RewriteTarget") is not None:
            self._RewriteTarget = RewriteTarget()
            self._RewriteTarget._deserialize(params.get("RewriteTarget"))
        self._HttpGzip = params.get("HttpGzip")
        self._BeAutoCreated = params.get("BeAutoCreated")
        self._DefaultServer = params.get("DefaultServer")
        self._Http2 = params.get("Http2")
        self._ForwardType = params.get("ForwardType")
        self._CreateTime = params.get("CreateTime")
        self._TargetType = params.get("TargetType")
        if params.get("TargetGroup") is not None:
            self._TargetGroup = BasicTargetGroupInfo()
            self._TargetGroup._deserialize(params.get("TargetGroup"))
        self._WafDomainId = params.get("WafDomainId")
        self._TrpcCallee = params.get("TrpcCallee")
        self._TrpcFunc = params.get("TrpcFunc")
        self._QuicStatus = params.get("QuicStatus")
        self._Domains = params.get("Domains")
        if params.get("TargetGroupList") is not None:
            self._TargetGroupList = []
            for item in params.get("TargetGroupList"):
                obj = BasicTargetGroupInfo()
                obj._deserialize(item)
                self._TargetGroupList.append(obj)
        if params.get("OAuth") is not None:
            self._OAuth = OAuth()
            self._OAuth._deserialize(params.get("OAuth"))
        self._CookieName = params.get("CookieName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleTargets(AbstractModel):
    r"""Information of the real server bound to a forwarding rule under an HTTP/HTTPS listener

    """

    def __init__(self):
        r"""
        :param _LocationId: Forwarding rule ID
        :type LocationId: str
        :param _Domain: Domain name of the forwarding rule
        :type Domain: str
        :param _Url: Forwarding rule path.
        :type Url: str
        :param _Targets: Real server information
        :type Targets: list of Backend
        :param _FunctionTargets: Describes the backend cloud function info.
        :type FunctionTargets: list of FunctionTarget
        """
        self._LocationId = None
        self._Domain = None
        self._Url = None
        self._Targets = None
        self._FunctionTargets = None

    @property
    def LocationId(self):
        r"""Forwarding rule ID
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Domain name of the forwarding rule
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""Forwarding rule path.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Targets(self):
        r"""Real server information
        :rtype: list of Backend
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def FunctionTargets(self):
        r"""Describes the backend cloud function info.
        :rtype: list of FunctionTarget
        """
        return self._FunctionTargets

    @FunctionTargets.setter
    def FunctionTargets(self, FunctionTargets):
        self._FunctionTargets = FunctionTargets


    def _deserialize(self, params):
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = Backend()
                obj._deserialize(item)
                self._Targets.append(obj)
        if params.get("FunctionTargets") is not None:
            self._FunctionTargets = []
            for item in params.get("FunctionTargets"):
                obj = FunctionTarget()
                obj._deserialize(item)
                self._FunctionTargets.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RulesItems(AbstractModel):
    r"""Object bound to the layer-7 listener rule

    """

    def __init__(self):
        r"""
        :param _LocationId: Rule ID.
        :type LocationId: str
        :param _Domain: Domain name.
        :type Domain: str
        :param _Url: Uri
        :type Url: str
        :param _Targets: Object bound to the real server.
        :type Targets: list of LbRsTargets
        """
        self._LocationId = None
        self._Domain = None
        self._Url = None
        self._Targets = None

    @property
    def LocationId(self):
        r"""Rule ID.
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Domain(self):
        r"""Domain name.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Url(self):
        r"""Uri
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Targets(self):
        r"""Object bound to the real server.
        :rtype: list of LbRsTargets
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets


    def _deserialize(self, params):
        self._LocationId = params.get("LocationId")
        self._Domain = params.get("Domain")
        self._Url = params.get("Url")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = LbRsTargets()
                obj._deserialize(item)
                self._Targets.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetCustomizedConfigForLoadBalancerRequest(AbstractModel):
    r"""SetCustomizedConfigForLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _OperationType: Operation type.
-ADD. specifies the creation.
- DELETE: DELETE.
-UPDATE: modify.
-BIND: specifies the binding status.
-UNBIND: unbind.
        :type OperationType: str
        :param _UconfigId: Personalized configuration ID. this field is required except when creating a custom configuration, for example: pz-1234abcd.
        :type UconfigId: str
        :param _ConfigContent: Specifies the personalized configuration content. this field is required when creating or modifying custom configuration.
Specifies specific restrictions. view layer-7 personalized configuration (https://www.tencentcloud.comom/document/product/214/15171?from_cn_redirect=1).
        :type ConfigContent: str
        :param _ConfigName: Custom configuration name. specifies the name when creating or modifying a custom configuration. this field is required.
        :type ConfigName: str
        :param _LoadBalancerIds: CLB instance ID. this field is required for bind/unbind operations.
Can be queried through the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) api.
        :type LoadBalancerIds: list of str
        """
        self._OperationType = None
        self._UconfigId = None
        self._ConfigContent = None
        self._ConfigName = None
        self._LoadBalancerIds = None

    @property
    def OperationType(self):
        r"""Operation type.
-ADD. specifies the creation.
- DELETE: DELETE.
-UPDATE: modify.
-BIND: specifies the binding status.
-UNBIND: unbind.
        :rtype: str
        """
        return self._OperationType

    @OperationType.setter
    def OperationType(self, OperationType):
        self._OperationType = OperationType

    @property
    def UconfigId(self):
        r"""Personalized configuration ID. this field is required except when creating a custom configuration, for example: pz-1234abcd.
        :rtype: str
        """
        return self._UconfigId

    @UconfigId.setter
    def UconfigId(self, UconfigId):
        self._UconfigId = UconfigId

    @property
    def ConfigContent(self):
        r"""Specifies the personalized configuration content. this field is required when creating or modifying custom configuration.
Specifies specific restrictions. view layer-7 personalized configuration (https://www.tencentcloud.comom/document/product/214/15171?from_cn_redirect=1).
        :rtype: str
        """
        return self._ConfigContent

    @ConfigContent.setter
    def ConfigContent(self, ConfigContent):
        self._ConfigContent = ConfigContent

    @property
    def ConfigName(self):
        r"""Custom configuration name. specifies the name when creating or modifying a custom configuration. this field is required.
        :rtype: str
        """
        return self._ConfigName

    @ConfigName.setter
    def ConfigName(self, ConfigName):
        self._ConfigName = ConfigName

    @property
    def LoadBalancerIds(self):
        r"""CLB instance ID. this field is required for bind/unbind operations.
Can be queried through the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) api.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds


    def _deserialize(self, params):
        self._OperationType = params.get("OperationType")
        self._UconfigId = params.get("UconfigId")
        self._ConfigContent = params.get("ConfigContent")
        self._ConfigName = params.get("ConfigName")
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetCustomizedConfigForLoadBalancerResponse(AbstractModel):
    r"""SetCustomizedConfigForLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _ConfigId: Configuration ID, such as "pz-1234abcd"
        :type ConfigId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ConfigId = None
        self._RequestId = None

    @property
    def ConfigId(self):
        r"""Configuration ID, such as "pz-1234abcd"
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._RequestId = params.get("RequestId")


class SetLoadBalancerClsLogRequest(AbstractModel):
    r"""SetLoadBalancerClsLog request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        :param _LogSetId: Log set ID of cloud log service (CLS).
<li>Specifies the logset ID that can be obtained by calling the [DescribeLogsets](https://www.tencentcloud.comom/document/product/614/58624?from_cn_redirect=1) API when adding or updating a log topic.</li>.
<Li>When deleting a log topic, set this parameter to an empty string.</li>.
        :type LogSetId: str
        :param _LogTopicId: Specifies the log topic ID of cloud log service (CLS).
<li>Specifies the log topic ID can be obtained by calling the [DescribeTopics](https://www.tencentcloud.comom/document/product/614/56454?from_cn_redirect=1) API when adding or updating a log topic.</li>.
<Li>When deleting a log topic, set this parameter to an empty string.</li>.
        :type LogTopicId: str
        :param _LogType: Log type:
<li>`ACCESS`: access logs</li>
<li>`HEALTH`: health check logs</li>
Default: `ACCESS`
        :type LogType: str
        """
        self._LoadBalancerId = None
        self._LogSetId = None
        self._LogTopicId = None
        self._LogType = None

    @property
    def LoadBalancerId(self):
        r"""ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LogSetId(self):
        r"""Log set ID of cloud log service (CLS).
<li>Specifies the logset ID that can be obtained by calling the [DescribeLogsets](https://www.tencentcloud.comom/document/product/614/58624?from_cn_redirect=1) API when adding or updating a log topic.</li>.
<Li>When deleting a log topic, set this parameter to an empty string.</li>.
        :rtype: str
        """
        return self._LogSetId

    @LogSetId.setter
    def LogSetId(self, LogSetId):
        self._LogSetId = LogSetId

    @property
    def LogTopicId(self):
        r"""Specifies the log topic ID of cloud log service (CLS).
<li>Specifies the log topic ID can be obtained by calling the [DescribeTopics](https://www.tencentcloud.comom/document/product/614/56454?from_cn_redirect=1) API when adding or updating a log topic.</li>.
<Li>When deleting a log topic, set this parameter to an empty string.</li>.
        :rtype: str
        """
        return self._LogTopicId

    @LogTopicId.setter
    def LogTopicId(self, LogTopicId):
        self._LogTopicId = LogTopicId

    @property
    def LogType(self):
        r"""Log type:
<li>`ACCESS`: access logs</li>
<li>`HEALTH`: health check logs</li>
Default: `ACCESS`
        :rtype: str
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LogSetId = params.get("LogSetId")
        self._LogTopicId = params.get("LogTopicId")
        self._LogType = params.get("LogType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetLoadBalancerClsLogResponse(AbstractModel):
    r"""SetLoadBalancerClsLog response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SetLoadBalancerSecurityGroupsRequest(AbstractModel):
    r"""SetLoadBalancerSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        :param _SecurityGroups: Specifies an array of security group ids. a load balancing instance supports a maximum binding of 50 security groups. to unbind all security groups, omit this parameter.
Can be queried through the [DescribeSecurityGroups](https://www.tencentcloud.comom/document/product/215/15808?from_cn_redirect=1) api.
        :type SecurityGroups: list of str
        """
        self._LoadBalancerId = None
        self._SecurityGroups = None

    @property
    def LoadBalancerId(self):
        r"""ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def SecurityGroups(self):
        r"""Specifies an array of security group ids. a load balancing instance supports a maximum binding of 50 security groups. to unbind all security groups, omit this parameter.
Can be queried through the [DescribeSecurityGroups](https://www.tencentcloud.comom/document/product/215/15808?from_cn_redirect=1) api.
        :rtype: list of str
        """
        return self._SecurityGroups

    @SecurityGroups.setter
    def SecurityGroups(self, SecurityGroups):
        self._SecurityGroups = SecurityGroups


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._SecurityGroups = params.get("SecurityGroups")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetLoadBalancerSecurityGroupsResponse(AbstractModel):
    r"""SetLoadBalancerSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SetLoadBalancerStartStatusRequest(AbstractModel):
    r"""SetLoadBalancerStartStatus request structure.

    """

    def __init__(self):
        r"""
        :param _OperationType: Operation type. Start: Start the instance; Stop: Stop the instance.
        :type OperationType: str
        :param _LoadBalancerId: ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :type LoadBalancerId: str
        :param _ListenerIds: Listener ID. If this field is empty, it indicates operating the CLB instance; if not empty, it indicates operating the listener.
        :type ListenerIds: list of str
        """
        self._OperationType = None
        self._LoadBalancerId = None
        self._ListenerIds = None

    @property
    def OperationType(self):
        r"""Operation type. Start: Start the instance; Stop: Stop the instance.
        :rtype: str
        """
        return self._OperationType

    @OperationType.setter
    def OperationType(self, OperationType):
        self._OperationType = OperationType

    @property
    def LoadBalancerId(self):
        r"""ID of the cloud load balancer instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def ListenerIds(self):
        r"""Listener ID. If this field is empty, it indicates operating the CLB instance; if not empty, it indicates operating the listener.
        :rtype: list of str
        """
        return self._ListenerIds

    @ListenerIds.setter
    def ListenerIds(self, ListenerIds):
        self._ListenerIds = ListenerIds


    def _deserialize(self, params):
        self._OperationType = params.get("OperationType")
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._ListenerIds = params.get("ListenerIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetLoadBalancerStartStatusResponse(AbstractModel):
    r"""SetLoadBalancerStartStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SetSecurityGroupForLoadbalancersRequest(AbstractModel):
    r"""SetSecurityGroupForLoadbalancers request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroup: Security group ID, such as sg-12345678. can be obtained through the API [DescribeSecurityGroups](https://www.tencentcloud.comom/document/product/215/15808?from_cn_redirect=1).
        :type SecurityGroup: str
        :param _OperationType: ADD: bind a security group;
DEL: unbind a security group
        :type OperationType: str
        :param _LoadBalancerIds: ID array of the clb instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
Specifies the maximum length supported by the list is 20.
        :type LoadBalancerIds: list of str
        """
        self._SecurityGroup = None
        self._OperationType = None
        self._LoadBalancerIds = None

    @property
    def SecurityGroup(self):
        r"""Security group ID, such as sg-12345678. can be obtained through the API [DescribeSecurityGroups](https://www.tencentcloud.comom/document/product/215/15808?from_cn_redirect=1).
        :rtype: str
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def OperationType(self):
        r"""ADD: bind a security group;
DEL: unbind a security group
        :rtype: str
        """
        return self._OperationType

    @OperationType.setter
    def OperationType(self, OperationType):
        self._OperationType = OperationType

    @property
    def LoadBalancerIds(self):
        r"""ID array of the clb instance. you can call the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) API to query the ID.
Specifies the maximum length supported by the list is 20.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds


    def _deserialize(self, params):
        self._SecurityGroup = params.get("SecurityGroup")
        self._OperationType = params.get("OperationType")
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetSecurityGroupForLoadbalancersResponse(AbstractModel):
    r"""SetSecurityGroupForLoadbalancers response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SlaUpdateParam(AbstractModel):
    r"""Parameters for upgrading to an LCU-supported instance

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID.
Can be queried through the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) api.
        :type LoadBalancerId: str
        :param _SlaType: Specification of the LCU-supported instance. Valid values:<li> clb.c2.medium: Standard </li><li> clb.c3.small: Advanced 1 </li><li> clb.c3.medium: Advanced 2 </li><li> clb.c4.small: Super Large 1 </li><li> clb.c4.medium: Super Large 2 </li><li> clb.c4.large: Super Large 3 </li><li> clb.c4.xlarge: Super Large 4 </li> For specification details, see [Instance Specifications Comparison](https://intl.cloud.tencent.com/document/product/214/84689?from_cn_redirect=1).
        :type SlaType: str
        """
        self._LoadBalancerId = None
        self._SlaType = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID.
Can be queried through the [DescribeLoadBalancers](https://www.tencentcloud.comom/document/product/1108/48459?from_cn_redirect=1) api.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def SlaType(self):
        r"""Specification of the LCU-supported instance. Valid values:<li> clb.c2.medium: Standard </li><li> clb.c3.small: Advanced 1 </li><li> clb.c3.medium: Advanced 2 </li><li> clb.c4.small: Super Large 1 </li><li> clb.c4.medium: Super Large 2 </li><li> clb.c4.large: Super Large 3 </li><li> clb.c4.xlarge: Super Large 4 </li> For specification details, see [Instance Specifications Comparison](https://intl.cloud.tencent.com/document/product/214/84689?from_cn_redirect=1).
        :rtype: str
        """
        return self._SlaType

    @SlaType.setter
    def SlaType(self, SlaType):
        self._SlaType = SlaType


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._SlaType = params.get("SlaType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SnatIp(AbstractModel):
    r"""`SnatIp` information structure

    """

    def __init__(self):
        r"""
        :param _SubnetId: Unique VPC subnet ID, such as `subnet-12345678`.
        :type SubnetId: str
        :param _Ip: IP address, such as 192.168.0.1
        :type Ip: str
        """
        self._SubnetId = None
        self._Ip = None

    @property
    def SubnetId(self):
        r"""Unique VPC subnet ID, such as `subnet-12345678`.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Ip(self):
        r"""IP address, such as 192.168.0.1
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip


    def _deserialize(self, params):
        self._SubnetId = params.get("SubnetId")
        self._Ip = params.get("Ip")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SpecAvailability(AbstractModel):
    r"""Specification availability

    """

    def __init__(self):
        r"""
        :param _SpecType: Specifies the specification type.
<Li>Clb.C2.Medium (standard type)</li><li>clb.c3.small (advanced type 1)</li><li>clb.c3.medium (advanced type 2)</li>.
<li>clb.c4.small (high-strength type 1)</li> <li>clb.c4.medium (high-strength type 2)</li> <li>clb.c4.large (high-strength type 3)</li> <li>clb.c4.xlarge (high-strength type 4)</li> <li>shared (shared type)</li>.

        :type SpecType: str
        :param _Availability: Specification availability. resource availability, "Available": Available, "Unavailable": Unavailable.
        :type Availability: str
        """
        self._SpecType = None
        self._Availability = None

    @property
    def SpecType(self):
        r"""Specifies the specification type.
<Li>Clb.C2.Medium (standard type)</li><li>clb.c3.small (advanced type 1)</li><li>clb.c3.medium (advanced type 2)</li>.
<li>clb.c4.small (high-strength type 1)</li> <li>clb.c4.medium (high-strength type 2)</li> <li>clb.c4.large (high-strength type 3)</li> <li>clb.c4.xlarge (high-strength type 4)</li> <li>shared (shared type)</li>.

        :rtype: str
        """
        return self._SpecType

    @SpecType.setter
    def SpecType(self, SpecType):
        self._SpecType = SpecType

    @property
    def Availability(self):
        r"""Specification availability. resource availability, "Available": Available, "Unavailable": Unavailable.
        :rtype: str
        """
        return self._Availability

    @Availability.setter
    def Availability(self, Availability):
        self._Availability = Availability


    def _deserialize(self, params):
        self._SpecType = params.get("SpecType")
        self._Availability = params.get("Availability")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TagInfo(AbstractModel):
    r"""CLB tag information

    """

    def __init__(self):
        r"""
        :param _TagKey: Tag key
        :type TagKey: str
        :param _TagValue: Tag value
        :type TagValue: str
        """
        self._TagKey = None
        self._TagValue = None

    @property
    def TagKey(self):
        r"""Tag key
        :rtype: str
        """
        return self._TagKey

    @TagKey.setter
    def TagKey(self, TagKey):
        self._TagKey = TagKey

    @property
    def TagValue(self):
        r"""Tag value
        :rtype: str
        """
        return self._TagValue

    @TagValue.setter
    def TagValue(self, TagValue):
        self._TagValue = TagValue


    def _deserialize(self, params):
        self._TagKey = params.get("TagKey")
        self._TagValue = params.get("TagValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Target(AbstractModel):
    r"""Redirect target, i.e., the real server bound to a CLB

    """

    def __init__(self):
        r"""
        :param _Port: Specifies the listening port of the backend service.
Note: this parameter must be specified when binding to CVM (cloud virtual machine) or ENI (elastic network interface).
        :type Port: int
        :param _Type: Specifies the backend service type. valid values: CVM (cloud virtual machine), ENI (elastic network interface). as an input parameter, this parameter does not take effect currently.
        :type Type: str
        :param _InstanceId: This parameter must be passed in when binding to CVM. it represents the unique ID of the CVM and can be obtained from the InstanceId field in the response of the DescribeInstances api. indicates binding the primary IPv4 address of the primary network interface. the InstanceId cannot be specified in the following scenarios: binding to non-CVM resources, binding to auxiliary network interface ips on CVM, binding to CVM through cross-domain 2.0, and binding to IPv6 addresses of CVM.
Note: you can only input one of the InstanceId parameter or the EniIp parameter.
        :type InstanceId: str
        :param _Weight: The new forwarding weight of the real server. Value range: [0, 100]. Default: 10. This parameter takes priority over `Weight` in [`RsWeightRule`](https://intl.cloud.tencent.com/document/api/214/30694?from_cn_redirect=1#RsWeightRule). If it’s left empty, the value of `Weight` in `RsWeightRule` will be used.
        :type Weight: int
        :param _EniIp: This parameter must be passed in for IP binding. it supports eni ips and other private IP addresses. if it is an eni, it must first be bound to a CVM before binding to a cloud load balancer instance.
Note: only one of the InstanceId parameter and EniIp parameter can be passed. if binding a dual-stack IPV6 instance, this parameter must be passed. if it is a cross-region binding, the parameter must be passed and the InstanceId parameter is not supported.
        :type EniIp: str
        :param _Tag: Tag.
        :type Tag: str
        """
        self._Port = None
        self._Type = None
        self._InstanceId = None
        self._Weight = None
        self._EniIp = None
        self._Tag = None

    @property
    def Port(self):
        r"""Specifies the listening port of the backend service.
Note: this parameter must be specified when binding to CVM (cloud virtual machine) or ENI (elastic network interface).
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Type(self):
        r"""Specifies the backend service type. valid values: CVM (cloud virtual machine), ENI (elastic network interface). as an input parameter, this parameter does not take effect currently.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InstanceId(self):
        r"""This parameter must be passed in when binding to CVM. it represents the unique ID of the CVM and can be obtained from the InstanceId field in the response of the DescribeInstances api. indicates binding the primary IPv4 address of the primary network interface. the InstanceId cannot be specified in the following scenarios: binding to non-CVM resources, binding to auxiliary network interface ips on CVM, binding to CVM through cross-domain 2.0, and binding to IPv6 addresses of CVM.
Note: you can only input one of the InstanceId parameter or the EniIp parameter.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Weight(self):
        r"""The new forwarding weight of the real server. Value range: [0, 100]. Default: 10. This parameter takes priority over `Weight` in [`RsWeightRule`](https://intl.cloud.tencent.com/document/api/214/30694?from_cn_redirect=1#RsWeightRule). If it’s left empty, the value of `Weight` in `RsWeightRule` will be used.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def EniIp(self):
        r"""This parameter must be passed in for IP binding. it supports eni ips and other private IP addresses. if it is an eni, it must first be bound to a CVM before binding to a cloud load balancer instance.
Note: only one of the InstanceId parameter and EniIp parameter can be passed. if binding a dual-stack IPV6 instance, this parameter must be passed. if it is a cross-region binding, the parameter must be passed and the InstanceId parameter is not supported.
        :rtype: str
        """
        return self._EniIp

    @EniIp.setter
    def EniIp(self, EniIp):
        self._EniIp = EniIp

    @property
    def Tag(self):
        r"""Tag.
        :rtype: str
        """
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag


    def _deserialize(self, params):
        self._Port = params.get("Port")
        self._Type = params.get("Type")
        self._InstanceId = params.get("InstanceId")
        self._Weight = params.get("Weight")
        self._EniIp = params.get("EniIp")
        self._Tag = params.get("Tag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetGroupAssociation(AbstractModel):
    r"""Association between rule and target group

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB instance ID
        :type LoadBalancerId: str
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _ListenerId: Listener ID. This parameter is required when the AssociateTargetGroups and DisassociateTargetGroups APIs are called.
        :type ListenerId: str
        :param _LocationId: Forwarding rule ID
        :type LocationId: str
        :param _Weight: Weight of the target group. Value range: [0, 100]. It takes effect only for binding v2 target groups. If not specified, it defaults to 10.
        :type Weight: int
        """
        self._LoadBalancerId = None
        self._TargetGroupId = None
        self._ListenerId = None
        self._LocationId = None
        self._Weight = None

    @property
    def LoadBalancerId(self):
        r"""CLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def ListenerId(self):
        r"""Listener ID. This parameter is required when the AssociateTargetGroups and DisassociateTargetGroups APIs are called.
        :rtype: str
        """
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def LocationId(self):
        r"""Forwarding rule ID
        :rtype: str
        """
        return self._LocationId

    @LocationId.setter
    def LocationId(self, LocationId):
        self._LocationId = LocationId

    @property
    def Weight(self):
        r"""Weight of the target group. Value range: [0, 100]. It takes effect only for binding v2 target groups. If not specified, it defaults to 10.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._TargetGroupId = params.get("TargetGroupId")
        self._ListenerId = params.get("ListenerId")
        self._LocationId = params.get("LocationId")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetGroupBackend(AbstractModel):
    r"""Real server bound to a target group

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _Type: Real server type. Valid values: CVM, ENI (coming soon)
        :type Type: str
        :param _InstanceId: Unique real server ID
        :type InstanceId: str
        :param _Port: Specifies the listening port of the backend service. for a port range listener, this field returns 0, representing an invalid port, indicating settings not supported.
        :type Port: int
        :param _Weight: Forwarding weight of real server. Value range: [0, 100]. Default value: 10.
        :type Weight: int
        :param _PublicIpAddresses: Public network IP of the real server
        :type PublicIpAddresses: list of str
        :param _PrivateIpAddresses: Private network IP of the real server
        :type PrivateIpAddresses: list of str
        :param _InstanceName: Instance name of the real server
        :type InstanceName: str
        :param _RegisteredTime: Real server binding time
Note: this field may return null, indicating that no valid values can be obtained.
        :type RegisteredTime: str
        :param _EniId: Unique ID of the ENI
        :type EniId: str
        :param _ZoneId: Specifies the availability zone ID of the backend service.
        :type ZoneId: int
        """
        self._TargetGroupId = None
        self._Type = None
        self._InstanceId = None
        self._Port = None
        self._Weight = None
        self._PublicIpAddresses = None
        self._PrivateIpAddresses = None
        self._InstanceName = None
        self._RegisteredTime = None
        self._EniId = None
        self._ZoneId = None

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def Type(self):
        r"""Real server type. Valid values: CVM, ENI (coming soon)
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InstanceId(self):
        r"""Unique real server ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Port(self):
        r"""Specifies the listening port of the backend service. for a port range listener, this field returns 0, representing an invalid port, indicating settings not supported.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Weight(self):
        r"""Forwarding weight of real server. Value range: [0, 100]. Default value: 10.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def PublicIpAddresses(self):
        r"""Public network IP of the real server
        :rtype: list of str
        """
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses

    @property
    def PrivateIpAddresses(self):
        r"""Private network IP of the real server
        :rtype: list of str
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def InstanceName(self):
        r"""Instance name of the real server
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def RegisteredTime(self):
        r"""Real server binding time
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RegisteredTime

    @RegisteredTime.setter
    def RegisteredTime(self, RegisteredTime):
        self._RegisteredTime = RegisteredTime

    @property
    def EniId(self):
        r"""Unique ID of the ENI
        :rtype: str
        """
        return self._EniId

    @EniId.setter
    def EniId(self, EniId):
        self._EniId = EniId

    @property
    def ZoneId(self):
        r"""Specifies the availability zone ID of the backend service.
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        self._Type = params.get("Type")
        self._InstanceId = params.get("InstanceId")
        self._Port = params.get("Port")
        self._Weight = params.get("Weight")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        self._PrivateIpAddresses = params.get("PrivateIpAddresses")
        self._InstanceName = params.get("InstanceName")
        self._RegisteredTime = params.get("RegisteredTime")
        self._EniId = params.get("EniId")
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetGroupHealthCheck(AbstractModel):
    r"""Details of target group health check

    """

    def __init__(self):
        r"""
        :param _HealthSwitch: Whether to enable the health check.
        :type HealthSwitch: bool
        :param _Protocol: Health check method. among them, only the new version V2 target group type supports this parameter. valid values: TCP | HTTP | HTTPS | PING | CUSTOM. among them:.
<ur><li>When the backend forwarding protocol of the target group is TCP, the health check method supports TCP/HTTP/CUSTOM, with a default value of TCP.</li><li>when the backend forwarding protocol of the target group is UDP, the health check method supports PING/CUSTOM, with a default value of PING.</li><li>when the backend forwarding protocol of the target group is HTTP, the health check method supports HTTP/TCP, with a default value of HTTP.</li><li>when the backend forwarding protocol of the target group is HTTPS, the health check method supports HTTPS/TCP, with a default value of HTTPS.</li><li>when the backend forwarding protocol of the target group is GRPC, the health check method supports GRPC/TCP, with a default value of GRPC.</li></ur>.
        :type Protocol: str
        :param _Port: Custom check parameters. health check port, defaults to the port of the backend service unless you want to specify a specific port, otherwise leave it blank. (applicable only to TCP/UDP target group).

        :type Port: int
        :param _Timeout: Health check timeout. The default is 2 seconds. Value range: 2-30 seconds.
        :type Timeout: int
        :param _GapTime: Detection interval time. The default is 5 seconds. Value range: 2-300 seconds.
        :type GapTime: int
        :param _GoodLimit: Health detection threshold. The default is 3 times. Value range: 2-10 times.
        :type GoodLimit: int
        :param _BadLimit: Unhealth detection threshold. The default is 3 times. Value range: 2-10 times.
        :type BadLimit: int
        :param _JumboFrame: Indicates whether jumbo frames are enabled for probe packets of all rss in the target group. enabled by default. this parameter is supported only for GWLB type target groups.
        :type JumboFrame: bool
        :param _HttpCode: Health check status code (applicable only to HTTP/HTTPS target group and HTTP health check method of TCP target group). value range: 1~31. default: 31. among them: <url> <li>1 means post-detection return value 1xx represents health.</li> <li>2 means return 2xx represents health.</li> <li>4 means return 3xx represents health.</li> <li>8 means return 4xx represents health.</li> <li>16 means return 5xx represents health.</li></url> to have multiple return codes represent health, sum up corresponding values.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpCode: int
        :param _HttpCheckDomain: Health check domain name. among them: <ur><li>applicable only to HTTP/HTTPS target groups and TCP target groups when using HTTP health check method.</li><li>targeting HTTP/HTTPS target groups, this parameter is required when using HTTP health check method.</li></ur>.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpCheckDomain: str
        :param _HttpCheckPath: Health check path (applicable only to HTTP/HTTPS forwarding rules and HTTP health checks of TCP listeners).
Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpCheckPath: str
        :param _HttpCheckMethod: Health check method (applicable only to HTTP/HTTPS forwarding rules and HTTP health checks of TCP listeners). Default: HEAD. Valid values: HEAD and GET.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpCheckMethod: str
        :param _ContextType: Input format of health check. required when health check method is CUSTOM. valid values: HEX or TEXT. among them:<ur><li>TEXT: TEXT format.</li><li>HEX: hexadecimal format. characters of SendContext and RecvContext can only be selected from 0123456789ABCDEF and the length must be an even number.</li><li>applicable only to TCP/UDP target group.</li></ur>.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContextType: str
        :param _SendContext: CUSTOM check parameters. required when the CheckType value is CUSTOM, represents the content of the request sent by the health check, only ASCII visible characters, maximum length limit 500. applicable only to TCP/UDP target group.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SendContext: str
        :param _RecvContext: CUSTOM check parameters. required when the CheckType value is CUSTOM. represents the result returned by the health check. only ASCII visible characters are allowed. maximum length limit is 500. (applicable only to TCP/UDP target group).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RecvContext: str
        :param _HttpVersion: HTTP version, where: <ur><li>this field is required if the value of CheckType is HTTP.</li><li>supports configuration options: HTTP/1.0, HTTP/1.1.</li><li>applicable only to TCP target group.</li></ur>.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpVersion: str
        :param _ExtendedCode: Health check status code when the protocol is GRPC. (this parameter applies only to target groups with the backend forwarding protocol of GRPC.) default value: 12. valid values: a single numerical value, multiple numerical values, or a range. for example, 20, 20,25, or 0-99.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExtendedCode: str
        """
        self._HealthSwitch = None
        self._Protocol = None
        self._Port = None
        self._Timeout = None
        self._GapTime = None
        self._GoodLimit = None
        self._BadLimit = None
        self._JumboFrame = None
        self._HttpCode = None
        self._HttpCheckDomain = None
        self._HttpCheckPath = None
        self._HttpCheckMethod = None
        self._ContextType = None
        self._SendContext = None
        self._RecvContext = None
        self._HttpVersion = None
        self._ExtendedCode = None

    @property
    def HealthSwitch(self):
        r"""Whether to enable the health check.
        :rtype: bool
        """
        return self._HealthSwitch

    @HealthSwitch.setter
    def HealthSwitch(self, HealthSwitch):
        self._HealthSwitch = HealthSwitch

    @property
    def Protocol(self):
        r"""Health check method. among them, only the new version V2 target group type supports this parameter. valid values: TCP | HTTP | HTTPS | PING | CUSTOM. among them:.
<ur><li>When the backend forwarding protocol of the target group is TCP, the health check method supports TCP/HTTP/CUSTOM, with a default value of TCP.</li><li>when the backend forwarding protocol of the target group is UDP, the health check method supports PING/CUSTOM, with a default value of PING.</li><li>when the backend forwarding protocol of the target group is HTTP, the health check method supports HTTP/TCP, with a default value of HTTP.</li><li>when the backend forwarding protocol of the target group is HTTPS, the health check method supports HTTPS/TCP, with a default value of HTTPS.</li><li>when the backend forwarding protocol of the target group is GRPC, the health check method supports GRPC/TCP, with a default value of GRPC.</li></ur>.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        r"""Custom check parameters. health check port, defaults to the port of the backend service unless you want to specify a specific port, otherwise leave it blank. (applicable only to TCP/UDP target group).

        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Timeout(self):
        r"""Health check timeout. The default is 2 seconds. Value range: 2-30 seconds.
        :rtype: int
        """
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout

    @property
    def GapTime(self):
        r"""Detection interval time. The default is 5 seconds. Value range: 2-300 seconds.
        :rtype: int
        """
        return self._GapTime

    @GapTime.setter
    def GapTime(self, GapTime):
        self._GapTime = GapTime

    @property
    def GoodLimit(self):
        r"""Health detection threshold. The default is 3 times. Value range: 2-10 times.
        :rtype: int
        """
        return self._GoodLimit

    @GoodLimit.setter
    def GoodLimit(self, GoodLimit):
        self._GoodLimit = GoodLimit

    @property
    def BadLimit(self):
        r"""Unhealth detection threshold. The default is 3 times. Value range: 2-10 times.
        :rtype: int
        """
        return self._BadLimit

    @BadLimit.setter
    def BadLimit(self, BadLimit):
        self._BadLimit = BadLimit

    @property
    def JumboFrame(self):
        r"""Indicates whether jumbo frames are enabled for probe packets of all rss in the target group. enabled by default. this parameter is supported only for GWLB type target groups.
        :rtype: bool
        """
        return self._JumboFrame

    @JumboFrame.setter
    def JumboFrame(self, JumboFrame):
        self._JumboFrame = JumboFrame

    @property
    def HttpCode(self):
        r"""Health check status code (applicable only to HTTP/HTTPS target group and HTTP health check method of TCP target group). value range: 1~31. default: 31. among them: <url> <li>1 means post-detection return value 1xx represents health.</li> <li>2 means return 2xx represents health.</li> <li>4 means return 3xx represents health.</li> <li>8 means return 4xx represents health.</li> <li>16 means return 5xx represents health.</li></url> to have multiple return codes represent health, sum up corresponding values.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._HttpCode

    @HttpCode.setter
    def HttpCode(self, HttpCode):
        self._HttpCode = HttpCode

    @property
    def HttpCheckDomain(self):
        r"""Health check domain name. among them: <ur><li>applicable only to HTTP/HTTPS target groups and TCP target groups when using HTTP health check method.</li><li>targeting HTTP/HTTPS target groups, this parameter is required when using HTTP health check method.</li></ur>.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HttpCheckDomain

    @HttpCheckDomain.setter
    def HttpCheckDomain(self, HttpCheckDomain):
        self._HttpCheckDomain = HttpCheckDomain

    @property
    def HttpCheckPath(self):
        r"""Health check path (applicable only to HTTP/HTTPS forwarding rules and HTTP health checks of TCP listeners).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HttpCheckPath

    @HttpCheckPath.setter
    def HttpCheckPath(self, HttpCheckPath):
        self._HttpCheckPath = HttpCheckPath

    @property
    def HttpCheckMethod(self):
        r"""Health check method (applicable only to HTTP/HTTPS forwarding rules and HTTP health checks of TCP listeners). Default: HEAD. Valid values: HEAD and GET.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HttpCheckMethod

    @HttpCheckMethod.setter
    def HttpCheckMethod(self, HttpCheckMethod):
        self._HttpCheckMethod = HttpCheckMethod

    @property
    def ContextType(self):
        r"""Input format of health check. required when health check method is CUSTOM. valid values: HEX or TEXT. among them:<ur><li>TEXT: TEXT format.</li><li>HEX: hexadecimal format. characters of SendContext and RecvContext can only be selected from 0123456789ABCDEF and the length must be an even number.</li><li>applicable only to TCP/UDP target group.</li></ur>.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ContextType

    @ContextType.setter
    def ContextType(self, ContextType):
        self._ContextType = ContextType

    @property
    def SendContext(self):
        r"""CUSTOM check parameters. required when the CheckType value is CUSTOM, represents the content of the request sent by the health check, only ASCII visible characters, maximum length limit 500. applicable only to TCP/UDP target group.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SendContext

    @SendContext.setter
    def SendContext(self, SendContext):
        self._SendContext = SendContext

    @property
    def RecvContext(self):
        r"""CUSTOM check parameters. required when the CheckType value is CUSTOM. represents the result returned by the health check. only ASCII visible characters are allowed. maximum length limit is 500. (applicable only to TCP/UDP target group).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RecvContext

    @RecvContext.setter
    def RecvContext(self, RecvContext):
        self._RecvContext = RecvContext

    @property
    def HttpVersion(self):
        r"""HTTP version, where: <ur><li>this field is required if the value of CheckType is HTTP.</li><li>supports configuration options: HTTP/1.0, HTTP/1.1.</li><li>applicable only to TCP target group.</li></ur>.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HttpVersion

    @HttpVersion.setter
    def HttpVersion(self, HttpVersion):
        self._HttpVersion = HttpVersion

    @property
    def ExtendedCode(self):
        r"""Health check status code when the protocol is GRPC. (this parameter applies only to target groups with the backend forwarding protocol of GRPC.) default value: 12. valid values: a single numerical value, multiple numerical values, or a range. for example, 20, 20,25, or 0-99.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExtendedCode

    @ExtendedCode.setter
    def ExtendedCode(self, ExtendedCode):
        self._ExtendedCode = ExtendedCode


    def _deserialize(self, params):
        self._HealthSwitch = params.get("HealthSwitch")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        self._Timeout = params.get("Timeout")
        self._GapTime = params.get("GapTime")
        self._GoodLimit = params.get("GoodLimit")
        self._BadLimit = params.get("BadLimit")
        self._JumboFrame = params.get("JumboFrame")
        self._HttpCode = params.get("HttpCode")
        self._HttpCheckDomain = params.get("HttpCheckDomain")
        self._HttpCheckPath = params.get("HttpCheckPath")
        self._HttpCheckMethod = params.get("HttpCheckMethod")
        self._ContextType = params.get("ContextType")
        self._SendContext = params.get("SendContext")
        self._RecvContext = params.get("RecvContext")
        self._HttpVersion = params.get("HttpVersion")
        self._ExtendedCode = params.get("ExtendedCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetGroupInfo(AbstractModel):
    r"""Target group information

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _VpcId: `vpcid` of target group
        :type VpcId: str
        :param _TargetGroupName: Target group name
        :type TargetGroupName: str
        :param _Port: Specifies the default port of the target group. for a full listen target group, this field returns 0, indicating an invalid port.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Port: int
        :param _CreatedTime: Target group creation time
        :type CreatedTime: str
        :param _UpdatedTime: Target group modification time
        :type UpdatedTime: str
        :param _AssociatedRule: Associated rule array. This parameter cannot be obtained when the DescribeTargetGroupList API is called.Note: This field may return null, indicating that no valid values can be obtained.
        :type AssociatedRule: list of AssociationItem
        :param _Protocol: Backend forwarding protocol of the target group. only returns valid values for the new version (v2) target group.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Protocol: str
        :param _ScheduleAlgorithm: Scheduling algorithm. returns a valid value only when the backend forwarding protocol is HTTP, HTTPS, or GRPC. available values:.
<ur>
<Li>WRR: weighted round-robin.</li>.
<Li>LEAST_CONN: specifies the least connection.</li>.
<Li>IP_HASH: based on ip hash.</li>.
</ur>

Note: This field may return null, indicating that no valid values can be obtained.
        :type ScheduleAlgorithm: str
        :param _HealthCheck: Health check details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HealthCheck: :class:`tencentcloud.clb.v20180317.models.TargetGroupHealthCheck`
        :param _TargetGroupType: Target group type, currently supported v1 (legacy version target group) and v2 (new version target group). defaults to v1 (legacy version target group).
        :type TargetGroupType: str
        :param _AssociatedRuleCount: Number of rules associated with the target group.
        :type AssociatedRuleCount: int
        :param _RegisteredInstancesCount: Specifies the number of instances in the target group.
        :type RegisteredInstancesCount: int
        :param _Tag: Tag.
        :type Tag: list of TagInfo
        :param _Weight: Default weight. only target groups of v2 type return this field. when NULL is returned, it means the default weight is not set.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Weight: int
        :param _FullListenSwitch: Specifies whether to listen to all target groups.
        :type FullListenSwitch: bool
        :param _KeepaliveEnable: Whether to enable persistent connections. valid only when the backend forwarding protocol is HTTP/HTTPS/GRPC and returned by the target group.
        :type KeepaliveEnable: bool
        :param _SessionExpireTime: Session persistence time. valid only when the backend forwarding protocol is HTTP/HTTPS/GRPC and the target group returns a valid value.
        :type SessionExpireTime: int
        :param _IpVersion: IP version.
        :type IpVersion: str
        """
        self._TargetGroupId = None
        self._VpcId = None
        self._TargetGroupName = None
        self._Port = None
        self._CreatedTime = None
        self._UpdatedTime = None
        self._AssociatedRule = None
        self._Protocol = None
        self._ScheduleAlgorithm = None
        self._HealthCheck = None
        self._TargetGroupType = None
        self._AssociatedRuleCount = None
        self._RegisteredInstancesCount = None
        self._Tag = None
        self._Weight = None
        self._FullListenSwitch = None
        self._KeepaliveEnable = None
        self._SessionExpireTime = None
        self._IpVersion = None

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def VpcId(self):
        r"""`vpcid` of target group
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def TargetGroupName(self):
        r"""Target group name
        :rtype: str
        """
        return self._TargetGroupName

    @TargetGroupName.setter
    def TargetGroupName(self, TargetGroupName):
        self._TargetGroupName = TargetGroupName

    @property
    def Port(self):
        r"""Specifies the default port of the target group. for a full listen target group, this field returns 0, indicating an invalid port.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def CreatedTime(self):
        r"""Target group creation time
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def UpdatedTime(self):
        r"""Target group modification time
        :rtype: str
        """
        return self._UpdatedTime

    @UpdatedTime.setter
    def UpdatedTime(self, UpdatedTime):
        self._UpdatedTime = UpdatedTime

    @property
    def AssociatedRule(self):
        r"""Associated rule array. This parameter cannot be obtained when the DescribeTargetGroupList API is called.Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of AssociationItem
        """
        return self._AssociatedRule

    @AssociatedRule.setter
    def AssociatedRule(self, AssociatedRule):
        self._AssociatedRule = AssociatedRule

    @property
    def Protocol(self):
        r"""Backend forwarding protocol of the target group. only returns valid values for the new version (v2) target group.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def ScheduleAlgorithm(self):
        r"""Scheduling algorithm. returns a valid value only when the backend forwarding protocol is HTTP, HTTPS, or GRPC. available values:.
<ur>
<Li>WRR: weighted round-robin.</li>.
<Li>LEAST_CONN: specifies the least connection.</li>.
<Li>IP_HASH: based on ip hash.</li>.
</ur>

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ScheduleAlgorithm

    @ScheduleAlgorithm.setter
    def ScheduleAlgorithm(self, ScheduleAlgorithm):
        self._ScheduleAlgorithm = ScheduleAlgorithm

    @property
    def HealthCheck(self):
        r"""Health check details.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.clb.v20180317.models.TargetGroupHealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def TargetGroupType(self):
        r"""Target group type, currently supported v1 (legacy version target group) and v2 (new version target group). defaults to v1 (legacy version target group).
        :rtype: str
        """
        return self._TargetGroupType

    @TargetGroupType.setter
    def TargetGroupType(self, TargetGroupType):
        self._TargetGroupType = TargetGroupType

    @property
    def AssociatedRuleCount(self):
        r"""Number of rules associated with the target group.
        :rtype: int
        """
        return self._AssociatedRuleCount

    @AssociatedRuleCount.setter
    def AssociatedRuleCount(self, AssociatedRuleCount):
        self._AssociatedRuleCount = AssociatedRuleCount

    @property
    def RegisteredInstancesCount(self):
        r"""Specifies the number of instances in the target group.
        :rtype: int
        """
        return self._RegisteredInstancesCount

    @RegisteredInstancesCount.setter
    def RegisteredInstancesCount(self, RegisteredInstancesCount):
        self._RegisteredInstancesCount = RegisteredInstancesCount

    @property
    def Tag(self):
        r"""Tag.
        :rtype: list of TagInfo
        """
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Weight(self):
        r"""Default weight. only target groups of v2 type return this field. when NULL is returned, it means the default weight is not set.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def FullListenSwitch(self):
        r"""Specifies whether to listen to all target groups.
        :rtype: bool
        """
        return self._FullListenSwitch

    @FullListenSwitch.setter
    def FullListenSwitch(self, FullListenSwitch):
        self._FullListenSwitch = FullListenSwitch

    @property
    def KeepaliveEnable(self):
        r"""Whether to enable persistent connections. valid only when the backend forwarding protocol is HTTP/HTTPS/GRPC and returned by the target group.
        :rtype: bool
        """
        return self._KeepaliveEnable

    @KeepaliveEnable.setter
    def KeepaliveEnable(self, KeepaliveEnable):
        self._KeepaliveEnable = KeepaliveEnable

    @property
    def SessionExpireTime(self):
        r"""Session persistence time. valid only when the backend forwarding protocol is HTTP/HTTPS/GRPC and the target group returns a valid value.
        :rtype: int
        """
        return self._SessionExpireTime

    @SessionExpireTime.setter
    def SessionExpireTime(self, SessionExpireTime):
        self._SessionExpireTime = SessionExpireTime

    @property
    def IpVersion(self):
        r"""IP version.
        :rtype: str
        """
        return self._IpVersion

    @IpVersion.setter
    def IpVersion(self, IpVersion):
        self._IpVersion = IpVersion


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        self._VpcId = params.get("VpcId")
        self._TargetGroupName = params.get("TargetGroupName")
        self._Port = params.get("Port")
        self._CreatedTime = params.get("CreatedTime")
        self._UpdatedTime = params.get("UpdatedTime")
        if params.get("AssociatedRule") is not None:
            self._AssociatedRule = []
            for item in params.get("AssociatedRule"):
                obj = AssociationItem()
                obj._deserialize(item)
                self._AssociatedRule.append(obj)
        self._Protocol = params.get("Protocol")
        self._ScheduleAlgorithm = params.get("ScheduleAlgorithm")
        if params.get("HealthCheck") is not None:
            self._HealthCheck = TargetGroupHealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        self._TargetGroupType = params.get("TargetGroupType")
        self._AssociatedRuleCount = params.get("AssociatedRuleCount")
        self._RegisteredInstancesCount = params.get("RegisteredInstancesCount")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Weight = params.get("Weight")
        self._FullListenSwitch = params.get("FullListenSwitch")
        self._KeepaliveEnable = params.get("KeepaliveEnable")
        self._SessionExpireTime = params.get("SessionExpireTime")
        self._IpVersion = params.get("IpVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetGroupInstance(AbstractModel):
    r"""Target group instance

    """

    def __init__(self):
        r"""
        :param _BindIP: Private IP of target group instance
        :type BindIP: str
        :param _Port: Port of target group instance. this field is not supported for full listen target groups.
        :type Port: int
        :param _Weight: Weight of a target group instance
Specifies that the Weight must be configured for a v2 target group. when calling the CreateTargetGroup API for target group creation, this parameter is used in combination with the Weight parameter in the create api, and one of them is required.
Valid values: 0-100.
        :type Weight: int
        :param _NewPort: The new port of the target group instance. this field is not supported for full listen target groups.
        :type NewPort: int
        """
        self._BindIP = None
        self._Port = None
        self._Weight = None
        self._NewPort = None

    @property
    def BindIP(self):
        r"""Private IP of target group instance
        :rtype: str
        """
        return self._BindIP

    @BindIP.setter
    def BindIP(self, BindIP):
        self._BindIP = BindIP

    @property
    def Port(self):
        r"""Port of target group instance. this field is not supported for full listen target groups.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Weight(self):
        r"""Weight of a target group instance
Specifies that the Weight must be configured for a v2 target group. when calling the CreateTargetGroup API for target group creation, this parameter is used in combination with the Weight parameter in the create api, and one of them is required.
Valid values: 0-100.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def NewPort(self):
        r"""The new port of the target group instance. this field is not supported for full listen target groups.
        :rtype: int
        """
        return self._NewPort

    @NewPort.setter
    def NewPort(self, NewPort):
        self._NewPort = NewPort


    def _deserialize(self, params):
        self._BindIP = params.get("BindIP")
        self._Port = params.get("Port")
        self._Weight = params.get("Weight")
        self._NewPort = params.get("NewPort")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetHealth(AbstractModel):
    r"""Describes the health information of a target

    """

    def __init__(self):
        r"""
        :param _IP: Private IP of the target
        :type IP: str
        :param _Port: Port bound to the target
        :type Port: int
        :param _HealthStatus: Current health status. true: healthy; false: unhealthy.
        :type HealthStatus: bool
        :param _TargetId: Instance ID of the target, such as ins-12345678
        :type TargetId: str
        :param _HealthStatusDetail: Describes the detailed information of the current health status. for example: Alive, Dead, Unknown, Close. Alive status is healthy, Dead state is abnormal, Unknown status includes not started, checking, Unknown status, Close means health check disabled or listener status stop.
        :type HealthStatusDetail: str
        :param _HealthStatusDetial: (**This parameter will be disused soon. Please use `HealthStatusDetail` instead.**) Details of the current health status. Values: `Alive` (healthy), `Dead` (abnormal), `Unknown` (Health check not started/checking/unknown status)
        :type HealthStatusDetial: str
        :param _TargetGroupId: Target group unique ID.
        :type TargetGroupId: str
        :param _Weight: Specifies the weight of the Target.
        :type Weight: int
        """
        self._IP = None
        self._Port = None
        self._HealthStatus = None
        self._TargetId = None
        self._HealthStatusDetail = None
        self._HealthStatusDetial = None
        self._TargetGroupId = None
        self._Weight = None

    @property
    def IP(self):
        r"""Private IP of the target
        :rtype: str
        """
        return self._IP

    @IP.setter
    def IP(self, IP):
        self._IP = IP

    @property
    def Port(self):
        r"""Port bound to the target
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def HealthStatus(self):
        r"""Current health status. true: healthy; false: unhealthy.
        :rtype: bool
        """
        return self._HealthStatus

    @HealthStatus.setter
    def HealthStatus(self, HealthStatus):
        self._HealthStatus = HealthStatus

    @property
    def TargetId(self):
        r"""Instance ID of the target, such as ins-12345678
        :rtype: str
        """
        return self._TargetId

    @TargetId.setter
    def TargetId(self, TargetId):
        self._TargetId = TargetId

    @property
    def HealthStatusDetail(self):
        r"""Describes the detailed information of the current health status. for example: Alive, Dead, Unknown, Close. Alive status is healthy, Dead state is abnormal, Unknown status includes not started, checking, Unknown status, Close means health check disabled or listener status stop.
        :rtype: str
        """
        return self._HealthStatusDetail

    @HealthStatusDetail.setter
    def HealthStatusDetail(self, HealthStatusDetail):
        self._HealthStatusDetail = HealthStatusDetail

    @property
    def HealthStatusDetial(self):
        warnings.warn("parameter `HealthStatusDetial` is deprecated", DeprecationWarning) 

        r"""(**This parameter will be disused soon. Please use `HealthStatusDetail` instead.**) Details of the current health status. Values: `Alive` (healthy), `Dead` (abnormal), `Unknown` (Health check not started/checking/unknown status)
        :rtype: str
        """
        return self._HealthStatusDetial

    @HealthStatusDetial.setter
    def HealthStatusDetial(self, HealthStatusDetial):
        warnings.warn("parameter `HealthStatusDetial` is deprecated", DeprecationWarning) 

        self._HealthStatusDetial = HealthStatusDetial

    @property
    def TargetGroupId(self):
        r"""Target group unique ID.
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def Weight(self):
        r"""Specifies the weight of the Target.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._IP = params.get("IP")
        self._Port = params.get("Port")
        self._HealthStatus = params.get("HealthStatus")
        self._TargetId = params.get("TargetId")
        self._HealthStatusDetail = params.get("HealthStatusDetail")
        self._HealthStatusDetial = params.get("HealthStatusDetial")
        self._TargetGroupId = params.get("TargetGroupId")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetRegionInfo(AbstractModel):
    r"""Information of the real server bound to a CLB instance, including region and network to which it belongs.

    """

    def __init__(self):
        r"""
        :param _Region: Region of the target, such as ap-guangzhou
        :type Region: str
        :param _VpcId: Network of the target, which is in the format of vpc-abcd1234 for VPC or 0 for basic network
        :type VpcId: str
        :param _NumericalVpcId: Target'S network, in the format of 86323 for a private network, or 0 if it is a basic network.
        :type NumericalVpcId: int
        """
        self._Region = None
        self._VpcId = None
        self._NumericalVpcId = None

    @property
    def Region(self):
        r"""Region of the target, such as ap-guangzhou
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def VpcId(self):
        r"""Network of the target, which is in the format of vpc-abcd1234 for VPC or 0 for basic network
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NumericalVpcId(self):
        r"""Target'S network, in the format of 86323 for a private network, or 0 if it is a basic network.
        :rtype: int
        """
        return self._NumericalVpcId

    @NumericalVpcId.setter
    def NumericalVpcId(self, NumericalVpcId):
        self._NumericalVpcId = NumericalVpcId


    def _deserialize(self, params):
        self._Region = params.get("Region")
        self._VpcId = params.get("VpcId")
        self._NumericalVpcId = params.get("NumericalVpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TypeInfo(AbstractModel):
    r"""ISP Type

    """

    def __init__(self):
        r"""
        :param _Type: Operator type.
        :type Type: str
        :param _SpecAvailabilitySet: Specification availability.
        :type SpecAvailabilitySet: list of SpecAvailability
        """
        self._Type = None
        self._SpecAvailabilitySet = None

    @property
    def Type(self):
        r"""Operator type.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SpecAvailabilitySet(self):
        r"""Specification availability.
        :rtype: list of SpecAvailability
        """
        return self._SpecAvailabilitySet

    @SpecAvailabilitySet.setter
    def SpecAvailabilitySet(self, SpecAvailabilitySet):
        self._SpecAvailabilitySet = SpecAvailabilitySet


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("SpecAvailabilitySet") is not None:
            self._SpecAvailabilitySet = []
            for item in params.get("SpecAvailabilitySet"):
                obj = SpecAvailability()
                obj._deserialize(item)
                self._SpecAvailabilitySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ZoneInfo(AbstractModel):
    r"""AZ information

    """

    def __init__(self):
        r"""
        :param _ZoneId: Unique ID of the AZ in numeric form, such as 100001
        :type ZoneId: int
        :param _Zone: Unique ID of the AZ in string format, such as ap-guangzhou-1
        :type Zone: str
        :param _ZoneName: AZ name, such as Guangzhou 1
        :type ZoneName: str
        :param _ZoneRegion: Specifies the region of the availability zone, for example: ap-guangzhou.
        :type ZoneRegion: str
        :param _LocalZone: Indicates whether the AZ is a LocalZone az, for example: false.
        :type LocalZone: bool
        :param _EdgeZone: Indicates whether the AZ is an EdgeZone az, for example: false.
        :type EdgeZone: bool
        """
        self._ZoneId = None
        self._Zone = None
        self._ZoneName = None
        self._ZoneRegion = None
        self._LocalZone = None
        self._EdgeZone = None

    @property
    def ZoneId(self):
        r"""Unique ID of the AZ in numeric form, such as 100001
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Zone(self):
        r"""Unique ID of the AZ in string format, such as ap-guangzhou-1
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def ZoneName(self):
        r"""AZ name, such as Guangzhou 1
        :rtype: str
        """
        return self._ZoneName

    @ZoneName.setter
    def ZoneName(self, ZoneName):
        self._ZoneName = ZoneName

    @property
    def ZoneRegion(self):
        r"""Specifies the region of the availability zone, for example: ap-guangzhou.
        :rtype: str
        """
        return self._ZoneRegion

    @ZoneRegion.setter
    def ZoneRegion(self, ZoneRegion):
        self._ZoneRegion = ZoneRegion

    @property
    def LocalZone(self):
        r"""Indicates whether the AZ is a LocalZone az, for example: false.
        :rtype: bool
        """
        return self._LocalZone

    @LocalZone.setter
    def LocalZone(self, LocalZone):
        self._LocalZone = LocalZone

    @property
    def EdgeZone(self):
        r"""Indicates whether the AZ is an EdgeZone az, for example: false.
        :rtype: bool
        """
        return self._EdgeZone

    @EdgeZone.setter
    def EdgeZone(self, EdgeZone):
        self._EdgeZone = EdgeZone


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Zone = params.get("Zone")
        self._ZoneName = params.get("ZoneName")
        self._ZoneRegion = params.get("ZoneRegion")
        self._LocalZone = params.get("LocalZone")
        self._EdgeZone = params.get("EdgeZone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ZoneResource(AbstractModel):
    r"""List of AZs

    """

    def __init__(self):
        r"""
        :param _MasterZone: Primary AZ, such as "ap-guangzhou-1".
        :type MasterZone: str
        :param _ResourceSet: Resource list.
        :type ResourceSet: list of Resource
        :param _SlaveZone: Secondary AZ, such as "ap-guangzhou-2". 
Note: This field may return null, indicating that no valid values can be obtained.
        :type SlaveZone: str
        :param _IPVersion: IP version. Values: `IPv4`, `IPv6`, and `IPv6_Nat`.
        :type IPVersion: str
        :param _ZoneRegion: Region of the AZ, such as `ap-guangzhou`.
        :type ZoneRegion: str
        :param _LocalZone: Whether the AZ is a `LocalZone`. Values: `true`, `false`.
        :type LocalZone: bool
        :param _ZoneResourceType: Type of resources in the zone. Values: `SHARED`, `EXCLUSIVE`
        :type ZoneResourceType: str
        :param _EdgeZone: Whether the AZ is an edge zone. Values: `true`, `false`.
        :type EdgeZone: bool
        :param _Egress: Specifies the network outbound.
        :type Egress: str
        """
        self._MasterZone = None
        self._ResourceSet = None
        self._SlaveZone = None
        self._IPVersion = None
        self._ZoneRegion = None
        self._LocalZone = None
        self._ZoneResourceType = None
        self._EdgeZone = None
        self._Egress = None

    @property
    def MasterZone(self):
        r"""Primary AZ, such as "ap-guangzhou-1".
        :rtype: str
        """
        return self._MasterZone

    @MasterZone.setter
    def MasterZone(self, MasterZone):
        self._MasterZone = MasterZone

    @property
    def ResourceSet(self):
        r"""Resource list.
        :rtype: list of Resource
        """
        return self._ResourceSet

    @ResourceSet.setter
    def ResourceSet(self, ResourceSet):
        self._ResourceSet = ResourceSet

    @property
    def SlaveZone(self):
        r"""Secondary AZ, such as "ap-guangzhou-2". 
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SlaveZone

    @SlaveZone.setter
    def SlaveZone(self, SlaveZone):
        self._SlaveZone = SlaveZone

    @property
    def IPVersion(self):
        r"""IP version. Values: `IPv4`, `IPv6`, and `IPv6_Nat`.
        :rtype: str
        """
        return self._IPVersion

    @IPVersion.setter
    def IPVersion(self, IPVersion):
        self._IPVersion = IPVersion

    @property
    def ZoneRegion(self):
        r"""Region of the AZ, such as `ap-guangzhou`.
        :rtype: str
        """
        return self._ZoneRegion

    @ZoneRegion.setter
    def ZoneRegion(self, ZoneRegion):
        self._ZoneRegion = ZoneRegion

    @property
    def LocalZone(self):
        r"""Whether the AZ is a `LocalZone`. Values: `true`, `false`.
        :rtype: bool
        """
        return self._LocalZone

    @LocalZone.setter
    def LocalZone(self, LocalZone):
        self._LocalZone = LocalZone

    @property
    def ZoneResourceType(self):
        r"""Type of resources in the zone. Values: `SHARED`, `EXCLUSIVE`
        :rtype: str
        """
        return self._ZoneResourceType

    @ZoneResourceType.setter
    def ZoneResourceType(self, ZoneResourceType):
        self._ZoneResourceType = ZoneResourceType

    @property
    def EdgeZone(self):
        r"""Whether the AZ is an edge zone. Values: `true`, `false`.
        :rtype: bool
        """
        return self._EdgeZone

    @EdgeZone.setter
    def EdgeZone(self, EdgeZone):
        self._EdgeZone = EdgeZone

    @property
    def Egress(self):
        r"""Specifies the network outbound.
        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress


    def _deserialize(self, params):
        self._MasterZone = params.get("MasterZone")
        if params.get("ResourceSet") is not None:
            self._ResourceSet = []
            for item in params.get("ResourceSet"):
                obj = Resource()
                obj._deserialize(item)
                self._ResourceSet.append(obj)
        self._SlaveZone = params.get("SlaveZone")
        self._IPVersion = params.get("IPVersion")
        self._ZoneRegion = params.get("ZoneRegion")
        self._LocalZone = params.get("LocalZone")
        self._ZoneResourceType = params.get("ZoneResourceType")
        self._EdgeZone = params.get("EdgeZone")
        self._Egress = params.get("Egress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        