import { FargateTaskDefinition } from '@aws-cdk/aws-ecs';
import { Construct } from '@aws-cdk/core';
import { ScheduledTaskBase, ScheduledTaskBaseProps, ScheduledTaskImageProps } from '../base/scheduled-task-base';
/**
 * The properties for the ScheduledFargateTask task.
 */
export interface ScheduledFargateTaskProps extends ScheduledTaskBaseProps {
    /**
     * The properties to define if using an existing TaskDefinition in this construct.
     * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
     *
     * @default none
     */
    readonly scheduledFargateTaskDefinitionOptions?: ScheduledFargateTaskDefinitionOptions;
    /**
     * The properties to define if the construct is to create a TaskDefinition.
     * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
     *
     * @default none
     */
    readonly scheduledFargateTaskImageOptions?: ScheduledFargateTaskImageOptions;
}
/**
 * The properties for the ScheduledFargateTask using an image.
 */
export interface ScheduledFargateTaskImageOptions extends ScheduledTaskImageProps {
    /**
     * The number of cpu units used by the task.
     *
     * Valid values, which determines your range of valid values for the memory parameter:
     *
     * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
     *
     * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
     *
     * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
     *
     * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
     *
     * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
     *
     * This default is set in the underlying FargateTaskDefinition construct.
     *
     * @default 256
     */
    readonly cpu?: number;
    /**
     * The hard limit (in MiB) of memory to present to the container.
     *
     * If your container attempts to exceed the allocated memory, the container
     * is terminated.
     *
     * @default 512
     */
    readonly memoryLimitMiB?: number;
}
/**
 * The properties for the ScheduledFargateTask using a task definition.
 */
export interface ScheduledFargateTaskDefinitionOptions {
    /**
     * The task definition to use for tasks in the service. Image or taskDefinition must be specified, but not both.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @default - none
     */
    readonly taskDefinition: FargateTaskDefinition;
}
/**
 * A scheduled Fargate task that will be initiated off of CloudWatch Events.
 */
export declare class ScheduledFargateTask extends ScheduledTaskBase {
    /**
     * The Fargate task definition in this construct.
     */
    readonly taskDefinition: FargateTaskDefinition;
    /**
     * Constructs a new instance of the ScheduledFargateTask class.
     */
    constructor(scope: Construct, id: string, props: ScheduledFargateTaskProps);
}
