# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-05-01 11:42


from django.db import migrations



def add_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    File = apps.get_model('files', 'File')
    # File = apps.get_model('filefields', 'FileFields')
    for file in File.objects.all():
        if file.password and file.password != '':
            file.file_obj.password = file.password
            file.file_obj.iv = file.iv
            file.file_obj.is_encrypt_needed = True
            file.file_obj.save()


def remove_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    File = apps.get_model('files', 'File')
    for file in File.objects.all():
        if file.file_obj.is_encrypt_needed:
            file.password = file.file_obj.password
            file.iv = file.file_obj.iv
            file.save()


class Migration(migrations.Migration):

    dependencies = [
        ('files', '0005_file_publish_date'),
    ]

    operations = [
        migrations.RunPython(add_keys, reverse_code=remove_keys),
    ]
