# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-10-25 16:02


from django.db import migrations
from aparnik.utils.utils import convert_iran_phone_number_to_world_number


class Migration(migrations.Migration):

    dependencies = [
        ('aparnik_users', '0006_user_avatar'),
    ]

    def convert_username(apps, schema_editor):
        '''
        We can't import the Post model directly as it may be a newer
        version than this migration expects. We use the historical version.
        '''
        User = apps.get_model('aparnik_users', 'User')
        for user in User.objects.all():
            user.username = convert_iran_phone_number_to_world_number(user.username)
            user.save()

    operations = [
        migrations.RunPython(convert_username),
    ]
