# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-12-13 18:45


from django.db import migrations


def create_through_relations(apps, schema_editor):
    Segment = apps.get_model('segments', 'BaseSegment')
    PageSort = apps.get_model('segments', 'PageSort')
    for obj in Segment.objects.all():
        for page_obj in obj.pages.all():
            PageSort(
                page_obj=page_obj,
                segment_obj=obj,
                sort=0
            ).save()


class Migration(migrations.Migration):

    dependencies = [
        ('segments', '0007_pagesort'),
    ]

    operations = [
        migrations.RunPython(create_through_relations, reverse_code=migrations.RunPython.noop),
    ]
