# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-12-13 16:07


from django.db import migrations


def create_through_relations(apps, schema_editor):
    Segment = apps.get_model('segments', 'BaseSegment')
    SegmentSort = apps.get_model('segments', 'SegmentSort')
    for obj in Segment.objects.all():
        for model_obj in obj.model_obj.all():
            SegmentSort(
                model_obj=model_obj,
                segment_obj=obj,
                sort=0
            ).save()


class Migration(migrations.Migration):

    dependencies = [
        ('segments', '0003_segmentsort'),
    ]

    operations = [
        migrations.RunPython(create_through_relations, reverse_code=migrations.RunPython.noop),
    ]
