# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-06-13 18:15


from django.db import migrations


def add_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    QA = apps.get_model('questionanswers', 'QA')
    for obj in QA.objects.all():
        obj.model_obj2 = obj.model_obj
        obj.save()


def remove_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    # FileField = apps.get_model('filefields', 'FileField')
    QA = apps.get_model('questionanswers', 'QA')
    for obj in QA.objects.all():
        obj.model_obj = obj.model_obj2
        obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ('questionanswers', '0004_qa_model_obj2'),
    ]

    operations = [
        migrations.RunPython(add_keys, reverse_code=remove_keys),
    ]
