# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-05-01 17:10


from django.db import migrations
from aparnik.utils.utils import is_app_installed


def add_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    try:
        CourseFile = apps.get_model('courses', 'CourseFile')
        for course_file in CourseFile.objects.all():
            course_file.file_obj.seconds = course_file.seconds
            course_file.file_obj.save()
    except:
        return


def remove_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    # FileField = apps.get_model('filefields', 'FileField')
    try:
        CourseFile = apps.get_model('courses', 'CourseFile')
        for course_file in CourseFile.objects.all():
            course_file.seconds = course_file.file_obj.seconds
            course_file.save()
    except:
        return


class Migration(migrations.Migration):

    dependencies = [
        ('filefields', '0007_filefield_seconds'),
    ]

    operations = [
        migrations.RunPython(add_keys, reverse_code=remove_keys),
    ]
