# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-11-20 10:55


import aparnik.utils.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('filefields', '0004_filefield_title'),
        ('socials', '0001_initial'),
        ('shortblogs', '0001_initial'),
        ('sliders', '0004_sliderimage'),
    ]

    operations = [
        migrations.CreateModel(
            name='Information',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('website', models.URLField(max_length=255, verbose_name='Website')),
                ('address', models.CharField(max_length=255, verbose_name='Address')),
                ('phone', aparnik.utils.fields.PhoneField(max_length=255, validators=[django.core.validators.RegexValidator(code=b'nomatch', message='phone is not valid, please insert with code', regex=b'^0(?!0)\\d{2}([0-9]{8})$')], verbose_name='Phone Number')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='Email')),
                ('about_us', models.TextField(verbose_name='About Us')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('update_at', models.DateTimeField(auto_now=True, verbose_name='Update at')),
                ('image', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='filefields.FileField', verbose_name='Image')),
                ('short_blogs', models.ManyToManyField(to='shortblogs.ShortBlog', verbose_name='Content Segment')),
                ('slider_segment_obj', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='aboutus_sliders', to='sliders.SliderSegment', verbose_name='Slider Segment')),
                ('socials', models.ManyToManyField(to='socials.SocialNetwork', verbose_name='Socials')),
            ],
            options={
                'verbose_name': 'Information',
                'verbose_name_plural': 'Informations',
            },
        ),
    ]
