# @Created Date: 2020-10-10 04:06:02 pm
# @Filename: data.py
# @Email:  1730416009@stu.suda.edu.cn
# @Author: ZeFeng Zhu
# @Last Modified: 2020-10-10 04:06:06 pm
# @Copyright (c) 2020 MinghuiGroup, Soochow University
# from copy import deepcopy

'''
class SwapKeyDict(dict):

    def __missing__(self, key):
        swap = key[::-1]
        if swap not in self:
            if hasattr(self, 'gap') and None in key:
                return self.gap
            raise KeyError(key)
        else:
            return self[swap]

    def set_gap(self, gap):
        cur = deepcopy(self)
        cur.gap = gap
        return cur
'''

def store_swap_key(data_from, data_to):
    for key, value in data_from.items():
        data_to[key] = value
        data_to[key[::-1]] = value
    return data_to

'''
Matrix Data From: https://github.com/biopython/biopython/blob/master/Bio/SubsMat/MatrixInfo.py
'''

blosum62 = store_swap_key({
    ('W', 'F'): 1, ('L', 'R'): -2, ('S', 'P'): -1, ('V', 'T'): 0,
    ('Q', 'Q'): 5, ('N', 'A'): -2, ('Z', 'Y'): -2, ('W', 'R'): -3,
    ('Q', 'A'): -1, ('S', 'D'): 0, ('H', 'H'): 8, ('S', 'H'): -1,
    ('H', 'D'): -1, ('L', 'N'): -3, ('W', 'A'): -3, ('Y', 'M'): -1,
    ('G', 'R'): -2, ('Y', 'I'): -1, ('Y', 'E'): -2, ('B', 'Y'): -3,
    ('Y', 'A'): -2, ('V', 'D'): -3, ('B', 'S'): 0, ('Y', 'Y'): 7,
    ('G', 'N'): 0, ('E', 'C'): -4, ('Y', 'Q'): -1, ('Z', 'Z'): 4,
    ('V', 'A'): 0, ('C', 'C'): 9, ('M', 'R'): -1, ('V', 'E'): -2,
    ('T', 'N'): 0, ('P', 'P'): 7, ('V', 'I'): 3, ('V', 'S'): -2,
    ('Z', 'P'): -1, ('V', 'M'): 1, ('T', 'F'): -2, ('V', 'Q'): -2,
    ('K', 'K'): 5, ('P', 'D'): -1, ('I', 'H'): -3, ('I', 'D'): -3,
    ('T', 'R'): -1, ('P', 'L'): -3, ('K', 'G'): -2, ('M', 'N'): -2,
    ('P', 'H'): -2, ('F', 'Q'): -3, ('Z', 'G'): -2, ('X', 'L'): -1,
    ('T', 'M'): -1, ('Z', 'C'): -3, ('X', 'H'): -1, ('D', 'R'): -2,
    ('B', 'W'): -4, ('X', 'D'): -1, ('Z', 'K'): 1, ('F', 'A'): -2,
    ('Z', 'W'): -3, ('F', 'E'): -3, ('D', 'N'): 1, ('B', 'K'): 0,
    ('X', 'X'): -1, ('F', 'I'): 0, ('B', 'G'): -1, ('X', 'T'): 0,
    ('F', 'M'): 0, ('B', 'C'): -3, ('Z', 'I'): -3, ('Z', 'V'): -2,
    ('S', 'S'): 4, ('L', 'Q'): -2, ('W', 'E'): -3, ('Q', 'R'): 1,
    ('N', 'N'): 6, ('W', 'M'): -1, ('Q', 'C'): -3, ('W', 'I'): -3,
    ('S', 'C'): -1, ('L', 'A'): -1, ('S', 'G'): 0, ('L', 'E'): -3,
    ('W', 'Q'): -2, ('H', 'G'): -2, ('S', 'K'): 0, ('Q', 'N'): 0,
    ('N', 'R'): 0, ('H', 'C'): -3, ('Y', 'N'): -2, ('G', 'Q'): -2,
    ('Y', 'F'): 3, ('C', 'A'): 0, ('V', 'L'): 1, ('G', 'E'): -2,
    ('G', 'A'): 0, ('K', 'R'): 2, ('E', 'D'): 2, ('Y', 'R'): -2,
    ('M', 'Q'): 0, ('T', 'I'): -1, ('C', 'D'): -3, ('V', 'F'): -1,
    ('T', 'A'): 0, ('T', 'P'): -1, ('B', 'P'): -2, ('T', 'E'): -1,
    ('V', 'N'): -3, ('P', 'G'): -2, ('M', 'A'): -1, ('K', 'H'): -1,
    ('V', 'R'): -3, ('P', 'C'): -3, ('M', 'E'): -2, ('K', 'L'): -2,
    ('V', 'V'): 4, ('M', 'I'): 1, ('T', 'Q'): -1, ('I', 'G'): -4,
    ('P', 'K'): -1, ('M', 'M'): 5, ('K', 'D'): -1, ('I', 'C'): -1,
    ('Z', 'D'): 1, ('F', 'R'): -3, ('X', 'K'): -1, ('Q', 'D'): 0,
    ('X', 'G'): -1, ('Z', 'L'): -3, ('X', 'C'): -2, ('Z', 'H'): 0,
    ('B', 'L'): -4, ('B', 'H'): 0, ('F', 'F'): 6, ('X', 'W'): -2,
    ('B', 'D'): 4, ('D', 'A'): -2, ('S', 'L'): -2, ('X', 'S'): 0,
    ('F', 'N'): -3, ('S', 'R'): -1, ('W', 'D'): -4, ('V', 'Y'): -1,
    ('W', 'L'): -2, ('H', 'R'): 0, ('W', 'H'): -2, ('H', 'N'): 1,
    ('W', 'T'): -2, ('T', 'T'): 5, ('S', 'F'): -2, ('W', 'P'): -4,
    ('L', 'D'): -4, ('B', 'I'): -3, ('L', 'H'): -3, ('S', 'N'): 1,
    ('B', 'T'): -1, ('L', 'L'): 4, ('Y', 'K'): -2, ('E', 'Q'): 2,
    ('Y', 'G'): -3, ('Z', 'S'): 0, ('Y', 'C'): -2, ('G', 'D'): -1,
    ('B', 'V'): -3, ('E', 'A'): -1, ('Y', 'W'): 2, ('E', 'E'): 5,
    ('Y', 'S'): -2, ('C', 'N'): -3, ('V', 'C'): -1, ('T', 'H'): -2,
    ('P', 'R'): -2, ('V', 'G'): -3, ('T', 'L'): -1, ('V', 'K'): -2,
    ('K', 'Q'): 1, ('R', 'A'): -1, ('I', 'R'): -3, ('T', 'D'): -1,
    ('P', 'F'): -4, ('I', 'N'): -3, ('K', 'I'): -3, ('M', 'D'): -3,
    ('V', 'W'): -3, ('W', 'W'): 11, ('M', 'H'): -2, ('P', 'N'): -2,
    ('K', 'A'): -1, ('M', 'L'): 2, ('K', 'E'): 1, ('Z', 'E'): 4,
    ('X', 'N'): -1, ('Z', 'A'): -1, ('Z', 'M'): -1, ('X', 'F'): -1,
    ('K', 'C'): -3, ('B', 'Q'): 0, ('X', 'B'): -1, ('B', 'M'): -3,
    ('F', 'C'): -2, ('Z', 'Q'): 3, ('X', 'Z'): -1, ('F', 'G'): -3,
    ('B', 'E'): 1, ('X', 'V'): -1, ('F', 'K'): -3, ('B', 'A'): -2,
    ('X', 'R'): -1, ('D', 'D'): 6, ('W', 'G'): -2, ('Z', 'F'): -3,
    ('S', 'Q'): 0, ('W', 'C'): -2, ('W', 'K'): -3, ('H', 'Q'): 0,
    ('L', 'C'): -1, ('W', 'N'): -4, ('S', 'A'): 1, ('L', 'G'): -4,
    ('W', 'S'): -3, ('S', 'E'): 0, ('H', 'E'): 0, ('S', 'I'): -2,
    ('H', 'A'): -2, ('S', 'M'): -1, ('Y', 'L'): -1, ('Y', 'H'): 2,
    ('Y', 'D'): -3, ('E', 'R'): 0, ('X', 'P'): -2, ('G', 'G'): 6,
    ('G', 'C'): -3, ('E', 'N'): 0, ('Y', 'T'): -2, ('Y', 'P'): -3,
    ('T', 'K'): -1, ('A', 'A'): 4, ('P', 'Q'): -1, ('T', 'C'): -1,
    ('V', 'H'): -3, ('T', 'G'): -2, ('I', 'Q'): -3, ('Z', 'T'): -1,
    ('C', 'R'): -3, ('V', 'P'): -2, ('P', 'E'): -1, ('M', 'C'): -1,
    ('K', 'N'): 0, ('I', 'I'): 4, ('P', 'A'): -1, ('M', 'G'): -3,
    ('T', 'S'): 1, ('I', 'E'): -3, ('P', 'M'): -2, ('M', 'K'): -1,
    ('I', 'A'): -1, ('P', 'I'): -3, ('R', 'R'): 5, ('X', 'M'): -1,
    ('L', 'I'): 2, ('X', 'I'): -1, ('Z', 'B'): 1, ('X', 'E'): -1,
    ('Z', 'N'): 0, ('X', 'A'): 0, ('B', 'R'): -1, ('B', 'N'): 3,
    ('F', 'D'): -3, ('X', 'Y'): -1, ('Z', 'R'): 0, ('F', 'H'): -1,
    ('B', 'F'): -3, ('F', 'L'): 0, ('X', 'Q'): -1, ('B', 'B'): 4
}, dict())

blosum95 = store_swap_key({
    ("W", "F"): 0, ("L", "R"): -3, ("S", "P"): -2, ("V", "T"): -1,
    ("Q", "Q"): 7, ("N", "A"): -2, ("Z", "Y"): -4, ("W", "R"): -4,
    ("Q", "A"): -1, ("S", "D"): -1, ("H", "H"): 9, ("S", "H"): -2,
    ("H", "D"): -2, ("L", "N"): -5, ("W", "A"): -4, ("Y", "M"): -3,
    ("G", "R"): -4, ("Y", "I"): -2, ("Y", "E"): -4, ("B", "Y"): -4,
    ("Y", "A"): -3, ("V", "D"): -5, ("B", "S"): -1, ("Y", "Y"): 8,
    ("G", "N"): -1, ("E", "C"): -6, ("Y", "Q"): -3, ("Z", "Z"): 4,
    ("V", "A"): -1, ("C", "C"): 9, ("M", "R"): -2, ("V", "E"): -3,
    ("T", "N"): -1, ("P", "P"): 8, ("V", "I"): 3, ("V", "S"): -3,
    ("Z", "P"): -2, ("V", "M"): 0, ("T", "F"): -3, ("V", "Q"): -3,
    ("K", "K"): 6, ("P", "D"): -3, ("I", "H"): -4, ("I", "D"): -5,
    ("T", "R"): -2, ("P", "L"): -4, ("K", "G"): -3, ("M", "N"): -3,
    ("P", "H"): -3, ("F", "Q"): -4, ("Z", "G"): -3, ("X", "L"): -2,
    ("T", "M"): -1, ("Z", "C"): -5, ("X", "H"): -2, ("D", "R"): -3,
    ("B", "W"): -6, ("X", "D"): -2, ("Z", "K"): 0, ("F", "A"): -3,
    ("Z", "W"): -4, ("F", "E"): -5, ("D", "N"): 1, ("B", "K"): -1,
    ("X", "X"): -2, ("F", "I"): -1, ("B", "G"): -2, ("X", "T"): -1,
    ("F", "M"): -1, ("B", "C"): -4, ("Z", "I"): -4, ("Z", "V"): -3,
    ("S", "S"): 5, ("L", "Q"): -3, ("W", "E"): -5, ("Q", "R"): 0,
    ("N", "N"): 7, ("W", "M"): -2, ("Q", "C"): -4, ("W", "I"): -4,
    ("S", "C"): -2, ("L", "A"): -2, ("S", "G"): -1, ("L", "E"): -4,
    ("W", "Q"): -3, ("H", "G"): -3, ("S", "K"): -1, ("Q", "N"): 0,
    ("N", "R"): -1, ("H", "C"): -5, ("Y", "N"): -3, ("G", "Q"): -3,
    ("Y", "F"): 3, ("C", "A"): -1, ("V", "L"): 0, ("G", "E"): -3,
    ("G", "A"): -1, ("K", "R"): 2, ("E", "D"): 1, ("Y", "R"): -3,
    ("M", "Q"): -1, ("T", "I"): -2, ("C", "D"): -5, ("V", "F"): -2,
    ("T", "A"): 0, ("T", "P"): -2, ("B", "P"): -3, ("T", "E"): -2,
    ("V", "N"): -4, ("P", "G"): -4, ("M", "A"): -2, ("K", "H"): -1,
    ("V", "R"): -4, ("P", "C"): -5, ("M", "E"): -3, ("K", "L"): -3,
    ("V", "V"): 5, ("M", "I"): 1, ("T", "Q"): -1, ("I", "G"): -6,
    ("P", "K"): -2, ("M", "M"): 7, ("K", "D"): -2, ("I", "C"): -2,
    ("Z", "D"): 0, ("F", "R"): -4, ("X", "K"): -1, ("Q", "D"): -1,
    ("X", "G"): -3, ("Z", "L"): -4, ("X", "C"): -3, ("Z", "H"): 0,
    ("B", "L"): -5, ("B", "H"): -1, ("F", "F"): 7, ("X", "W"): -4,
    ("B", "D"): 4, ("D", "A"): -3, ("S", "L"): -3, ("X", "S"): -1,
    ("F", "N"): -4, ("S", "R"): -2, ("W", "D"): -6, ("V", "Y"): -3,
    ("W", "L"): -3, ("H", "R"): -1, ("W", "H"): -3, ("H", "N"): 0,
    ("W", "T"): -4, ("T", "T"): 6, ("S", "F"): -3, ("W", "P"): -5,
    ("L", "D"): -5, ("B", "I"): -5, ("L", "H"): -4, ("S", "N"): 0,
    ("B", "T"): -1, ("L", "L"): 5, ("Y", "K"): -3, ("E", "Q"): 2,
    ("Y", "G"): -5, ("Z", "S"): -1, ("Y", "C"): -4, ("G", "D"): -2,
    ("B", "V"): -5, ("E", "A"): -1, ("Y", "W"): 2, ("E", "E"): 6,
    ("Y", "S"): -3, ("C", "N"): -4, ("V", "C"): -2, ("T", "H"): -2,
    ("P", "R"): -3, ("V", "G"): -5, ("T", "L"): -2, ("V", "K"): -3,
    ("K", "Q"): 1, ("R", "A"): -2, ("I", "R"): -4, ("T", "D"): -2,
    ("P", "F"): -5, ("I", "N"): -4, ("K", "I"): -4, ("M", "D"): -5,
    ("V", "W"): -3, ("W", "W"): 11, ("M", "H"): -3, ("P", "N"): -3,
    ("K", "A"): -1, ("M", "L"): 2, ("K", "E"): 0, ("Z", "E"): 4,
    ("X", "N"): -2, ("Z", "A"): -1, ("Z", "M"): -2, ("X", "F"): -2,
    ("K", "C"): -5, ("B", "Q"): -1, ("X", "B"): -2, ("B", "M"): -4,
    ("F", "C"): -3, ("Z", "Q"): 4, ("X", "Z"): -1, ("F", "G"): -5,
    ("B", "E"): 0, ("X", "V"): -2, ("F", "K"): -4, ("B", "A"): -3,
    ("X", "R"): -2, ("D", "D"): 7, ("W", "G"): -5, ("Z", "F"): -4,
    ("S", "Q"): -1, ("W", "C"): -4, ("W", "K"): -5, ("H", "Q"): 1,
    ("L", "C"): -3, ("W", "N"): -5, ("S", "A"): 1, ("L", "G"): -5,
    ("W", "S"): -4, ("S", "E"): -1, ("H", "E"): -1, ("S", "I"): -3,
    ("H", "A"): -3, ("S", "M"): -3, ("Y", "L"): -2, ("Y", "H"): 1,
    ("Y", "D"): -5, ("E", "R"): -1, ("X", "P"): -3, ("G", "G"): 6,
    ("G", "C"): -5, ("E", "N"): -1, ("Y", "T"): -3, ("Y", "P"): -5,
    ("T", "K"): -1, ("A", "A"): 5, ("P", "Q"): -2, ("T", "C"): -2,
    ("V", "H"): -4, ("T", "G"): -3, ("I", "Q"): -4, ("Z", "T"): -2,
    ("C", "R"): -5, ("V", "P"): -4, ("P", "E"): -2, ("M", "C"): -3,
    ("K", "N"): 0, ("I", "I"): 5, ("P", "A"): -1, ("M", "G"): -4,
    ("T", "S"): 1, ("I", "E"): -4, ("P", "M"): -3, ("M", "K"): -2,
    ("I", "A"): -2, ("P", "I"): -4, ("R", "R"): 7, ("X", "M"): -2,
    ("L", "I"): 1, ("X", "I"): -2, ("Z", "B"): 0, ("X", "E"): -2,
    ("Z", "N"): -1, ("X", "A"): -1, ("B", "R"): -2, ("B", "N"): 4,
    ("F", "D"): -5, ("X", "Y"): -2, ("Z", "R"): -1, ("F", "H"): -2,
    ("B", "F"): -5, ("F", "L"): 0, ("X", "Q"): -1, ("B", "B"): 4
}, dict())


'''
Reference

* Original Paper: Miyata T, Miyazawa S, Yasunaga T. Two types of amino acid substitutions in protein evolution. J Mol Evol. 1979 Mar 15;12(3):219-36. doi: 10.1007/BF01732340. PMID: 439147.
* Matrix Data From: https://web.archive.org/web/19991013233553/http://www.embl-heidelberg.de/~vogt/matrices/miyata.cmp
* Above Link Provided by: https://github.com/biopython/biopython/blob/master/Bio/SubsMat/MatrixInfo.py
* Wiki: https://en.wikipedia.org/wiki/Amino_acid_replacement

This miyata similarity matrix obtained from the above link is derived by (similarity_i = highest_similarity - distance_i) with the original distance matrix as input.
    NOTE: highest_similarity=1.25
After transform the distance matrix into a similarity matrix, normalize each value by the highest_similarity.
    NOTE: now the maximum similarity is 1
'''

miyata_similarity_matrix = store_swap_key({
 ('A', 'A'): 1.0,
 ('A', 'C'): -0.112,
 ('A', 'P'): 0.952,
 ('C', 'C'): 1.0,
 ('D', 'A'): -0.896,
 ('D', 'C'): -1.784,
 ('D', 'D'): 1.0,
 ('D', 'E'): 0.28,
 ('D', 'G'): -0.896,
 ('D', 'N'): 0.48,
 ('D', 'P'): -0.92,
 ('D', 'Q'): -0.176,
 ('D', 'S'): -0.496,
 ('D', 'T'): -0.64,
 ('E', 'A'): -0.968,
 ('E', 'C'): -1.608,
 ('E', 'E'): 1.0,
 ('E', 'G'): -1.224,
 ('E', 'P'): -0.984,
 ('E', 'Q'): 0.328,
 ('E', 'S'): -0.648,
 ('E', 'T'): -0.464,
 ('F', 'A'): -1.584,
 ('F', 'C'): -0.792,
 ('F', 'D'): -2.416,
 ('F', 'E'): -1.872,
 ('F', 'F'): 1.0,
 ('F', 'G'): -2.312,
 ('F', 'H'): -1.104,
 ('F', 'I'): 0.512,
 ('F', 'K'): -1.28,
 ('F', 'L'): 0.496,
 ('F', 'M'): 0.344,
 ('F', 'N'): -1.96,
 ('F', 'P'): -1.536,
 ('F', 'Q'): -1.248,
 ('F', 'R'): -0.976,
 ('F', 'S'): -1.76,
 ('F', 'T'): -1.08,
 ('F', 'V'): -0.144,
 ('G', 'A'): 0.272,
 ('G', 'C'): -0.776,
 ('G', 'G'): 1.0,
 ('G', 'P'): 0.224,
 ('H', 'A'): -0.736,
 ('H', 'C'): -1.048,
 ('H', 'D'): -0.376,
 ('H', 'E'): 0.232,
 ('H', 'G'): -1.224,
 ('H', 'H'): 1.0,
 ('H', 'N'): -0.032,
 ('H', 'P'): -0.72,
 ('H', 'Q'): 0.744,
 ('H', 'S'): -0.552,
 ('H', 'T'): -0.056,
 ('I', 'A'): -1.152,
 ('I', 'C'): -0.304,
 ('I', 'D'): -2.184,
 ('I', 'E'): -1.712,
 ('I', 'G'): -1.88,
 ('I', 'H'): -0.96,
 ('I', 'I'): 1.0,
 ('I', 'K'): -1.272,
 ('I', 'L'): 0.888,
 ('I', 'N'): -1.696,
 ('I', 'P'): -1.096,
 ('I', 'Q'): -1.056,
 ('I', 'R'): -0.992,
 ('I', 'S'): -1.36,
 ('I', 'T'): -0.712,
 ('I', 'V'): 0.32,
 ('K', 'A'): -1.368,
 ('K', 'C'): -1.616,
 ('K', 'D'): -0.64,
 ('K', 'E'): 0.088,
 ('K', 'G'): -1.832,
 ('K', 'H'): 0.368,
 ('K', 'K'): 1.0,
 ('K', 'N'): -0.472,
 ('K', 'P'): -1.352,
 ('K', 'Q'): 0.152,
 ('K', 'S'): -1.168,
 ('K', 'T'): -0.68,
 ('L', 'A'): -1.208,
 ('L', 'C'): -0.32,
 ('L', 'D'): -2.28,
 ('L', 'E'): -1.824,
 ('L', 'G'): -1.936,
 ('L', 'H'): -1.072,
 ('L', 'K'): -1.384,
 ('L', 'L'): 1.0,
 ('L', 'N'): -1.792,
 ('L', 'P'): -1.16,
 ('L', 'Q'): -1.16,
 ('L', 'R'): -1.096,
 ('L', 'S'): -1.432,
 ('L', 'T'): -0.8,
 ('L', 'V'): 0.272,
 ('M', 'A'): -0.936,
 ('M', 'C'): -0.168,
 ('M', 'D'): -1.952,
 ('M', 'E'): -1.504,
 ('M', 'G'): -1.672,
 ('M', 'H'): -0.752,
 ('M', 'I'): 0.768,
 ('M', 'K'): -1.104,
 ('M', 'L'): 0.672,
 ('M', 'M'): 1.0,
 ('M', 'N'): -1.464,
 ('M', 'P'): -0.888,
 ('M', 'Q'): -0.84,
 ('M', 'R'): -0.832,
 ('M', 'S'): -1.136,
 ('M', 'T'): -0.488,
 ('M', 'V'): 0.504,
 ('N', 'A'): -0.424,
 ('N', 'C'): -1.264,
 ('N', 'E'): 0.32,
 ('N', 'G'): -0.568,
 ('N', 'N'): 1.0,
 ('N', 'P'): -0.44,
 ('N', 'Q'): 0.208,
 ('N', 'S'): -0.048,
 ('N', 'T'): -0.12,
 ('P', 'C'): -0.064,
 ('P', 'P'): 1.0,
 ('Q', 'A'): -0.536,
 ('Q', 'C'): -0.984,
 ('Q', 'G'): -0.984,
 ('Q', 'P'): -0.536,
 ('Q', 'Q'): 1.0,
 ('Q', 'S'): -0.32,
 ('Q', 'T'): 0.104,
 ('R', 'A'): -1.336,
 ('R', 'C'): -1.448,
 ('R', 'D'): -0.872,
 ('R', 'E'): -0.16,
 ('R', 'G'): -1.864,
 ('R', 'H'): 0.344,
 ('R', 'K'): 0.68,
 ('R', 'N'): -0.632,
 ('R', 'P'): -1.32,
 ('R', 'Q'): 0.096,
 ('R', 'R'): 1.0,
 ('R', 'S'): -1.192,
 ('R', 'T'): -0.624,
 ('S', 'A'): 0.592,
 ('S', 'C'): -0.472,
 ('S', 'G'): 0.32,
 ('S', 'P'): 0.552,
 ('S', 'S'): 1.0,
 ('T', 'A'): 0.28,
 ('T', 'C'): -0.16,
 ('T', 'G'): -0.36,
 ('T', 'P'): 0.304,
 ('T', 'S'): 0.288,
 ('T', 'T'): 1.0,
 ('V', 'A'): -0.48,
 ('V', 'C'): 0.312,
 ('V', 'D'): -1.72,
 ('V', 'E'): -1.376,
 ('V', 'G'): -1.208,
 ('V', 'H'): -0.688,
 ('V', 'K'): -1.16,
 ('V', 'N'): -1.208,
 ('V', 'P'): -0.432,
 ('V', 'Q'): -0.704,
 ('V', 'R'): -0.944,
 ('V', 'S'): -0.72,
 ('V', 'T'): -0.136,
 ('V', 'V'): 1.0,
 ('W', 'A'): -2.384,
 ('W', 'C'): -1.672,
 ('W', 'D'): -2.904,
 ('W', 'E'): -2.264,
 ('W', 'F'): 0.112,
 ('W', 'G'): -3.104,
 ('W', 'H'): -1.528,
 ('W', 'I'): -0.376,
 ('W', 'K'): -1.488,
 ('W', 'L'): -0.384,
 ('W', 'M'): -0.512,
 ('W', 'N'): -2.512,
 ('W', 'P'): -2.336,
 ('W', 'Q'): -1.736,
 ('W', 'R'): -1.176,
 ('W', 'S'): -2.504,
 ('W', 'T'): -1.8,
 ('W', 'V'): -1.008,
 ('W', 'W'): 1.0,
 ('W', 'Y'): 0.152,
 ('Y', 'A'): -1.544,
 ('Y', 'C'): -0.904,
 ('Y', 'D'): -2.16,
 ('Y', 'E'): -1.576,
 ('Y', 'F'): 0.616,
 ('Y', 'G'): -2.264,
 ('Y', 'H'): -0.816,
 ('Y', 'I'): 0.312,
 ('Y', 'K'): -0.936,
 ('Y', 'L'): 0.248,
 ('Y', 'M'): 0.256,
 ('Y', 'N'): -1.736,
 ('Y', 'P'): -1.496,
 ('Y', 'Q'): -0.984,
 ('Y', 'R'): -0.616,
 ('Y', 'S'): -1.664,
 ('Y', 'T'): -0.96,
 ('Y', 'V'): -0.216,
 ('Y', 'Y'): 1.0}, dict())
