/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.value.scalar;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.impala.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

public class ETRepeatFn
extends ETScalarFn {
    public ETRepeatFn(IColumn iColumn, ArrayList<ETValueExpr> arrayList, List<IColumn> list) throws ErrorException {
        super(iColumn, arrayList, list);
        assert (list.get(0).getTypeMetadata().isCharacterType());
        assert (4 == list.get(1).getTypeMetadata().getType());
        assert (iColumn.getTypeMetadata().isCharacterType());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(1);
        if (this.hasMoreData(0)) {
            throw SQLEngineExceptionFactory.invalidScalarFunctionDataException("REPEAT", 1);
        }
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string = iSqlDataWrapper.getChar();
        long l = iSqlDataWrapper2.getInteger();
        if (0 == string.length() || 0L >= l) {
            eTDataRequest.getData().setChar("");
            return false;
        }
        long l2 = l * (long)string.length();
        long l3 = eTDataRequest.getOffset() / 2L;
        long l4 = l3 / (long)string.length();
        if (l2 / (long)string.length() != l) {
            throw SQLEngineExceptionFactory.invalidScalarFunctionDataException("REPEAT", 2);
        }
        int n = (int)(l3 % (long)string.length());
        long l5 = eTDataRequest.getMaxSize() == -1L ? Integer.MAX_VALUE : eTDataRequest.getMaxSize() / 2L;
        int n2 = (int)Math.min(Math.min(l5, Integer.MAX_VALUE), l2 - l3);
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(string.substring(n));
        ++l4;
        if (stringBuilder.length() > n2) {
            stringBuilder.setLength(n2);
            eTDataRequest.getData().setChar(stringBuilder.toString());
            return true;
        }
        int n3 = (n2 - stringBuilder.length()) % string.length();
        int n4 = n2 - n3;
        while (stringBuilder.length() < n4) {
            assert (l4 < l);
            stringBuilder.append(string);
            ++l4;
        }
        if (0 < n3) {
            stringBuilder.append(string, 0, n3);
        }
        eTDataRequest.getData().setChar(stringBuilder.toString());
        return l4 < l;
    }
}

