/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineException;
import com.cloudera.impala.sqlengine.executor.etree.value.ArithmeticExprType;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.BigIntAddFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.BigIntDivideFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.BigIntMultiplyFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.BigIntNegateFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.BigIntSubtractFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.BinaryArithmeticOperator;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.CharAddFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DateAddBigIntFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DateAddIntFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DateMinusBigIntFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DateMinusIntFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DateNegateFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DecimalAddFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DecimalDivideFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DecimalMultiplyFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DecimalNegateFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DecimalSubtractFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DoubleAddFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DoubleDivideFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DoubleMultiplyFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DoubleNegateFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.DoubleSubtractFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.IUnaryArithmeticFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.IntegerAddFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.IntegerDivideFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.IntegerMultiplyFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.IntegerNegateFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.IntegerSubtractFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.RealAddFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.RealDivideFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.RealMultiplyFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.RealNegateFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.RealSubtractFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.SmallIntAddFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.SmallIntDivideFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.SmallIntMultiplyFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.SmallIntNegateFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.SmallIntSubtractFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.TimestampAddBigIntFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.TimestampAddIntFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.TimestampMinusBigIntFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.TimestampMinusIntFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.TimestampNegateFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.TinyIntAddFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.TinyIntDivideFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.TinyIntMultiplyFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.TinyIntNegateFunctor;
import com.cloudera.impala.sqlengine.executor.etree.value.functor.arithmetic.TinyIntSubtractFunctor;
import com.cloudera.impala.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.Map;

public class ArithmeticFunctorFactory {
    private static Map<FunctorMapKey, IBinaryArithmeticFunctor> s_binaryFunctorMap = new HashMap<FunctorMapKey, IBinaryArithmeticFunctor>();
    private static Map<FunctorMapKey, IUnaryArithmeticFunctor> s_unaryFunctorMap;

    public static BinaryArithmeticOperator getBinaryArithFunctor(ArithmeticExprType arithmeticExprType, IColumn iColumn, IColumn iColumn2, IColumn iColumn3) throws ErrorException {
        TypeMetadata typeMetadata = iColumn.getTypeMetadata();
        short s = typeMetadata.getType();
        if (s == 93) {
            return ArithmeticFunctorFactory.getTimestampBinFunctor(arithmeticExprType, iColumn, iColumn2, iColumn3);
        }
        if (s == 91) {
            return ArithmeticFunctorFactory.getDateBinFunctor(arithmeticExprType, iColumn, iColumn2, iColumn3);
        }
        FunctorMapKey.Signedness signedness = FunctorMapKey.Signedness.NA;
        switch (typeMetadata.getType()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                signedness = typeMetadata.isSigned() ? FunctorMapKey.Signedness.SIGNED : FunctorMapKey.Signedness.UNSIGNED;
            }
        }
        FunctorMapKey functorMapKey = new FunctorMapKey(s, signedness, arithmeticExprType);
        IBinaryArithmeticFunctor iBinaryArithmeticFunctor = s_binaryFunctorMap.get(functorMapKey);
        if (iBinaryArithmeticFunctor == null) {
            throw new SQLEngineException(SQLEngineMessageKey.UNSUPPORT_ARITH_OP.name(), new String[]{"Operation: " + arithmeticExprType.name() + ", result type: " + typeMetadata.getTypeName() + ", left operand type: " + iColumn2.getTypeMetadata().getTypeName() + ", right operand type: " + iColumn3.getTypeMetadata().getTypeName()});
        }
        return new BinaryArithmeticOperator(iBinaryArithmeticFunctor, iColumn, iColumn);
    }

    private static BinaryArithmeticOperator getDateBinFunctor(ArithmeticExprType arithmeticExprType, IColumn iColumn, IColumn iColumn2, IColumn iColumn3) throws ErrorException {
        TypeMetadata typeMetadata = iColumn.getTypeMetadata();
        assert (typeMetadata.getType() == 91);
        TypeMetadata typeMetadata2 = iColumn2.getTypeMetadata();
        TypeMetadata typeMetadata3 = iColumn3.getTypeMetadata();
        if (typeMetadata2.getType() == 91 || typeMetadata3.getType() == 91) {
            if (arithmeticExprType == ArithmeticExprType.ADDITION) {
                if (typeMetadata3.getType() == -5 || typeMetadata2.getType() == -5) {
                    return new BinaryArithmeticOperator(new DateAddBigIntFunctor(), iColumn2, iColumn3);
                }
                if (typeMetadata3.isIntegerType()) {
                    TypeMetadata typeMetadata4 = TypeMetadata.createTypeMetadata(4, iColumn3.getTypeMetadata().isSigned());
                    return new BinaryArithmeticOperator(new DateAddIntFunctor(), iColumn2, new ColumnMetadata(typeMetadata4));
                }
                if (typeMetadata2.isIntegerType()) {
                    TypeMetadata typeMetadata5 = TypeMetadata.createTypeMetadata(4, iColumn2.getTypeMetadata().isSigned());
                    return new BinaryArithmeticOperator(new DateAddIntFunctor(), new ColumnMetadata(typeMetadata5), iColumn3);
                }
            } else if (arithmeticExprType == ArithmeticExprType.SUBTRACTION) {
                if (typeMetadata3.getType() == -5 || typeMetadata2.getType() == -5) {
                    return new BinaryArithmeticOperator(new DateMinusBigIntFunctor(), iColumn2, iColumn3);
                }
                if (typeMetadata3.isIntegerType()) {
                    TypeMetadata typeMetadata6 = TypeMetadata.createTypeMetadata(4, iColumn3.getTypeMetadata().isSigned());
                    return new BinaryArithmeticOperator(new DateMinusIntFunctor(), iColumn2, new ColumnMetadata(typeMetadata6));
                }
                if (typeMetadata2.isIntegerType()) {
                    TypeMetadata typeMetadata7 = TypeMetadata.createTypeMetadata(4, iColumn2.getTypeMetadata().isSigned());
                    return new BinaryArithmeticOperator(new DateMinusIntFunctor(), new ColumnMetadata(typeMetadata7), iColumn3);
                }
            }
        }
        throw new SQLEngineException(SQLEngineMessageKey.UNSUPPORT_ARITH_OP.name(), new String[]{"Operation: " + arithmeticExprType.name() + ", result type: " + typeMetadata.getTypeName() + ", left operand type: " + typeMetadata2.getTypeName() + ", right operand type: " + typeMetadata3.getTypeName()});
    }

    private static BinaryArithmeticOperator getTimestampBinFunctor(ArithmeticExprType arithmeticExprType, IColumn iColumn, IColumn iColumn2, IColumn iColumn3) throws ErrorException {
        TypeMetadata typeMetadata = iColumn.getTypeMetadata();
        assert (typeMetadata.getType() == 93);
        TypeMetadata typeMetadata2 = iColumn2.getTypeMetadata();
        TypeMetadata typeMetadata3 = iColumn3.getTypeMetadata();
        if (typeMetadata2.getType() == 93 || typeMetadata3.getType() == 93) {
            if (arithmeticExprType == ArithmeticExprType.ADDITION) {
                if (typeMetadata3.getType() == -5 || typeMetadata2.getType() == -5) {
                    return new BinaryArithmeticOperator(new TimestampAddBigIntFunctor(), iColumn2, iColumn3);
                }
                if (typeMetadata3.isIntegerType()) {
                    TypeMetadata typeMetadata4 = TypeMetadata.createTypeMetadata(4, iColumn3.getTypeMetadata().isSigned());
                    return new BinaryArithmeticOperator(new TimestampAddIntFunctor(), iColumn2, new ColumnMetadata(typeMetadata4));
                }
                if (typeMetadata2.isIntegerType()) {
                    TypeMetadata typeMetadata5 = TypeMetadata.createTypeMetadata(4, iColumn2.getTypeMetadata().isSigned());
                    return new BinaryArithmeticOperator(new TimestampAddIntFunctor(), new ColumnMetadata(typeMetadata5), iColumn3);
                }
            } else if (arithmeticExprType == ArithmeticExprType.SUBTRACTION) {
                if (typeMetadata3.getType() == -5 || typeMetadata2.getType() == -5) {
                    return new BinaryArithmeticOperator(new TimestampMinusBigIntFunctor(), iColumn2, iColumn3);
                }
                if (typeMetadata3.isIntegerType()) {
                    TypeMetadata typeMetadata6 = TypeMetadata.createTypeMetadata(4, iColumn3.getTypeMetadata().isSigned());
                    return new BinaryArithmeticOperator(new TimestampMinusIntFunctor(), iColumn2, new ColumnMetadata(typeMetadata6));
                }
                if (typeMetadata2.isIntegerType()) {
                    TypeMetadata typeMetadata7 = TypeMetadata.createTypeMetadata(4, iColumn2.getTypeMetadata().isSigned());
                    return new BinaryArithmeticOperator(new TimestampMinusIntFunctor(), new ColumnMetadata(typeMetadata7), iColumn3);
                }
            }
        }
        throw new SQLEngineException(SQLEngineMessageKey.UNSUPPORT_ARITH_OP.name(), new String[]{"Operation: " + arithmeticExprType.name() + ", result type: " + typeMetadata.getTypeName() + ", left operand type: " + typeMetadata2.getTypeName() + ", right operand type: " + typeMetadata3.getTypeName()});
    }

    public static IUnaryArithmeticFunctor getUnaryArithFunctor(ArithmeticExprType arithmeticExprType, TypeMetadata typeMetadata, TypeMetadata typeMetadata2) throws SQLEngineException {
        assert (arithmeticExprType == ArithmeticExprType.NEGATION);
        short s = typeMetadata.getType();
        if (91 != s && 93 != s && !typeMetadata.isSigned()) {
            throw new SQLEngineException(SQLEngineMessageKey.UNSUPPORT_ARITH_OP.name(), new String[]{"Negation resulting in unsigned type"});
        }
        FunctorMapKey.Signedness signedness = FunctorMapKey.Signedness.NA;
        FunctorMapKey functorMapKey = new FunctorMapKey(s, signedness, arithmeticExprType);
        IUnaryArithmeticFunctor iUnaryArithmeticFunctor = s_unaryFunctorMap.get(functorMapKey);
        if (iUnaryArithmeticFunctor == null) {
            throw new SQLEngineException(SQLEngineMessageKey.UNSUPPORT_ARITH_OP.name(), new String[]{"Operation: " + arithmeticExprType.name() + ", result type: " + typeMetadata.getTypeName() + ", operand type: " + typeMetadata2.getTypeName()});
        }
        return iUnaryArithmeticFunctor;
    }

    static {
        s_binaryFunctorMap.put(new FunctorMapKey(1, FunctorMapKey.Signedness.NA, ArithmeticExprType.ADDITION), new CharAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-8, FunctorMapKey.Signedness.NA, ArithmeticExprType.ADDITION), new CharAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(12, FunctorMapKey.Signedness.NA, ArithmeticExprType.ADDITION), new CharAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-9, FunctorMapKey.Signedness.NA, ArithmeticExprType.ADDITION), new CharAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-1, FunctorMapKey.Signedness.NA, ArithmeticExprType.ADDITION), new CharAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-10, FunctorMapKey.Signedness.NA, ArithmeticExprType.ADDITION), new CharAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-6, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.ADDITION), new TinyIntAddFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(-6, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.SUBTRACTION), new TinyIntSubtractFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(-6, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.MULTIPLICATION), new TinyIntMultiplyFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(-6, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.DIVISION), new TinyIntDivideFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(-6, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.ADDITION), new TinyIntAddFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(-6, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.SUBTRACTION), new TinyIntSubtractFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(-6, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.MULTIPLICATION), new TinyIntMultiplyFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(-6, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.DIVISION), new TinyIntDivideFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(5, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.ADDITION), new SmallIntAddFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(5, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.SUBTRACTION), new SmallIntSubtractFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(5, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.MULTIPLICATION), new SmallIntMultiplyFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(5, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.DIVISION), new SmallIntDivideFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(5, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.ADDITION), new SmallIntAddFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(5, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.SUBTRACTION), new SmallIntSubtractFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(5, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.MULTIPLICATION), new SmallIntMultiplyFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(5, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.DIVISION), new SmallIntDivideFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(4, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.ADDITION), new IntegerAddFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(4, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.SUBTRACTION), new IntegerSubtractFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(4, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.MULTIPLICATION), new IntegerMultiplyFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(4, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.DIVISION), new IntegerDivideFunctor(true));
        s_binaryFunctorMap.put(new FunctorMapKey(4, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.ADDITION), new IntegerAddFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(4, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.SUBTRACTION), new IntegerSubtractFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(4, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.MULTIPLICATION), new IntegerMultiplyFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(4, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.DIVISION), new IntegerDivideFunctor(false));
        s_binaryFunctorMap.put(new FunctorMapKey(-5, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.ADDITION), new BigIntAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-5, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.SUBTRACTION), new BigIntSubtractFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-5, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.MULTIPLICATION), new BigIntMultiplyFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-5, FunctorMapKey.Signedness.SIGNED, ArithmeticExprType.DIVISION), new BigIntDivideFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-5, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.ADDITION), new BigIntAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-5, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.SUBTRACTION), new BigIntSubtractFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-5, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.MULTIPLICATION), new BigIntMultiplyFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(-5, FunctorMapKey.Signedness.UNSIGNED, ArithmeticExprType.DIVISION), new BigIntDivideFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(7, FunctorMapKey.Signedness.NA, ArithmeticExprType.ADDITION), new RealAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(7, FunctorMapKey.Signedness.NA, ArithmeticExprType.SUBTRACTION), new RealSubtractFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(7, FunctorMapKey.Signedness.NA, ArithmeticExprType.MULTIPLICATION), new RealMultiplyFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(7, FunctorMapKey.Signedness.NA, ArithmeticExprType.DIVISION), new RealDivideFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(6, FunctorMapKey.Signedness.NA, ArithmeticExprType.ADDITION), new DoubleAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(6, FunctorMapKey.Signedness.NA, ArithmeticExprType.SUBTRACTION), new DoubleSubtractFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(6, FunctorMapKey.Signedness.NA, ArithmeticExprType.MULTIPLICATION), new DoubleMultiplyFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(6, FunctorMapKey.Signedness.NA, ArithmeticExprType.DIVISION), new DoubleDivideFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(8, FunctorMapKey.Signedness.NA, ArithmeticExprType.ADDITION), new DoubleAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(8, FunctorMapKey.Signedness.NA, ArithmeticExprType.SUBTRACTION), new DoubleSubtractFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(8, FunctorMapKey.Signedness.NA, ArithmeticExprType.MULTIPLICATION), new DoubleMultiplyFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(8, FunctorMapKey.Signedness.NA, ArithmeticExprType.DIVISION), new DoubleDivideFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(3, FunctorMapKey.Signedness.NA, ArithmeticExprType.ADDITION), new DecimalAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(3, FunctorMapKey.Signedness.NA, ArithmeticExprType.SUBTRACTION), new DecimalSubtractFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(3, FunctorMapKey.Signedness.NA, ArithmeticExprType.MULTIPLICATION), new DecimalMultiplyFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(3, FunctorMapKey.Signedness.NA, ArithmeticExprType.DIVISION), new DecimalDivideFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(2, FunctorMapKey.Signedness.NA, ArithmeticExprType.ADDITION), new DecimalAddFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(2, FunctorMapKey.Signedness.NA, ArithmeticExprType.SUBTRACTION), new DecimalSubtractFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(2, FunctorMapKey.Signedness.NA, ArithmeticExprType.MULTIPLICATION), new DecimalMultiplyFunctor());
        s_binaryFunctorMap.put(new FunctorMapKey(2, FunctorMapKey.Signedness.NA, ArithmeticExprType.DIVISION), new DecimalDivideFunctor());
        s_unaryFunctorMap = new HashMap<FunctorMapKey, IUnaryArithmeticFunctor>();
        s_unaryFunctorMap.put(new FunctorMapKey(-6, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new TinyIntNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(5, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new SmallIntNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(4, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new IntegerNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(-5, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new BigIntNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(6, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new DoubleNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(7, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new RealNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(8, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new DoubleNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(3, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new DecimalNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(3, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new DecimalNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(2, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new DecimalNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(2, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new DecimalNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(91, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new DateNegateFunctor());
        s_unaryFunctorMap.put(new FunctorMapKey(93, FunctorMapKey.Signedness.NA, ArithmeticExprType.NEGATION), new TimestampNegateFunctor());
    }

    private static class FunctorMapKey {
        private final int m_sqlType;
        private final Signedness m_signedness;
        private final ArithmeticExprType m_opType;

        public FunctorMapKey(int n, Signedness signedness, ArithmeticExprType arithmeticExprType) {
            if (null == signedness || null == arithmeticExprType) {
                throw new NullPointerException();
            }
            this.m_sqlType = n;
            this.m_signedness = signedness;
            this.m_opType = arithmeticExprType;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.m_opType.hashCode();
            n = 31 * n + this.m_signedness.hashCode();
            n = 31 * n + this.m_sqlType;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FunctorMapKey functorMapKey = (FunctorMapKey)object;
            if (this.m_opType != functorMapKey.m_opType) {
                return false;
            }
            if (this.m_signedness != functorMapKey.m_signedness) {
                return false;
            }
            return this.m_sqlType == functorMapKey.m_sqlType;
        }

        public static enum Signedness {
            SIGNED,
            UNSIGNED,
            NA;

        }
    }
}

