/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.temptable.column;

import com.cloudera.impala.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.IColumnSlice;
import java.sql.Time;

public final class TimeColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = -1382490667428191778L;
    private Time[] m_data;
    private final int m_columnNumber;

    public TimeColumnSlice(int n, int n2) {
        this.m_data = new Time[n];
        this.m_columnNumber = n2;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public boolean isNull(int n) {
        return null == this.m_data[n];
    }

    @Override
    public void setNull(int n) {
        this.m_data[n] = null;
    }

    @Override
    public Time getTime(int n) {
        return this.m_data[n];
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.TIME;
    }

    @Override
    public void setTime(int n, Time time) {
        this.m_data[n] = time;
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        TimeColumnSlice timeColumnSlice = (TimeColumnSlice)iColumnSlice;
        System.arraycopy(timeColumnSlice.m_data, n, this.m_data, n3, n2);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectShellSize() + javaSize.getLongSize() + javaSize.getObjectRefSize();
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectRefSize();
    }
}

