/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.temptable.column;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.BigIntColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.BinaryColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.BooleanColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.CharColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.DateColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.DoubleColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.ExactNumColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.FileMarkerColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.GuidColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.IntegerColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.RealColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.SmallIntColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.TimeColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.TimestampColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.TinyIntColumnSlice;

public final class ColumnSizeCalculator {
    public static final JavaSize JAVA_SIZE = ColumnSizeCalculator.init32VmSize();

    public static double getColumnSizePerRow(IColumn iColumn, boolean bl, int n) {
        if (!bl) {
            return 0.0;
        }
        TypeMetadata typeMetadata = iColumn.getTypeMetadata();
        JavaSize javaSize = JAVA_SIZE;
        switch (typeMetadata.getType()) {
            case -5: {
                return BigIntColumnSlice.estimateRowSize(javaSize);
            }
            case -4: 
            case -3: 
            case -2: {
                long l = iColumn.getColumnLength();
                if (!ColumnSizeCalculator.isLongData(iColumn, n)) {
                    return BinaryColumnSlice.estimateRowSize(javaSize, (int)l);
                }
                return FileMarkerColumnSlice.estimateRowSize(javaSize);
            }
            case -7: 
            case 16: {
                return BooleanColumnSlice.estimateRowSize(javaSize);
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                long l = iColumn.getColumnLength();
                if (!ColumnSizeCalculator.isLongData(iColumn, n)) {
                    return CharColumnSlice.estimateRowSize(javaSize, (int)l);
                }
                return FileMarkerColumnSlice.estimateRowSize(javaSize);
            }
            case 91: {
                return DateColumnSlice.estimateRowSize(javaSize);
            }
            case 2: 
            case 3: {
                return ExactNumColumnSlice.estimateRowSize(javaSize);
            }
            case 6: 
            case 8: {
                return DoubleColumnSlice.estimateRowSize(javaSize);
            }
            case 4: {
                return IntegerColumnSlice.estimateRowSize(javaSize);
            }
            case 7: {
                return RealColumnSlice.estimateRowSize(javaSize);
            }
            case 5: {
                return SmallIntColumnSlice.estimateRowSize(javaSize);
            }
            case 92: {
                return TimeColumnSlice.estimateRowSize(javaSize);
            }
            case 93: {
                return TimestampColumnSlice.estimateRowSize(javaSize);
            }
            case -6: {
                return TinyIntColumnSlice.estimateRowSize(javaSize);
            }
            case -11: {
                return GuidColumnSlice.estimateRowSize(javaSize);
            }
        }
        throw new UnsupportedOperationException(typeMetadata.getTypeName() + " (" + typeMetadata.getType() + ")");
    }

    public static double getOverHeadPerRow(IColumn iColumn, boolean bl, int n) {
        if (!bl) {
            return 0.0;
        }
        TypeMetadata typeMetadata = iColumn.getTypeMetadata();
        JavaSize javaSize = JAVA_SIZE;
        switch (typeMetadata.getType()) {
            case -5: {
                return BigIntColumnSlice.estimateRowOverhead(javaSize);
            }
            case -4: 
            case -3: 
            case -2: {
                if (!ColumnSizeCalculator.isLongData(iColumn, n)) {
                    return BinaryColumnSlice.estimateRowOverhead(javaSize);
                }
                return FileMarkerColumnSlice.estimateRowOverhead(javaSize);
            }
            case -7: 
            case 16: {
                return BooleanColumnSlice.estimateRowOverhead(javaSize);
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                if (!ColumnSizeCalculator.isLongData(iColumn, n)) {
                    return CharColumnSlice.estimateRowOverhead(javaSize);
                }
                return FileMarkerColumnSlice.estimateRowOverhead(javaSize);
            }
            case 91: {
                return DateColumnSlice.estimateRowOverhead(javaSize);
            }
            case 2: 
            case 3: {
                return ExactNumColumnSlice.estimateRowOverhead(javaSize);
            }
            case 6: 
            case 8: {
                return DoubleColumnSlice.estimateRowOverhead(javaSize);
            }
            case 4: {
                return IntegerColumnSlice.estimateRowOverhead(javaSize);
            }
            case 7: {
                return RealColumnSlice.estimateRowOverhead(javaSize);
            }
            case 5: {
                return SmallIntColumnSlice.estimateRowOverhead(javaSize);
            }
            case 92: {
                return TimeColumnSlice.estimateRowOverhead(javaSize);
            }
            case 93: {
                return TimestampColumnSlice.estimateRowOverhead(javaSize);
            }
            case -6: {
                return TinyIntColumnSlice.estimateRowOverhead(javaSize);
            }
            case -11: {
                return GuidColumnSlice.estimateRowOverhead(javaSize);
            }
        }
        throw new UnsupportedOperationException(typeMetadata.getTypeName() + " (" + typeMetadata.getType() + ")");
    }

    public static boolean isLongData(IColumn iColumn, int n) {
        if (!iColumn.getTypeMetadata().isCharacterOrBinaryType()) {
            return false;
        }
        long l = iColumn.getColumnLength();
        if (iColumn.getTypeMetadata().isCharacterType()) {
            l *= 2L;
        }
        return l > (long)n;
    }

    private static JavaSize init32VmSize() {
        JavaSize javaSize = new JavaSize();
        javaSize.m_objectShellSize = 8;
        javaSize.m_objectRefSize = 8;
        javaSize.m_longSize = 8;
        javaSize.m_intSize = 4;
        javaSize.m_shortSize = 2;
        javaSize.m_charSize = 2;
        javaSize.m_byteSize = 1;
        javaSize.m_booleanSize = 1;
        javaSize.m_doubleSize = 8;
        javaSize.m_floatSize = 4;
        return javaSize;
    }

    public static class JavaSize {
        private int m_objectShellSize;
        private int m_objectRefSize;
        private int m_booleanSize;
        private int m_charSize;
        private int m_byteSize;
        private int m_shortSize;
        private int m_intSize;
        private int m_longSize;
        private int m_floatSize;
        private int m_doubleSize;

        private JavaSize() {
        }

        public int getObjectShellSize() {
            return this.m_objectShellSize;
        }

        public int getObjectRefSize() {
            return this.m_objectRefSize;
        }

        public int getBooleanSize() {
            return this.m_booleanSize;
        }

        public int getCharSize() {
            return this.m_charSize;
        }

        public int getByteSize() {
            return this.m_byteSize;
        }

        public int getShortSize() {
            return this.m_shortSize;
        }

        public int getIntSize() {
            return this.m_intSize;
        }

        public int getLongSize() {
            return this.m_longSize;
        }

        public int getFloatSize() {
            return this.m_floatSize;
        }

        public int getDoubleSize() {
            return this.m_doubleSize;
        }

        public int estimateStringSize(int n) {
            assert (0 <= n);
            int n2 = this.getObjectShellSize();
            n2 += 3 * this.getIntSize();
            n2 += this.getObjectRefSize();
            return n2 += this.estimateArraySize(this.getCharSize(), n);
        }

        public int estimateArraySize(int n, int n2) {
            assert (0 <= n2);
            return this.getObjectShellSize() + this.getObjectRefSize() + this.getIntSize() + n2 * n;
        }
    }
}

