/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.aeprocessor.aebuilder.value;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.impala.dsi.exceptions.NumericOverflowException;
import com.cloudera.impala.sqlengine.aeprocessor.AEUtils;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.ScalarFunctionID;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AENull;
import com.cloudera.impala.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.cloudera.impala.sqlengine.aeprocessor.metadatautil.AECoercionProperties;
import com.cloudera.impala.sqlengine.aeprocessor.metadatautil.AEMetadataCoercionHandler;
import com.cloudera.impala.sqlengine.aeprocessor.metadatautil.MetadataColumnInfo;
import com.cloudera.impala.sqlengine.aeprocessor.metadatautil.MetadataUtilities;
import com.cloudera.impala.sqlengine.aeprocessor.metadatautil.SqlTypes;
import com.cloudera.impala.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.impala.sqlengine.dsiext.dataengine.IColumnInfo;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.impala.sqlengine.dsiext.dataengine.utils.ScalarFunctionArgType;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.support.conv.CharConverter;
import com.cloudera.impala.support.conv.ConversionResult;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class AEScalarFnMetadataFactory {
    private static final short MAX_FRACTION_PRECISION = 9;
    private final ICoercionHandler m_coercionHandler = new AEMetadataCoercionHandler();
    private AECoercionProperties m_coercionProperties = new AECoercionProperties.Builder().build();

    private AEScalarFnMetadataFactory() {
    }

    public ScalarFnMetadata createMetadata(SqlDataEngineContext sqlDataEngineContext, ScalarFunctionID scalarFunctionID, String string, List<AECoercionColumnInfo> list) throws ErrorException {
        ScalarFnMetadata scalarFnMetadata;
        switch (scalarFunctionID) {
            case ASCII: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createAsciiMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case CHAR: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCharMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case CONCAT: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createConcatMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case INSERT: {
                if (4 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<AECoercionColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createInsertMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case LCASE: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLCaseMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case LEFT: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLeftMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case LENGTH: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLengthMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case LOCATE2: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLocateMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case LOCATE3: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<AECoercionColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createLocateMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case LTRIM: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLTrimMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case REPEAT: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRepeatMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case REPLACE: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<AECoercionColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createReplaceMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case RIGHT: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRightMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case RTRIM: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRTrimMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SOUNDEX: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSoundexMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SPACE: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSpaceMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SUBSTRING3: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<AECoercionColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createSubstringMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case SUBSTRING2: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSubstringMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case UCASE: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createUCaseMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case CURDATE: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurDateMetadata(sqlDataEngineContext);
                break;
            }
            case CURTIME: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurTimeMetadata(sqlDataEngineContext);
                break;
            }
            case CURRENT_DATE: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurrentDateMetadata(sqlDataEngineContext);
                break;
            }
            case CURRENT_TIME: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurrentTimeMetadata(sqlDataEngineContext);
                break;
            }
            case CURRENT_TIME1: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurrentTimeMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case CURRENT_TIMESTAMP: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurrentTimestampMetadata(sqlDataEngineContext);
                break;
            }
            case CURRENT_TIMESTAMP1: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCurrentTimestampMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case DAYNAME: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDayNameMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case DAYOFWEEK: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDayOfWeekMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case DAYOFMONTH: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDayOfMonthMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case DAYOFYEAR: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDayOfYearMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case EXTRACT: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createExtractMetadata(list.get(0), list.get(1));
                break;
            }
            case HOUR: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createHourMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case MINUTE: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMinuteMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case MONTH: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMonthMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case MONTHNAME: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMonthNameMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case NOW: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNowMetadata(sqlDataEngineContext);
                break;
            }
            case QUARTER: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createQuarterMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SECOND: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSecondMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case TIMESTAMPADD: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<AECoercionColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createTimestampAddMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case TIMESTAMPDIFF: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                Iterator<AECoercionColumnInfo> iterator = list.iterator();
                scalarFnMetadata = this.createTimestampDiffMetadata(sqlDataEngineContext, iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case WEEK: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createWeekMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case WEEK_ISO: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createWeekISOMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case YEAR: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createYearMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ABS: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createAbsMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ACOS: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createACosMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ASIN: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createASinMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ATAN: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createATanMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ATAN2: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createATanMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case CEILING: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCeilingMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case COS: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCosMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case COT: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCotMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case DEGREES: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDegreesMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case EXP: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createExpMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case FLOOR: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFloorMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case LOG: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLogMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case LOG10: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLog10Metadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case MOD: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createModMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case PI: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createPiMetadata(sqlDataEngineContext);
                break;
            }
            case POWER: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createPowerMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case RADIANS: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRadiansMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case RAND0: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRandMetadata(sqlDataEngineContext);
                break;
            }
            case RAND1: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRandMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case ROUND: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRoundMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case SIGN: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSignMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SIN: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSinMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case SQRT: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSqrtMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case TAN: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTanMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case TRUNCATE: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTruncateMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case DATABASE: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDatabaseMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case IFNULL: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIfNullMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case NULL: {
                if (0 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNullMetadata(sqlDataEngineContext);
                break;
            }
            case USER: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createUserMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case CONVERT2: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createConvertMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case CONVERT3: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCastMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                if (!scalarFnMetadata.getColumnMetadata().getTypeMetadata().isExactNumericType()) break;
                short s = Short.parseShort(list.get(2).getLiteralString());
                scalarFnMetadata.getColumnMetadata().getTypeMetadata().setPrecision(s);
                break;
            }
            case CONVERT4: {
                if (4 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCastMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                if (!scalarFnMetadata.getColumnMetadata().getTypeMetadata().isExactNumericType()) break;
                short s = Short.parseShort(list.get(2).getLiteralString());
                scalarFnMetadata.getColumnMetadata().getTypeMetadata().setPrecision(s);
                short s2 = Short.parseShort(list.get(3).getLiteralString());
                scalarFnMetadata.getColumnMetadata().getTypeMetadata().setScale(s2);
                break;
            }
            case CAST2: {
                if (2 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCastMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                break;
            }
            case CAST3: {
                if (3 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCastMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                if (!scalarFnMetadata.getColumnMetadata().getTypeMetadata().isExactNumericType()) break;
                short s = Short.parseShort(list.get(2).getLiteralString());
                scalarFnMetadata.getColumnMetadata().getTypeMetadata().setPrecision(s);
                break;
            }
            case CAST4: {
                if (4 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCastMetadata(sqlDataEngineContext, list.get(0), list.get(1));
                if (!scalarFnMetadata.getColumnMetadata().getTypeMetadata().isExactNumericType()) break;
                short s = Short.parseShort(list.get(2).getLiteralString());
                scalarFnMetadata.getColumnMetadata().getTypeMetadata().setPrecision(s);
                short s3 = Short.parseShort(list.get(3).getLiteralString());
                scalarFnMetadata.getColumnMetadata().getTypeMetadata().setScale(s3);
                break;
            }
            case LOWER: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLowerMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            case UPPER: {
                if (1 != list.size()) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createUpperMetadata(sqlDataEngineContext, list.get(0));
                break;
            }
            default: {
                scalarFnMetadata = null;
            }
        }
        if (null == scalarFnMetadata) {
            throw SQLEngineExceptionFactory.featureNotImplementedException(scalarFunctionID.toString());
        }
        return scalarFnMetadata;
    }

    public void validateMetadata(SqlDataEngineContext sqlDataEngineContext, ScalarFunctionID scalarFunctionID, String string, List<? extends IColumnInfo> list) throws ErrorException {
        this.validateArgTypes(sqlDataEngineContext, scalarFunctionID.getName(), scalarFunctionID.getArguments(), list);
    }

    private ICoercionHandler getCoercionHandler() {
        return this.m_coercionHandler;
    }

    public ScalarFnMetadata createAsciiMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createCharMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(1L), Arrays.asList(this.createIntMetadata()));
    }

    public ScalarFnMetadata createConcatMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        ColumnMetadata columnMetadata = this.createStringMetadata(iColumnInfo);
        ColumnMetadata columnMetadata2 = this.createStringMetadata(iColumnInfo2);
        ICoercionHandler iCoercionHandler = this.getCoercionHandler();
        IColumn iColumn = iCoercionHandler.coerceConcatColumns(new MetadataColumnInfo(columnMetadata, iColumnInfo.getColumnType()), new MetadataColumnInfo(columnMetadata2, iColumnInfo2.getColumnType()));
        return new ScalarFnMetadata(iColumn, Arrays.asList(columnMetadata, columnMetadata2));
    }

    public ScalarFnMetadata createInsertMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3, IColumnInfo iColumnInfo4) throws ErrorException {
        ColumnMetadata columnMetadata = this.createStringMetadata(iColumnInfo);
        ColumnMetadata columnMetadata2 = this.createStringMetadata(iColumnInfo4);
        ICoercionHandler iCoercionHandler = this.getCoercionHandler();
        IColumn iColumn = iCoercionHandler.coerceConcatColumns(new MetadataColumnInfo(columnMetadata, iColumnInfo.getColumnType()), new MetadataColumnInfo(columnMetadata2, iColumnInfo4.getColumnType()));
        return new ScalarFnMetadata(ColumnMetadata.copyOf(iColumn), Arrays.asList(columnMetadata, this.createIntMetadata(), this.createIntMetadata(), columnMetadata2));
    }

    public ScalarFnMetadata createLCaseMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createLeftMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo), this.createIntMetadata()));
    }

    public ScalarFnMetadata createLengthMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createLocateMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        ColumnMetadata columnMetadata = this.createStringMetadata(iColumnInfo);
        ColumnMetadata columnMetadata2 = this.createStringMetadata(iColumnInfo2);
        long l = Math.max(columnMetadata.getColumnLength(), columnMetadata2.getColumnLength());
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createStringMetadata(l), this.createStringMetadata(l)));
    }

    public ScalarFnMetadata createLocateMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) throws ErrorException {
        ColumnMetadata columnMetadata = this.createStringMetadata(iColumnInfo);
        ColumnMetadata columnMetadata2 = this.createStringMetadata(iColumnInfo2);
        long l = Math.max(columnMetadata.getColumnLength(), columnMetadata2.getColumnLength());
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createStringMetadata(l), this.createStringMetadata(l), this.createIntMetadata()));
    }

    public ScalarFnMetadata createLTrimMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createRepeatMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        Long l;
        long l2 = -1L;
        if (IColumnInfo.ColumnType.LITERAL == iColumnInfo2.getColumnType() && null != (l = this.parseIntegerLiteral(iColumnInfo2))) {
            l2 = Math.max(l, 0L);
        }
        long l3 = 0L == l2 || 0L < l2 && this.m_coercionProperties.getMaxWvarcharLength() / l2 > iColumnInfo.getColumnLength() ? iColumnInfo.getColumnLength() * l2 : Math.max(this.m_coercionProperties.getMaxVarcharlength(), iColumnInfo.getColumnLength());
        ColumnMetadata columnMetadata = this.createStringMetadata(iColumnInfo.getType(), l3);
        return new ScalarFnMetadata(columnMetadata, Arrays.asList(this.createStringMetadata(iColumnInfo), this.createIntMetadata()));
    }

    public ScalarFnMetadata createReplaceMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) throws ErrorException {
        ColumnMetadata columnMetadata = this.createStringMetadata(iColumnInfo);
        ColumnMetadata columnMetadata2 = this.createStringMetadata(iColumnInfo2);
        ColumnMetadata columnMetadata3 = this.createStringMetadata(iColumnInfo3);
        ColumnMetadata columnMetadata4 = this.createStringMetadata(columnMetadata.getColumnLength() * Math.max(columnMetadata3.getColumnLength(), 1L));
        return new ScalarFnMetadata(ColumnMetadata.copyOf(columnMetadata4), Arrays.asList(columnMetadata, columnMetadata2, columnMetadata3));
    }

    public ScalarFnMetadata createRightMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo), this.createIntMetadata()));
    }

    public ScalarFnMetadata createRTrimMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createSoundexMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(4L), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createSpaceMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        Long l;
        long l2 = -1L;
        if (IColumnInfo.ColumnType.LITERAL == iColumnInfo.getColumnType() && null != (l = this.parseIntegerLiteral(iColumnInfo))) {
            l2 = Math.max(l, 0L);
        }
        if (0L > l2 || l2 > this.m_coercionProperties.getMaxVarcharlength()) {
            l2 = this.m_coercionProperties.getMaxVarcharlength();
        }
        return new ScalarFnMetadata(this.createStringMetadata(l2), Arrays.asList(this.createIntMetadata()));
    }

    public ScalarFnMetadata createSubstringMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo), this.createIntMetadata(), this.createIntMetadata()));
    }

    public ScalarFnMetadata createSubstringMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo), this.createIntMetadata()));
    }

    public ScalarFnMetadata createUCaseMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createCurDateMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new ScalarFnMetadata(this.createDateMetadata(), Collections.emptyList());
    }

    public ScalarFnMetadata createCurTimeMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new ScalarFnMetadata(this.createTimeMetadata((short)0), Collections.emptyList());
    }

    public ScalarFnMetadata createCurrentDateMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return this.createCurDateMetadata(sqlDataEngineContext);
    }

    public ScalarFnMetadata createCurrentTimeMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return this.createCurTimeMetadata(sqlDataEngineContext);
    }

    public ScalarFnMetadata createCurrentTimeMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createTimeMetadata(this.m_coercionProperties.getMaxTimePrecision()), Arrays.asList(this.createIntMetadata()));
    }

    public ScalarFnMetadata createCurrentTimestampMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new ScalarFnMetadata(this.createTimestampMetadata(), Collections.emptyList());
    }

    public ScalarFnMetadata createCurrentTimestampMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createTimestampMetadata(), Arrays.asList(this.createIntMetadata()));
    }

    public ScalarFnMetadata createDayNameMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(32L), Arrays.asList(this.createDateMetadata()));
    }

    public ScalarFnMetadata createDayOfMonthMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createDateMetadata()));
    }

    public ScalarFnMetadata createDayOfWeekMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createDateMetadata()));
    }

    public ScalarFnMetadata createDayOfYearMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createDateMetadata()));
    }

    public ScalarFnMetadata createExtractMetadata(AECoercionColumnInfo aECoercionColumnInfo, AECoercionColumnInfo aECoercionColumnInfo2) throws ErrorException {
        ColumnMetadata columnMetadata;
        short s;
        int n;
        ColumnMetadata columnMetadata2;
        String string = aECoercionColumnInfo.getLiteralString();
        if (string.equalsIgnoreCase("QUARTER") || string.equalsIgnoreCase("DAYOFWEEK") || string.equalsIgnoreCase("YEAR") || string.equalsIgnoreCase("MONTH") || string.equalsIgnoreCase("DAY")) {
            columnMetadata2 = this.createIntMetadata();
            n = 91;
        } else if (string.equalsIgnoreCase("HOUR") || string.equalsIgnoreCase("MINUTE") || string.equalsIgnoreCase("WEEK")) {
            columnMetadata2 = this.createIntMetadata();
            n = 92;
        } else if (string.equalsIgnoreCase("SECOND")) {
            s = this.getFractionalSecondsPrecisionFromValue(aECoercionColumnInfo2);
            columnMetadata2 = s > 0 ? this.createExactNumericMetadata((short)(s + 2), s) : this.createIntMetadata();
            n = 92;
        } else {
            throw new RuntimeException(String.format("Invalid field type \"%s\", should be prevented by parser", string));
        }
        if (91 == n) {
            columnMetadata = aECoercionColumnInfo2.getType() == 93 ? this.createTimestampMetadata() : this.createDateMetadata();
        } else if (aECoercionColumnInfo2.getColumnMetadata().getTypeMetadata().isCharacterType()) {
            s = columnMetadata2.getTypeMetadata().isExactNumericType() ? columnMetadata2.getTypeMetadata().getScale() : (short)0;
            columnMetadata = this.createTimestampMetadata((short)Math.min(s, this.m_coercionProperties.getMaxTimestampPrecision()));
        } else {
            columnMetadata = aECoercionColumnInfo2.getType() == 92 ? this.createTimeMetadata(aECoercionColumnInfo2.getPrecision()) : (aECoercionColumnInfo2.getType() == 93 ? this.createTimestampMetadata(aECoercionColumnInfo2.getPrecision()) : this.createTimestampMetadata());
        }
        return new ScalarFnMetadata(columnMetadata2, Arrays.asList(this.createStringMetadata(1, string.length()), columnMetadata));
    }

    private short getFractionalSecondsPrecisionFromValue(AECoercionColumnInfo aECoercionColumnInfo) {
        short s = this.m_coercionProperties.getMaxTimestampPrecision();
        TypeMetadata typeMetadata = aECoercionColumnInfo.getColumnMetadata().getTypeMetadata();
        switch (typeMetadata.getType()) {
            case 92: 
            case 93: {
                return typeMetadata.getPrecision();
            }
            case -15: 
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = aECoercionColumnInfo.getLiteralString();
                if (string == null) break;
                short s2 = (short)string.lastIndexOf(".");
                if (s2 >= 0) {
                    return (short)Math.min(s, string.length() - s2 - 1);
                }
                return 0;
            }
        }
        return s;
    }

    public ScalarFnMetadata createHourMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createTimeMetadata((short)0)));
    }

    public ScalarFnMetadata createMinuteMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createTimeMetadata((short)0)));
    }

    public ScalarFnMetadata createMonthMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createDateMetadata()));
    }

    public ScalarFnMetadata createMonthNameMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(32L), Arrays.asList(this.createDateMetadata()));
    }

    public ScalarFnMetadata createNowMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new ScalarFnMetadata(this.createTimestampMetadata(), Collections.emptyList());
    }

    public ScalarFnMetadata createQuarterMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createDateMetadata()));
    }

    public ScalarFnMetadata createSecondMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createTimeMetadata((short)0)));
    }

    public ScalarFnMetadata createTimestampAddMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) throws ErrorException {
        ColumnMetadata columnMetadata = this.createTimestampMetadata();
        columnMetadata.getTypeMetadata().setPrecision((short)9);
        columnMetadata.getTypeMetadata().setScale((short)9);
        return new ScalarFnMetadata(columnMetadata, Arrays.asList(this.createStringMetadata(iColumnInfo), this.createBigIntMetadata(), columnMetadata));
    }

    public ScalarFnMetadata createTimestampDiffMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumnInfo iColumnInfo3) throws ErrorException {
        ColumnMetadata columnMetadata = this.createTimestampMetadata();
        columnMetadata.getTypeMetadata().setPrecision((short)9);
        columnMetadata.getTypeMetadata().setScale((short)9);
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createStringMetadata(iColumnInfo), columnMetadata, columnMetadata));
    }

    public ScalarFnMetadata createWeekMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createDateMetadata()));
    }

    public ScalarFnMetadata createWeekISOMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createDateMetadata()));
    }

    public ScalarFnMetadata createYearMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createDateMetadata()));
    }

    public ScalarFnMetadata createAbsMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        ColumnMetadata columnMetadata = this.createNumericMetadata(iColumnInfo);
        if (columnMetadata.getTypeMetadata().isIntegerType()) {
            columnMetadata.getTypeMetadata().setSigned(false);
        }
        return new ScalarFnMetadata(columnMetadata, Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createACosMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createASinMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createATanMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createATanMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata(), this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createCeilingMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        ColumnMetadata columnMetadata = this.createNumericMetadata(iColumnInfo);
        if (columnMetadata.getTypeMetadata().isExactNumericType()) {
            TypeMetadata typeMetadata = columnMetadata.getTypeMetadata();
            typeMetadata.setPrecision((short)(typeMetadata.getPrecision() + 1));
            typeMetadata.setScale((short)0);
        }
        return new ScalarFnMetadata(columnMetadata, Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createCosMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createCotMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createDegreesMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createExpMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createFloorMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        ColumnMetadata columnMetadata = this.createNumericMetadata(iColumnInfo);
        if (columnMetadata.getTypeMetadata().isExactNumericType()) {
            TypeMetadata typeMetadata = columnMetadata.getTypeMetadata();
            typeMetadata.setPrecision((short)(typeMetadata.getPrecision() + 1));
            typeMetadata.setScale((short)0);
        }
        return new ScalarFnMetadata(columnMetadata, Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createLogMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createLog10Metadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createModMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        ColumnMetadata columnMetadata;
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(2);
        if (IColumnInfo.ColumnType.PARAMETER_UNSET == iColumnInfo.getColumnType() && IColumnInfo.ColumnType.PARAMETER_UNSET == iColumnInfo2.getColumnType()) {
            columnMetadata = this.createBigIntMetadata();
            arrayList.add(this.createBigIntMetadata());
            arrayList.add(this.createBigIntMetadata());
        } else {
            ColumnMetadata columnMetadata2 = this.createNumericMetadata(iColumnInfo);
            ColumnMetadata columnMetadata3 = this.createNumericMetadata(iColumnInfo2);
            IColumn iColumn = this.getCoercionHandler().coerceUnionColumns(new MetadataColumnInfo(columnMetadata2, iColumnInfo.getColumnType()), new MetadataColumnInfo(columnMetadata3, iColumnInfo2.getColumnType()));
            columnMetadata = ColumnMetadata.copyOf(iColumn);
            arrayList.add(ColumnMetadata.copyOf(iColumn));
            arrayList.add(ColumnMetadata.copyOf(iColumn));
        }
        return new ScalarFnMetadata(columnMetadata, arrayList);
    }

    public ScalarFnMetadata createPiMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Collections.emptyList());
    }

    public ScalarFnMetadata createPowerMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata(), this.createIntMetadata()));
    }

    public ScalarFnMetadata createRadiansMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createRandMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Collections.emptyList());
    }

    public ScalarFnMetadata createRandMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createIntMetadata()));
    }

    public ScalarFnMetadata createRoundMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        IColumn iColumn = TypeUtilities.isExactNumericType(iColumnInfo.getType()) ? this.m_coercionHandler.coercePlusColumns(iColumnInfo, iColumnInfo) : this.createNumericMetadata(iColumnInfo);
        return new ScalarFnMetadata(iColumn, Arrays.asList(this.createNumericMetadata(iColumnInfo), this.createIntMetadata()));
    }

    public ScalarFnMetadata createSignMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createIntMetadata(), Arrays.asList(this.createNumericMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createSinMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createSqrtMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createTanMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    public ScalarFnMetadata createTruncateMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return new ScalarFnMetadata(this.createNumericMetadata(iColumnInfo), Arrays.asList(this.createNumericMetadata(iColumnInfo), this.createIntMetadata()));
    }

    public ScalarFnMetadata createDatabaseMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createIfNullMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        IColumn iColumn = this.getCoercionHandler().coerceUnionColumns(new MetadataColumnInfo(MetadataUtilities.createColumnMetadata(iColumnInfo), iColumnInfo.getColumnType()), new MetadataColumnInfo(MetadataUtilities.createColumnMetadata(iColumnInfo2), iColumnInfo2.getColumnType()));
        return new ScalarFnMetadata(ColumnMetadata.copyOf(iColumn), Arrays.asList(ColumnMetadata.copyOf(iColumn), ColumnMetadata.copyOf(iColumn)));
    }

    public ScalarFnMetadata createNullMetadata(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return new ScalarFnMetadata(new AENull().getColumn(), Collections.emptyList());
    }

    public ScalarFnMetadata createUserMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createConvertMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        int n;
        if (IColumnInfo.ColumnType.LITERAL != iColumnInfo2.getColumnType()) {
            throw SQLEngineExceptionFactory.invalidSecondArgumentToConvertException();
        }
        String string = iColumnInfo2.getLiteralString();
        try {
            n = SqlTypes.valueOf(string.toUpperCase()).getSqlType();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw SQLEngineExceptionFactory.invalidSecondArgumentToConvertException();
        }
        ColumnMetadata columnMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(n));
        if (columnMetadata.getTypeMetadata().isCharacterType()) {
            try {
                this.setOutputCharLength(columnMetadata, iColumnInfo.getDisplaySize());
            }
            catch (NumericOverflowException numericOverflowException) {}
        } else if (columnMetadata.getTypeMetadata().isBinaryType()) {
            try {
                this.setOutputByteLength(columnMetadata, iColumnInfo.getDisplaySize());
            }
            catch (NumericOverflowException numericOverflowException) {
                // empty catch block
            }
        }
        return new ScalarFnMetadata(columnMetadata, Arrays.asList(columnMetadata, this.createStringMetadata(iColumnInfo2)));
    }

    public ScalarFnMetadata createCastMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        ColumnMetadata columnMetadata;
        if (IColumnInfo.ColumnType.LITERAL != iColumnInfo2.getColumnType()) {
            throw SQLEngineExceptionFactory.invalidSecondArgumentToCastException();
        }
        String string = iColumnInfo2.getLiteralString();
        Integer n = sqlDataEngineContext.getSqlTypeForTypeName(string);
        if (0 == n) {
            n = TypeUtilities.getTypeForSqlTypeString(string);
            if (null == n) {
                throw SQLEngineExceptionFactory.invalidSecondArgumentToCastException();
            }
            if (TypeUtilities.isIntervalType(n)) {
                throw SQLEngineExceptionFactory.unsupportedTypesException(string);
            }
        }
        if ((columnMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(n))).getTypeMetadata().isCharacterType()) {
            try {
                this.setOutputCharLength(columnMetadata, iColumnInfo.getDisplaySize());
            }
            catch (NumericOverflowException numericOverflowException) {
                // empty catch block
            }
        }
        return new ScalarFnMetadata(columnMetadata, Arrays.asList(columnMetadata, this.createStringMetadata(iColumnInfo2)));
    }

    public ScalarFnMetadata createLowerMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    public ScalarFnMetadata createUpperMetadata(SqlDataEngineContext sqlDataEngineContext, IColumnInfo iColumnInfo) throws ErrorException {
        return new ScalarFnMetadata(this.createStringMetadata(iColumnInfo), Arrays.asList(this.createStringMetadata(iColumnInfo)));
    }

    static AEScalarFnMetadataFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private ColumnMetadata createExactNumericMetadata(short s, short s2) {
        try {
            return new ColumnMetadata(TypeMetadata.createTypeMetadata(2, s, s2, 0, true));
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    private ColumnMetadata createDoubleMetadata() {
        try {
            return new ColumnMetadata(TypeMetadata.createTypeMetadata(8));
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    private ColumnMetadata createBigIntMetadata() {
        try {
            return new ColumnMetadata(TypeMetadata.createTypeMetadata(-5));
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    private ColumnMetadata createIntMetadata() {
        try {
            return new ColumnMetadata(TypeMetadata.createTypeMetadata(4));
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    private ColumnMetadata createUnknownMetadata() {
        try {
            return new ColumnMetadata(TypeMetadata.createTypeMetadata(0));
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    private ColumnMetadata createStringMetadata(long l) {
        try {
            ColumnMetadata columnMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(12));
            columnMetadata.setColumnLength(l);
            return columnMetadata;
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new AssertionError((Object)numericOverflowException);
        }
    }

    private ColumnMetadata createStringMetadata(IColumnInfo iColumnInfo) {
        if (IColumnInfo.ColumnType.PARAMETER_UNSET == iColumnInfo.getColumnType() || !TypeUtilities.isCharacterType(iColumnInfo.getType())) {
            return this.createStringMetadata(255L);
        }
        try {
            ColumnMetadata columnMetadata = new ColumnMetadata(MetadataUtilities.createTypeMetadata(iColumnInfo));
            columnMetadata.setColumnLength(iColumnInfo.getColumnLength());
            return columnMetadata;
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new AssertionError((Object)numericOverflowException);
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    private ColumnMetadata createStringMetadata(int n, long l) throws ErrorException {
        ColumnMetadata columnMetadata = SqlTypes.getValueOf(n).isWChar() ? (this.m_coercionProperties.getMaxWvarcharLength() < l ? new ColumnMetadata(TypeMetadata.createTypeMetadata(-10)) : (this.m_coercionProperties.getMaxWcharlength() < l ? new ColumnMetadata(TypeMetadata.createTypeMetadata(-9)) : new ColumnMetadata(TypeMetadata.createTypeMetadata(-8)))) : (this.m_coercionProperties.getMaxVarcharlength() < l ? new ColumnMetadata(TypeMetadata.createTypeMetadata(-1)) : (this.m_coercionProperties.getMaxCharLength() < l ? new ColumnMetadata(TypeMetadata.createTypeMetadata(12)) : new ColumnMetadata(TypeMetadata.createTypeMetadata(1))));
        try {
            columnMetadata.setColumnLength(l);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new AssertionError((Object)numericOverflowException);
        }
        return columnMetadata;
    }

    private ColumnMetadata createTimeMetadata(short s) {
        try {
            TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(92);
            typeMetadata.setPrecision(s);
            typeMetadata.setScale(s);
            return new ColumnMetadata(typeMetadata);
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    private ColumnMetadata createTimestampMetadata(short s) {
        try {
            TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(93);
            typeMetadata.setPrecision(s);
            return new ColumnMetadata(typeMetadata);
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    private ColumnMetadata createTimestampMetadata() {
        return this.createTimestampMetadata(this.m_coercionProperties.getMaxTimestampPrecision());
    }

    private ColumnMetadata createDateMetadata() {
        try {
            return new ColumnMetadata(TypeMetadata.createTypeMetadata(91));
        }
        catch (ErrorException errorException) {
            throw new AssertionError((Object)errorException);
        }
    }

    private ColumnMetadata createNumericMetadata(IColumnInfo iColumnInfo) {
        if (IColumnInfo.ColumnType.PARAMETER_UNSET == iColumnInfo.getColumnType()) {
            return this.createUnknownMetadata();
        }
        if (AEUtils.isTypeNumeric(iColumnInfo.getType())) {
            try {
                return new ColumnMetadata(MetadataUtilities.createTypeMetadata(iColumnInfo));
            }
            catch (ErrorException errorException) {
                throw new AssertionError((Object)errorException);
            }
        }
        return this.createDoubleMetadata();
    }

    private boolean isValidTypeMetadata(SqlDataEngineContext sqlDataEngineContext, ScalarFunctionArgType scalarFunctionArgType, short s) throws ErrorException {
        return MetadataUtilities.isConversionLegal(s, scalarFunctionArgType);
    }

    private Long parseIntegerLiteral(IColumnInfo iColumnInfo) {
        if (IColumnInfo.ColumnType.LITERAL != iColumnInfo.getColumnType()) {
            throw new IllegalArgumentException();
        }
        ConversionResult conversionResult = new ConversionResult();
        long l = CharConverter.toInteger(iColumnInfo.getLiteralString(), conversionResult, iColumnInfo.isSigned());
        switch (conversionResult.getState()) {
            case FRAC_TRUNCATION_ROUNDED_DOWN: 
            case FRAC_TRUNCATION_ROUNDED_UP: 
            case SUCCESS: {
                return l;
            }
        }
        return null;
    }

    private void setOutputCharLength(ColumnMetadata columnMetadata, long l) throws NumericOverflowException {
        assert (columnMetadata.getTypeMetadata().isCharacterType());
        if (0xFFFFFFFEL < l) {
            throw new NumericOverflowException();
        }
        switch (columnMetadata.getTypeMetadata().getType()) {
            case 1: {
                columnMetadata.setColumnLength(Math.min(l, this.m_coercionProperties.getMaxCharLength()));
                break;
            }
            case 12: {
                columnMetadata.setColumnLength(Math.min(l, this.m_coercionProperties.getMaxVarcharlength()));
                break;
            }
            case -1: {
                columnMetadata.setColumnLength(l);
                break;
            }
            case -8: {
                columnMetadata.setColumnLength(Math.min(l, this.m_coercionProperties.getMaxWcharlength()));
                break;
            }
            case -9: {
                columnMetadata.setColumnLength(Math.min(l, this.m_coercionProperties.getMaxWvarcharLength()));
                break;
            }
            case -10: {
                columnMetadata.setColumnLength(l);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void setOutputByteLength(ColumnMetadata columnMetadata, long l) throws NumericOverflowException {
        assert (columnMetadata.getTypeMetadata().isBinaryType());
        if (l % 2L != 0L) {
            --l;
        }
        if (0xFFFFFFFEL < l) {
            throw new NumericOverflowException();
        }
        switch (columnMetadata.getTypeMetadata().getType()) {
            case -2: {
                columnMetadata.setColumnLength(Math.min(l / 2L, this.m_coercionProperties.getMaxBinaryLength()));
                break;
            }
            case -3: {
                columnMetadata.setColumnLength(Math.min(l / 2L, this.m_coercionProperties.getMaxVarbinaryLength()));
                break;
            }
            case -4: {
                columnMetadata.setColumnLength(l / 2L);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void validateTypeMetadata(SqlDataEngineContext sqlDataEngineContext, String string, int n, ScalarFunctionArgType scalarFunctionArgType, IColumnInfo iColumnInfo) throws ErrorException {
        if (!this.isValidTypeMetadata(sqlDataEngineContext, scalarFunctionArgType, iColumnInfo.getType())) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentTypeException(string, n, iColumnInfo.getType());
        }
    }

    private void validateArgTypes(SqlDataEngineContext sqlDataEngineContext, String string, List<ScalarFunctionArgType> list, List<? extends IColumnInfo> list2) throws ErrorException {
        if (string.equalsIgnoreCase("USER") || string.equalsIgnoreCase("DATABASE") ? 0 != list.size() || 1 != list2.size() : list.size() != list2.size()) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
        }
        for (int i = 0; i < list.size(); ++i) {
            this.validateTypeMetadata(sqlDataEngineContext, string, i + 1, list.get(i), list2.get(i));
        }
    }

    private static final class InstanceHolder {
        public static final AEScalarFnMetadataFactory INSTANCE = new AEScalarFnMetadataFactory();

        private InstanceHolder() {
        }
    }

    public static final class ScalarFnMetadata {
        private final IColumn m_columnMetadata;
        private final List<IColumn> m_expectedArgumentMetadata;

        public ScalarFnMetadata(IColumn iColumn, List<? extends IColumn> list) {
            if (null == iColumn) {
                throw new NullPointerException("columnMetadata");
            }
            this.m_columnMetadata = iColumn;
            this.m_expectedArgumentMetadata = new ArrayList<IColumn>(list);
        }

        public IColumn getColumnMetadata() {
            return this.m_columnMetadata;
        }

        public List<IColumn> getExpectedArgumentMetadata() {
            return this.m_expectedArgumentMetadata;
        }
    }
}

