/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.util;

import com.cloudera.impala.jdbc42.internal.apache.jute.BinaryInputArchive;
import com.cloudera.impala.jdbc42.internal.apache.jute.BinaryOutputArchive;
import com.cloudera.impala.jdbc42.internal.apache.jute.InputArchive;
import com.cloudera.impala.jdbc42.internal.apache.jute.OutputArchive;
import com.cloudera.impala.jdbc42.internal.apache.jute.Record;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.DataTree;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.Request;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.ZooTrace;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.txn.CreateSessionTxn;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.txn.CreateTxn;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.txn.CreateTxnV0;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.txn.DeleteTxn;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.txn.ErrorTxn;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.txn.MultiTxn;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.txn.SetACLTxn;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.txn.SetDataTxn;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.txn.TxnHeader;
import com.cloudera.impala.jdbc42.internal.slf4j.Logger;
import com.cloudera.impala.jdbc42.internal.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SerializeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SerializeUtils.class);

    public static Record deserializeTxn(byte[] txnBytes, TxnHeader hdr) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(txnBytes);
        BinaryInputArchive ia = BinaryInputArchive.getArchive(bais);
        hdr.deserialize(ia, "hdr");
        bais.mark(bais.available());
        Record txn = null;
        switch (hdr.getType()) {
            case -10: {
                txn = new CreateSessionTxn();
                break;
            }
            case -11: {
                return null;
            }
            case 1: {
                txn = new CreateTxn();
                break;
            }
            case 2: {
                txn = new DeleteTxn();
                break;
            }
            case 5: {
                txn = new SetDataTxn();
                break;
            }
            case 7: {
                txn = new SetACLTxn();
                break;
            }
            case -1: {
                txn = new ErrorTxn();
                break;
            }
            case 14: {
                txn = new MultiTxn();
                break;
            }
            default: {
                throw new IOException("Unsupported Txn with type=%d" + hdr.getType());
            }
        }
        if (txn != null) {
            try {
                txn.deserialize(ia, "txn");
            }
            catch (EOFException e) {
                if (hdr.getType() == 1) {
                    CreateTxn create = (CreateTxn)txn;
                    bais.reset();
                    CreateTxnV0 createv0 = new CreateTxnV0();
                    createv0.deserialize(ia, "txn");
                    create.setPath(createv0.getPath());
                    create.setData(createv0.getData());
                    create.setAcl(createv0.getAcl());
                    create.setEphemeral(createv0.getEphemeral());
                    create.setParentCVersion(-1);
                }
                throw e;
            }
        }
        return txn;
    }

    public static void deserializeSnapshot(DataTree dt, InputArchive ia, Map<Long, Integer> sessions) throws IOException {
        for (int count = ia.readInt("count"); count > 0; --count) {
            long id = ia.readLong("id");
            int to = ia.readInt("timeout");
            sessions.put(id, to);
            if (!LOG.isTraceEnabled()) continue;
            ZooTrace.logTraceMessage(LOG, 32L, "loadData --- session in archive: " + id + " with timeout: " + to);
        }
        dt.deserialize(ia, "tree");
    }

    public static void serializeSnapshot(DataTree dt, OutputArchive oa, Map<Long, Integer> sessions) throws IOException {
        HashMap<Long, Integer> sessSnap = new HashMap<Long, Integer>(sessions);
        oa.writeInt(sessSnap.size(), "count");
        for (Map.Entry<Long, Integer> entry : sessSnap.entrySet()) {
            oa.writeLong(entry.getKey(), "id");
            oa.writeInt(entry.getValue(), "timeout");
        }
        dt.serialize(oa, "tree");
    }

    public static byte[] serializeRequest(Request request) {
        if (request == null || request.hdr == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        try {
            request.hdr.serialize(boa, "hdr");
            if (request.txn != null) {
                request.txn.serialize(boa, "txn");
            }
            baos.close();
        }
        catch (IOException e) {
            LOG.error("This really should be impossible", e);
        }
        return baos.toByteArray();
    }
}

