/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.util;

import com.cloudera.impala.jdbc42.internal.slf4j.Logger;
import com.cloudera.impala.jdbc42.internal.slf4j.LoggerFactory;

public class Profiler {
    private static final Logger LOG = LoggerFactory.getLogger(Profiler.class);

    public static <T> T profile(Operation<T> op, long timeout, String message) throws Exception {
        long start = System.currentTimeMillis();
        T res = op.execute();
        long end = System.currentTimeMillis();
        if (end - start > timeout) {
            LOG.info("Elapsed " + (end - start) + " ms: " + message);
        }
        return res;
    }

    public static interface Operation<T> {
        public T execute() throws Exception;
    }
}

