/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.util;

import com.cloudera.impala.jdbc42.internal.slf4j.Logger;
import com.cloudera.impala.jdbc42.internal.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;

public class OSMXBean {
    static final Logger LOG = LoggerFactory.getLogger(OSMXBean.class);
    private OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
    private static final boolean ibmvendor = System.getProperty("java.vendor").contains("IBM");
    private static final boolean windows = System.getProperty("os.name").startsWith("Windows");
    private static final boolean linux = System.getProperty("os.name").startsWith("Linux");

    public boolean getUnix() {
        if (windows) {
            return false;
        }
        return ibmvendor ? linux : true;
    }

    private Long getOSUnixMXBeanMethod(String mBeanMethodName) {
        try {
            Class<?> classRef = Class.forName("com.sun.management.UnixOperatingSystemMXBean");
            if (classRef.isInstance(this.osMbean)) {
                Method mBeanMethod = classRef.getDeclaredMethod(mBeanMethodName, new Class[0]);
                Object unixos = classRef.cast(this.osMbean);
                return (Long)mBeanMethod.invoke(unixos, new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.warn("Not able to load class or method for com.sun.managment.UnixOperatingSystemMXBean.", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getOpenFileDescriptorCount() {
        if (!ibmvendor) {
            Long ofdc = this.getOSUnixMXBeanMethod("getOpenFileDescriptorCount");
            if (ofdc == null) return -1L;
            long l = ofdc;
            return l;
        }
        try {
            RuntimeMXBean rtmbean = ManagementFactory.getRuntimeMXBean();
            String rtname = rtmbean.getName();
            String[] pidhost = rtname.split("@");
            Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "ls /proc/" + pidhost[0] + "/fdinfo | wc -l"});
            InputStream in = p.getInputStream();
            BufferedReader output = new BufferedReader(new InputStreamReader(in));
            try {
                String openFileDesCount = output.readLine();
                if (openFileDesCount == null) return -1L;
                long l = Long.parseLong(openFileDesCount);
                return l;
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (IOException ie) {
            LOG.warn("Not able to get the number of open file descriptors", ie);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMaxFileDescriptorCount() {
        if (!ibmvendor) {
            Long mfdc = this.getOSUnixMXBeanMethod("getMaxFileDescriptorCount");
            if (mfdc == null) return -1L;
            long l = mfdc;
            return l;
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "ulimit -n"});
            InputStream in = p.getInputStream();
            BufferedReader output = new BufferedReader(new InputStreamReader(in));
            try {
                String maxFileDesCount = output.readLine();
                if (maxFileDesCount == null) return -1L;
                long l = Long.parseLong(maxFileDesCount);
                return l;
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (IOException ie) {
            LOG.warn("Not able to get the max number of file descriptors", ie);
        }
        return -1L;
    }
}

