/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum;

import com.cloudera.impala.jdbc42.internal.apache.zookeeper.KeeperException;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.proto.ReplyHeader;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.Request;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.RequestProcessor;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.ZooKeeperCriticalThread;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.ZooKeeperServer;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.ZooTrace;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum.Leader;
import com.cloudera.impala.jdbc42.internal.slf4j.Logger;
import com.cloudera.impala.jdbc42.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class ReadOnlyRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyRequestProcessor.class);
    private LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    private boolean finished = false;
    private RequestProcessor nextProcessor;
    private ZooKeeperServer zks;

    public ReadOnlyRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("ReadOnlyRequestProcessor:" + zks.getServerId(), zks.getZooKeeperServerListener());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public void run() {
        try {
            block8: while (!this.finished) {
                Request request = this.queuedRequests.take();
                long traceMask = 2L;
                if (request.type == 11) {
                    traceMask = 8L;
                }
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logRequest(LOG, traceMask, 'R', request, "");
                }
                if (Request.requestOfDeath != request) {
                    switch (request.type) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: 
                        case 9: 
                        case 13: 
                        case 14: {
                            ReplyHeader hdr = new ReplyHeader(request.cxid, this.zks.getZKDatabase().getDataTreeLastProcessedZxid(), KeeperException.Code.NOTREADONLY.intValue());
                            try {
                                request.cnxn.sendResponse(hdr, null, null);
                            }
                            catch (IOException e) {
                                LOG.error("IO exception while sending response", e);
                            }
                            continue block8;
                        }
                    }
                    if (this.nextProcessor == null) continue;
                    this.nextProcessor.processRequest(request);
                    continue;
                }
                break;
            }
        }
        catch (RequestProcessor.RequestProcessorException e) {
            if (e.getCause() instanceof Leader.XidRolloverException) {
                LOG.info(e.getCause().getMessage());
            }
            this.handleException(this.getName(), e);
        }
        catch (Exception e) {
            this.handleException(this.getName(), e);
        }
        LOG.info("ReadOnlyRequestProcessor exited loop!");
    }

    @Override
    public void processRequest(Request request) {
        if (!this.finished) {
            this.queuedRequests.add(request);
        }
    }

    @Override
    public void shutdown() {
        this.finished = true;
        this.queuedRequests.clear();
        this.queuedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }
}

