/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.logging.slf4j;

import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.Logger;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.Marker;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.MarkerManager;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.status.StatusLogger;
import com.cloudera.impala.jdbc42.internal.apache.logging.slf4j.Log4jMarker;
import com.cloudera.impala.jdbc42.internal.slf4j.IMarkerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Log4jMarkerFactory
implements IMarkerFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final ConcurrentMap<String, com.cloudera.impala.jdbc42.internal.slf4j.Marker> markerMap = new ConcurrentHashMap<String, com.cloudera.impala.jdbc42.internal.slf4j.Marker>();

    @Override
    public com.cloudera.impala.jdbc42.internal.slf4j.Marker getMarker(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Marker name must not be null");
        }
        com.cloudera.impala.jdbc42.internal.slf4j.Marker marker = (com.cloudera.impala.jdbc42.internal.slf4j.Marker)this.markerMap.get(name);
        if (marker != null) {
            return marker;
        }
        Marker log4jMarker = MarkerManager.getMarker(name);
        return this.addMarkerIfAbsent(name, log4jMarker);
    }

    private com.cloudera.impala.jdbc42.internal.slf4j.Marker addMarkerIfAbsent(String name, Marker log4jMarker) {
        Log4jMarker marker = new Log4jMarker(log4jMarker);
        com.cloudera.impala.jdbc42.internal.slf4j.Marker existing = this.markerMap.putIfAbsent(name, marker);
        return existing == null ? marker : existing;
    }

    public com.cloudera.impala.jdbc42.internal.slf4j.Marker getMarker(com.cloudera.impala.jdbc42.internal.slf4j.Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        com.cloudera.impala.jdbc42.internal.slf4j.Marker m = (com.cloudera.impala.jdbc42.internal.slf4j.Marker)this.markerMap.get(marker.getName());
        if (m != null) {
            return m;
        }
        return this.addMarkerIfAbsent(marker.getName(), Log4jMarkerFactory.convertMarker(marker));
    }

    private static Marker convertMarker(com.cloudera.impala.jdbc42.internal.slf4j.Marker original) {
        if (original == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        return Log4jMarkerFactory.convertMarker(original, new ArrayList<com.cloudera.impala.jdbc42.internal.slf4j.Marker>());
    }

    private static Marker convertMarker(com.cloudera.impala.jdbc42.internal.slf4j.Marker original, Collection<com.cloudera.impala.jdbc42.internal.slf4j.Marker> visited) {
        Marker marker = MarkerManager.getMarker(original.getName());
        if (original.hasReferences()) {
            Iterator<com.cloudera.impala.jdbc42.internal.slf4j.Marker> it = original.iterator();
            while (it.hasNext()) {
                com.cloudera.impala.jdbc42.internal.slf4j.Marker next = it.next();
                if (visited.contains(next)) {
                    LOGGER.warn("Found a cycle in Marker [{}]. Cycle will be broken.", (Object)next.getName());
                    continue;
                }
                visited.add(next);
                marker.addParents(Log4jMarkerFactory.convertMarker(next, visited));
            }
        }
        return marker;
    }

    @Override
    public boolean exists(String name) {
        return this.markerMap.containsKey(name);
    }

    @Override
    public boolean detachMarker(String name) {
        return false;
    }

    @Override
    public com.cloudera.impala.jdbc42.internal.slf4j.Marker getDetachedMarker(String name) {
        LOGGER.warn("Log4j does not support detached Markers. Returned Marker [{}] will be unchanged.", (Object)name);
        return this.getMarker(name);
    }
}

