/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.filter;

import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.Level;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.Logger;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.Marker;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.Filter;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.LogEvent;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config.Configuration;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config.plugins.Plugin;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginElement;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.filter.AbstractFilter;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.script.AbstractScript;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.script.ScriptRef;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.message.Message;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.message.ObjectMessage;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.message.SimpleMessage;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.status.StatusLogger;
import java.util.Map;
import javax.script.SimpleBindings;

@Plugin(name="ScriptFilter", category="Core", elementType="filter", printObject=true)
public final class ScriptFilter
extends AbstractFilter {
    private static Logger logger = StatusLogger.getLogger();
    private final AbstractScript script;
    private final Configuration configuration;

    private ScriptFilter(AbstractScript script, Configuration configuration, Filter.Result onMatch, Filter.Result onMismatch) {
        super(onMatch, onMismatch);
        this.script = script;
        this.configuration = configuration;
        if (!(script instanceof ScriptRef)) {
            configuration.getScriptManager().addScript(script);
        }
    }

    @Override
    public Filter.Result filter(com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object ... params) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("logger", (Object)logger);
        bindings.put("level", (Object)level);
        bindings.put("marker", (Object)marker);
        bindings.put("message", (Object)new SimpleMessage(msg));
        bindings.put("parameters", (Object)params);
        bindings.put("throwable", (Object)null);
        bindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        bindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        return object == null || !Boolean.TRUE.equals(object) ? this.onMismatch : this.onMatch;
    }

    @Override
    public Filter.Result filter(com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("logger", (Object)logger);
        bindings.put("level", (Object)level);
        bindings.put("marker", (Object)marker);
        bindings.put("message", (Object)(msg instanceof String ? new SimpleMessage((String)msg) : new ObjectMessage(msg)));
        bindings.put("parameters", (Object)null);
        bindings.put("throwable", (Object)t);
        bindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        bindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        return object == null || !Boolean.TRUE.equals(object) ? this.onMismatch : this.onMatch;
    }

    @Override
    public Filter.Result filter(com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("logger", (Object)logger);
        bindings.put("level", (Object)level);
        bindings.put("marker", (Object)marker);
        bindings.put("message", (Object)msg);
        bindings.put("parameters", (Object)null);
        bindings.put("throwable", (Object)t);
        bindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        bindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        return object == null || !Boolean.TRUE.equals(object) ? this.onMismatch : this.onMatch;
    }

    @Override
    public Filter.Result filter(LogEvent event) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("logEvent", (Object)event);
        bindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        bindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        return object == null || !Boolean.TRUE.equals(object) ? this.onMismatch : this.onMatch;
    }

    @Override
    public String toString() {
        return this.script.getName();
    }

    @PluginFactory
    public static ScriptFilter createFilter(@PluginElement(value="Script") AbstractScript script, @PluginAttribute(value="onMatch") Filter.Result match, @PluginAttribute(value="onMismatch") Filter.Result mismatch, @PluginConfiguration Configuration configuration) {
        if (script == null) {
            LOGGER.error("A Script, ScriptFile or ScriptRef element must be provided for this ScriptFilter");
            return null;
        }
        if (script instanceof ScriptRef && configuration.getScriptManager().getScript(script.getName()) == null) {
            logger.error("No script with name {} has been declared.", (Object)script.getName());
            return null;
        }
        return new ScriptFilter(script, configuration, match, mismatch);
    }
}

