/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config;

import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config.AwaitCompletionReliabilityStrategy;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config.AwaitUnconditionallyReliabilityStrategy;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config.LockingReliabilityStrategy;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config.LoggerConfig;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.config.ReliabilityStrategy;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.core.util.Loader;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.status.StatusLogger;
import com.cloudera.impala.jdbc42.internal.apache.logging.log4j.util.PropertiesUtil;

public final class ReliabilityStrategyFactory {
    private ReliabilityStrategyFactory() {
    }

    public static ReliabilityStrategy getReliabilityStrategy(LoggerConfig loggerConfig) {
        String strategy = PropertiesUtil.getProperties().getStringProperty("log4j.ReliabilityStrategy", "AwaitCompletion");
        if ("AwaitCompletion".equals(strategy)) {
            return new AwaitCompletionReliabilityStrategy(loggerConfig);
        }
        if ("AwaitUnconditionally".equals(strategy)) {
            return new AwaitUnconditionallyReliabilityStrategy(loggerConfig);
        }
        if ("Locking".equals(strategy)) {
            return new LockingReliabilityStrategy(loggerConfig);
        }
        try {
            Class<ReliabilityStrategy> cls = Loader.loadClass(strategy).asSubclass(ReliabilityStrategy.class);
            return cls.getConstructor(LoggerConfig.class).newInstance(loggerConfig);
        }
        catch (Exception dynamicFailed) {
            StatusLogger.getLogger().warn("Could not create ReliabilityStrategy for '{}', using default AwaitCompletionReliabilityStrategy: {}", (Object)strategy, (Object)dynamicFailed);
            return new AwaitCompletionReliabilityStrategy(loggerConfig);
        }
    }
}

