/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.jute;

import com.cloudera.impala.jdbc42.internal.apache.jute.BinaryInputArchive;
import com.cloudera.impala.jdbc42.internal.apache.jute.CsvInputArchive;
import com.cloudera.impala.jdbc42.internal.apache.jute.InputArchive;
import com.cloudera.impala.jdbc42.internal.apache.jute.Record;
import com.cloudera.impala.jdbc42.internal.apache.jute.XmlInputArchive;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class RecordReader {
    private InputArchive archive;
    private static HashMap archiveFactory = new HashMap();

    private static InputArchive createArchive(InputStream in, String format) throws IOException {
        Method factory = (Method)archiveFactory.get(format);
        if (factory != null) {
            Object[] params = new Object[]{in};
            try {
                return (InputArchive)factory.invoke(null, params);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public RecordReader(InputStream in, String format) throws IOException {
        this.archive = RecordReader.createArchive(in, format);
    }

    public void read(Record r) throws IOException {
        r.deserialize(this.archive, "");
    }

    static {
        Class[] params = new Class[]{InputStream.class};
        try {
            archiveFactory.put("binary", BinaryInputArchive.class.getDeclaredMethod("getArchive", params));
            archiveFactory.put("csv", CsvInputArchive.class.getDeclaredMethod("getArchive", params));
            archiveFactory.put("xml", XmlInputArchive.class.getDeclaredMethod("getArchive", params));
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
    }
}

