/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.http.protocol;

import com.cloudera.impala.jdbc42.internal.apache.http.HttpConnection;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpException;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpHost;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpInetConnection;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpRequest;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpRequestInterceptor;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpVersion;
import com.cloudera.impala.jdbc42.internal.apache.http.ProtocolException;
import com.cloudera.impala.jdbc42.internal.apache.http.ProtocolVersion;
import com.cloudera.impala.jdbc42.internal.apache.http.annotation.Contract;
import com.cloudera.impala.jdbc42.internal.apache.http.annotation.ThreadingBehavior;
import com.cloudera.impala.jdbc42.internal.apache.http.protocol.HttpContext;
import com.cloudera.impala.jdbc42.internal.apache.http.protocol.HttpCoreContext;
import com.cloudera.impala.jdbc42.internal.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

