/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.oauth;

import com.cloudera.impala.jdbc.common.CommonUtils;
import com.cloudera.impala.jdbc.common.OAuthSettings;
import com.cloudera.impala.jdbc.common.SSLSettings;
import com.cloudera.impala.jdbc.core.DSDriver;
import com.cloudera.impala.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpEntity;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpResponse;
import com.cloudera.impala.jdbc42.internal.apache.http.client.entity.UrlEncodedFormEntity;
import com.cloudera.impala.jdbc42.internal.apache.http.client.methods.HttpPost;
import com.cloudera.impala.jdbc42.internal.apache.http.conn.ssl.SSLSocketFactory;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.client.CloseableHttpClient;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.client.HttpClients;
import com.cloudera.impala.jdbc42.internal.apache.http.message.BasicNameValuePair;
import com.cloudera.impala.jdbc42.internal.apache.http.util.EntityUtils;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.JsonNode;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.ObjectMapper;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;

public class OAuthFactory {
    private static final String JSON_ACCESS_TOKEN_KEY = "access_token";
    private static final String EXPIRY_TIME_KEY = "expires_in";
    private static final String JSON_ERROR_KEY = "error";
    private static final String JSON_ERROR_DESCRIPTION_KEY = "error_description";
    private static final String GRANT_TYPE_KEY = "grant_type";
    private static final String SCOPE_KEY = "scope";
    private static final String CLIENT_ID_KEY = "client_id";
    private static final String CLIENT_SECRET_KEY = "client_secret";
    private static final String CLIENT_CRED_GRANT = "client_credentials";
    private static final String UTF_8_CHARSET = "UTF-8";

    public static String clientCredentialOAuth(OAuthSettings oAuthSettings, SSLSettings sSLSettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, oAuthSettings, sSLSettings, iLogger);
        URI uRI = null;
        try {
            uRI = new URL(oAuthSettings.m_authrizationUrl).toURI();
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage(), exception.getCause().toString()});
            throw errorException;
        }
        HttpResponse httpResponse = null;
        String string = null;
        HttpPost httpPost = new HttpPost(uRI);
        httpPost = OAuthFactory.setRequestParams(oAuthSettings, httpPost);
        SSLSocketFactory sSLSocketFactory = CommonUtils.getSocketFactory(uRI.getHost(), sSLSettings);
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory(sSLSocketFactory).build();
        try {
            httpResponse = closeableHttpClient.execute(httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            string = EntityUtils.toString(httpEntity);
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage(), exception.getCause().toString()});
            throw errorException;
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n != 200) {
            if (n == 400) {
                String string2 = OAuthFactory.parseJsonResponse(string, JSON_ERROR_KEY);
                String string3 = OAuthFactory.parseJsonResponse(string, JSON_ERROR_DESCRIPTION_KEY);
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{string2, string3});
                throw errorException;
            }
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{Integer.toString(n), httpResponse.getStatusLine().getReasonPhrase()});
            throw errorException;
        }
        String string4 = OAuthFactory.parseJsonResponse(string.toString(), JSON_ACCESS_TOKEN_KEY);
        int n2 = Integer.valueOf(OAuthFactory.parseJsonResponse(string.toString(), EXPIRY_TIME_KEY));
        if (oAuthSettings.m_tokenExpiryBuffer < n2) {
            n2 -= oAuthSettings.m_tokenExpiryBuffer;
        } else {
            LogUtilities.logWarning("Token expiry buffer " + String.valueOf(oAuthSettings.m_tokenExpiryBuffer) + " is greater than the token expiry time " + n2 + ". No buffer is used for token expiry time.", iLogger);
        }
        oAuthSettings.m_expiryTime = System.currentTimeMillis() + (long)(n2 * 1000);
        if (null == string4) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name());
            throw errorException;
        }
        return string4;
    }

    private static String parseJsonResponse(String string, String string2) throws ErrorException {
        JsonNode jsonNode = null;
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode2 = null;
        try {
            jsonNode2 = objectMapper.readTree(string);
        }
        catch (IOException iOException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.ERROR_PARSING_JSON_RESPONSE.name(), iOException.getMessage());
            errorException.initCause(iOException);
            throw errorException;
        }
        jsonNode = jsonNode2.get(string2);
        return jsonNode.asText();
    }

    private static HttpPost setRequestParams(OAuthSettings oAuthSettings, HttpPost httpPost) throws ErrorException {
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
        arrayList.add(new BasicNameValuePair(GRANT_TYPE_KEY, CLIENT_CRED_GRANT));
        arrayList.add(new BasicNameValuePair(CLIENT_ID_KEY, oAuthSettings.m_authClientID));
        arrayList.add(new BasicNameValuePair(CLIENT_SECRET_KEY, oAuthSettings.m_authClientSecret));
        if (null != oAuthSettings.m_authScope) {
            arrayList.add(new BasicNameValuePair(SCOPE_KEY, oAuthSettings.m_authScope));
        }
        try {
            httpPost.setEntity(new UrlEncodedFormEntity(arrayList, UTF_8_CHARSET));
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage(), exception.getCause().toString()});
            throw errorException;
        }
        return httpPost;
    }
}

