/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.jdbc42.future;

import com.cloudera.impala.dsi.dataengine.utilities.OrderType;
import com.cloudera.impala.exceptions.ExceptionConverter;
import com.cloudera.impala.jdbc.common.SConnection;
import com.cloudera.impala.jdbc.jdbc41.future.S41DatabaseMetaData;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import java.sql.SQLException;

public class S42DatabaseMetaData
extends S41DatabaseMetaData {
    public S42DatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 2;
    }

    @Override
    protected OrderType getJDBCOrderType() {
        return OrderType.JDBC_42;
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }
}

