/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.core;

import com.cloudera.impala.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.impala.dsi.core.utilities.Variant;
import com.cloudera.impala.jdbc.common.CustomNetworkHooksSettings;
import com.cloudera.impala.jdbc.common.OAuthFlow;
import com.cloudera.impala.jdbc.common.OAuthSettings;
import com.cloudera.impala.jdbc.common.ProxySettings;
import com.cloudera.impala.jdbc.common.SSLSettings;
import com.cloudera.impala.jdbc.core.DSDriver;
import com.cloudera.impala.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.Warning;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.ErrorException;

public class DSConnectionUtils {
    public static final String O_AUTH_TOKEN_ENDPOINT = "OAuth_";

    public static void readCustomNetworkHooksProperties(ConnSettingRequestMap connSettingRequestMap, CustomNetworkHooksSettings customNetworkHooksSettings) {
        Variant variant = connSettingRequestMap.getProperty("SocketFactory");
        if (null != variant) {
            customNetworkHooksSettings.m_socketFactory = variant.getString();
            variant = connSettingRequestMap.getProperty("SocketFactoryArg");
            if (null != variant) {
                customNetworkHooksSettings.m_socketFactoryArg = variant.getString();
            }
        }
        if (null != (variant = connSettingRequestMap.getProperty("DnsResolver"))) {
            customNetworkHooksSettings.m_dnsResolver = variant.getString();
            variant = connSettingRequestMap.getProperty("DnsResolverArg");
            if (null != variant) {
                customNetworkHooksSettings.m_dnsResolverArg = variant.getString();
            }
        }
    }

    public static void readOAuthProperties(ConnSettingRequestMap connSettingRequestMap, OAuthSettings oAuthSettings, SSLSettings sSLSettings, IWarningListener iWarningListener) throws ErrorException {
        block9: {
            Variant variant = connSettingRequestMap.getProperty("Auth_Client_ID");
            if (null != variant) {
                oAuthSettings.m_authClientID = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("Auth_Client_Secret"))) {
                oAuthSettings.m_authClientSecret = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("AuthorizationUrl"))) {
                oAuthSettings.m_authrizationUrl = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("Auth_Scope"))) {
                oAuthSettings.m_authScope = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("Auth_AccessToken"))) {
                oAuthSettings.m_accessToken = variant.getString();
                oAuthSettings.m_refreshAccessToken = true;
            }
            if (null != (variant = connSettingRequestMap.getProperty("Auth_Flow"))) {
                oAuthSettings.m_authFlow = OAuthFlow.convertToOAuthFlow(variant, iWarningListener);
            }
            variant = connSettingRequestMap.getProperty("Auth_Token_Expiry_Buffer");
            oAuthSettings.m_tokenExpiryBuffer = 60;
            if (null != variant) {
                try {
                    oAuthSettings.m_tokenExpiryBuffer = variant.getInt();
                }
                catch (Exception exception) {
                    if (null == iWarningListener) break block9;
                    iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{String.valueOf("Auth_Token_Expiry_Buffer"), variant.getString(), "Integers"}));
                }
            }
        }
        DSConnectionUtils.readSSLSettings(connSettingRequestMap, sSLSettings, oAuthSettings.m_tokenEndpointSSLSettings, true, O_AUTH_TOKEN_ENDPOINT, iWarningListener);
    }

    public static void readSSLSettings(ConnSettingRequestMap connSettingRequestMap, SSLSettings sSLSettings, SSLSettings sSLSettings2, boolean bl, String string, IWarningListener iWarningListener) throws ErrorException {
        Variant variant;
        block64: {
            variant = connSettingRequestMap.getProperty(string + "ssl");
            if (bl) {
                sSLSettings2.m_enableSSL = true;
            } else if (variant != null) {
                try {
                    int n = variant.getInt();
                    if (1 == n) {
                        sSLSettings2.m_sslSpecifiedByUser = true;
                        sSLSettings2.m_enableSSL = true;
                    } else if (0 == n) {
                        sSLSettings2.m_sslSpecifiedByUser = true;
                        sSLSettings2.m_enableSSL = false;
                    } else if (null != iWarningListener) {
                        iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "ssl", variant.getString(), "0 or 1"}));
                    }
                }
                catch (Exception exception) {
                    ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "ssl", variant.getString(), "0 , 1"});
                    errorException.initCause(exception);
                    throw errorException;
                }
            }
            variant = connSettingRequestMap.getProperty(string + "SSLKeyStore");
            if (null != variant) {
                sSLSettings2.m_sslKeyStore = variant.getString();
            } else if (null != sSLSettings) {
                sSLSettings2.m_sslKeyStore = sSLSettings.m_sslKeyStore;
            }
            variant = connSettingRequestMap.getProperty(string + "SSLKeyStorePwd");
            if (null != variant) {
                sSLSettings2.m_sslKeyStorePwd = variant.getString();
            } else if (null != sSLSettings) {
                sSLSettings2.m_sslKeyStorePwd = sSLSettings.m_sslKeyStorePwd;
            }
            variant = connSettingRequestMap.getProperty(string + "SSLTrustStore");
            if (null != variant) {
                sSLSettings2.m_sslTrustStore = variant.getString();
            } else if (null != sSLSettings) {
                sSLSettings2.m_sslTrustStore = sSLSettings.m_sslTrustStore;
            }
            variant = connSettingRequestMap.getProperty(string + "SSLTrustStorePwd");
            if (null != variant) {
                sSLSettings2.m_sslTrustStorePwd = variant.getString();
            } else if (null != sSLSettings) {
                sSLSettings2.m_sslTrustStorePwd = sSLSettings.m_sslTrustStorePwd;
            }
            sSLSettings2.m_allowSelfSigned = false;
            variant = connSettingRequestMap.getProperty(string + "AllowSelfSignedCerts");
            if (variant != null) {
                try {
                    if (1 == variant.getInt()) {
                        sSLSettings2.m_allowSelfSigned = true;
                        sSLSettings2.m_allowSelfSignedSpecifiedByUser = true;
                    }
                    if (0 == variant.getInt()) {
                        sSLSettings2.m_allowSelfSigned = false;
                        sSLSettings2.m_allowSelfSignedSpecifiedByUser = true;
                    }
                    break block64;
                }
                catch (Exception exception) {
                    if (null != iWarningListener) {
                        iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "AllowSelfSignedCerts", variant.getString(), "0 or 1"}));
                    }
                    break block64;
                }
            }
            if (null != sSLSettings) {
                sSLSettings2.m_allowSelfSigned = sSLSettings.m_allowSelfSigned;
            }
        }
        sSLSettings2.m_certNamesMismatch = false;
        Variant variant2 = connSettingRequestMap.getProperty(string + "AllowAllHostNames");
        Variant variant3 = connSettingRequestMap.getProperty(string + "CAIssuedCertNamesMismatch");
        int n = -1;
        if (null != variant3) {
            block65: {
                try {
                    n = variant3.getInt();
                }
                catch (Exception exception) {
                    if (null == iWarningListener) break block65;
                    iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "CAIssuedCertNamesMismatch", variant.getString(), "0 or 1"}));
                }
            }
            if (1 == n) {
                sSLSettings2.m_certNamesMismatch = true;
                sSLSettings2.m_certNamesMismatchSpecifiedByUser = true;
            } else if (0 == n) {
                sSLSettings2.m_certNamesMismatch = false;
                sSLSettings2.m_certNamesMismatchSpecifiedByUser = true;
            }
        } else if (variant2 != null) {
            block66: {
                try {
                    n = variant2.getInt();
                }
                catch (Exception exception) {
                    if (null == iWarningListener) break block66;
                    iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "AllowAllHostNames", variant.getString(), "0 or 1"}));
                }
            }
            if (1 == n) {
                sSLSettings2.m_certNamesMismatch = true;
                sSLSettings2.m_certNamesMismatchSpecifiedByUser = true;
            } else if (0 == n) {
                sSLSettings2.m_certNamesMismatch = false;
                sSLSettings2.m_certNamesMismatchSpecifiedByUser = true;
            }
        } else if (null != sSLSettings) {
            sSLSettings2.m_certNamesMismatch = sSLSettings.m_certNamesMismatch;
        }
        sSLSettings2.m_hostNameInSAN = true;
        variant = connSettingRequestMap.getProperty(string + "SubjectAlternativeNamesHostNames");
        n = -1;
        if (variant != null) {
            try {
                n = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "SubjectAlternativeNamesHostNames", variant.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
            if (0 == n) {
                sSLSettings2.m_hostNameInSAN = false;
            } else if (1 == n) {
                sSLSettings2.m_hostNameInSAN = true;
            }
        } else if (null != sSLSettings) {
            sSLSettings2.m_hostNameInSAN = sSLSettings.m_hostNameInSAN;
        }
        variant = connSettingRequestMap.getProperty(string + "SSLTrustStoreType");
        if (null != variant) {
            sSLSettings2.m_sslTrustStoreType = variant.getString();
        } else if (null != sSLSettings) {
            sSLSettings2.m_sslTrustStoreType = sSLSettings.m_sslTrustStoreType;
        }
        variant = connSettingRequestMap.getProperty(string + "SSLTrustStoreProvider");
        if (null != variant) {
            sSLSettings2.m_sslTrustStoreProvider = variant.getString();
        } else if (null != sSLSettings) {
            sSLSettings2.m_sslTrustStoreProvider = sSLSettings.m_sslTrustStoreProvider;
        }
        variant = connSettingRequestMap.getProperty(string + "SSLKeyStoreType");
        if (null != variant) {
            sSLSettings2.m_sslKeyStoreType = variant.getString();
        } else if (null != sSLSettings) {
            sSLSettings2.m_sslKeyStoreType = sSLSettings.m_sslKeyStoreType;
        }
        variant = connSettingRequestMap.getProperty(string + "SSLKeyStoreProvider");
        if (null != variant) {
            sSLSettings2.m_sslKeyStoreProvider = variant.getString();
        } else if (null != sSLSettings) {
            sSLSettings2.m_sslKeyStoreProvider = sSLSettings.m_sslKeyStoreProvider;
        }
    }

    public static void readProxySettings(ConnSettingRequestMap connSettingRequestMap, ProxySettings proxySettings) throws ErrorException {
        Variant variant = connSettingRequestMap.getProperty("UseProxy");
        if (null != variant) {
            try {
                int n = variant.getInt();
                if (1 != n && 0 != n) {
                    throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"UseProxy", variant.getString(), "0/1"});
                }
                proxySettings.m_useProxy = 1 == n;
            }
            catch (Exception exception) {
                throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"UseProxy", variant.getString(), "0/1"});
            }
            if (proxySettings.m_useProxy) {
                variant = connSettingRequestMap.getProperty("ProxyType");
                if (null != variant) {
                    String string = variant.getString();
                    if (string.equals("0") || string.equalsIgnoreCase("HTTP Proxy")) {
                        proxySettings.m_proxyType = ProxySettings.ProxyType.DS_PT_HTTP;
                    } else if (string.equals("1") || string.equalsIgnoreCase("SOCKS Proxy")) {
                        proxySettings.m_proxyType = ProxySettings.ProxyType.DS_PT_SOCKS;
                    } else {
                        throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ProxyType", variant.getString(), "0/HTTP Proxy or 1/SOCKS Proxy"});
                    }
                }
                if (proxySettings.m_proxyType.equals((Object)ProxySettings.ProxyType.DS_PT_HTTP)) {
                    variant = connSettingRequestMap.getProperty("ProxyHost");
                    Variant variant2 = connSettingRequestMap.getProperty("ProxyPort");
                    if (null != variant && null != variant2) {
                        proxySettings.m_proxyHost = variant.getString();
                        try {
                            proxySettings.m_proxyPort = variant2.getInt();
                        }
                        catch (Exception exception) {
                            throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ProxyPort", variant2.getString(), "Integers"});
                        }
                    } else {
                        throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_USE_PROXY_ERR.name());
                    }
                    variant = connSettingRequestMap.getProperty("ProxyAuth");
                    if (null != variant) {
                        String string = variant.getString().toUpperCase();
                        if (string.equals("0") || string.equals("NONE")) {
                            proxySettings.m_proxyAuth = ProxySettings.ProxyAuthentication.NONE;
                        } else if (string.equals("1") || string.equals("BASIC")) {
                            proxySettings.m_proxyAuth = ProxySettings.ProxyAuthentication.BASIC;
                        } else {
                            throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ProxyAuth", variant.getString(), "0/NONE or 1/BASIC"});
                        }
                    }
                    if (proxySettings.m_proxyAuth.equals((Object)ProxySettings.ProxyAuthentication.BASIC)) {
                        variant = connSettingRequestMap.getProperty("ProxyUid");
                        variant2 = connSettingRequestMap.getProperty("ProxyPwd");
                        if (null != variant && null != variant2) {
                            proxySettings.m_proxyUid = variant.getString();
                            proxySettings.m_proxyPwd = variant2.getString();
                        } else {
                            throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_PROXY_AUTH_ERR.name());
                        }
                    }
                }
            }
        }
    }
}

