/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.querytranslation.hql;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;

public class SelectListAnalyzer
extends AEDefaultVisitor<Void> {
    private ArrayList<AETable> m_tables = new ArrayList();
    private int m_numColumns;
    private boolean m_canReplaceListWithStar = true;

    public SelectListAnalyzer(AEProject aEProject) throws ErrorException {
        aEProject.acceptVisitor(this);
    }

    @Override
    public Void visit(AEValueExprList aEValueExprList) throws ErrorException {
        this.visitChildren(aEValueExprList);
        return null;
    }

    @Override
    public Void visit(AEProject aEProject) throws ErrorException {
        Iterator<IAENode> iterator = aEProject.getChildItr();
        iterator.next().acceptVisitor(this);
        if (this.m_numColumns != aEProject.getColumnCount()) {
            this.m_canReplaceListWithStar = false;
            return null;
        }
        int n = 0;
        for (AETable aETable : this.m_tables) {
            String string = aETable.getBaseTableName();
            String string2 = aETable.getSchemaName();
            for (int i = 0; i < aETable.getColumnCount(); ++i) {
                IColumn iColumn = aETable.getBaseColumn(i);
                IColumn iColumn2 = aEProject.getColumn(n++);
                if (iColumn.getName().equalsIgnoreCase(iColumn2.getName()) && string.equalsIgnoreCase(iColumn2.getTableName()) && this.hasMatchingSchemaName(iColumn.getSchemaName(), string2)) continue;
                this.m_canReplaceListWithStar = false;
                return null;
            }
        }
        return null;
    }

    @Override
    public Void visit(AECrossJoin aECrossJoin) throws ErrorException {
        this.visitChildren(aECrossJoin);
        return null;
    }

    @Override
    public Void visit(AEJoin aEJoin) throws ErrorException {
        Iterator<IAENode> iterator = aEJoin.getChildItr();
        iterator.next().acceptVisitor(this);
        iterator.next().acceptVisitor(this);
        return null;
    }

    @Override
    public Void visit(AETable aETable) throws ErrorException {
        this.m_tables.add(aETable);
        this.m_numColumns += aETable.getColumnCount();
        return null;
    }

    @Override
    public Void defaultVisit(IAENode iAENode) throws ErrorException {
        this.m_canReplaceListWithStar = false;
        return null;
    }

    public boolean canReplaceListWithStar() {
        return this.m_canReplaceListWithStar;
    }

    private boolean hasMatchingSchemaName(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if (string.length() == 0 && string2.equalsIgnoreCase("default")) {
            return true;
        }
        return string2.length() == 0 && string.equalsIgnoreCase("default");
    }

    private void visitChildren(IAENode iAENode) throws ErrorException {
        Iterator<? extends IAENode> iterator = iAENode.getChildItr();
        while (iterator.hasNext()) {
            iterator.next().acceptVisitor(this);
        }
    }
}

