/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.querytranslation.hql;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionContexts;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.IServerVersion;
import com.cloudera.impala.hivecommon.IServerVersionUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.querytranslation.IQueryTranslator;
import com.cloudera.impala.hivecommon.querytranslation.hql.HiveQLAENodeVisitor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;

public class HiveQueryTranslator
implements IQueryTranslator {
    @Override
    public String translate(AEStatements aEStatements, ExecutionContexts executionContexts, SqlQueryExecutor sqlQueryExecutor, IServerVersionUtils iServerVersionUtils, IServerVersion iServerVersion, HiveJDBCSettings hiveJDBCSettings, ArrayList<ColumnMetadata> arrayList) throws ErrorException {
        Iterator<IAEStatement> iterator = aEStatements.getStatementItr();
        if (!iterator.hasNext()) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), "translation error");
            throw errorException;
        }
        return this.translate(iterator.next(), executionContexts, sqlQueryExecutor, iServerVersionUtils, iServerVersion, hiveJDBCSettings, arrayList);
    }

    public String translate(IAEStatement iAEStatement, ExecutionContexts executionContexts, SqlQueryExecutor sqlQueryExecutor, IServerVersionUtils iServerVersionUtils, IServerVersion iServerVersion, HiveJDBCSettings hiveJDBCSettings, ArrayList<ColumnMetadata> arrayList) throws ErrorException {
        String string;
        Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
        if (!iterator.hasNext()) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), "translation error");
            throw errorException;
        }
        if (iAEStatement instanceof AEQuery) {
            AEQuery aEQuery = (AEQuery)iAEStatement;
            HiveQLAENodeVisitor hiveQLAENodeVisitor = new HiveQLAENodeVisitor(iterator.next(), sqlQueryExecutor, iServerVersionUtils, iServerVersion, hiveJDBCSettings);
            string = aEQuery.acceptVisitor(hiveQLAENodeVisitor);
            ArrayList<IColumn> arrayList2 = ((AEQuery)iAEStatement).createResultSetColumns();
            if (null != arrayList2) {
                for (IColumn iColumn : arrayList2) {
                    arrayList.add(ColumnMetadata.copyOf(iColumn));
                }
            }
        } else if (iAEStatement instanceof AEInsert) {
            AEInsert aEInsert = (AEInsert)iAEStatement;
            HiveQLAENodeVisitor hiveQLAENodeVisitor = executionContexts.getCount() > 1 && iServerVersionUtils.supportsDMLstatement(iServerVersion) ? new HiveQLAENodeVisitor(executionContexts, sqlQueryExecutor, iServerVersionUtils, iServerVersion) : new HiveQLAENodeVisitor(iterator.next(), sqlQueryExecutor, iServerVersionUtils, iServerVersion, hiveJDBCSettings);
            string = aEInsert.acceptVisitor(hiveQLAENodeVisitor);
        } else if (iAEStatement instanceof AEDelete && iServerVersionUtils.supportsDMLstatement(iServerVersion)) {
            AEDelete aEDelete = (AEDelete)iAEStatement;
            HiveQLAENodeVisitor hiveQLAENodeVisitor = new HiveQLAENodeVisitor(iterator.next(), sqlQueryExecutor, iServerVersionUtils, iServerVersion, hiveJDBCSettings);
            string = aEDelete.acceptVisitor(hiveQLAENodeVisitor);
        } else if (iAEStatement instanceof AEUpdate && iServerVersionUtils.supportsDMLstatement(iServerVersion)) {
            AEUpdate aEUpdate = (AEUpdate)iAEStatement;
            HiveQLAENodeVisitor hiveQLAENodeVisitor = new HiveQLAENodeVisitor(iterator.next(), sqlQueryExecutor, iServerVersionUtils, iServerVersion, hiveJDBCSettings);
            string = aEUpdate.acceptVisitor(hiveQLAENodeVisitor);
        } else {
            throw new ErrorException("error", "Statement type is not supported.", 0);
        }
        return string;
    }
}

