/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.jdbc42;

import com.cloudera.impala.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.impala.hivecommon.core.HiveJDBCStatement;
import com.cloudera.impala.hivecommon.core.IHadoopStatement;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCDSIExtQueryExecutor;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.impala.hivecommon.jdbc42.Hive42ForwardResultSet;
import com.cloudera.impala.jdbc.common.SConnection;
import com.cloudera.impala.jdbc.common.SStatement;
import com.cloudera.impala.jdbc.jdbc42.S42Statement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Hive42Statement
extends S42Statement
implements IHadoopStatement {
    public Hive42Statement(HiveJDBCStatement hiveJDBCStatement, SConnection sConnection, int n) {
        super(hiveJDBCStatement, sConnection, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        super.cancel();
        Object object = this.m_cancelLock;
        synchronized (object) {
            if (this.m_statement instanceof HiveJDBCStatement && this.m_isInCancelableFunction) {
                ((HiveJDBCStatement)this.m_statement).cancel();
            }
        }
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        if (this.m_statement instanceof HiveJDBCStatement) {
            ((HiveJDBCStatement)this.m_statement).setExecuteMethodType(HiveJDBCStatement.ExecuteMethodType.EXECUTE);
        }
        return super.execute(string);
    }

    @Override
    public synchronized long executeAnyUpdate(String string) throws SQLException {
        if (this.m_statement instanceof HiveJDBCStatement) {
            ((HiveJDBCStatement)this.m_statement).setExecuteMethodType(HiveJDBCStatement.ExecuteMethodType.EXECUTE_UPDATE);
        }
        return super.executeAnyUpdate(string);
    }

    @Override
    public synchronized ResultSet executeAsync(String string) throws SQLException {
        this.setAsyncExecution(true);
        return super.executeQuery(string);
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.setAsyncExecution(false);
        if (this.m_statement instanceof HiveJDBCStatement) {
            ((HiveJDBCStatement)this.m_statement).setExecuteMethodType(HiveJDBCStatement.ExecuteMethodType.EXECUTE_QUERY);
        }
        return super.executeQuery(string);
    }

    public boolean getAsyncExecution() {
        return ((HiveJDBCStatement)this.m_statement).getAsyncExecution();
    }

    public void setAsyncExecution(boolean bl) {
        ((HiveJDBCStatement)this.m_statement).setAsyncExecution(bl);
    }

    @Override
    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        ResultSet resultSet = null;
        if (this.getAsyncExecution() && executionResult.getResult() instanceof HiveJDBCResultSet) {
            resultSet = new Hive42ForwardResultSet((SStatement)this, (HiveJDBCResultSet)executionResult.getResult(), this.m_logger);
            resultSet.setFetchSize(this.getFetchSize());
        } else {
            resultSet = super.createResultSet(executionResult);
        }
        return resultSet;
    }

    @Override
    public String getYarnATSGuid() {
        if (null != this.m_queryExecutor && this.m_queryExecutor instanceof HiveJDBCDSIExtQueryExecutor) {
            return ((HiveJDBCDSIExtQueryExecutor)this.m_queryExecutor).getYarnATSGuid();
        }
        return null;
    }
}

