/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine.metadata;

import com.cloudera.impala.dsi.dataengine.filters.IFilter;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.core.CoreUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.dataengine.filters.HiveJDBCFilter;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveCommonColumnMetadata;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveCommonTablesMetadataSourceRow;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCExceptionUtils;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.DiagState;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MetadataUtils {
    public static int CATALOG_PATTERN_IDX = 0;
    public static int SCHEMA_PATTERN_IDX = 1;
    public static int TABLE_PATTERN_IDX = 2;
    public static int COLUMN_PATTERN_IDX = 3;
    public static final char[] CATALOG_FUNC_WILDCARD_CHARS = new char[]{'_', '%'};
    public static final char CATALOG_FUNC_ESCAPE_CHAR = '\\';

    public static boolean checkForCommunicationLinkFailure(Exception exception) {
        return exception instanceof ErrorException && ((ErrorException)exception).getDiagState() == DiagState.DIAG_COMM_LINK_FAILURE;
    }

    public static String EscapeWildCard(String string, char[] cArray, char c) {
        if (null == string || 0 == string.length() || null == cArray || 0 == cArray.length) {
            return string;
        }
        int n = string.length();
        boolean bl = false;
        String string2 = "";
        for (int i = 0; n > i; ++i) {
            char c2 = string.charAt(i);
            if (!bl) {
                if (c2 == c) {
                    bl = true;
                } else {
                    for (char c3 : cArray) {
                        if (c2 != c3) continue;
                        string2 = string2 + c;
                        break;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
            string2 = string2 + c2;
        }
        return string2;
    }

    public static List<HiveCommonColumnMetadata> GetColumns(String string, Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, ArrayList<IFilter> arrayList2, IHiveClient<?> iHiveClient, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        Object object;
        if (!string.equals(hiveJDBCSettings.m_platformCatalog)) {
            return new ArrayList<HiveCommonColumnMetadata>();
        }
        ArrayList<HiveCommonColumnMetadata> arrayList3 = null;
        if (hiveJDBCSettings.m_pushdownCatalogFunctionFilters) {
            try {
                arrayList3 = iHiveClient.getColumns(map, arrayList);
            }
            catch (Exception exception) {
                if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                    throw (ErrorException)exception;
                }
                if (hiveJDBCSettings.m_enableIsQualifierTypeReturnedTesting) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.TYPE_QUALIFIER_SIZE_ERROR.name(), "Qualified Type Names Error");
                    throw errorException;
                }
                CoreUtils.postWarning(exception, iHiveClient.getWarningListener(), WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage());
                HiveJDBCExceptionUtils.logException(exception, iHiveClient.getLogger());
            }
        }
        if (null != arrayList3) {
            return arrayList3;
        }
        arrayList3 = new ArrayList();
        String string2 = MetadataUtils.UnescapeWildCards(MetadataUtils.GetRestriction(map, MetadataSourceColumnTag.SCHEMA_NAME));
        String string3 = MetadataUtils.UnescapeWildCards(MetadataUtils.GetRestriction(map, MetadataSourceColumnTag.TABLE_NAME));
        if (null != string2 && string2.contains("\\") || null != string3 && string3.contains("\\")) {
            return arrayList3;
        }
        if (hiveJDBCSettings.m_pushdownCatalogFunctionFilters && null != (object = iHiveClient.getTables(map, arrayList))) {
            Iterator<HiveCommonTablesMetadataSourceRow> iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                HiveCommonTablesMetadataSourceRow hiveCommonTablesMetadataSourceRow = iterator.next();
                arrayList3.addAll(iHiveClient.getColumns(hiveCommonTablesMetadataSourceRow.getSchemaName(), hiveCommonTablesMetadataSourceRow.getTableName()));
            }
            return arrayList3;
        }
        object = null;
        HiveJDBCFilter hiveJDBCFilter = null;
        for (IFilter object2 : arrayList2) {
            switch (object2.getColumnTag()) {
                case SCHEMA_NAME: {
                    object = new HiveJDBCFilter(object2);
                    break;
                }
                case TABLE_NAME: {
                    hiveJDBCFilter = new HiveJDBCFilter(object2);
                    break;
                }
            }
        }
        if (!hiveJDBCSettings.m_pushdownCatalogFunctionFilters || null == string2) {
            Iterator<HiveCommonTablesMetadataSourceRow> iterator2 = new ArrayList();
            if (null != string2) {
                ((ArrayList)((Object)iterator2)).add((HiveCommonTablesMetadataSourceRow)((Object)string2));
            } else {
                ((ArrayList)((Object)iterator2)).addAll(iHiveClient.getSchemas());
            }
            ArrayList<String> arrayList4 = new ArrayList<String>();
            if (null != object) {
                Iterator iterator = ((ArrayList)((Object)iterator2)).iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (!((HiveJDBCFilter)object).filter(string4)) continue;
                    arrayList4.add(string4);
                }
            }
            for (String string4 : arrayList4) {
                if (!hiveJDBCSettings.m_pushdownCatalogFunctionFilters || null == string3) {
                    for (HiveCommonTablesMetadataSourceRow hiveCommonTablesMetadataSourceRow : iHiveClient.getTables(string4)) {
                        if (null != hiveJDBCFilter && !hiveJDBCFilter.filter(hiveCommonTablesMetadataSourceRow.getTableName())) continue;
                        arrayList3.addAll(iHiveClient.getColumns(string4, hiveCommonTablesMetadataSourceRow.getTableName()));
                    }
                    continue;
                }
                arrayList3.addAll(iHiveClient.getColumns(string4, string3));
            }
        } else if (string3 == null) {
            for (HiveCommonTablesMetadataSourceRow hiveCommonTablesMetadataSourceRow : iHiveClient.getTables(string2)) {
                if (null != hiveJDBCFilter && !hiveJDBCFilter.filter(hiveCommonTablesMetadataSourceRow.getTableName())) continue;
                arrayList3.addAll(iHiveClient.getColumns(string2, hiveCommonTablesMetadataSourceRow.getTableName()));
            }
        } else {
            arrayList3 = iHiveClient.getColumns(string2, string3);
        }
        return arrayList3;
    }

    public static String GetRestriction(Map<MetadataSourceColumnTag, String> map, MetadataSourceColumnTag metadataSourceColumnTag) {
        String string = "";
        if (map != null) {
            string = map.get((Object)metadataSourceColumnTag);
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    public static int getBufferSize(HiveCommonColumnMetadata hiveCommonColumnMetadata, IHiveClient<?> iHiveClient) {
        TypeMetadata typeMetadata = hiveCommonColumnMetadata.getTypeMetadata();
        if (typeMetadata.getTypeName().contains("ARRAY<") || typeMetadata.getTypeName().contains("STRUCT<") || typeMetadata.getTypeName().contains("MAP<") || typeMetadata.getTypeName().contains("UNIONTYPE<")) {
            return iHiveClient.getStringColumnSize();
        }
        if (typeMetadata.getTypeName().contains("CHAR") && typeMetadata.getType() == Integer.valueOf(1).shortValue()) {
            if (typeMetadata.getTypeName().contains("(")) {
                String string = typeMetadata.getTypeName();
                int n = Integer.parseInt(string.substring(string.indexOf(40) + 1, string.indexOf(41)).trim());
                return n;
            }
            int n = (int)hiveCommonColumnMetadata.getColumnLength();
            return n;
        }
        if (typeMetadata.getTypeName().contains("VARCHAR") && typeMetadata.getType() == Integer.valueOf(12).shortValue()) {
            if (typeMetadata.getTypeName().contains("(")) {
                String string = typeMetadata.getTypeName();
                int n = Integer.parseInt(string.substring(string.indexOf(40) + 1, string.indexOf(41)).trim());
                return n;
            }
            int n = (int)hiveCommonColumnMetadata.getColumnLength();
            return n;
        }
        if (typeMetadata.getTypeName().contains("DECIMAL(")) {
            String string = typeMetadata.getTypeName();
            int n = Integer.parseInt(string.substring(string.indexOf(40) + 1, string.indexOf(44)).trim());
            return n;
        }
        if (typeMetadata.getTypeName().contains("STRING")) {
            return iHiveClient.getStringColumnSize();
        }
        if (typeMetadata.getTypeName().contains("BINARY")) {
            return iHiveClient.getBinaryColumnSize();
        }
        return TypeUtilities.getSizeInBytes(typeMetadata.getType());
    }

    public static short getNumPrecRadix(TypeMetadata typeMetadata) {
        if (TypeUtilities.isNumberType(typeMetadata.getType())) {
            return 10;
        }
        return 0;
    }

    public static String UnescapeWildCards(String string) {
        if (null != string) {
            string = string.replaceAll("\\\\_", "_");
            string = string.replaceAll("\\\\%", "%");
        }
        return string;
    }
}

