/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine.metadata;

import com.cloudera.impala.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.impala.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;

public class HiveJDBCCatalogOnlyMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private boolean m_hasStartedFetch = false;
    private final IHiveClient<?> m_hiveClient;
    private String m_currentCatalog;

    public HiveJDBCCatalogOnlyMetadataSource(ILogger iLogger, IHiveClient iHiveClient) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_hiveClient = iHiveClient;
        this.m_currentCatalog = null;
        this.initCatalog();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentCatalog, dataWrapper, l, l2);
            }
        }
        throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return !this.m_hasStartedFetch;
    }

    private void initCatalog() throws ErrorException {
        if (this.m_currentCatalog == null) {
            try {
                this.m_currentCatalog = this.m_hiveClient.getCatalogs().get(0);
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_CATALOG_ERR.name(), "Metadata Initialization Error");
                errorException.initCause(exception);
                throw errorException;
            }
        }
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_hasStartedFetch) {
            return false;
        }
        this.m_hasStartedFetch = true;
        return true;
    }
}

