/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.core;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.dsi.core.impl.DSILogger;
import com.cloudera.impala.dsi.core.interfaces.IEnvironment;
import com.cloudera.impala.dsi.core.interfaces.IStatement;
import com.cloudera.impala.dsi.core.utilities.ClientInfoData;
import com.cloudera.impala.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.impala.dsi.core.utilities.ConnSettingResponseMap;
import com.cloudera.impala.dsi.core.utilities.Variant;
import com.cloudera.impala.dsi.exceptions.BadAuthException;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;
import com.cloudera.impala.hivecommon.AuthMech;
import com.cloudera.impala.hivecommon.BrandingPreferences;
import com.cloudera.impala.hivecommon.HiveJDBCCasePreservingAlias;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.HiveServerType;
import com.cloudera.impala.hivecommon.IServerVersion;
import com.cloudera.impala.hivecommon.KrbAuthType;
import com.cloudera.impala.hivecommon.ServiceDiscoveryMode;
import com.cloudera.impala.hivecommon.TransportMode;
import com.cloudera.impala.hivecommon.api.HS2Client;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.api.IHiveClientFactory;
import com.cloudera.impala.hivecommon.api.SSOSAMLSettings;
import com.cloudera.impala.hivecommon.api.TEHTTPSettings;
import com.cloudera.impala.hivecommon.api.ZookeeperSettings;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.core.HiveJDBCStatement;
import com.cloudera.impala.hivecommon.core.ThreadPoolExecutorExt;
import com.cloudera.impala.hivecommon.dataengine.IHiveCustomScalarFnFactory;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.utils.HiveCommonConnectionUtils;
import com.cloudera.impala.hivecommon.utils.HiveCommonGSSCredentialMap;
import com.cloudera.impala.jdbc.common.CommonCoreUtils;
import com.cloudera.impala.jdbc.common.CustomNetworkHooksSettings;
import com.cloudera.impala.jdbc.common.OAuthFlow;
import com.cloudera.impala.jdbc.common.OAuthSettings;
import com.cloudera.impala.jdbc.common.ProductInfoHandler;
import com.cloudera.impala.jdbc.common.ProxySettings;
import com.cloudera.impala.jdbc.common.SSLSettings;
import com.cloudera.impala.jdbc.core.DSConnectionUtils;
import com.cloudera.impala.jdbc.core.LoginTimeoutConnection;
import com.cloudera.impala.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.impala.jdbc.utils.ParseQueryUtils;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TProtocolVersion;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogLevel;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.Warning;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.ClientInfoException;
import com.cloudera.impala.support.exceptions.DiagState;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class HiveJDBCCommonConnection
extends LoginTimeoutConnection {
    private static final String MASKED_FIELD_VAL = "****";
    private static final String NO_PROP_KEY_PREFIX = "";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private static final String AOSS_PREFIX = "AOSS_";
    private static final int DEFAULT_ARROW_FETCH_MAX_BYTES = 10000000;
    private static final int JDK_8_MAJOR_VER = 8;
    protected static int s_connectionID = 0;
    protected static Object s_loggerLock = new Object();
    protected ILogger m_log;
    protected HiveJDBCSettings m_settings;
    protected IHiveClient m_hiveClient;
    private ExecutorService m_threadPool;
    private ConnSettingRequestMap m_requestMap;
    private boolean m_authMechSpecifiedByUser = false;
    private boolean m_transportModeSpecifiedByUser = false;
    private boolean m_useSasl = true;
    protected Map<String, Boolean> m_definedSettings = new TreeMap<String, Boolean>(String.CASE_INSENSITIVE_ORDER);
    protected IHiveClientFactory m_factory;

    protected HiveJDBCCommonConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
        this.setDefaultProperties();
        this.m_threadPool = new ThreadPoolExecutorExt(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.m_factory = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getClientFactory();
    }

    public void cancelDelegationToken(String string) throws ErrorException {
        if (this.m_hiveClient instanceof HS2Client) {
            try {
                ((HS2Client)this.m_hiveClient).cancelDelegationToken(string);
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CANCEL_DELEGATION_TOKEN_ERR.name(), new String[]{exception.getMessage(), string});
                errorException.initCause(exception);
                throw errorException;
            }
        } else {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), "cancelDelegationToken");
            throw errorException;
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_threadPool.shutdown();
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new HiveJDBCStatement(this, this.m_requestMap);
    }

    @Override
    public void disconnect() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_hiveClient) {
            this.m_hiveClient.closeSession();
        }
    }

    @Override
    public void establishConnection(ConnSettingRequestMap connSettingRequestMap, int n) throws ErrorException, BadAuthException {
        Object object;
        Object object2;
        Variant variant;
        Variant variant2;
        block183: {
            block182: {
                Object object3;
                block181: {
                    block180: {
                        block179: {
                            block178: {
                                block177: {
                                    block176: {
                                        block175: {
                                            block174: {
                                                block173: {
                                                    connSettingRequestMap.setHiddenKey("Auth_AccessToken");
                                                    CommonCoreUtils.logConnectionFunctionEntrance(this.getConnectionLog(), connSettingRequestMap, 2, 6, 23, 1028);
                                                    this.m_requestMap = connSettingRequestMap;
                                                    this.m_settings = new HiveJDBCSettings();
                                                    this.m_settings.m_thriftHTTPSettings = new TEHTTPSettings();
                                                    this.m_settings.m_zookeeperSettings = new ZookeeperSettings();
                                                    this.m_settings.m_ssoSamlSettings = new SSOSAMLSettings();
                                                    this.m_settings.m_enableArrow = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).supportsArrowSerialization();
                                                    this.m_settings.m_arrowMaxBytesPerFetch = 0;
                                                    this.m_settings.m_arrowTimestampAsString = true;
                                                    this.setImplementationDefaultSettings();
                                                    this.setSupportedHttpRetryType();
                                                    this.m_definedSettings.put("Host", true);
                                                    this.m_settings.m_connDBType = this.getRequiredSetting("DatabaseType", connSettingRequestMap).getString();
                                                    this.m_definedSettings.put("DatabaseType", true);
                                                    this.m_settings.m_port = 10000;
                                                    this.m_settings.m_isConnAlive = false;
                                                    this.m_settings.m_timeout = 0;
                                                    this.m_settings.m_rowsFetchedPerBlock = 10000;
                                                    this.m_settings.m_stringColumnSize = (short)255;
                                                    this.m_settings.m_binaryColumnSize = Short.MAX_VALUE;
                                                    this.m_settings.m_asyncExecPollInterval = 10;
                                                    this.m_settings.m_authMech = AuthMech.NOAUTH;
                                                    this.m_settings.m_useNativeQuery = false;
                                                    this.m_settings.m_decimalColumnScale = (short)10;
                                                    this.m_settings.m_switchCataANDSchema = BrandingPreferences.defaultCatalogSchemaSwitch;
                                                    this.m_settings.m_preparedStmtGetMetadataLimitZero = true;
                                                    this.m_settings.m_columnNameAliaseCase = HiveJDBCCasePreservingAlias.SERVER_DETERMINED;
                                                    this.m_settings.m_pushdownCatalogFunctionFilters = true;
                                                    this.validateLicenseFile();
                                                    this.m_settings.m_optimizedInsert = false;
                                                    this.m_definedSettings.put("OptimizedInsert", true);
                                                    this.m_settings.m_stripCatalogName = true;
                                                    this.m_settings.m_supportTimeOnlyTimestamp = false;
                                                    this.m_settings.m_upperCaseResultSetColName = false;
                                                    this.m_settings.m_automaticColumnRename = false;
                                                    this.m_settings.m_tableNameColIndex = 0;
                                                    this.m_settings.m_isTemporaryColIndex = 1;
                                                    this.m_settings.m_fetchEndWaitTime = 5L;
                                                    this.m_settings.m_protocolVersion = TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1;
                                                    this.m_settings.m_nonSSPs = new ArrayList<String>();
                                                    this.m_settings.m_nonSSPs.add("driver");
                                                    this.m_settings.m_nonSSPs.add("url");
                                                    this.m_settings.m_nonSSPs.add("http.header.");
                                                    this.m_settings.m_setFetchSizeTakesPrecedence = true;
                                                    this.m_settings.m_enableSetFetchSizeTesting = false;
                                                    this.m_settings.m_expectedFetchSize = 0;
                                                    this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion("AUTO", this.m_log);
                                                    variant2 = this.getOptionalSetting("ServerVersion", connSettingRequestMap);
                                                    this.m_definedSettings.put("ServerVersion", true);
                                                    if (variant2 != null) {
                                                        try {
                                                            IServerVersion iServerVersion;
                                                            this.m_settings.m_strServerVersion = variant2.getString();
                                                            this.m_settings.m_serverVersion = iServerVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(variant2.getString(), this.m_log);
                                                        }
                                                        catch (Exception exception) {
                                                            if (null == this.getWarningListener()) break block173;
                                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant2.getString(), "ServerVersion"}));
                                                        }
                                                    }
                                                }
                                                this.m_settings.m_fastConnect = false;
                                                variant2 = this.getOptionalSetting("FastConnection", connSettingRequestMap);
                                                this.m_definedSettings.put("FastConnection", true);
                                                if (variant2 != null) {
                                                    try {
                                                        boolean bl;
                                                        this.m_settings.m_fastConnect = bl = variant2.getInt() == 1;
                                                    }
                                                    catch (Exception exception) {
                                                        if (null == this.getWarningListener()) break block174;
                                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant2.getString(), "FastConnection", "0, 1"}));
                                                    }
                                                }
                                            }
                                            variant2 = this.getOptionalSetting("transportMode", connSettingRequestMap);
                                            this.m_definedSettings.put("transportMode", true);
                                            if (variant2 != null) {
                                                try {
                                                    String string = variant2.getString();
                                                    this.m_transportModeSpecifiedByUser = true;
                                                    if (string.equalsIgnoreCase("http")) {
                                                        this.m_settings.m_transportMode = TransportMode.HTTP;
                                                    } else if (string.equalsIgnoreCase("binary")) {
                                                        this.m_settings.m_transportMode = TransportMode.BINARY;
                                                    } else if (string.equalsIgnoreCase("sasl")) {
                                                        this.m_settings.m_transportMode = TransportMode.SASL;
                                                    } else {
                                                        this.m_settings.m_transportMode = TransportMode.SASL;
                                                        this.m_transportModeSpecifiedByUser = false;
                                                        if (null != this.getWarningListener()) {
                                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_TRANSPORT_MODE_ERROR.name(), new String[]{variant2.getString()}));
                                                        }
                                                    }
                                                    break block175;
                                                }
                                                catch (Exception exception) {
                                                    this.m_settings.m_transportMode = this.m_settings.m_transportMode = TransportMode.SASL;
                                                    this.m_transportModeSpecifiedByUser = false;
                                                    if (null != this.getWarningListener()) {
                                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_TRANSPORT_MODE_ERROR.name(), new String[]{variant2.getString()}));
                                                    }
                                                    break block175;
                                                }
                                            }
                                            this.m_settings.m_transportMode = TransportMode.SASL;
                                        }
                                        if (TransportMode.HTTP == this.m_settings.m_transportMode) {
                                            variant2 = this.getOptionalSetting("httpPath", connSettingRequestMap);
                                            this.m_definedSettings.put("httpPath", true);
                                            if (variant2 != null) {
                                                this.m_settings.m_httpPath = variant2.getString();
                                            }
                                            variant2 = this.getOptionalSetting("UseLegacyUserAgent", connSettingRequestMap);
                                            this.m_definedSettings.put("UseLegacyUserAgent", true);
                                            if (variant2 != null) {
                                                this.m_settings.m_thriftHTTPSettings.setLegacyUserAgent();
                                            } else {
                                                variant2 = this.getOptionalSetting("UserAgentEntry", connSettingRequestMap);
                                                this.m_definedSettings.put("UserAgentEntry", true);
                                                if (null != variant2) {
                                                    this.m_settings.m_thriftHTTPSettings.setUserAgentEntry(variant2);
                                                }
                                            }
                                            this.m_settings.m_thriftHTTPSettings.m_enableSessionTag = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableThriftSessionTag", this.m_settings.m_thriftHTTPSettings.m_enableSessionTag, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
                                            this.setCustomHTTPHeaders(connSettingRequestMap);
                                        }
                                        Variant variant3 = this.getOptionalSetting("Host", connSettingRequestMap);
                                        Variant variant4 = this.getOptionalSetting("ServiceDiscoveryMode", connSettingRequestMap);
                                        String string = null;
                                        if (null != variant4) {
                                            string = variant4.getString();
                                        }
                                        if (null != string && string.equalsIgnoreCase(ServiceDiscoveryMode.NO_SERVICE_DISCOVERY.name())) {
                                            variant3 = this.getRequiredSetting("Host", connSettingRequestMap);
                                            this.setNoServiceDiscovery(connSettingRequestMap, variant3);
                                        } else {
                                            Variant variant5 = this.getOptionalSetting("AOSSStatusEndpoints", connSettingRequestMap);
                                            object3 = this.getOptionalSetting("zk", connSettingRequestMap);
                                            if ((null != object3 || null != string && ServiceDiscoveryMode.ZOOKEEPER.name().equalsIgnoreCase(string)) && this.m_factory.supportServiceDiscoveryMode(ServiceDiscoveryMode.ZOOKEEPER, this.getConnectionLog())) {
                                                this.setZookeeperServiceDiscovery(connSettingRequestMap, (Variant)object3);
                                            } else if ((null != variant5 || null != string && ServiceDiscoveryMode.AOSS.name().equalsIgnoreCase(string)) && this.m_factory.supportServiceDiscoveryMode(ServiceDiscoveryMode.AOSS, this.getConnectionLog())) {
                                                this.setAOSSServiceDiscovery(connSettingRequestMap, variant5);
                                            } else {
                                                variant3 = this.getRequiredSetting("Host", connSettingRequestMap);
                                                this.setNoServiceDiscovery(connSettingRequestMap, variant3);
                                            }
                                            this.m_definedSettings.put("HiveServerType", true);
                                        }
                                        variant2 = this.getOptionalSetting("AuthMech", connSettingRequestMap);
                                        this.m_definedSettings.put("AuthMech", true);
                                        if (variant2 != null) {
                                            try {
                                                int n2 = variant2.getInt();
                                                object3 = AuthMech.getAuthMech(n2);
                                                if (null != object3) {
                                                    this.m_settings.m_authMech = object3;
                                                    this.m_authMechSpecifiedByUser = true;
                                                    this.rectifyAuthMech(this.m_settings);
                                                }
                                                break block176;
                                            }
                                            catch (Exception exception) {
                                                if (exception instanceof ErrorException) {
                                                    throw (ErrorException)exception;
                                                }
                                                this.m_settings.m_authMech = this.m_settings.m_platformVersionUtils.resolveDefaultAuthMech(this.m_settings);
                                                this.m_authMechSpecifiedByUser = false;
                                                if (null != this.getWarningListener()) {
                                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
                                                }
                                                break block176;
                                            }
                                        }
                                        this.m_settings.m_authMech = this.m_settings.m_platformVersionUtils.resolveDefaultAuthMech(this.m_settings);
                                        this.m_authMechSpecifiedByUser = false;
                                        LogUtilities.logInfo("Auth Mech is set to default: " + (Object)((Object)this.m_settings.m_authMech), this.m_log);
                                        if (AuthMech.NOAUTH == this.m_settings.m_authMech) {
                                            this.m_settings.m_transportMode = TransportMode.BINARY;
                                        }
                                    }
                                    this.m_settings.m_proxySettings = new ProxySettings();
                                    DSConnectionUtils.readProxySettings(connSettingRequestMap, this.m_settings.m_proxySettings);
                                    this.m_settings.m_useResolvedHostname = false;
                                    this.m_definedSettings.put("UseResolvedHostname", false);
                                    variant2 = this.getOptionalSetting("UseResolvedHostname", connSettingRequestMap);
                                    if (null != variant2) {
                                        int n3 = 0;
                                        try {
                                            n3 = variant2.getInt();
                                        }
                                        catch (Exception exception) {
                                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"UseResolvedHostname", variant2.getString(), "0 , 1"});
                                            errorException.initCause(exception);
                                            throw errorException;
                                        }
                                        if (1 == n3) {
                                            this.m_settings.m_useResolvedHostname = true;
                                        }
                                    }
                                    variant2 = this.getOptionalSetting("ConnSchema", connSettingRequestMap);
                                    this.m_definedSettings.put("ConnSchema", true);
                                    if (null == variant2 || variant2.getString().equalsIgnoreCase("NULL")) {
                                        this.m_settings.m_Schema = "default";
                                        LogUtilities.logInfo("Schema is set to default: " + this.m_settings.m_Schema, this.m_log);
                                    } else {
                                        this.m_settings.m_Schema = variant2.getString();
                                    }
                                    variant2 = this.getOptionalSetting("KrbHostFQDN", connSettingRequestMap);
                                    this.m_definedSettings.put("KrbHostFQDN", true);
                                    if (variant2 != null) {
                                        this.m_settings.m_krbHostFQDN = variant2.getString();
                                        if (ServiceDiscoveryMode.NO_SERVICE_DISCOVERY == this.m_settings.m_serviceDiscoveryMode && this.m_settings.m_krbHostFQDN.equals("_HOST")) {
                                            this.m_settings.m_krbHostFQDN = this.m_settings.m_host;
                                        }
                                    }
                                    variant2 = this.getOptionalSetting("KrbRealm", connSettingRequestMap);
                                    this.m_definedSettings.put("KrbRealm", true);
                                    if (variant2 != null) {
                                        this.m_settings.m_krbRealm = variant2.getString();
                                    }
                                    variant2 = this.getOptionalSetting("KrbServiceName", connSettingRequestMap);
                                    this.m_definedSettings.put("KrbServiceName", true);
                                    if (variant2 != null) {
                                        this.m_settings.m_krbServiceName = variant2.getString();
                                    }
                                    this.m_settings.m_krbAuthType = KrbAuthType.AUTO_DETECT;
                                    variant2 = this.getOptionalSetting("krbAuthType", connSettingRequestMap);
                                    this.m_definedSettings.put("krbAuthType", true);
                                    if (variant2 != null) {
                                        try {
                                            int n4 = variant2.getInt();
                                            if (n4 < KrbAuthType.values().length && n4 >= 0) {
                                                this.m_settings.m_krbAuthType = KrbAuthType.values()[n4];
                                            } else if (null != this.getWarningListener()) {
                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_INVALID_KRB_AUTH_TYPE.name()));
                                            }
                                        }
                                        catch (Exception exception) {
                                            if (null == this.getWarningListener()) break block177;
                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_INVALID_KRB_AUTH_TYPE.name()));
                                        }
                                    }
                                }
                                variant2 = this.getOptionalSetting("krbJAASFile", connSettingRequestMap);
                                this.m_definedSettings.put("krbJAASFile", true);
                                if (null != variant2) {
                                    this.m_settings.m_krbJaasConfigFile = variant2.getString();
                                }
                                this.m_settings.m_username = null;
                                this.m_settings.m_password = null;
                                this.m_definedSettings.put("UID", true);
                                if ((AuthMech.SASL_PLAIN_UID == this.m_settings.m_authMech || AuthMech.UIDPWD == this.m_settings.m_authMech || this.m_settings.m_platformVersionUtils.sendUidViaOpenSessionReq(this.m_settings.m_authMech)) && (variant2 = this.getOptionalSetting("UID", connSettingRequestMap)) != null) {
                                    this.m_settings.m_username = variant2.getString();
                                }
                                if (AuthMech.SASL_PLAIN_UID == this.m_settings.m_authMech || AuthMech.UIDPWD == this.m_settings.m_authMech) {
                                    if (this.m_authMechSpecifiedByUser) {
                                        variant2 = this.getRequiredSetting("UID", connSettingRequestMap);
                                        this.m_settings.m_username = variant2.getString();
                                    } else if (this.m_settings.m_username == null || this.m_settings.m_username.length() == 0) {
                                        this.m_settings.m_username = "anonymous";
                                        if (null != this.getWarningListener()) {
                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_PARAMETER_NOT_SET.name(), new String[]{"UID", "anonymous"}));
                                        }
                                    }
                                }
                                this.m_definedSettings.put("PWD", true);
                                if (AuthMech.UIDPWD == this.m_settings.m_authMech) {
                                    if (this.m_authMechSpecifiedByUser) {
                                        variant2 = this.getRequiredSetting("PWD", connSettingRequestMap);
                                        this.m_settings.m_password = variant2.getString();
                                    } else {
                                        variant2 = this.getOptionalSetting("PWD", connSettingRequestMap);
                                        if (variant2 != null) {
                                            this.m_settings.m_password = variant2.getString();
                                        }
                                        if (this.m_settings.m_password == null || this.m_settings.m_password.length() == 0) {
                                            this.m_settings.m_password = "anonymous";
                                            if (null != this.getWarningListener()) {
                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_PARAMETER_NOT_SET.name(), new String[]{"PWD", "anonymous"}));
                                            }
                                        }
                                    }
                                }
                                this.m_settings.m_serverSSLSettings = new SSLSettings();
                                DSConnectionUtils.readSSLSettings(connSettingRequestMap, null, this.m_settings.m_serverSSLSettings, this.m_settings.m_forceSSL, NO_PROP_KEY_PREFIX, this.getWarningListener());
                                this.addSslPropertiesToDefinedSettings(NO_PROP_KEY_PREFIX);
                                if (ServiceDiscoveryMode.AOSS == this.m_settings.m_serviceDiscoveryMode) {
                                    this.readAOSSSettings(connSettingRequestMap);
                                }
                                if (AuthMech.OAUTH_2 == this.m_settings.m_authMech) {
                                    this.setOAuthProperties(connSettingRequestMap);
                                }
                                variant2 = this.getOptionalSetting("UseNativeQuery", connSettingRequestMap);
                                this.m_definedSettings.put("UseNativeQuery", true);
                                if (null != variant2) {
                                    try {
                                        this.m_settings.m_useNativeQuery = variant2.getInt() == 1;
                                    }
                                    catch (Exception exception) {
                                        object3 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_NATIVEMODE_ERR.name(), exception.getMessage());
                                        ((Throwable)object3).initCause(exception);
                                        throw object3;
                                    }
                                }
                                this.m_definedSettings.put("UpperCaseResultSetColName", true);
                                this.m_settings.m_upperCaseResultSetColName = this.readOptionalBooleanSetting(connSettingRequestMap, "UpperCaseResultSetColName", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                this.m_definedSettings.put("EnableIsQualifierTypeReturnedTesting", true);
                                this.m_settings.m_enableIsQualifierTypeReturnedTesting = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableIsQualifierTypeReturnedTesting", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
                                if (this.m_settings.m_enableIsQualifierTypeReturnedTesting) {
                                    LogUtilities.logWarning("EnableIsQualifierTypeReturnedTesting is enabled. This should only be turned on for testing purposes.", this.m_log);
                                }
                                variant2 = this.getOptionalSetting("DelegationUID", connSettingRequestMap);
                                this.m_definedSettings.put("DelegationUID", true);
                                if (null != variant2) {
                                    try {
                                        this.m_settings.m_delegationUID = variant2.getString();
                                    }
                                    catch (Exception exception) {
                                        object3 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATIONUID_ERR.name(), exception.getMessage());
                                        ((Throwable)object3).initCause(exception);
                                        throw object3;
                                    }
                                }
                                variant2 = this.getOptionalSetting("DefaultStringColumnLength", connSettingRequestMap);
                                this.m_definedSettings.put("DefaultStringColumnLength", true);
                                if (null != variant2) {
                                    try {
                                        this.m_settings.m_stringColumnSize = variant2.getShort();
                                        if (this.m_settings.m_stringColumnSize <= 0 || this.m_settings.m_stringColumnSize > Short.MAX_VALUE) {
                                            this.m_settings.m_stringColumnSize = (short)255;
                                            if (null != this.getWarningListener()) {
                                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_STRINGCOLUMNSIZE_ERR.name(), new String[]{"Column size value is invalid."}));
                                            }
                                        }
                                    }
                                    catch (Exception exception) {
                                        this.m_settings.m_stringColumnSize = (short)255;
                                        if (null == this.getWarningListener()) break block178;
                                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_STRINGCOLUMNSIZE_ERR.name(), new String[]{"Column size data type is invalid."}));
                                    }
                                }
                            }
                            variant2 = this.getOptionalSetting("AsyncExecPollInterval", connSettingRequestMap);
                            this.m_definedSettings.put("AsyncExecPollInterval", true);
                            if (null != variant2) {
                                try {
                                    this.m_settings.m_asyncExecPollInterval = variant2.getInt();
                                    if (0 >= this.m_settings.m_asyncExecPollInterval) {
                                        this.m_settings.m_asyncExecPollInterval = 10;
                                        if (null != this.getWarningListener()) {
                                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ASYNCEXECPOLLINTERVAL_ERR.name()));
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    this.m_settings.m_asyncExecPollInterval = 10;
                                    if (null == this.getWarningListener()) break block179;
                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ASYNCEXECPOLLINTERVAL_ERR.name()));
                                }
                            }
                        }
                        variant2 = this.getOptionalSetting("FetchEndWaitTime", connSettingRequestMap);
                        this.m_definedSettings.put("FetchEndWaitTime", true);
                        if (null != variant2) {
                            try {
                                this.m_settings.m_fetchEndWaitTime = variant2.getLong();
                            }
                            catch (Exception exception) {
                                this.m_settings.m_fetchEndWaitTime = 5L;
                                if (null == this.getWarningListener()) break block180;
                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant2.getString(), "FetchEndWaitTime", String.valueOf(5L)}));
                            }
                        }
                    }
                    variant = this.getOptionalSetting("SocketTimeOut", connSettingRequestMap);
                    this.m_definedSettings.put("SocketTimeOut", true);
                    if (null != variant) {
                        try {
                            this.m_settings.m_timeout = variant.getInt() * 1000;
                            if (this.m_settings.m_timeout < 0) {
                                this.m_settings.m_timeout = 0;
                                if (null != this.getWarningListener()) {
                                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.SET_SOCKETTIMEOUT_ERR.name(), new String[]{"Timeout value cannot be negative."}));
                                }
                            }
                        }
                        catch (Exception exception) {
                            this.m_settings.m_timeout = 0;
                            if (null == this.getWarningListener()) break block181;
                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.SET_SOCKETTIMEOUT_ERR.name(), new String[]{"Timeout value must be an integer."}));
                        }
                    }
                }
                object3 = this.getOptionalSetting("RowsFetchedPerBlock", connSettingRequestMap);
                this.m_definedSettings.put("RowsFetchedPerBlock", true);
                if (null != object3) {
                    try {
                        this.m_settings.m_rowsFetchedPerBlock = ((Variant)object3).getInt();
                        if (this.m_settings.m_rowsFetchedPerBlock < 0) {
                            this.m_settings.m_rowsFetchedPerBlock = 10000;
                            if (null != this.getWarningListener()) {
                                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ROWSFETCHEDPERBLOCK_ERR.name(), new String[]{"Value of RowsFetchedPerBlock cannot be negative."}));
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.m_settings.m_rowsFetchedPerBlock = 10000;
                        if (null == this.getWarningListener()) break block182;
                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ROWSFETCHEDPERBLOCK_ERR.name(), new String[]{"Value of RowsFetchedPerBlock must be an integer."}));
                    }
                }
            }
            this.m_definedSettings.put("SetFetchSizeTakesPrecedence", true);
            this.m_settings.m_setFetchSizeTakesPrecedence = this.readOptionalBooleanSetting(connSettingRequestMap, "SetFetchSizeTakesPrecedence", true, HiveJDBCMessageKey.CONN_CONF_ERROR);
            this.m_definedSettings.put("EnableSetFetchSizeTesting", true);
            this.m_settings.m_enableSetFetchSizeTesting = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableSetFetchSizeTesting", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
            if (this.m_settings.m_enableSetFetchSizeTesting) {
                LogUtilities.logWarning("EnableSetFetchSizeTesting is enabled. This should only be turned on for testing purposes.", this.m_log);
            }
            this.m_definedSettings.put("ExpectedFetchSize", true);
            this.m_settings.m_expectedFetchSize = this.readOptionalPositiveIntegerSetting(connSettingRequestMap, "ExpectedFetchSize", this.m_settings.m_rowsFetchedPerBlock);
            Variant variant6 = this.getOptionalSetting("DecimalColumnScale", connSettingRequestMap);
            this.m_definedSettings.put("DecimalColumnScale", true);
            if (null != variant6) {
                try {
                    this.m_settings.m_decimalColumnScale = variant6.getShort();
                    if (this.m_settings.m_decimalColumnScale < 0 || this.m_settings.m_decimalColumnScale > 38) {
                        this.m_settings.m_decimalColumnScale = (short)10;
                        if (null != this.getWarningListener()) {
                            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_ROWSFETCHEDPERBLOCK_ERR.name(), new String[]{"Value of Decimal Column Scale must be less than 38 and greater or equal to 0."}));
                        }
                    }
                }
                catch (Exception exception) {
                    this.m_settings.m_decimalColumnScale = (short)10;
                    if (null == this.getWarningListener()) break block183;
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_DECIMALCOLUMNSCALE_ERR.name(), new String[]{"Value of RowsFetchedPerBlock must be an integer."}));
                }
            }
        }
        this.m_definedSettings.put("BinaryColumnLength", true);
        this.m_settings.m_binaryColumnSize = this.readOptionalPositiveIntegerSetting(connSettingRequestMap, "BinaryColumnLength", Short.MAX_VALUE);
        this.m_definedSettings.put("EnableZeroRowsTesting", true);
        this.m_settings.m_thriftHTTPSettings.m_enableZeroRowsTesting = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableZeroRowsTesting", false, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        if (this.m_settings.m_thriftHTTPSettings.m_enableZeroRowsTesting) {
            this.m_definedSettings.put("EmulateZeroRowFetchBlocks", true);
            this.m_settings.m_thriftHTTPSettings.m_emulateZeroRowBlocks = this.readOptionalPositiveIntegerSetting(connSettingRequestMap, "EmulateZeroRowFetchBlocks", 0);
        }
        variant2 = this.getOptionalSetting("ServerReturnsCorrectHasMoreRows", connSettingRequestMap);
        this.m_definedSettings.put("ServerReturnsCorrectHasMoreRows", true);
        if (null != variant2) {
            try {
                this.m_settings.m_isServerReturnsCorrectHasMoreRows = variant2.getInt() == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"ServerReturnsCorrectHasMoreRows", variant2.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("CatalogSchemaSwitch", connSettingRequestMap);
        this.m_definedSettings.put("CatalogSchemaSwitch", true);
        if (null != variant2) {
            try {
                if (variant2.getInt() == 0) {
                    this.m_settings.m_switchCataANDSchema = false;
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SWITCHCATASCHEMA_TYPE_ERR.name(), incorrectTypeException.getMessage());
                errorException.initCause(incorrectTypeException);
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SWITCHCATASCHEMA_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("PreparedMetaLimitZero", connSettingRequestMap);
        this.m_definedSettings.put("PreparedMetaLimitZero", true);
        if (null != variant2) {
            try {
                this.m_settings.m_preparedStmtGetMetadataLimitZero = variant2.getInt() == 1;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_PREPAREDMETALIMITZERO_TYPE_ERR.name(), incorrectTypeException.getMessage());
                errorException.initCause(incorrectTypeException);
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_PREPAREDMETALIMITZERO_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("LowerCaseResultSetColumnName", connSettingRequestMap);
        this.m_definedSettings.put("LowerCaseResultSetColumnName", true);
        if (null != variant2) {
            try {
                if (variant2.getInt() == 0) {
                    this.m_settings.m_columnNameAliaseCase = HiveJDBCCasePreservingAlias.PRESERVE_CASE;
                } else if (variant2.getInt() == 1) {
                    this.m_settings.m_columnNameAliaseCase = HiveJDBCCasePreservingAlias.LOWERCASE;
                }
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_LOWERCASE_COLUMNNAME_ALIASE_ERROR.name()));
            }
        }
        variant2 = this.getOptionalSetting("PushdownCatalogFunctionFilters", connSettingRequestMap);
        this.m_definedSettings.put("PushdownCatalogFunctionFilters", true);
        if (null != variant2) {
            try {
                this.m_settings.m_pushdownCatalogFunctionFilters = variant2.getInt() == 1;
            }
            catch (Exception exception) {
                this.m_settings.m_pushdownCatalogFunctionFilters = true;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_PUSHDOWN_CATALOG_FUNCTION_FILTERS_ERROR.name()));
            }
        }
        variant2 = this.getOptionalSetting("StripCatalogName", connSettingRequestMap);
        this.m_definedSettings.put("StripCatalogName", true);
        if (null != variant2) {
            try {
                if (0 == variant2.getInt() && !this.m_settings.m_useNativeQuery) {
                    this.m_settings.m_stripCatalogName = false;
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STRIPCATALOGNAME_TYPE_ERR.name(), incorrectTypeException.getMessage());
                errorException.initCause(incorrectTypeException);
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STRIPCATALOGNAME_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (this.m_settings.m_switchCataANDSchema) {
            this.m_settings.m_stripCatalogName = false;
        }
        variant2 = this.getOptionalSetting("userGSSCredentialID", connSettingRequestMap);
        this.m_definedSettings.put("userGSSCredentialID", true);
        if (null != variant2 && null != (object2 = HiveCommonGSSCredentialMap.get(variant2.getString()))) {
            this.m_settings.m_userGSSCredential = object2;
            HiveCommonGSSCredentialMap.remove(variant2.getString());
        }
        this.m_settings.m_useCustomCoercionMap = true;
        variant2 = this.getOptionalSetting("UseCustomTypeCoercionMap", connSettingRequestMap);
        this.m_definedSettings.put("UseCustomTypeCoercionMap", true);
        if (null != variant2) {
            try {
                this.m_settings.m_useCustomCoercionMap = variant2.getInt() == 1;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"UseCustomTypeCoercionMap", variant2.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("AutomaticColumnRename", connSettingRequestMap);
        this.m_definedSettings.put("AutomaticColumnRename", true);
        if (null != variant2) {
            try {
                this.m_settings.m_automaticColumnRename = variant2.getInt() == 1;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"AutomaticColumnRename", variant2.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        this.m_settings.m_hiveAsyncQueryTest = false;
        variant2 = this.getOptionalSetting("HiveAsyncQueryTest", connSettingRequestMap);
        this.m_definedSettings.put("HiveAsyncQueryTest", true);
        if (null != variant2) {
            try {
                this.m_settings.m_hiveAsyncQueryTest = variant2.getInt() == 1;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"HiveAsyncQueryTest", variant2.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("DelegationToken", connSettingRequestMap);
        this.m_definedSettings.put("DelegationToken", true);
        if (null != variant2) {
            try {
                this.m_settings.m_delegationToken = variant2.getString();
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"DelegationToken", variant2.getString()});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        variant2 = this.getOptionalSetting("NonSSPs", connSettingRequestMap);
        this.m_definedSettings.put("NonSSPs", true);
        if (null != variant2) {
            try {
                object2 = variant2.getString();
                object = ((String)object2).split(",");
                this.m_settings.m_nonSSPs.addAll(Arrays.asList(object));
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"NonSSPs", variant2.getString()});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        this.m_settings.m_customNetworkHooksSettings = new CustomNetworkHooksSettings();
        DSConnectionUtils.readCustomNetworkHooksProperties(connSettingRequestMap, this.m_settings.m_customNetworkHooksSettings);
        this.m_definedSettings.put("SocketFactory", true);
        this.m_definedSettings.put("SocketFactoryArg", true);
        this.m_definedSettings.put("DnsResolver", true);
        this.m_definedSettings.put("DnsResolverArg", true);
        this.m_settings.m_socketTimeoutAfterConnected = true;
        variant2 = this.getOptionalSetting("SocketTimeoutAfterConnected", connSettingRequestMap);
        this.m_definedSettings.put("SocketTimeoutAfterConnected", true);
        if (null != variant2) {
            try {
                this.m_settings.m_socketTimeoutAfterConnected = variant2.getInt() != 0;
            }
            catch (Exception exception) {
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"SocketTimeoutAfterConnected", variant2.getString(), "0 , 1"});
                ((Throwable)object).initCause(exception);
                throw object;
            }
        }
        HiveCommonConnectionUtils.readHttpRetrySettings(connSettingRequestMap, this.m_settings.m_supportedHttpRetryType, this.m_settings.m_thriftHTTPSettings.m_httpRetrySettingsList, this.getWarningListener());
        HiveCommonConnectionUtils.readHttpErrorEmulationSettings(connSettingRequestMap, this.m_settings.m_thriftHTTPSettings.m_httpErrorEmulationSettingsMap, this.getWarningListener());
        this.m_definedSettings.put("EnableHttpErrorTesting", true);
        this.m_definedSettings.put("HttpEmulatedError", true);
        HiveCommonConnectionUtils.readZookeeperSettings(connSettingRequestMap, this.m_settings.m_zookeeperSettings, this.getWarningListener(), this.m_log);
        if (AuthMech.SAML_2_0 == this.m_settings.m_authMech) {
            HiveCommonConnectionUtils.readSSOSAMLSettings(connSettingRequestMap, this.m_settings, this.m_definedSettings, this.m_log);
        }
        this.m_definedSettings.put("EnableZkRoundRobinStrategy", true);
        this.m_definedSettings.put("EnableZookeeperTesting", true);
        this.m_definedSettings.put("ZKTestHosts", true);
        this.m_definedSettings.put("ZKTestIndices", true);
        this.m_definedSettings.put("ZKTestSetCallIndex", true);
        this.m_definedSettings.put("MaxNumServerLists", true);
        this.setDriverSpecificSettings();
        this.m_definedSettings.put("EnableDirectResults", true);
        this.m_settings.m_enableDirectResults = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableDirectResults", this.m_settings.m_enableDirectResults, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("EnableArrow", true);
        this.m_settings.m_enableArrow = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableArrow", this.m_settings.m_enableArrow, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        if (this.m_settings.m_enableArrow) {
            this.m_definedSettings.put("MaxBytesPerFetchRequest", true);
            this.m_settings.m_arrowMaxBytesPerFetch = this.readOptionalPositiveIntegerSetting(connSettingRequestMap, "MaxBytesPerFetchRequest", 10000000);
            this.m_definedSettings.put("ArrowTimestampAsString", true);
            this.m_settings.m_arrowTimestampAsString = this.readOptionalBooleanSetting(connSettingRequestMap, "ArrowTimestampAsString", this.m_settings.m_arrowTimestampAsString, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        }
        if (!this.m_settings.m_fastConnect) {
            object2 = "socketTimeout = " + this.m_settings.m_timeout / 1000 + ", loginTimeout = " + n;
            LogUtilities.logDebug((String)object2, this.m_log);
            int n5 = this.m_settings.m_timeout;
            int n6 = n * 1000;
            if (0 != n) {
                if (0 == this.m_settings.m_timeout || this.m_settings.m_timeout > n6 || null == variant) {
                    this.m_settings.m_timeout = n6;
                    object2 = "SocketTimeout is: " + this.m_settings.m_timeout / 1000 + " seconds for test";
                    LogUtilities.logDebug((String)object2, this.m_log);
                }
            } else if (null == variant) {
                this.m_settings.m_timeout = 30000;
                object2 = "SocketTimeout is: " + this.m_settings.m_timeout / 1000 + " seconds for test";
                LogUtilities.logDebug((String)object2, this.m_log);
            }
            IHiveClientFactory iHiveClientFactory = this.getClientFactory();
            this.m_hiveClient = iHiveClientFactory.createClient(this.m_settings, this.m_log, this.getWarningListener());
            if (null == variant || !this.m_settings.m_socketTimeoutAfterConnected || !this.m_settings.m_platformVersionUtils.supportsAsynchronousOperations(this.m_settings.m_serverVersion)) {
                n5 = 0;
            }
            if (n5 != this.m_settings.m_timeout) {
                ServiceDiscoveryMode serviceDiscoveryMode = this.m_settings.m_serviceDiscoveryMode;
                this.m_settings.m_serviceDiscoveryMode = ServiceDiscoveryMode.NO_SERVICE_DISCOVERY;
                this.m_settings.m_timeout = n5;
                this.m_hiveClient.setSocketTimeout(n5);
                object2 = "socketTimeout is set back to " + this.m_settings.m_timeout + " seconds";
                LogUtilities.logDebug((String)object2, this.m_log);
                this.m_settings.m_serviceDiscoveryMode = serviceDiscoveryMode;
            }
        } else {
            object2 = this.getClientFactory();
            this.m_hiveClient = object2.createClient(this.m_settings, this.m_log, this.getWarningListener());
        }
        if (ServiceDiscoveryMode.ZOOKEEPER == this.m_settings.m_serviceDiscoveryMode) {
            this.m_definedSettings.put("Port", true);
        }
        this.m_definedSettings.put("DisableTranslatedToOriginalQueryFallback", true);
        this.m_settings.m_disableTranslatedToOriginalQueryFallback = this.readOptionalBooleanSetting(connSettingRequestMap, "DisableTranslatedToOriginalQueryFallback", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_settings.m_tableNameColIndex = this.m_settings.m_platformVersionUtils.getTableNameColIndex(this.m_settings.m_serverVersion);
        this.m_settings.m_isTemporaryColIndex = this.m_settings.m_platformVersionUtils.getIsTemporaryColIndex(this.m_settings.m_serverVersion);
        this.m_definedSettings.put("ShowTablesTableNameColIdx", true);
        variant2 = this.getOptionalSetting("ShowTablesTableNameColIdx", connSettingRequestMap);
        if (null != variant2) {
            try {
                int n7 = variant2.getInt();
                this.m_settings.m_tableNameColIndex = 0 <= n7 ? n7 : this.m_settings.m_tableNameColIndex;
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SHOW_TABLES_TABLE_NAME_COL_IDX.name()));
            }
        }
        this.m_definedSettings.put("ShowTablesIsTempTableColIdx", true);
        variant2 = this.getOptionalSetting("ShowTablesIsTempTableColIdx", connSettingRequestMap);
        if (null != variant2) {
            try {
                int n8 = variant2.getInt();
                this.m_settings.m_isTemporaryColIndex = 0 <= n8 ? n8 : this.m_settings.m_isTemporaryColIndex;
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SHOW_TABLES_IS_TEMP_TABLE_COL_IDX.name()));
            }
        }
        this.m_definedSettings.put("RenameJoinColumn", true);
        this.m_settings.m_renameJoinColumn = this.readOptionalBooleanSetting(connSettingRequestMap, "RenameJoinColumn", false, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("GetTablesWithQuery", true);
        this.m_settings.m_getTablesWithQuery = this.readOptionalBooleanSetting(connSettingRequestMap, "GetTablesWithQuery", !this.m_settings.m_platformVersionUtils.supportsGetTablesAPI(this.m_settings.m_serverVersion), HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("GetSchemasWithQuery", true);
        this.m_settings.m_getSchemasWithQuery = this.readOptionalBooleanSetting(connSettingRequestMap, "GetSchemasWithQuery", !this.m_settings.m_platformVersionUtils.supportsGetSchemasAPI(this.m_settings.m_serverVersion), HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("GetColumnsWithQuery", true);
        this.m_settings.m_getColumnsWithQuery = this.readOptionalBooleanSetting(connSettingRequestMap, "GetColumnsWithQuery", !this.m_settings.m_platformVersionUtils.supportsGetColumnsAPI(this.m_settings.m_serverVersion), HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("ServerReturnsCorrectNullability", true);
        this.m_settings.m_isServerReturnsCorrectNullability = this.readOptionalBooleanSetting(connSettingRequestMap, "ServerReturnsCorrectNullability", this.m_settings.m_platformVersionUtils.supportsGetColumnsAPINullability(this.m_settings.m_serverVersion), HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("CteReturnsQueryResultSet", true);
        this.m_settings.m_cteQueryResultSet = this.readOptionalBooleanSetting(connSettingRequestMap, "CteReturnsQueryResultSet", this.m_settings.m_cteQueryResultSet, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        this.m_definedSettings.put("SetKeyValueQueryResultSet", true);
        this.m_settings.m_setKeyValueQueryResultSet = this.readOptionalBooleanSetting(connSettingRequestMap, "SetKeyValueQueryResultSet", this.m_settings.m_setKeyValueQueryResultSet, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
        if (this.m_hiveClient.isArrowEnabled()) {
            boolean bl = true;
            this.m_definedSettings.put("ArrowNettyReflectionProperty", true);
            variant2 = this.getOptionalSetting("ArrowNettyReflectionProperty", connSettingRequestMap);
            if (null != variant2) {
                bl = this.readOptionalBooleanSetting(connSettingRequestMap, "ArrowNettyReflectionProperty", bl, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
            } else {
                try {
                    bl = this.parseJavaMajorVersion() > 8;
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
            if (bl) {
                System.setProperty("io.netty.tryReflectionSetAccessible", "true");
            }
        }
        this.m_definedSettings.put("ConvertUnionToUnionAll", true);
        this.m_settings.m_convertUnionToUnionAll = this.readOptionalBooleanSetting(connSettingRequestMap, "ConvertUnionToUnionAll", false, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("SupportsDefaultOrderBy", true);
        this.m_settings.m_supportsDefaultOrderBy = this.readOptionalBooleanSetting(connSettingRequestMap, "SupportsDefaultOrderBy", this.m_settings.m_platformVersionUtils.hqlSupportsDefaultOrderBy(this.m_settings.m_serverVersion), HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("EnableDMLResult", true);
        this.m_settings.m_supportsDMLResults = this.readOptionalBooleanSetting(connSettingRequestMap, "EnableDMLResult", this.m_settings.m_platformVersionUtils.supportsDMLResults(), HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("SupportsNumModifiedRows", true);
        this.m_settings.m_supportsNumRowsModified = this.readOptionalBooleanSetting(connSettingRequestMap, "SupportsNumModifiedRows", this.m_settings.m_supportsNumRowsModified, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.m_definedSettings.put("UnrecognizedStmtReturnsQueryResult", true);
        this.m_settings.m_unrecognizedStmtReturnsQueryResult = this.readOptionalBooleanSetting(connSettingRequestMap, "UnrecognizedStmtReturnsQueryResult", this.m_settings.m_unrecognizedStmtReturnsQueryResult, HiveJDBCMessageKey.CONN_CONF_ERROR);
        this.setServersideProperties(connSettingRequestMap);
    }

    public IHiveClient getClient() {
        return this.m_hiveClient;
    }

    public IHiveClientFactory getClientFactory() {
        return this.m_factory;
    }

    public String getDelegationToken(String string, String string2) throws ErrorException {
        if (this.m_hiveClient instanceof HS2Client) {
            try {
                String string3 = ((HS2Client)this.m_hiveClient).getDelegationToken(string, string2);
                String string4 = string3.replace("=", NO_PROP_KEY_PREFIX).replace("+", "-").replace("/", "_");
                return string4;
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GET_DELEGATION_TOKEN_ERR.name(), new String[]{exception.getMessage(), string, string2});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), "getDelegationToken");
        throw errorException;
    }

    public IHiveClient getHiveClient() {
        return this.m_hiveClient;
    }

    public HiveJDBCSettings getSettings() {
        return this.m_settings;
    }

    public ExecutorService getThreadPool() {
        return this.m_threadPool;
    }

    @Override
    public void handleException(Exception exception) throws ErrorException {
        Throwable throwable;
        if (null != exception && !(exception instanceof TimeoutException) && null != (throwable = exception.getCause()) && throwable instanceof ErrorException && null != (throwable = throwable.getCause()) && throwable instanceof TTransportException && null != throwable.getCause()) {
            String string;
            if (throwable.getCause() instanceof SocketTimeoutException) {
                ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{null != throwable.getMessage() ? throwable.getMessage() : "Unknown"});
                errorException.initCause(throwable);
                throw errorException;
            }
            if (throwable.getCause() instanceof ConnectException && null != (string = throwable.getCause().getMessage()) && string.toLowerCase().contains("connection timed out")) {
                ErrorException errorException = new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{null != throwable.getMessage() ? throwable.getMessage() : "Unknown"});
                errorException.initCause(throwable);
                throw errorException;
            }
        }
        super.handleException(exception);
    }

    @Override
    public boolean isAlive() {
        return this.m_settings.m_isConnAlive;
    }

    @Override
    public void setClientInfoProperty(String string, String string2) throws ClientInfoException {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        if ("Auth_AccessToken".equalsIgnoreCase(string)) {
            this.m_settings.m_oAuthSettings.m_accessToken = string2;
            this.m_settings.m_oAuthSettings.m_refreshAccessToken = true;
            if (!this.m_settings.m_oAuthSettings.m_maskClientInfoAccessToken) {
                super.setClientInfoProperty("Auth_AccessToken", string2);
            }
        } else {
            super.setClientInfoProperty(string, string2);
        }
    }

    public void renewDelegationToken(String string) throws ErrorException {
        if (this.m_hiveClient instanceof HS2Client) {
            try {
                ((HS2Client)this.m_hiveClient).renewDelegationToken(string);
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.RENEW_DELEGATION_TOKEN_ERR.name(), new String[]{exception.getLocalizedMessage(), string});
                errorException.initCause(exception);
                throw errorException;
            }
        } else {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), "renewDelegationToken");
            throw errorException;
        }
    }

    @Override
    public String toNativeSQL(String string) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        if (!this.m_settings.m_useNativeQuery) {
            HashMap<Character, Character> hashMap = new HashMap<Character, Character>();
            hashMap.put(Character.valueOf('\''), Character.valueOf('\''));
            hashMap.put(Character.valueOf('\"'), Character.valueOf('\"'));
            hashMap.put(Character.valueOf('`'), Character.valueOf('`'));
            return ParseQueryUtils.parseCommentsOnSingleQuery(string, this.m_settings.m_platformVersionUtils.supportsQueryCommentHints(this.m_settings.m_serverVersion), hashMap);
        }
        return string;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        Object object;
        Variant variant;
        Object object2;
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        String string = null;
        LogLevel logLevel = LogLevel.OFF;
        String string2 = NO_PROP_KEY_PREFIX;
        Variant variant2 = this.getOptionalSetting("LogPath", connSettingRequestMap);
        Variant variant3 = this.getOptionalSetting("LogLevel", connSettingRequestMap);
        Variant variant4 = this.getOptionalSetting("LogNamespace", connSettingRequestMap);
        if (null != variant2) {
            string = variant2.getString();
        }
        if (null != variant3) {
            logLevel = LogLevel.getLogLevel(variant3.getString());
        }
        if (null != variant4) {
            string2 = variant4.getString();
        }
        this.createConnectionLog(logLevel, string, string2);
        HiveJDBCSettings hiveJDBCSettings = new HiveJDBCSettings();
        hiveJDBCSettings.m_serverSSLSettings = new SSLSettings();
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        Variant variant5 = this.getOptionalSetting("AuthMech", connSettingRequestMap);
        if (null != variant5) {
            try {
                object2 = AuthMech.getAuthMech(variant5.getInt());
                if (null != object2) {
                    hiveJDBCSettings.m_authMech = object2;
                }
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.toString(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (null != (object2 = this.getOptionalSetting("HiveServerType", connSettingRequestMap))) {
            try {
                if (1 == ((Variant)object2).getInt()) {
                    hiveJDBCSettings.m_hiveServerType = HiveServerType.HiveServer1;
                } else if (2 == ((Variant)object2).getInt()) {
                    hiveJDBCSettings.m_hiveServerType = HiveServerType.HiveServer2;
                }
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HIVESERVERTYPE_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        Variant variant6 = this.getOptionalSetting("ssl", connSettingRequestMap);
        this.m_definedSettings.put("ssl", true);
        if (variant6 != null) {
            try {
                boolean bl;
                boolean bl2 = bl = variant6.getInt() == 1;
                hiveJDBCSettings.m_serverSSLSettings.m_enableSSL = bl;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CONF_ERROR.name(), new String[]{"ssl", variant6.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (null != (variant = this.getOptionalSetting("transportMode", connSettingRequestMap))) {
            object = variant.getString();
            hiveJDBCSettings.m_transportMode = ((String)object).equalsIgnoreCase("http") ? TransportMode.HTTP : (((String)object).equalsIgnoreCase("binary") ? TransportMode.BINARY : TransportMode.SASL);
        }
        this.verifyOptionalSetting("ServiceDiscoveryMode", connSettingRequestMap, connSettingResponseMap);
        object = this.getOptionalSetting("ServiceDiscoveryMode", connSettingRequestMap);
        if (null != object && ServiceDiscoveryMode.NO_SERVICE_DISCOVERY.name().equalsIgnoreCase(((Variant)object).getString())) {
            hiveJDBCSettings.m_serviceDiscoveryMode = ServiceDiscoveryMode.NO_SERVICE_DISCOVERY;
        } else {
            Variant variant7 = this.getOptionalSetting("zk", connSettingRequestMap);
            Variant variant8 = this.getOptionalSetting("AOSSStatusEndpoints", connSettingRequestMap);
            Variant variant9 = this.getOptionalSetting("Host", connSettingRequestMap);
            hiveJDBCSettings.m_serviceDiscoveryMode = (null != variant7 || null != object && ServiceDiscoveryMode.ZOOKEEPER.name().equalsIgnoreCase(((Variant)object).getString())) && this.m_factory.supportServiceDiscoveryMode(ServiceDiscoveryMode.ZOOKEEPER, this.getConnectionLog()) ? ServiceDiscoveryMode.ZOOKEEPER : (null != variant8 || null != object && ServiceDiscoveryMode.AOSS.name().equalsIgnoreCase(((Variant)object).getString()) && this.m_factory.supportServiceDiscoveryMode(ServiceDiscoveryMode.AOSS, this.getConnectionLog()) ? ServiceDiscoveryMode.AOSS : ServiceDiscoveryMode.NO_SERVICE_DISCOVERY);
        }
        if (ServiceDiscoveryMode.NO_SERVICE_DISCOVERY == hiveJDBCSettings.m_serviceDiscoveryMode) {
            this.verifyRequiredSetting("Host", connSettingRequestMap, connSettingResponseMap);
            if (this.isPortRequired()) {
                this.verifyRequiredSetting("Port", connSettingRequestMap, connSettingResponseMap);
            } else {
                this.verifyOptionalSetting("Port", connSettingRequestMap, connSettingResponseMap);
            }
        }
        this.verifyRequiredSetting("DatabaseType", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DefaultStringColumnLength", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("AsyncExecPollInterval", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("RowsFetchedPerBlock", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("AuthMech", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("SocketTimeOut", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DelegationUID", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("ConnSchema", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("ssl", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("CatalogSchemaSwitch", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("PreparedMetaLimitZero", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("UseNativeQuery", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("UseCustomTypeCoercionMap", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("StripCatalogName", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("AutomaticColumnRename", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DelegationToken", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("ServerVersion", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("FastConnection", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("NonSSPs", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("SocketFactory", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("SocketFactoryArg", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DnsResolver", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("DnsResolverArg", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("krbJAASFile", connSettingRequestMap, connSettingResponseMap);
        return this.updateConnectionSettings(hiveJDBCSettings, connSettingRequestMap, connSettingResponseMap);
    }

    public ConnSettingResponseMap updateConnectionSettings(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        return connSettingResponseMap;
    }

    public abstract IHiveCustomScalarFnFactory getScalarFnHelper();

    protected boolean isPortRequired() {
        return true;
    }

    protected void setDriverSpecificSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createConnectionLog(LogLevel logLevel, String string, String string2) {
        String string3 = this.getConnectionLogFileName();
        Object object = s_loggerLock;
        synchronized (object) {
            if (null == this.m_log) {
                this.m_log = new DSILogger(string3 + Integer.toString(s_connectionID++), logLevel, string, string2);
                this.m_log.setLocale(this.getLocale());
            }
        }
    }

    protected abstract String getConnectionLogFileName();

    protected abstract ProductInfoHandler getProductInfoHandler();

    protected boolean isAuthMechValid(HiveJDBCSettings hiveJDBCSettings) {
        switch (hiveJDBCSettings.m_transportMode) {
            case BINARY: {
                return AuthMech.NOAUTH == hiveJDBCSettings.m_authMech || AuthMech.UIDPWD == hiveJDBCSettings.m_authMech;
            }
            case SASL: {
                return AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech || AuthMech.SASL_PLAIN_UID == hiveJDBCSettings.m_authMech || AuthMech.UIDPWD == hiveJDBCSettings.m_authMech;
            }
            case HTTP: {
                return this.m_settings.m_platformVersionUtils.supportsHttp(hiveJDBCSettings.m_authMech);
            }
        }
        return false;
    }

    protected boolean readOptionalBooleanSetting(ConnSettingRequestMap connSettingRequestMap, String string, boolean bl, HiveJDBCMessageKey hiveJDBCMessageKey) {
        boolean bl2 = bl;
        Variant variant = this.getOptionalSetting(string, connSettingRequestMap);
        if (null != variant) {
            try {
                int n = variant.getInt();
                if (n == 1) {
                    return true;
                }
                if (n == 0) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != this.getWarningListener()) {
                if (HiveJDBCMessageKey.CONN_CONF_ERROR == hiveJDBCMessageKey) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, hiveJDBCMessageKey.name(), new String[]{string, variant.getString(), "0 or 1"}));
                } else if (HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR == hiveJDBCMessageKey) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, hiveJDBCMessageKey.name(), new String[]{variant.getString(), string, String.valueOf(bl)}));
                }
            }
        }
        return bl2;
    }

    protected int readOptionalPositiveIntegerSetting(ConnSettingRequestMap connSettingRequestMap, String string, int n) {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string, n);
        int n2 = n;
        Variant variant = this.getOptionalSetting(string, connSettingRequestMap);
        if (null != variant) {
            try {
                int n3 = variant.getInt();
                if (n3 > 0) {
                    return n3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != this.getWarningListener()) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant.getString(), string, "Value must be a positive integer value"}));
            }
        }
        return n2;
    }

    protected String readOptionalStringSetting(ConnSettingRequestMap connSettingRequestMap, String string, String string2) {
        String string3 = string2;
        Variant variant = this.getOptionalSetting(string, connSettingRequestMap);
        if (variant != null) {
            string3 = variant.getString();
        }
        return string3;
    }

    protected void setDefaultProperties() throws ErrorException {
        String string = null;
        if (DSIDriverSingleton.getInstance() instanceof HiveJDBCCommonDriver) {
            string = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName();
        }
        try {
            this.setProperty(101, new Variant(0, "ImpalaJDBC"));
            this.setProperty(139, new Variant(0, "User"));
            this.setProperty(22, new Variant(0, string));
            this.setProperty(58, new Variant(0, "`"));
            this.setProperty(66, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(68, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(76, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(81, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(83, new Variant(2, Character.valueOf('\u0080')));
            this.setProperty(80, new Variant(0, "N"));
        }
        catch (Exception exception) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DEFAULT_PROP_SETTING_ERR.name(), exception.getMessage());
        }
    }

    protected abstract void setDefaultPort();

    protected abstract void setImplementationDefaultSettings();

    protected abstract void setSupportedHttpRetryType();

    private void validateLicenseFile() throws ErrorException {
        try {
            this.getProductInfoHandler().validateLicense();
        }
        catch (Exception exception) {
            if (exception instanceof ErrorException) {
                if (HiveJDBCMessageKey.LICENSE_FILE_LOCATION_ERROR.name() == exception.getLocalizedMessage()) {
                    throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.LICENSE_FILE_LOCATION_ERROR.name(), ((ErrorException)exception).getMessageParams());
                }
                if (HiveJDBCMessageKey.LICENSE_FILE_READ_ERROR.name() == exception.getLocalizedMessage()) {
                    throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.LICENSE_FILE_READ_ERROR.name(), ((ErrorException)exception).getMessageParams());
                }
                if (HiveJDBCMessageKey.LICENSE_VALIDATION_ERROR.name() == exception.getLocalizedMessage()) {
                    throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.LICENSE_VALIDATION_ERROR.name(), ((ErrorException)exception).getMessageParams());
                }
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.LICENSE_VALIDATION_ERROR.name());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private int parseJavaMajorVersion() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.")) {
            return Integer.parseInt(string.substring(2, 3));
        }
        return Integer.parseInt(string.substring(0, string.indexOf(".")));
    }

    private void rectifyAuthMech(HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        if (AuthMech.NOAUTH_SSL == this.m_settings.m_authMech) {
            this.m_settings.m_authMech = AuthMech.NOAUTH;
            this.m_settings.m_transportMode = TransportMode.BINARY;
            this.m_settings.m_forceSSL = true;
        } else if (AuthMech.SASL_PLAIN_UIDPWD_SSL == this.m_settings.m_authMech) {
            this.m_settings.m_authMech = AuthMech.UIDPWD;
            this.m_settings.m_transportMode = TransportMode.SASL;
            this.m_settings.m_forceSSL = true;
        } else if (AuthMech.OAUTH_CLIENT_CREDENTIALS == this.m_settings.m_authMech) {
            this.m_settings.m_authMech = AuthMech.OAUTH_2;
            this.m_settings.m_oAuthSettings = new OAuthSettings();
            this.m_settings.m_oAuthSettings.m_authFlow = OAuthFlow.CLIENT_CREDENTIALS;
        }
        if (AuthMech.OAUTH_2 == this.m_settings.m_authMech && !this.m_settings.m_platformVersionUtils.supportsAuthMech(this.m_settings.m_authMech)) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_INVALID_AUTH_MECH_ERROR.name(), "OAuth authentication is not supported for " + this.m_settings.m_dbmsName);
            throw errorException;
        }
        if (AuthMech.SAML_2_0 == this.m_settings.m_authMech) {
            this.m_settings.m_thriftHTTPSettings.m_throwDifferentExceptionOnRedirect = true;
            if (!this.m_settings.m_platformVersionUtils.supportsAuthMech(this.m_settings.m_authMech)) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_INVALID_AUTH_MECH_ERROR.name(), this.m_settings.m_authMech.getDisplayName() + " authentication is not supported for " + this.m_settings.m_dbmsName);
                throw errorException;
            }
            if (TransportMode.HTTP != this.m_settings.m_transportMode) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.INVALID_TRANSPORT_MODE_FOR_AUTH_MECH.name(), new String[]{this.m_settings.m_authMech.getDisplayName(), TransportMode.HTTP.name()});
                throw errorException;
            }
        }
        if (TransportMode.HTTP == this.m_settings.m_transportMode && !this.m_settings.m_platformVersionUtils.supportsHttp(this.m_settings.m_authMech)) {
            if (null != this.getWarningListener()) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_AUTH_MECH_ERROR.name(), new String[]{this.m_settings.m_authMech.toString()}));
            }
            this.m_settings.m_authMech = AuthMech.UIDPWD;
            this.m_authMechSpecifiedByUser = false;
            if (null != this.getWarningListener()) {
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
            }
        }
        if (this.m_transportModeSpecifiedByUser) {
            if (!this.isAuthMechValid(this.m_settings)) {
                this.m_settings.m_authMech = this.m_settings.m_platformVersionUtils.resolveDefaultAuthMech(this.m_settings);
                this.m_authMechSpecifiedByUser = false;
                if (null != this.getWarningListener()) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
                }
            }
        } else if (AuthMech.NOAUTH == this.m_settings.m_authMech || AuthMech.UIDPWD == this.m_settings.m_authMech && !this.m_useSasl) {
            this.m_settings.m_transportMode = TransportMode.BINARY;
        }
    }

    private void setAOSSServiceDiscovery(ConnSettingRequestMap connSettingRequestMap, Variant variant) throws ErrorException {
        Variant variant2;
        block17: {
            Object object;
            this.m_definedSettings.put("AOSSStatusEndpoints", true);
            this.m_settings.m_serviceDiscoveryMode = ServiceDiscoveryMode.AOSS;
            String string = variant.getString();
            this.m_settings.m_hiveServerType = HiveServerType.HiveServer2;
            try {
                object = string.split(",");
                this.m_settings.m_serviceDiscoveryEndpoints = object;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_GENERAL_ERROR.name(), new String[]{ServiceDiscoveryMode.AOSS.toString(), exception.getMessage()});
                errorException.initCause(exception);
                throw errorException;
            }
            object = this.getOptionalSetting("AOSSStatusRequestTimeout", connSettingRequestMap);
            if (null != object) {
                try {
                    if (((Variant)object).getInt() >= 0) {
                        this.m_settings.m_AOSSSocketTimeout = ((Variant)object).getInt() * 1000;
                        break block17;
                    }
                    if (null != this.getWarningListener()) {
                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{((Variant)object).getString(), "AOSSStatusRequestTimeout", String.valueOf(30000)}));
                    }
                    this.m_settings.m_AOSSSocketTimeout = 30000;
                }
                catch (Exception exception) {
                    if (null != this.getWarningListener()) {
                        this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{((Variant)object).getString(), "AOSSStatusRequestTimeout", String.valueOf(30000)}));
                    }
                    this.m_settings.m_AOSSSocketTimeout = 30000;
                }
            } else {
                this.m_settings.m_AOSSSocketTimeout = 30000;
            }
        }
        if (null != (variant2 = this.getOptionalSetting("AOSS_AuthMech", connSettingRequestMap))) {
            int n;
            block18: {
                this.m_settings.m_AOSS_authMech = AuthMech.NOAUTH;
                n = -1;
                try {
                    n = variant2.getInt();
                }
                catch (Exception exception) {
                    if (null == this.getWarningListener()) break block18;
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_authMech.toString()}));
                }
            }
            if (n < AuthMech.values().length && n >= 0) {
                this.m_settings.m_AOSS_authMech = AuthMech.values()[n];
            }
            if (AuthMech.SASL_KERBEROS == this.m_settings.m_authMech) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), new String[]{"Authentication via Kerberos is not supported for AOSS endpoint."});
                throw errorException;
            }
            if (AuthMech.UIDPWD != this.m_settings.m_AOSS_authMech && AuthMech.NOAUTH != this.m_settings.m_AOSS_authMech) {
                if (null != this.getWarningListener()) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_AUTH_MECH_ERROR.name(), new String[]{this.m_settings.m_authMech.toString()}));
                }
                this.m_settings.m_AOSS_authMech = AuthMech.NOAUTH;
                if (null != this.getWarningListener()) {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_AUTH_MECH_SET_TO_DEFAULT.name(), new String[]{this.m_settings.m_AOSS_authMech.toString()}));
                }
            }
        }
        this.m_definedSettings.put("AOSS_AuthMech", true);
    }

    private void setCustomHTTPHeaders(ConnSettingRequestMap connSettingRequestMap) {
        Iterator<String> iterator = connSettingRequestMap.getKeysIterator();
        int n = "http.header.".length();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!string.startsWith("http.header.")) continue;
            this.m_settings.m_thriftHTTPSettings.addCustomHeader(string.substring(n), connSettingRequestMap.getProperty(string).getString());
        }
    }

    private void setNoServiceDiscovery(ConnSettingRequestMap connSettingRequestMap, Variant variant) throws ErrorException {
        this.m_settings.m_serviceDiscoveryMode = ServiceDiscoveryMode.NO_SERVICE_DISCOVERY;
        this.m_settings.m_host = variant.getString();
        Variant variant2 = this.isPortRequired() ? this.getRequiredSetting("Port", connSettingRequestMap) : this.getOptionalSetting("Port", connSettingRequestMap);
        this.m_definedSettings.put("Port", true);
        Variant variant3 = this.getRequiredSetting("HiveServerType", connSettingRequestMap);
        try {
            this.m_settings.m_port = variant2.getInt();
            if (1 == variant3.getInt()) {
                this.m_settings.m_hiveServerType = HiveServerType.HiveServer1;
            } else if (2 == variant3.getInt()) {
                this.m_settings.m_hiveServerType = HiveServerType.HiveServer2;
            }
        }
        catch (Exception exception) {
            if (!this.isPortRequired()) {
                this.setDefaultPort();
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HIVESERVERTYPE_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private void setServersideProperties(ConnSettingRequestMap connSettingRequestMap) {
        TreeMap<Object, String> treeMap = new TreeMap<Object, String>();
        Iterator<String> iterator = connSettingRequestMap.getKeysIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (this.m_definedSettings.containsKey(string) || this.m_settings.m_nonSSPs.contains(string) || string.equals("DriverLocale") || string.equals("LogLevel") || string.equals("LogPath") || string.equals("LogNamespace")) continue;
            treeMap.put(string, connSettingRequestMap.getProperty(string).getString());
        }
        LogUtilities.logDebug(treeMap.toString(), this.m_log);
        for (String string : treeMap.keySet()) {
            String string2 = "SET " + string + "=" + (String)treeMap.get(string);
            try {
                this.m_hiveClient.executeUpdate(string2, null);
            }
            catch (ErrorException errorException) {
                if (null == this.getWarningListener()) continue;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, errorException.getMessageKeyOrText(), errorException.getMessageParams()));
            }
        }
    }

    private void setZookeeperServiceDiscovery(ConnSettingRequestMap connSettingRequestMap, Variant variant) throws ErrorException {
        this.m_definedSettings.put("zk", true);
        this.m_settings.m_serviceDiscoveryMode = ServiceDiscoveryMode.ZOOKEEPER;
        String string = variant.getString();
        this.m_settings.m_hiveServerType = HiveServerType.HiveServer2;
        try {
            String[] stringArray = string.split(",");
            this.m_settings.m_serviceDiscoveryEndpoints = stringArray;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private void readAOSSSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        if (AuthMech.UIDPWD == this.m_settings.m_AOSS_authMech) {
            Variant variant = this.getOptionalSetting("AOSS_UID", connSettingRequestMap);
            this.m_settings.m_AOSS_username = null != variant ? variant.getString() : this.m_settings.m_username;
            if (null == this.m_settings.m_AOSS_username || 0 == this.m_settings.m_AOSS_username.length()) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.REQUIRED_PROP_NOT_FOUND.name(), new String[]{"AOSS_UID"});
                throw errorException;
            }
            Variant variant2 = this.getOptionalSetting("AOSS_PWD", connSettingRequestMap);
            this.m_settings.m_AOSS_password = null != variant2 ? variant2.getString() : this.m_settings.m_password;
            if (null == this.m_settings.m_AOSS_password || 0 == this.m_settings.m_AOSS_password.length()) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.REQUIRED_PROP_NOT_FOUND.name(), new String[]{"AOSS_PWD"});
                throw errorException;
            }
        }
        this.m_settings.m_AOSS_SSLSettings = new SSLSettings();
        DSConnectionUtils.readSSLSettings(connSettingRequestMap, this.m_settings.m_serverSSLSettings, this.m_settings.m_AOSS_SSLSettings, false, AOSS_PREFIX, this.getWarningListener());
    }

    private void setOAuthProperties(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        this.m_settings.m_thriftHTTPSettings.m_isOAuth = true;
        if (null == this.m_settings.m_oAuthSettings) {
            this.m_settings.m_oAuthSettings = new OAuthSettings();
        }
        this.m_settings.m_oAuthSettings.m_tokenEndpointSSLSettings = new SSLSettings();
        boolean bl = false;
        this.m_definedSettings.put("UseServerSSLConfigsForOAuthEndPoint", true);
        bl = this.readOptionalBooleanSetting(connSettingRequestMap, "UseServerSSLConfigsForOAuthEndPoint", bl, HiveJDBCMessageKey.CONN_CONF_ERROR);
        if (bl) {
            DSConnectionUtils.readOAuthProperties(connSettingRequestMap, this.m_settings.m_oAuthSettings, this.m_settings.m_serverSSLSettings, this.getWarningListener());
        } else {
            DSConnectionUtils.readOAuthProperties(connSettingRequestMap, this.m_settings.m_oAuthSettings, null, this.getWarningListener());
        }
        if (null == this.m_settings.m_oAuthSettings.m_authFlow) {
            this.m_settings.m_oAuthSettings.m_authFlow = this.m_settings.m_platformVersionUtils.getDefaultOAuthFlow();
        }
        if (OAuthFlow.TOKEN_PASSTHROUGH == this.m_settings.m_oAuthSettings.m_authFlow && null != this.m_settings.m_oAuthSettings.m_accessToken) {
            this.m_settings.m_oAuthSettings.m_maskClientInfoAccessToken = this.readOptionalBooleanSetting(connSettingRequestMap, "MaskAccessTokenClientInfoValue", true, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
            this.setClientInfoProperty(new ClientInfoData("Auth_AccessToken", Integer.MAX_VALUE, this.m_settings.m_oAuthSettings.m_maskClientInfoAccessToken ? MASKED_FIELD_VAL : this.m_settings.m_oAuthSettings.m_accessToken, "OAuth access token"));
        }
        this.m_definedSettings.put("Auth_Flow", true);
        this.m_definedSettings.put("Auth_Client_ID", true);
        this.m_definedSettings.put("Auth_Client_Secret", true);
        this.m_definedSettings.put("Auth_Scope", true);
        this.m_definedSettings.put("AuthorizationUrl", true);
        this.m_definedSettings.put("Auth_AccessToken", true);
        this.m_definedSettings.put("MaskAccessTokenClientInfoValue", true);
        this.addSslPropertiesToDefinedSettings("OAuth_");
    }

    private void addSslPropertiesToDefinedSettings(String string) {
        this.m_definedSettings.put(string + "AllowAllHostNames", true);
        this.m_definedSettings.put(string + "ssl", true);
        this.m_definedSettings.put(string + "CAIssuedCertNamesMismatch", true);
        this.m_definedSettings.put(string + "SSLKeyStore", true);
        this.m_definedSettings.put(string + "SSLKeyStorePwd", true);
        this.m_definedSettings.put(string + "SSLTrustStore", true);
        this.m_definedSettings.put(string + "SSLTrustStorePwd", true);
        this.m_definedSettings.put(string + "AllowSelfSignedCerts", true);
        this.m_definedSettings.put(string + "CAIssuedCertNamesMismatch", true);
        this.m_definedSettings.put(string + "SubjectAlternativeNamesHostNames", true);
        this.m_definedSettings.put(string + "SSLTrustStoreType", true);
        this.m_definedSettings.put(string + "SSLTrustStoreProvider", true);
        this.m_definedSettings.put(string + "SSLKeyStoreType", true);
        this.m_definedSettings.put(string + "SSLKeyStoreProvider", true);
    }
}

