/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.ServiceDiscoveryMode;
import com.cloudera.impala.hivecommon.api.ServiceDiscoveryFactory;
import com.cloudera.impala.hivecommon.api.ZookeeperDynamicDiscovery;
import com.cloudera.impala.hivecommon.api.ZookeeperSettings;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.emulation.ZookeeperEmulator;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZooKeeperEnabledExtendedHS2Factory
extends ServiceDiscoveryFactory {
    public static final String PARSEING_REGEX = "(.+):(\\d+)(.*)";
    public static final int IP_INDEX = 1;
    public static final int PORT_INDEX = 2;
    public static final int NAMESPACE_INDEX = 3;
    public static final int EXPECTED_NUM_HOST_PARTS = 2;
    private HashMap<String, Queue<String>> m_urlToHiveClustersMap = new HashMap();
    private Queue<String> m_rankedClusterList = new PriorityQueue<String>();
    private Random rand = new Random();
    private static ZooKeeperEnabledExtendedHS2Factory s_factory = null;

    private ZooKeeperEnabledExtendedHS2Factory() {
    }

    public static synchronized ZooKeeperEnabledExtendedHS2Factory getInstance() {
        if (null == s_factory) {
            s_factory = new ZooKeeperEnabledExtendedHS2Factory();
        }
        return s_factory;
    }

    @Override
    public boolean supportServiceDiscoveryMode(ServiceDiscoveryMode serviceDiscoveryMode, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[]{serviceDiscoveryMode, iLogger});
        switch (serviceDiscoveryMode) {
            case ZOOKEEPER: {
                return true;
            }
        }
        return false;
    }

    protected synchronized void consolidateExistingClusters(HiveJDBCSettings hiveJDBCSettings, Stack<String> stack) {
        String string = ZooKeeperEnabledExtendedHS2Factory.getCombinedHostString(hiveJDBCSettings);
        if (!this.m_urlToHiveClustersMap.containsKey(string)) {
            this.m_urlToHiveClustersMap.put(string, new ArrayDeque());
        }
        if (!this.m_urlToHiveClustersMap.get(string).isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(stack);
            Queue<String> queue = this.m_urlToHiveClustersMap.get(string);
            Object object = queue.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (!hashSet.contains(string2)) {
                    object.remove();
                    continue;
                }
                hashSet.remove(string2);
            }
            queue.addAll(hashSet);
            object = queue.poll();
            if (null != object) {
                queue.add((String)object);
            }
            this.m_rankedClusterList.remove(string);
            this.m_rankedClusterList.add(string);
        } else {
            this.m_urlToHiveClustersMap.get(string).addAll(stack);
            this.m_rankedClusterList.add(string);
        }
    }

    @Override
    protected String getNextServer(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) {
        Stack<String> stack = null;
        stack = hiveJDBCSettings.m_zookeeperSettings.m_zkTestingEnabled ? ZookeeperEmulator.getEmulatedServers(hiveJDBCSettings.m_zookeeperSettings) : this.getServersFromZooKeeper(hiveJDBCSettings, iLogger);
        if (null == stack) {
            return null;
        }
        if (hiveJDBCSettings.m_zookeeperSettings.m_enableRoundRobin) {
            this.consolidateExistingClusters(hiveJDBCSettings, stack);
            this.manageCache(hiveJDBCSettings.m_zookeeperSettings);
            return this.getNextServerByRoundRobin(hiveJDBCSettings, iLogger);
        }
        return this.getNextServerByRandom(stack, iLogger);
    }

    protected String getNextServerByRandom(Stack<String> stack, ILogger iLogger) {
        while (stack.size() > 0) {
            int n = this.rand.nextInt(stack.size());
            String string = (String)stack.remove(n);
            if (!this.checkHostNameAndCacheException(string, iLogger)) continue;
            return string;
        }
        return null;
    }

    protected synchronized String getNextServerByRoundRobin(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) {
        String string = ZooKeeperEnabledExtendedHS2Factory.getCombinedHostString(hiveJDBCSettings);
        Queue<String> queue = this.m_urlToHiveClustersMap.get(string);
        if (null != queue && !queue.isEmpty()) {
            for (int i = 0; i < queue.size(); ++i) {
                String string2 = queue.peek();
                if (!this.checkHostNameAndCacheException(string2, iLogger)) continue;
                return string2;
            }
        }
        return null;
    }

    private boolean checkHostNameAndCacheException(String string, ILogger iLogger) {
        boolean bl;
        String[] stringArray = string.split(":");
        boolean bl2 = bl = 2 == stringArray.length;
        if (!bl) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{ServiceDiscoveryMode.ZOOKEEPER.toString(), string + " is not in the valid hostname format of <host>:<name>"});
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            LogUtilities.logWarning(errorException.getMessage(), iLogger);
            this.m_cacheExp = errorException;
        }
        return bl;
    }

    private static String getCombinedHostString(HiveJDBCSettings hiveJDBCSettings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < hiveJDBCSettings.m_serviceDiscoveryEndpoints.length; ++i) {
            if (0 != i) {
                stringBuilder.append(',');
            }
            stringBuilder.append(hiveJDBCSettings.m_serviceDiscoveryEndpoints[i]);
        }
        return stringBuilder.toString();
    }

    private Stack<String> getServersFromZooKeeper(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) {
        ZookeeperDynamicDiscovery zookeeperDynamicDiscovery = null;
        Pattern pattern = null;
        for (int i = 0; i < hiveJDBCSettings.m_serviceDiscoveryEndpoints.length; ++i) {
            Object object;
            int n = (hiveJDBCSettings.m_zookeeperSettings.m_endpointIdx + i) % hiveJDBCSettings.m_serviceDiscoveryEndpoints.length;
            try {
                String string;
                int n2;
                String string2;
                Stack<String> stack;
                String string3;
                if (null == zookeeperDynamicDiscovery) {
                    zookeeperDynamicDiscovery = new ZookeeperDynamicDiscovery();
                }
                if (null == pattern) {
                    pattern = Pattern.compile(PARSEING_REGEX);
                }
                if (!((Matcher)(object = pattern.matcher(string3 = hiveJDBCSettings.m_serviceDiscoveryEndpoints[n]))).matches() || (stack = zookeeperDynamicDiscovery.retrieveInfoFromZooKeeper(string2 = ((Matcher)object).group(1), n2 = Integer.parseInt(((Matcher)object).group(2)), string = ((Matcher)object).group(3), hiveJDBCSettings.m_timeout)).empty()) continue;
                hiveJDBCSettings.m_zookeeperSettings.m_endpointIdx = n;
                return stack;
            }
            catch (Exception exception) {
                iLogger.logWarning(this.getClass().getPackage().toString(), this.getClass().getName(), "createClient", exception.getMessage());
                this.m_cacheExp = object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ZOOKEEPER_CONNECTION_ERROR.name(), new String[]{hiveJDBCSettings.m_serviceDiscoveryEndpoints[n], exception.getMessage()});
            }
        }
        return null;
    }

    private synchronized void manageCache(ZookeeperSettings zookeeperSettings) {
        while (zookeeperSettings.m_maxNumServers > 0 && this.m_urlToHiveClustersMap.size() > zookeeperSettings.m_maxNumServers) {
            this.removeOldestCache();
        }
    }

    private synchronized void removeOldestCache() {
        if (this.m_rankedClusterList.isEmpty()) {
            return;
        }
        String string = this.m_rankedClusterList.remove();
        this.m_urlToHiveClustersMap.remove(string);
    }
}

