/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.api.HiveJDBCBrowserServerResponse;
import com.cloudera.impala.hivecommon.api.SSOSAMLSettings;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.Socket;
import java.util.ArrayList;

public class WebConnection
implements Runnable {
    public static final int BUFFER_SIZE = 16384;
    public static final String UTF8_STR = "UTF-8";
    private ILogger m_logger;
    private SetValueFunction m_setValueFunction;
    private final Socket m_socket;
    private SSOSAMLSettings m_settings;

    public WebConnection(Socket socket, SetValueFunction setValueFunction, ILogger iLogger, SSOSAMLSettings sSOSAMLSettings) {
        this.m_setValueFunction = setValueFunction;
        this.m_socket = socket;
        this.m_logger = iLogger;
        this.m_settings = sSOSAMLSettings;
    }

    @Override
    public void run() {
        try {
            this.readServerResponse(this.m_socket);
        }
        catch (IOException iOException) {
            LogUtilities.logDebug("Encountered exception on remote port " + this.m_socket.getPort() + " when listening for browser response: " + iOException.getMessage(), this.m_logger);
        }
        finally {
            if (null != this.m_socket) {
                try {
                    this.m_socket.close();
                }
                catch (IOException iOException) {
                    LogUtilities.logDebug("Error closing socket: " + iOException.getMessage(), this.m_logger);
                }
            }
        }
    }

    private HiveJDBCBrowserServerResponse parseServerResponse(String string) {
        String[] stringArray = string.split("\r\n");
        if (this.m_settings.m_ssoLogSensitiveInfoForDebug) {
            LogUtilities.logTrace("Response received: " + string, this.m_logger);
        }
        for (String string2 : stringArray) {
            if (string2.isEmpty() || !string2.contains("token=")) continue;
            LogUtilities.logTrace("Token was parsed from server response", this.m_logger);
            return new HiveJDBCBrowserServerResponse(string2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readServerResponse(Socket socket) throws IOException {
        Object object;
        HiveJDBCBrowserServerResponse hiveJDBCBrowserServerResponse = null;
        try {
            object = new BufferedReader(new InputStreamReader(socket.getInputStream(), UTF8_STR));
            LogUtilities.logDebug("Waiting for a server response on port " + socket.getLocalPort() + " with a timeout of " + socket.getSoTimeout() + " ms on socket " + socket.toString(), this.m_logger);
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[16384];
            while (((Reader)object).read(cArray) != -1) {
                stringBuilder.append(cArray);
                hiveJDBCBrowserServerResponse = this.parseServerResponse(stringBuilder.toString());
                if (null == hiveJDBCBrowserServerResponse) continue;
                LogUtilities.logTrace("Parsed response", this.m_logger);
                break;
            }
            LogUtilities.logTrace("Done reading from connection", this.m_logger);
        }
        catch (IOException iOException) {
            try {
                LogUtilities.logTrace("Unexpected exception while processing server response " + iOException.getMessage(), this.m_logger);
                throw iOException;
            }
            catch (Throwable throwable) {
                try {
                    this.sendBrowserMsg(socket, hiveJDBCBrowserServerResponse);
                }
                catch (IOException iOException2) {
                    LogUtilities.logTrace("Unexpected exception while responding to browser " + iOException2.getMessage(), this.m_logger);
                    throw iOException2;
                }
                WebConnection iOException2 = this;
                synchronized (iOException2) {
                    if (hiveJDBCBrowserServerResponse == null) throw throwable;
                    this.m_setValueFunction.setValue(hiveJDBCBrowserServerResponse);
                    throw throwable;
                }
            }
        }
        try {
            this.sendBrowserMsg(socket, hiveJDBCBrowserServerResponse);
        }
        catch (IOException iOException) {
            LogUtilities.logTrace("Unexpected exception while responding to browser " + iOException.getMessage(), this.m_logger);
            throw iOException;
        }
        object = this;
        synchronized (object) {
            if (hiveJDBCBrowserServerResponse != null) {
                this.m_setValueFunction.setValue(hiveJDBCBrowserServerResponse);
            }
        }
        if (null != hiveJDBCBrowserServerResponse) return true;
        return false;
    }

    private void sendBrowserMsg(Socket socket, HiveJDBCBrowserServerResponse hiveJDBCBrowserServerResponse) throws IOException {
        PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("HTTP/1.0 200 OK");
        arrayList.add("Content-Type: text/html");
        String string = null == hiveJDBCBrowserServerResponse ? "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"/><link rel=\"icon\" href=\"data:,\"><title>SAML Response Received</title></head><body>Authentication failed:  Unexpected message format received  Please check server logs for more details. You may close this window.</body></html>" : (hiveJDBCBrowserServerResponse.isSuccessful() ? "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"/><link rel=\"icon\" href=\"data:,\"><title>SAML Response Received</title></head><body>Successfully authenticated. You may close this window.</body></html>" : "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"/><link rel=\"icon\" href=\"data:,\"><title>SAML Response Received</title></head><body>Authentication failed: " + hiveJDBCBrowserServerResponse.getMsg() + " Please check server logs for more details. You may close this window.</body></html>");
        arrayList.add(String.format("Content-Length: %s", string.length()));
        arrayList.add("");
        arrayList.add(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                printWriter.print("\r\n");
            }
            printWriter.print((String)arrayList.get(i));
        }
        printWriter.flush();
    }

    public static interface SetValueFunction {
        public void setValue(HiveJDBCBrowserServerResponse var1);
    }
}

