/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.jdbc42.internal.apache.commons.codec.binary.Base64;
import com.cloudera.impala.jdbc42.internal.apache.http.auth.AuthenticationException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.locks.ReentrantLock;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class HiveServerHttpPrivilegedAction<T>
implements PrivilegedExceptionAction<T> {
    private static ReentrantLock s_kerberosLock;
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private static Oid s_kerberosOid;
    private GSSManager m_gssManager = GSSManager.getInstance();
    private GSSName m_gssServerName;
    private String m_service;
    private String m_tokenStr;

    public HiveServerHttpPrivilegedAction(String string) {
        this.m_service = string;
    }

    public String getKerberosTokenString() {
        return this.m_tokenStr;
    }

    @Override
    public T run() throws Exception {
        try {
            s_kerberosLock.lock();
            GSSContext gSSContext = this.m_gssManager.createContext(this.m_gssManager.createName(this.m_service, GSSName.NT_HOSTBASED_SERVICE).canonicalize(s_kerberosOid), s_kerberosOid, null, 0);
            gSSContext.requestMutualAuth(true);
            gSSContext.requestCredDeleg(true);
            byte[] byArray = new byte[]{};
            byArray = gSSContext.initSecContext(byArray, 0, byArray.length);
            if (null == byArray) {
                throw new AuthenticationException("GSS security context initialization failed");
            }
            this.m_tokenStr = new String(Base64.encodeBase64(byArray, false));
            gSSContext.dispose();
        }
        finally {
            s_kerberosLock.unlock();
        }
        return null;
    }

    static {
        try {
            System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
            if (null != System.getenv("KRB5_CONFIG")) {
                System.setProperty("java.security.krb5.conf", System.getenv("KRB5_CONFIG"));
            }
            s_kerberosOid = new Oid(KERBEROS_OID);
            s_kerberosLock = new ReentrantLock(true);
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError(gSSException);
        }
    }
}

