/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon;

import com.cloudera.impala.hivecommon.HttpRetryType;
import com.cloudera.impala.hivecommon.WholeNumberIntervalList;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCQueryAnalyserUtils;
import com.cloudera.impala.hivecommon.exceptions.TEHttpRetryException;
import com.cloudera.impala.jdbc.utils.ParseQueryUtils;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import java.util.ArrayList;

public class HttpRetrySettings {
    public static final int DEFAULT_UNSET_RETRY_AFTER_VAL = -1;
    public boolean m_enableRetry = true;
    public int m_timeout = -1;
    public int m_timeoutCounter = 0;
    public int m_minRetryInterval;
    public int m_retryInterval;
    public boolean m_increaseRetryIntervalAfterEachRetry;
    public boolean m_overrideRetryAfterTime = false;
    public int m_maxRetryTime = -1;
    public int m_retryTimeCounter = 0;
    public WholeNumberIntervalList m_codeRanges;
    public ArrayList<String> m_nonRetryApiList;
    public ArrayList<String> m_nonRetryQueryList;
    public HttpRetryType m_httpRetryType;

    public HttpRetrySettings(HttpRetryType httpRetryType) {
        this.m_httpRetryType = httpRetryType;
        this.m_maxRetryTime = httpRetryType.m_defaultMaxRetryTime;
        this.m_minRetryInterval = httpRetryType.m_defaultMinRetryInterval;
        this.m_timeout = httpRetryType.m_defaultTimeout;
        this.m_overrideRetryAfterTime = httpRetryType.m_defaultOverrideRetryAfterTime;
        this.m_increaseRetryIntervalAfterEachRetry = httpRetryType.m_defaultIncreaseRetryIntervalAfterEachRetry;
        this.m_codeRanges = httpRetryType.m_defaultCodeRanges;
        this.m_nonRetryApiList = httpRetryType.m_defaultNonRetryApiList;
        this.m_nonRetryQueryList = httpRetryType.m_defaultNonRetryQueryList;
    }

    public void reset() {
        this.m_timeoutCounter = 0;
        this.m_retryTimeCounter = 0;
    }

    public boolean shouldRetry(String string, String string2, TEHttpRetryException tEHttpRetryException) throws TTransportException {
        if (!this.m_enableRetry || !this.shouldRetryWithHttpCode(string, string2, tEHttpRetryException.errorCode) || this.m_timeout < 0 && this.m_maxRetryTime < 0) {
            return false;
        }
        if (this.m_timeout > 0 && this.m_timeoutCounter >= this.m_timeout) {
            String string3 = this.m_httpRetryType.m_httpRetryTypeKey + " timeout of " + this.m_timeout + " seconds has been hit. Configure these values with " + this.m_httpRetryType.m_httpRetryTypeKey + " and " + this.m_httpRetryType.m_httpRetryTypeKey + "Timeout" + ". Error from server: ";
            string3 = string3 + tEHttpRetryException.getMessage();
            throw new TTransportException(string3);
        }
        if (this.m_maxRetryTime > 0 && this.m_retryTimeCounter >= this.m_maxRetryTime) {
            String string4 = this.m_httpRetryType.m_httpRetryTypeKey + " max retry time of " + this.m_maxRetryTime + " has been hit. Configure these values with " + this.m_httpRetryType.m_httpRetryTypeKey + " and " + this.m_httpRetryType.m_httpRetryTypeKey + "MaxRetryTime" + ". Error from server: ";
            string4 = string4 + tEHttpRetryException.getMessage();
            throw new TTransportException(string4);
        }
        int n = this.m_minRetryInterval;
        if (this.m_overrideRetryAfterTime) {
            if (this.m_increaseRetryIntervalAfterEachRetry) {
                n = this.m_minRetryInterval * (this.m_retryTimeCounter + 1);
            }
        } else if (-1 != tEHttpRetryException.retryAfterTime) {
            n = tEHttpRetryException.retryAfterTime;
        } else {
            throw new TTransportException("HTTP retry after response received with no Retry-After header, error: " + tEHttpRetryException.getMessage());
        }
        try {
            Thread.sleep(n * 1000);
        }
        catch (InterruptedException interruptedException) {
            throw new TTransportException("Thread interrupted while waiting for retry: " + interruptedException.getMessage() + "\nEarlier response from server: ");
        }
        this.m_timeoutCounter += n;
        ++this.m_retryTimeCounter;
        tEHttpRetryException.retryAfterTime = -1;
        return true;
    }

    public boolean shouldRetryWithHttpCode(String string, String string2, int n) {
        if (null != this.m_nonRetryApiList && this.m_nonRetryApiList.contains(string)) {
            return false;
        }
        if (string.equals("ExecuteStatement") && this.m_nonRetryQueryList != null && string2 != null) {
            char c;
            String string3 = ParseQueryUtils.parseCommentsOnSingleQuery(string2.trim()).toUpperCase();
            if (string3.startsWith("WITH")) {
                string3 = HiveJDBCQueryAnalyserUtils.removeWithExpression(string3);
            }
            int n2 = 0;
            for (int i = 0; i < string3.length() && ('(' == (c = string3.charAt(i)) || Character.isWhitespace(c)); ++i) {
                ++n2;
            }
            for (String string4 : this.m_nonRetryQueryList) {
                string4.toUpperCase();
                if (!string3.startsWith(string4)) continue;
                return false;
            }
        }
        return this.m_codeRanges.IsNumberInIntervals(n);
    }
}

