/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.dsi.dataengine.utilities;

public class DSIMonthSpan
implements Cloneable {
    private int m_intervalType;
    private int m_year = 0;
    private int m_month = 0;
    private boolean m_isNegative = false;

    private static void validate(int n, int n2) {
        if (0 != n && (0 > n2 || 11 < n2)) {
            throw new IllegalArgumentException("Invalid month value.");
        }
    }

    public DSIMonthSpan(int n, int n2, int n3, boolean bl) {
        DSIMonthSpan.validate(n2, n3);
        this.m_intervalType = n;
        this.m_year = n2;
        this.m_month = n3;
        this.m_isNegative = bl;
    }

    public int getIntervalType() {
        return this.m_intervalType;
    }

    public int getMonth() {
        return this.m_month;
    }

    public int getYear() {
        return this.m_year;
    }

    public boolean isNegative() {
        return this.m_isNegative;
    }

    public void setIsNegative(boolean bl) {
        this.m_isNegative = bl;
    }

    public void setMonth(int n) {
        DSIMonthSpan.validate(this.m_year, n);
        this.m_month = n;
    }

    public void setYear(int n) {
        DSIMonthSpan.validate(n, this.m_month);
        this.m_year = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        if (this.m_isNegative) {
            stringBuilder.append("-");
        }
        stringBuilder.append(String.valueOf(this.m_year)).append("-");
        stringBuilder.append(String.valueOf(this.m_month));
        return stringBuilder.toString();
    }

    public DSIMonthSpan clone() {
        try {
            return (DSIMonthSpan)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.m_intervalType;
        n = 31 * n + (this.m_isNegative ? 1231 : 1237);
        n = 31 * n + this.m_month;
        n = 31 * n + this.m_year;
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DSIMonthSpan)) {
            return false;
        }
        DSIMonthSpan dSIMonthSpan = (DSIMonthSpan)object;
        return this.m_isNegative == dSIMonthSpan.m_isNegative && this.m_month == dSIMonthSpan.m_month && this.m_year == dSIMonthSpan.m_year && this.m_intervalType == dSIMonthSpan.m_intervalType;
    }
}

