/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.dsi.core.utilities.impl.future;

import com.cloudera.impala.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class UnsignedSmallIntJDBCDataSource
extends NumericJDBCDataSource {
    private static final int TWO_TO_16 = 65536;

    public UnsignedSmallIntJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public Integer get() throws ErrorException {
        try {
            int n = this.getAndCheck();
            if (n == 0 && this.wasNull()) {
                return null;
            }
            return n;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, SQLException {
        int n = this.getAndCheck();
        if (n == 0 && this.wasNull()) {
            return null;
        }
        return Integer.toString(n);
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getAndCheck() != 0;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, SQLException {
        int n = this.getAndCheck();
        if (n > 127) {
            this.onOverflow(n, "getByte");
        }
        return (byte)n;
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, SQLException {
        int n = this.getAndCheck();
        if (n > Short.MAX_VALUE) {
            this.onOverflow(n, "getShort");
        }
        return (short)n;
    }

    @Override
    public abstract int getInt() throws ErrorException, SQLException;

    protected final int getAndCheck() throws ErrorException, SQLException {
        int n = this.getInt();
        assert (n >= 0 && n <= 65536);
        return n;
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getAndCheck();
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getAndCheck();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getAndCheck();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, SQLException {
        int n = this.getAndCheck();
        if (n == 0 && this.wasNull()) {
            return null;
        }
        return new BigDecimal(n);
    }
}

