/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.dsi.core.utilities.impl.future;

import com.cloudera.impala.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class FloatJDBCDataSink
extends NumberJDBCDataSink<Float> {
    public FloatJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null || object instanceof Float) {
            this.doSet(null);
        } else if (object instanceof Number) {
            this.doSet(Float.valueOf(((Number)object).floatValue()));
        } else {
            throw new IncorrectTypeException();
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, SQLException, ErrorException {
        this.setFloat(by);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, SQLException, ErrorException {
        this.setFloat(s);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, SQLException, ErrorException {
        this.setFloat(n);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, SQLException, ErrorException {
        this.setFloat(l);
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSet(Float.valueOf(f));
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, SQLException, ErrorException {
        this.setFloat((float)d);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            this.setDouble(bigDecimal.floatValue());
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            this.setFloat(Float.parseFloat(string));
        }
    }
}

