/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.dsi.core.utilities.impl.future;

import com.cloudera.impala.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.impala.dsi.core.utilities.impl.future.ArrayJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.BinaryJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.BitBooleanJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.DateJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.DecimalJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.DoubleJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.FloatJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.GuidJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.MonthSpanJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.SignedBigIntJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.SignedIntJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.SignedSmallIntJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.SignedTinyIntJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.StringJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.TimeJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.TimeSpanJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.TimestampJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.UnsignedBigIntJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.UnsignedIntJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.UnsignedSmallIntJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.core.utilities.impl.future.UnsignedTinyIntJDBCDataSourceAdapter;
import com.cloudera.impala.dsi.dataengine.interfaces.IArray;
import com.cloudera.impala.dsi.dataengine.interfaces.future.IJDBCDataSource;
import com.cloudera.impala.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.cloudera.impala.dsi.dataengine.interfaces.future.ISqlDataSource;
import com.cloudera.impala.dsi.dataengine.utilities.DSIMonthSpan;
import com.cloudera.impala.dsi.dataengine.utilities.DSITimeSpan;
import com.cloudera.impala.dsi.dataengine.utilities.SqlTypeWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;
import com.cloudera.impala.dsi.exceptions.future.UnsupportedException;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.UUID;

public abstract class ConvertingJDBCDataSource
implements IJDBCDataSource {
    protected static final Charset s_asciiCharSet = Charset.forName("US-ASCII");
    protected static final Charset s_utf8CharSet = Charset.forName("UTF-8");
    private boolean m_wasNull = false;
    private final IWarningListener m_warningListener;
    private GregorianCalendar m_tempCalendar = null;
    private final NonTrivialJDBCConversions.SimpleListener m_listener = new NonTrivialJDBCConversions.SimpleListener();

    public static IJDBCDataSource wrapSqlDataSourceIfNecessary(ISqlDataSource iSqlDataSource, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws UnsupportedException {
        if (iSqlDataSource == null) {
            throw null;
        }
        if (iSqlDataSource instanceof IJDBCDataSource) {
            return (IJDBCDataSource)iSqlDataSource;
        }
        switch (typeMetadata.getType()) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return new StringJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 2003: {
                return new ArrayJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case -4: 
            case -3: 
            case -2: {
                return new BinaryJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case -7: 
            case 16: {
                return new BitBooleanJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case -11: {
                return new GuidJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case -6: {
                if (typeMetadata.isSigned()) {
                    return new SignedTinyIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
                }
                return new UnsignedTinyIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 91: {
                return new DateJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 92: {
                return new TimeJDBCDataSourceAdapter(iSqlDataSource, typeMetadata, iWarningListener);
            }
            case 93: {
                return new TimestampJDBCDataSourceAdapter(iSqlDataSource, typeMetadata, iWarningListener);
            }
            case -5: {
                if (typeMetadata.isSigned()) {
                    return new SignedBigIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
                }
                return new UnsignedBigIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 6: 
            case 8: {
                return new DoubleJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 7: {
                return new FloatJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 5: {
                if (typeMetadata.isSigned()) {
                    return new SignedSmallIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
                }
                return new UnsignedSmallIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 4: {
                if (typeMetadata.isSigned()) {
                    return new SignedIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
                }
                return new UnsignedIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 2: 
            case 3: {
                return new DecimalJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return new TimeSpanJDBCDataSourceAdapter(iSqlDataSource, typeMetadata, iWarningListener);
            }
            case 101: 
            case 102: 
            case 107: {
                return new MonthSpanJDBCDataSourceAdapter(iSqlDataSource, typeMetadata, iWarningListener);
            }
        }
        throw new UnsupportedException();
    }

    public ConvertingJDBCDataSource(IWarningListener iWarningListener) {
        if (iWarningListener == null) {
            throw null;
        }
        this.m_warningListener = iWarningListener;
    }

    protected final IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    protected final GregorianCalendar getLocalCalendarForConversions() {
        if (this.m_tempCalendar == null) {
            this.m_tempCalendar = new GregorianCalendar();
        }
        return this.m_tempCalendar;
    }

    protected final NonTrivialJDBCConversions.SimpleListener getListener() {
        return this.m_listener;
    }

    protected final NonTrivialJDBCConversions.SimpleListener getAndClearListener() {
        this.m_listener.clearStatus();
        return this.m_listener;
    }

    protected void onOverflow(Object object, String string) {
    }

    protected void onFractionalTruncation(Object object, int n, String string) {
    }

    protected final void setWasNull(boolean bl) {
        this.m_wasNull = bl;
    }

    protected final <T> T returnObject(T t) {
        this.setWasNull(t == null);
        return t;
    }

    protected Integer getSqlTypeFromRegistration(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        if (outputParameterRegistration.getSqlType() instanceof Integer) {
            return (Integer)outputParameterRegistration.getSqlType();
        }
        SqlTypeWrapper sqlTypeWrapper = new SqlTypeWrapper(outputParameterRegistration.getSqlType());
        if (sqlTypeWrapper.getVendor().equals("com.cloudera.jdbc.jdbc42.utilities")) {
            return sqlTypeWrapper.getVendorTypeNumber();
        }
        return null;
    }

    protected final boolean isCharType(int n) {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    protected final boolean isBinaryType(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    protected final boolean isNumericType(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected boolean registeredTypeIsSupported(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        Integer n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        if (n == null) {
            return false;
        }
        switch (n) {
            case -11: 
            case -7: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 1111: 
            case 2000: 
            case 2003: {
                return true;
            }
        }
        return this.isCharType(n) || this.isBinaryType(n) || this.isNumericType(n);
    }

    public IJDBCExecution.RegistrationResult supportsRegistration(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        if (!this.registeredTypeIsSupported(outputParameterRegistration)) {
            return IJDBCExecution.RegistrationResult.REGISTERED_TYPE_NOT_SUPPORTED;
        }
        if (!this.supportsConversionToRegisteredType(outputParameterRegistration)) {
            return IJDBCExecution.RegistrationResult.CONVERSION_TO_REGISTERED_TYPE_NOT_SUPPORTED;
        }
        return IJDBCExecution.RegistrationResult.REGISTRATION_SUCEEDED;
    }

    protected abstract boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration var1);

    @Override
    public Reader getAsReader() throws IncorrectTypeException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public InputStream getAsInputStream() throws IncorrectTypeException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public boolean wasNull() throws ErrorException, SQLException {
        return this.m_wasNull;
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws ErrorException, IncorrectTypeException, SQLException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal bigDecimal2 = bigDecimal.setScale(n, RoundingMode.DOWN);
        if (!bigDecimal2.equals(bigDecimal)) {
            this.onFractionalTruncation(bigDecimal, n, "getBigDecimal");
        }
        return bigDecimal2;
    }

    @Override
    public byte[] getBytes() throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public Date getDate() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getDate(this.getLocalCalendarForConversions());
    }

    @Override
    public Time getTime() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getTime(this.getLocalCalendarForConversions());
    }

    @Override
    public Timestamp getTimestamp() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getTimestamp(this.getLocalCalendarForConversions());
    }

    @Override
    public InputStream getAsciiStream() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        Reader reader = this.getAsReader();
        if (reader == null) {
            return null;
        }
        return new ReaderInputStream(reader, s_asciiCharSet);
    }

    @Override
    public InputStream getUnicodeStream() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        Reader reader = this.getAsReader();
        if (reader == null) {
            return null;
        }
        return new ReaderInputStream(reader, s_utf8CharSet);
    }

    @Override
    public InputStream getBinaryStream() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        return this.getAsInputStream();
    }

    @Override
    public Object getObject() throws ErrorException, IncorrectTypeException, SQLException {
        return this.get();
    }

    @Override
    public Reader getCharacterStream() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        return this.getAsReader();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public Object getObject(Map<String, Class<?>> map) throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public Ref getRef() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public Blob getBlob() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public Clob getClob() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public IArray getArray() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public Date getDate(Calendar calendar) throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public Time getTime(Calendar calendar) throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws ErrorException, IncorrectTypeException, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public URL getURL() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public RowId getRowId() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public NClob getNClob() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public SQLXML getSQLXML() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public String getNString() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public Reader getNCharacterStream() throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    protected BigInteger getBigInt() throws IncorrectTypeException, ErrorException, SQLException {
        Object object = this.getObject();
        assert (object == null == this.wasNull());
        if (this.wasNull()) {
            return null;
        }
        Number number = NonTrivialJDBCConversions.objectToBigInt(object, this.getAndClearListener());
        BigInteger bigInteger = number instanceof Long ? BigInteger.valueOf((Long)number) : (BigInteger)number;
        switch (this.m_listener.getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(object, 0, "getObject");
                break;
            }
            case OVERFLOW: {
                this.onOverflow(object, "getObject");
            }
        }
        return bigInteger;
    }

    @Override
    public <T> T getObject(Class<T> clazz) throws ErrorException, IncorrectTypeException, SQLException, UnsupportedException {
        Object object;
        assert (clazz != null);
        if (clazz.equals(BigInteger.class)) {
            object = this.getBigInt();
        } else if (clazz.equals(BigDecimal.class)) {
            object = this.getBigDecimal();
        } else if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            boolean bl = this.getBoolean();
            assert (this.wasNull() == !bl);
            object = this.wasNull() ? null : Boolean.valueOf(bl);
        } else if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            byte by = this.getByte();
            assert (this.wasNull() == (by == 0));
            object = this.wasNull() ? null : Byte.valueOf(by);
        } else if (clazz.equals(byte[].class)) {
            object = this.getBytes();
        } else if (clazz.equals(Date.class)) {
            object = this.getDate();
        } else if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            double d = this.getDouble();
            assert (this.wasNull() == (d == 0.0));
            object = this.wasNull() ? null : Double.valueOf(d);
        } else if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            float f = this.getFloat();
            assert (this.wasNull() == (f == 0.0f));
            object = this.wasNull() ? null : Float.valueOf(f);
        } else if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            int n = this.getInt();
            assert (this.wasNull() == (n == 0));
            object = this.wasNull() ? null : Integer.valueOf(n);
        } else if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            long l = this.getLong();
            assert (this.wasNull() == (l == 0L));
            object = this.wasNull() ? null : Long.valueOf(l);
        } else if (clazz.equals(Object.class)) {
            object = this.getObject();
        } else if (clazz.equals(UUID.class)) {
            Object object2 = this.getObject();
            object = object2 == null ? object2 : NonTrivialJDBCConversions.objectToGUID(object2);
        } else if (clazz.equals(DSIMonthSpan.class) || clazz.equals(DSITimeSpan.class)) {
            object = this.getObject();
            if (object != null && !clazz.isInstance(object)) {
                throw new IncorrectTypeException();
            }
        } else if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            short s = this.getShort();
            assert (this.wasNull() == (s == 0));
            object = this.wasNull() ? null : Short.valueOf(s);
        } else if (clazz.equals(String.class)) {
            object = this.getString();
        } else if (clazz.equals(Time.class)) {
            object = this.getTime();
        } else if (clazz.equals(Timestamp.class)) {
            object = this.getTimestamp();
        } else {
            throw new UnsupportedException(clazz.getName());
        }
        return clazz.cast(object);
    }

    public static class ReaderInputStream
    extends InputStream {
        private Reader m_wrapped;
        private final ByteBuffer m_byteBuf = ByteBuffer.allocate(1024);
        private final CharBuffer m_charBuf = CharBuffer.allocate(512);
        private final CharsetEncoder m_encoder;
        private boolean m_readerHasMore = true;
        private boolean m_decoderFinished = false;

        public ReaderInputStream(Reader reader, Charset charset) {
            if (reader == null) {
                throw null;
            }
            this.m_wrapped = reader;
            this.m_encoder = charset.newEncoder();
        }

        private void checkIfClosed() {
            if (this.m_wrapped == null) {
                throw new IllegalStateException("Stream is closed!");
            }
        }

        private void getMoreConvertedData() throws IOException {
            CoderResult coderResult;
            assert (!this.m_byteBuf.hasRemaining());
            if (this.m_decoderFinished) {
                return;
            }
            if (!this.m_charBuf.hasRemaining() && this.m_readerHasMore) {
                this.m_charBuf.rewind();
                if (-1 == this.m_wrapped.read(this.m_charBuf)) {
                    this.m_readerHasMore = false;
                }
            }
            if ((coderResult = this.m_encoder.encode(this.m_charBuf, this.m_byteBuf, !this.m_readerHasMore)).isError()) {
                coderResult.throwException();
            }
            this.m_byteBuf.rewind();
            if (!this.m_readerHasMore) {
                this.m_decoderFinished = true;
            }
        }

        private int byteToInt(byte n) {
            return n >= 0 ? n : n + 256;
        }

        private boolean hasMoreToReturn() throws IOException {
            if (!this.m_byteBuf.hasRemaining()) {
                this.getMoreConvertedData();
                if (!this.m_byteBuf.hasRemaining()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public int read() throws IOException {
            this.checkIfClosed();
            if (!this.hasMoreToReturn()) {
                return -1;
            }
            return this.byteToInt(this.m_byteBuf.get());
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            assert (byArray != null);
            assert (n >= 0);
            assert (n2 >= 0);
            assert (n + n2 <= byArray.length);
            this.checkIfClosed();
            if (n2 == 0) {
                return 0;
            }
            if (!this.hasMoreToReturn()) {
                return -1;
            }
            int n3 = Math.min(this.m_byteBuf.remaining(), n2);
            this.m_byteBuf.get(byArray, n, n3);
            this.m_byteBuf.position(this.m_byteBuf.position() + n3);
            return n3;
        }

        @Override
        public void close() throws IOException {
            if (this.m_wrapped != null) {
                this.m_wrapped.close();
                this.m_wrapped = null;
            }
        }
    }
}

