"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Three ways to call an integrated service: Request Response, Run a Job and Wait for a Callback with Task Token.
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
 *
 * Here, they are named as FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN respectly.
 *
 * @default FIRE_AND_FORGET
 */
var ServiceIntegrationPattern;
(function (ServiceIntegrationPattern) {
    /**
     * Call a service and progress to the next state immediately after the API call completes
     */
    ServiceIntegrationPattern["FIRE_AND_FORGET"] = "FIRE_AND_FORGET";
    /**
     * Call a service and wait for a job to complete.
     */
    ServiceIntegrationPattern["SYNC"] = "SYNC";
    /**
     * Call a service with a task token and wait until that token is returned by SendTaskSuccess/SendTaskFailure with paylaod
     */
    ServiceIntegrationPattern["WAIT_FOR_TASK_TOKEN"] = "WAIT_FOR_TASK_TOKEN";
})(ServiceIntegrationPattern = exports.ServiceIntegrationPattern || (exports.ServiceIntegrationPattern = {}));
//# sourceMappingURL=data:application/json;base64,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