# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateBandwidthPackageRequest(JDCloudRequest):
    """
    指定地域创建共享带宽包实例。

## 接口说明

- 需要接口完成实名认证、支付方式确认、计费类型选择等准备工作。

- 各地域下包年包月和按配置计费的共享带宽包不受配额限制，按用量计费的共享带宽包可创建数量受配额限制，创建前请通过 [DescribeQuotas](https://docs.jdcloud.com/cn/shared-bandwidth-package/api/describequotas?content=API) 确认配额，如须提升请[提交工单](https://ticket.jdcloud.com/applyorder/submit)或联系京东云客服。

- 通过本接口创建包年包月资源时将自动从账户扣款（代金券优先），如需使用第三方支付方式请通过控制台创建。

- 按用量计费模式需提工单申请使用权限，默认支持增强95消峰计费。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateBandwidthPackageRequest, self).__init__(
            '/regions/{regionId}/bandwidthPackages/', 'POST', header, version)
        self.parameters = parameters


class CreateBandwidthPackageParameters(object):

    def __init__(self, regionId,name, bandwidthMbps, ):
        """
        :param regionId: Region ID
        :param name: 名称，只支持中文、数字、大小写字母、英文下划线“_”及中划线“-”，且长度不超过32个字符
        :param bandwidthMbps: 共享带宽包带宽上限，取值范围200-5000，单位为Mbps，保底带宽 = 共享带宽包带宽上限 * 20%
        """

        self.regionId = regionId
        self.name = name
        self.description = None
        self.bandwidthMbps = bandwidthMbps
        self.provider = None
        self.chargeSpec = None
        self.userTags = None
        self.resourceGroupId = None

    def setDescription(self, description):
        """
        :param description: (Optional) 描述，长度不超过256个字符
        """
        self.description = description

    def setProvider(self, provider):
        """
        :param provider: (Optional) 线路信息，默认bgp，目前只支持中心节点的BGP线路
        """
        self.provider = provider

    def setChargeSpec(self, chargeSpec):
        """
        :param chargeSpec: (Optional) 计费配置。支持包年包月、按配置、按用量计费模式
        """
        self.chargeSpec = chargeSpec

    def setUserTags(self, userTags):
        """
        :param userTags: (Optional) 用户标签
        """
        self.userTags = userTags

    def setResourceGroupId(self, resourceGroupId):
        """
        :param resourceGroupId: (Optional) 资源所属资源组ID
        """
        self.resourceGroupId = resourceGroupId

