# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeOnlineUserNumRequest(JDCloudRequest):
    """
    查询房间人数，通讯时长，最大支持查询7天的数据
允许通过条件过滤查询，支持的过滤字段如下：
           - appId[eq] 按应用ID精确查询(必填)
           - userRoomId[eq] 按房间ID精确查询(必填)
           - startTime[eq] 开始时间 UTC格式(必填)
           - endTime[eq] 截止时间 UTC格式 (必填)

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeOnlineUserNumRequest, self).__init__(
            '/describeOnlineUserNum', 'GET', header, version)
        self.parameters = parameters


class DescribeOnlineUserNumParameters(object):

    def __init__(self, filters):
        """
        :param filters: 传参字段描述:
  appId:   应用ID (必填)
  userRoomId：业务接入方定义的且在JRTC系统内注册过的房间号(必填)
  startTime: 房间使用起始时间 UTC (必填)
  endTime：房间使用截止时间 UTC (必填)

        """

        self.pageNumber = None
        self.pageSize = None
        self.filters = filters

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码；默认值为 1
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小；默认值为 10；取值范围 [10, 100]
        """
        self.pageSize = pageSize

