# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeDeadLetterNumbersRequest(JDCloudRequest):
    """
    死信消息数(按照用户或者consumerGroupId)
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeDeadLetterNumbersRequest, self).__init__(
            '/regions/{regionId}/deadLetterNumbers', 'GET', header, version)
        self.parameters = parameters


class DescribeDeadLetterNumbersParameters(object):

    def __init__(self, regionId, ):
        """
        :param regionId: 所在区域的Region ID
        """

        self.regionId = regionId
        self.consumerGroupId = None
        self.pageNumber = None
        self.pageSize = None

    def setConsumerGroupId(self, consumerGroupId):
        """
        :param consumerGroupId: (Optional) consumerGroupId为空则显示该用户所有订阅关系里的死信数量
        """
        self.consumerGroupId = consumerGroupId

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小；默认为10；取值范围[10, 100]
        """
        self.pageSize = pageSize

