# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateRepositoryRequest(JDCloudRequest):
    """
    通过参数创建镜像仓库。
仓库名称可以分解为多个路径名，每个名称必须至少包含一个小写字母数字，考虑URL规范。
支持包含段划线或者下划线进行分割，但不允许点'.'，多个路径名之间通过("/")连接，总长度不超过256个字符，当前只支持二级目录。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateRepositoryRequest, self).__init__(
            '/regions/{regionId}/registries/{registryName}/repositories', 'POST', header, version)
        self.parameters = parameters


class CreateRepositoryParameters(object):

    def __init__(self, regionId, registryName, repositoryName, ):
        """
        :param regionId: Region ID
        :param registryName: 注册表名称
        :param repositoryName: 镜像仓库名称。
可以专有模式如默认命名空间nginx-web-app；或者和命名空间一起将多个仓库聚集在一起如 project-a/nginx-web-app。

        """

        self.regionId = regionId
        self.registryName = registryName
        self.repositoryName = repositoryName
        self.description = None

    def setDescription(self, description):
        """
        :param description: (Optional) 注册表描述，<a href="https://www.jdcloud.com/help/detail/3870/isCatalog/1">参考公共参数规范</a>。

        """
        self.description = description

