# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class GetActionLogRequest(JDCloudRequest):
    """
    查看用户在云解析服务下的操作记录
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(GetActionLogRequest, self).__init__(
            '/regions/{regionId}/log/actionLog', 'GET', header, version)
        self.parameters = parameters


class GetActionLogParameters(object):

    def __init__(self, regionId, pageNumber, pageSize, startTime, endTime, ):
        """
        :param regionId: 地域ID
        :param pageNumber: 分页参数，页的序号，默认是1
        :param pageSize: 分页参数，每页含有的结果的数目，默认是10
        :param startTime: 记录的起始时间，格式：UTC时间例如2017-11-10T23:00:00Z
        :param endTime: 记录的终止时间，格式：UTC时间例如2017-11-10T23:00:00Z
        """

        self.regionId = regionId
        self.pageNumber = pageNumber
        self.pageSize = pageSize
        self.startTime = startTime
        self.endTime = endTime
        self.keyWord = None
        self.success = None
        self.type = None

    def setKeyWord(self, keyWord):
        """
        :param keyWord: (Optional) 日志需要匹配的关键词
        """
        self.keyWord = keyWord

    def setSuccess(self, success):
        """
        :param success: (Optional) 日志里面的结果是成功还是失败
        """
        self.success = success

    def setType(self, type):
        """
        :param type: (Optional) 日志的类型
        """
        self.type = type

