import sys
from .gcca import GCCA
from .omnibus import Omnibus
from .mvmds import MVMDS
from .kcca import KCCA
from .utils import select_dimension
try:
    import torch
    from torch.utils.data import Dataset, DataLoader
    import torch.nn as nn
    from torch.utils.data import BatchSampler, SequentialSampler, RandomSampler
    from .dcca import DCCA, linear_cca, cca_loss, MlpNet, DeepPairedNetworks
    from .splitae import SplitAE
except ModuleNotFoundError:
    pass

__all__ = [
        "GCCA",
        "Omnibus",
        "MVMDS",
        "KCCA",
        "select_dimension",
        "DCCA",
        "SplitAE",
    ]
