[![Maintainability](https://api.codeclimate.com/v1/badges/650cde37de8ccb468b8c/maintainability)](https://codeclimate.com/github/phydev/trajpy/maintainability)
[![codecov](https://codecov.io/gh/phydev/trajpy/branch/master/graph/badge.svg?token=lhYwQjiAlU)](https://codecov.io/gh/phydev/trajpy)
[![Build Status](https://travis-ci.com/phydev/trajpy.svg?branch=master)](https://travis-ci.com/phydev/trajpy)
[![PyUp](https://pyup.io/repos/github/phydev/trajpy/shield.svg?t=1570846676802)](https://pyup.io/repos/github/phydev/trajpy/)
[![Python 3](https://pyup.io/repos/github/phydev/trajpy/python-3-shield.svg)](https://pyup.io/repos/github/phydev/trajpy/)
[![Documentation Status](https://readthedocs.org/projects/trajpy/badge/?version=latest)](https://trajpy.readthedocs.io/en/latest/?badge=latest)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![DOI](https://zenodo.org/badge/194252287.svg)](https://zenodo.org/badge/latestdoi/194252287)


# TrajPy
Pythonic package for trajectory classification in 3D.


## Features
- Ensemble-averaged MSD
- Time-averaged MSD
- MSD Ratio
- Anomalous Exponent
- Fractal dimension
- Gyration radius
- Anisotropy
- Kurtosis
- Straightness
- Efficiency
- Gaussianity
- Trappedness
- Asymmetry (2D only)

## Trajectory generator
- Normal Diffusion
- Direct Motion
- Anomalous Diffusion
- Confined Diffusion

## Requirements
- numpy >= 1.14.3
- scipy >= 1.2.1
- scikit-learn >= 0.20.3
- matplotlib >= 3.0.3

[ ~ Dependencies scanned by PyUp.io ~ ]

## Publications
M. Moreira-Soares, S. Pinto-Cunha, J. R. Bordin, R. D. M. Travasso. *["Adhesion modulates cell morphology and migration within dense fibrous networks"](https://www.biorxiv.org/content/10.1101/838995v1)*.  https://doi.org/10.1101/838995

