# openboxes-client
[OpenBoxes](https://openboxes.org) is an open-source LMIS application that increases stock visibility, reduces the risk of stock-outs and stock wastage, and offers tools to improve forecasting and traceability.  **Notice** The following API documentation is a work in progress.  --- 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.8.17
- Package version: 0.1a1
- Build date: 2022-04-15T10:55:05.114-07:00[America/Los_Angeles]
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen
For more information, please visit [https://discuss.openboxes.com](https://discuss.openboxes.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import openboxes 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openboxes
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import openboxes
from openboxes.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = openboxes.AuthenticationApi(openboxes.ApiClient(configuration))
body = openboxes.LoginRequest() # LoginRequest | 

try:
    # retrieve a cookie for authentication
    api_instance.login(body)
except ApiException as e:
    print("Exception when calling AuthenticationApi->login: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://obdev.pih-emr.org/openboxes*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**login**](docs/AuthenticationApi.md#login) | **POST** /api/login | retrieve a cookie for authentication
*ConfigurationApi* | [**choose_location**](docs/ConfigurationApi.md#choose_location) | **PUT** /api/chooseLocation/{id} | specify a location
*LocationApi* | [**list_locations**](docs/LocationApi.md#list_locations) | **GET** /api/locations | get a list of locations
*ProductApi* | [**available_items**](docs/ProductApi.md#available_items) | **GET** /api/products/{id}/availableItems | retrieve bin locations and quantities for one or more products
*ProductApi* | [**demand**](docs/ProductApi.md#demand) | **GET** /api/products/{id}/demand | calculate demand for one product at the currently-selected warehouse
*ProductApi* | [**demand_summary**](docs/ProductApi.md#demand_summary) | **GET** /api/products/{id}/demandSummary | summarize demand history for one product at the currently-selected warehouse
*ProductApi* | [**list_products**](docs/ProductApi.md#list_products) | **GET** /api/products | list products tracked in OpenBoxes
*ProductApi* | [**product_availability**](docs/ProductApi.md#product_availability) | **GET** /api/products/{id}/productAvailability | get detailed availability for one product at the currently-selected warehouse
*ProductApi* | [**product_availability_and_demand**](docs/ProductApi.md#product_availability_and_demand) | **GET** /api/products/{id}/productAvailabilityAndDemand | get the monthly demand for, and current quantity of, one product at the currently-selected warehouse
*ProductApi* | [**product_summary**](docs/ProductApi.md#product_summary) | **GET** /api/products/{id}/productSummary | report the current quantity of one product at the currently-selected warehouse
*UserApi* | [**list_users**](docs/UserApi.md#list_users) | **GET** /api/persons | get a list of OpenBoxes users, as well as points of contact

## Documentation For Models

 - [AvailableItem](docs/AvailableItem.md)
 - [Document](docs/Document.md)
 - [DocumentType](docs/DocumentType.md)
 - [IdContainer](docs/IdContainer.md)
 - [Inventory](docs/Inventory.md)
 - [InventoryItem](docs/InventoryItem.md)
 - [InventoryLevel](docs/InventoryLevel.md)
 - [Location](docs/Location.md)
 - [LocationGroup](docs/LocationGroup.md)
 - [LocationListResponse](docs/LocationListResponse.md)
 - [LocationType](docs/LocationType.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [Organization](docs/Organization.md)
 - [Party](docs/Party.md)
 - [PartyRole](docs/PartyRole.md)
 - [PartyType](docs/PartyType.md)
 - [Person](docs/Person.md)
 - [PersonListResponse](docs/PersonListResponse.md)
 - [Product](docs/Product.md)
 - [ProductAvailability](docs/ProductAvailability.md)
 - [ProductAvailabilityAndDemand](docs/ProductAvailabilityAndDemand.md)
 - [ProductAvailabilityResponse](docs/ProductAvailabilityResponse.md)
 - [ProductAvailableItemResponse](docs/ProductAvailableItemResponse.md)
 - [ProductCatalog](docs/ProductCatalog.md)
 - [ProductCatalogItem](docs/ProductCatalogItem.md)
 - [ProductDemand](docs/ProductDemand.md)
 - [ProductDemandResponse](docs/ProductDemandResponse.md)
 - [ProductGroup](docs/ProductGroup.md)
 - [ProductListResponse](docs/ProductListResponse.md)
 - [ProductPackage](docs/ProductPackage.md)
 - [ProductSummary](docs/ProductSummary.md)
 - [ProductSummaryResponse](docs/ProductSummaryResponse.md)
 - [ProductSupplier](docs/ProductSupplier.md)
 - [Role](docs/Role.md)
 - [Synonym](docs/Synonym.md)
 - [SynonymLocale](docs/SynonymLocale.md)
 - [Tag](docs/Tag.md)
 - [UnitOfMeasure](docs/UnitOfMeasure.md)
 - [UnitOfMeasureClass](docs/UnitOfMeasureClass.md)
 - [User](docs/User.md)

## Documentation For Authorization


## cookie

- **Type**: API key
- **API key parameter name**: JSESSIONID
- **Location**: URL query string


## Author


